%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                  %%%%%%%%%%
%%%%%%%%%%   FUNDAMENTALS   %%%%%%%%%%
%%%%%%%%%%                  %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Basic declarations
\ProvidesClass{slixte}[Slixte (Slides of Sixte) LaTeX class]
\LoadClass{beamer}

% Visual packages
\RequirePackage{tikz}
\RequirePackage{geometry}
\RequirePackage{xcolor}
% Text packages
\RequirePackage{amsmath,amssymb,amsthm,bbm}
\RequirePackage{lmodern}
\RequirePackage{contour}
% Coding packages
\RequirePackage{xfp}
\RequirePackage{ifthen}
\RequirePackage{etoolbox}
% Other packages
\RequirePackage{enumitem}
\RequirePackage{refcount}
\RequirePackage{fontawesome}

% Options of general scale
\def\pagescale{1}
\DeclareOption{short}{\def\pagescale{0.5}}
\DeclareOption{tall}{\def\pagescale{5}}
% Options of aspect ratio
\def\pageratio{16/9}
\DeclareOption{square}{\def\pageratio{1/1}}
\DeclareOption{photo}{\def\pageratio{3/2}}
\DeclareOption{standard}{\def\pageratio{4/3}}
\DeclareOption{widescreen}{\def\pageratio{16/9}}
% Options of origin
\def\pageshift{0}
\def\pagereverse{1}
\DeclareOption{upper}{\def\pagereverse{-1}}
\DeclareOption{center}{\def\pageshift{0.5}}
% Options of grid
\newtoggle{grid}
\DeclareOption{grid}{\toggletrue{grid}}
% Options of info
\newtoggle{info}
\DeclareOption{info}{\toggletrue{info}}
% Applying the options
\ProcessOptions\relax

% Global geometry
\setbeamertemplate{navigation symbols}{}
\def\standardheight{20}
\geometry{
    top=0cm,
    bottom=0cm,
    left=0cm,
    right=0cm,
    paperwidth=\fpeval{\pageratio*\pagescale*\standardheight}cm,
    paperheight=\fpeval{\pagescale*\standardheight}cm,
}
\setlist[itemize]{
    topsep=0.1cm,
    parsep=0.15cm,
    itemsep=0cm,
    leftmargin=1.2cm,
    itemindent=0cm,
    listparindent=0cm,
    labelsep=0.4cm,
    labelwidth=0cm,
}
% Making \sum and \prod big in displays
\DeclareFontShape{OMX}{cmex}{m}{n}{
  <-7.5> cmex7
  <7.5-8.5> cmex8
  <8.5-9.5> cmex9
  <9.5-> cmex10
}{}
\SetSymbolFont{largesymbols}{normal}{OMX}{cmex}{m}{n}
\SetSymbolFont{largesymbols}{bold}{OMX}{cmex}{m}{n}
% Grid
\newcommand{\drawgrid}{
    \draw[opacity=0.1] (-90,-50) grid (180, 100);
    \draw[opacity=0.2] (-90,-50) grid[step=5] (180, 100);
    \draw[opacity=0.3] (-90,-50) grid[step=10] (180, 100);
    \begin{scope}[
        xshift=\fpeval{(0.5-\pageshift)/5}cm,
        yshift=\fpeval{(0.5-\pageshift)/5}cm,
    ]
        \draw[
            ->,
            line width=\fpeval{\pagescale/10}cm,
            line cap=round,
            color=third,
        ] (0, 0) -- (\pagescale, 0);
        \draw[
            ->,
            line width=\fpeval{\pagescale/10}cm,
            line cap=round,
            color=third,
        ] (0, 0) -- (0, \pagescale);
    \end{scope}
}

% Fundamentals
\newlength\thisx
\newlength\thisy
\newlength\thisw
\newlength\thish
\newcounter{this}
% colors
\definecolor{page}{RGB}{255, 255, 255}
\definecolor{text}{RGB}{0, 0, 0}
\definecolor{first}{RGB}{96, 159, 103} % hsl(127, 25% 50%)
\definecolor{second}{RGB}{103, 96, 159} % hsl(247, 25%, 50%)
\definecolor{third}{RGB}{159, 103, 96} % hsl(007, 25%, 50%)

% Adaptable set-up commands
\newcommand{\setfontsize}[4]{%
    \setlength{#3}{\fpeval{#2/1cm}cm}%
    \ifthenelse{\isundefined{#4}}{\newlength{#4}}{}%
    \setlength{#4}{\fpeval{#1*#2/1cm}cm}%
}
\newcommand{\thisfontsize}[2]{%
    \ifthenelse{\isundefined{#2}}%
        {\fontsize{#1}{1.2#1}\selectfont}%
        {\fontsize{#1}{#2}\selectfont}%
}
\newcommand{\setthiscolor}[2]{%
    \makeatletter%
    \@ifundefined{\string\color@#1}%
        {\colorlet{this}{#2}}%
        {\colorlet{this}{#1}}%
    \makeatother%
}
\newcommand{\defaultx}[2]{%
    \setlength{#1}{#2\paperwidth}%
    \addtolength{#1}{-\pageshift\paperwidth}%
}
\newcommand{\defaulty}[2]{%
    \ifthenelse{\pagereverse>0}%
        {\setlength{#1}{#2\paperheight}%
            \addtolength{#1}{-\pageshift\paperheight}}%
        {\setlength{#1}{-#2\paperheight}%
            \addtolength{#1}{\paperheight}}%
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                      %%%%%%%%%%
%%%%%%%%%%   GLOBAL STRUCTURE   %%%%%%%%%%
%%%%%%%%%%                      %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Commands
\newcommand{\spacing}[1][0.5]{\vspace{#1cm}\par}
\newcommand{\cmdpage}[1]{
    \begin{frame}[plain]
    \fontsizecontent
    \begin{tikzpicture}[yscale=\pagereverse]
        \clip (0,0) rectangle (\paperwidth,\paperheight);
        \begin{scope}[xshift=\pageshift*\paperwidth, yshift=\pageshift*\paperheight]
            #1
            \iftoggle{grid}{\drawgrid}{}
        \end{scope}
    \end{tikzpicture}
    \end{frame} 
}
\newcommand{\cmdslide}[2]{
    \begin{tikzslide}[#1]
        \content{#2}
    \end{tikzslide}
}
\newcommand{\backpage}{}
\newcommand{\frontpage}{}
% Environments
\NewDocumentEnvironment{page}{+b}{\cmdpage{{\backpage}#1{\frontpage}}}{}
\newenvironment{tikzslide}[1][]{
    \begin{page}
    \drawbackground
    \drawbanner
    \drawcontent
    \drawprogress
    \drawbannerheader{#1}
    \drawbannertext
}{
    \end{page}
}
\NewDocumentEnvironment{slide}{O{} +b}{\cmdslide{#1}{#2}}{}
% Splits
\newtoggle{splits}
\toggletrue{splits}
\newcommand{\spliton}{\toggletrue{splits}}
\newcommand{\splitoff}{\togglefalse{splits}}
\renewcommand{\break}{\iftoggle{splits}{{\pause}}{}}
\newcommand{\showon}[2][]{\iftoggle{splits}{{\onslide<#1>{#2}}}{#2}}
\newcommand{\makeon}[2][]{\iftoggle{splits}{{\only<#1>{#2}}}{}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%   BACKGROUND   %%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\backgroundfile{background.png}
\def\backgroundanchor{center}
\newtoggle{background}
\toggletrue{background}
% Commands
\newcommand{\background}[1]{\def\backgroundfile{#1}}
\newcommand{\showbackground}{\toggletrue{background}}
\newcommand{\hidebackground}{\togglefalse{background}}
\newcommand{\drawbackground}{\iftoggle{background}{
    \ifthenelse{\isundefined{\backgroundx}}
        {\defaultx{\thisx}{0.5}}
        {\setlength{\thisx}{\backgroundx}}
    \ifthenelse{\isundefined{\backgroundy}}
        {\defaulty{\thisy}{0.5}}
        {\setlength{\thisy}{\backgroundy}}
    \setthiscolor{titlepagetext}{page}
    \node[
        inner sep=0cm,
        outer sep=0cm,
        anchor=\backgroundanchor,
        color=this,
    ] at (\thisx, \thisy)
    {\ifthenelse{\isundefined{\backgroundwidth}}
        {\ifthenelse{\isundefined{\backgroundheight}}
            {\includegraphics[
                width=\paperwidth,
                height=\paperheight,
            ]{\backgroundfile}}
            {\includegraphics[
                height=\backgroundheight,
            ]{\backgroundfile}}}
        {\ifthenelse{\isundefined{\backgroundheight}}
            {\includegraphics[
                width=\backgroundwidth,
            ]{\backgroundfile}}
            {\includegraphics[
                width=\backgroundwidth,
                height=\backgroundheight,
            ]{\backgroundfile}}}};
}{}}
\newcommand{\drawoverlay}[2]{
    \draw[opacity=#1, color=#2, fill=#2]
    (-\paperwidth,-\paperheight) rectangle (\paperwidth,\paperheight);
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%   TITLE PAGE   %%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definition
\def\titlepageopacity{0.5}
% Logo
\def\logofile{logo.png}
\def\logoanchor{center}
\def\logoxratio{0.15}
\def\logoyratio{0.25}
\def\logohratio{0.15}
\newtoggle{logo}
\toggletrue{logo}
% Title
\def\titlename{}
\def\titleanchor{west}
\def\titlealign{left}
\def\titlexratio{0.1}
\def\titleyratio{0.7}
\newlength\titlefontheight
\setlength{\titlefontheight}{2cm}
% Subtitle
\def\subtitlename{}
\def\subtitleanchor{west}
\def\subtitlealign{left}
\def\subtitlexratio{0.12}
\def\subtitleyratio{0.55}
\newlength\subtitlefontheight
\setlength{\subtitlefontheight}{1.5cm}
% Author
\def\authorname{}
\def\authoranchor{east}
\def\authoralign{right}
\def\authorxratio{0.9}
\def\authoryratio{0.3}
\newlength\authorfontheight
\setlength{\authorfontheight}{1.2cm}
% Info
\def\infoname{}
\def\infoanchor{east}
\def\infoalign{right}
\def\infoxratio{0.9}
\def\infoyratio{0.2}
\newlength\infofontheight
\setlength{\infofontheight}{1cm}

% Commands
\renewcommand{\maketitle}{
    \hypertarget{page:titlepage}{}
    \begin{page}
        \drawbackground
        \setthiscolor{titlepage}{text}
        \drawoverlay{\titlepageopacity}{this}
        \drawlogo
        \drawinfo
        \drawauthor
        \drawsubtitle
        \drawtitle
    \end{page}
}
\renewcommand{\titlepage}{\maketitle}
\newcommand{\titleslide}{\maketitle}
% Logo
\renewcommand{\logo}[1]{\def\logofile{#1}}
\newcommand{\showlogo}{\toggletrue{logo}}
\newcommand{\hidelogo}{\togglefalse{logo}}
\newcommand{\drawlogo}{\iftoggle{logo}{
    \ifthenelse{\isundefined{\logox}}
        {\defaultx{\thisx}{\logoxratio}}
        {\setlength{\thisx}{\logox}}
    \ifthenelse{\isundefined{\logoy}}
        {\defaulty{\thisy}{\logoyratio}}
        {\setlength{\thisy}{\logoy}}
    \setthiscolor{titlepagetext}{page}
    \node[
        inner sep=0cm,
        outer sep=0cm,
        anchor=\logoanchor,
        color=this,
        \iftoggle{info}{draw}{}
    ] at (\thisx, \thisy)
    {\ifthenelse{\isundefined{\logoheight}}
        {\ifthenelse{\isundefined{\logowidth}}
            {\includegraphics[
                height=\logohratio\paperheight,
            ]{\logofile}}
            {\includegraphics[
                width=\logowidth,
            ]{\logofile}}}
        {\ifthenelse{\isundefined{\logowidth}}
            {\includegraphics[
                height=\logoheight,
            ]{\logofile}}
            {\includegraphics[
                width=\logowidth,
                height=\logoheight,
            ]{\logofile}}}};
}{}}
% Title
\renewcommand{\title}[1]{\def\titlename{#1}}
\newcommand{\fontsizetitle}{%
    \thisfontsize{\titlefontheight}{\titlefontspace}%
}
\newcommand{\setfontsizetitle}[2][1.2]{%
    \setfontsize{#1}{#2}{\titlefontheight}{\titlefontspace}%
}
\newcommand{\drawtitle}{
    \ifthenelse{\isundefined{\titlex}}
        {\defaultx{\thisx}{\titlexratio}}
        {\setlength{\thisx}{\titlex}}
    \ifthenelse{\isundefined{\titley}}
        {\defaulty{\thisy}{\titleyratio}}
        {\setlength{\thisy}{\titley}}
    \ifthenelse{\isundefined{\titlewidth}}
        {\setlength{\thisw}{\fpeval{
            (1-2*min(\thisx/\paperwidth,1-\thisx/\paperwidth))*\standardheight*\pageratio
        }cm}}
        {\setlength{\thisw}{\titlewidth}}
    \fontsizetitle
    \setthiscolor{titlepagetext}{page}
    \setthiscolor{title}{this}
    \node[
        scale=\pagescale,
        inner sep=0cm,
        outer sep=0cm,
        anchor=\titleanchor,
        text width=\thisw,
        align=\titlealign,
        color=this,
        \iftoggle{info}{draw}{}
    ] at (\thisx, \thisy){\textbf{\titlename}};
    \fontsizecontent
}
% Subtitle
\renewcommand{\subtitle}[1]{\def\subtitlename{#1}}
\newcommand{\fontsizesubtitle}{%
    \thisfontsize{\subtitlefontheight}{\subtitlefontspace}%
}
\newcommand{\setfontsizesubtitle}[2][1.2]{%
    \setfontsize{#1}{#2}{\subtitlefontheight}{\subtitlefontspace}%
}
\newcommand{\drawsubtitle}{
    \ifthenelse{\isundefined{\subtitlex}}
        {\defaultx{\thisx}{\subtitlexratio}}
        {\setlength{\thisx}{\subtitlex}}
    \ifthenelse{\isundefined{\subtitley}}
        {\defaulty{\thisy}{\subtitleyratio}}
        {\setlength{\thisy}{\subtitley}}
    \ifthenelse{\isundefined{\subtitlewidth}}
        {\setlength{\thisw}{\fpeval{
            (1-2*min(\thisx/\paperwidth,1-\thisx/\paperwidth))*\standardheight*\pageratio
        }cm}}
        {\setlength{\thisw}{\subtitlewidth}}
    \fontsizesubtitle
    \setthiscolor{titlepagetext}{page}
    \setthiscolor{subtitle}{this}
    \node[
        scale=\pagescale,
        inner sep=0cm,
        outer sep=0cm,
        anchor=\subtitleanchor,
        text width=\thisw,
        align=\subtitlealign,
        color=this,
        \iftoggle{info}{draw}{}
    ] at (\thisx, \thisy){\textbf{\subtitlename}};
    \fontsizecontent
}
% Author
\renewcommand{\author}[1]{\def\authorname{#1}}
\newcommand{\fontsizeauthor}{%
    \thisfontsize{\authorfontheight}{\authorfontspace}%
}
\newcommand{\setfontsizeauthor}[2][1.2]{%
    \setfontsize{#1}{#2}{\authorfontheight}{\authorfontspace}%
}
\newcommand{\drawauthor}{
    \ifthenelse{\isundefined{\authorx}}
        {\defaultx{\thisx}{\authorxratio}}
        {\setlength{\thisx}{\authorx}}
    \ifthenelse{\isundefined{\authory}}
        {\defaulty{\thisy}{\authoryratio}}
        {\setlength{\thisy}{\authory}}
    \ifthenelse{\isundefined{\authorwidth}}
        {\setlength{\thisw}{\fpeval{
            (1-2*min(\thisx/\paperwidth,1-\thisx/\paperwidth))*\standardheight*\pageratio
        }cm}}
        {\setlength{\thisw}{\authorwidth}}
    \fontsizeauthor
    \setthiscolor{titlepagetext}{page}
    \setthiscolor{author}{this}
    \node[
        scale=\pagescale,
        inner sep=0cm,
        outer sep=0cm,
        anchor=\authoranchor,
        text width=\thisw,
        align=\authoralign,
        color=this,
        \iftoggle{info}{draw}{}
    ] at (\thisx, \thisy){\textbf{\authorname}};
    \fontsizecontent
}
% Info
\newcommand{\info}[1]{\def\infoname{#1}}
\newcommand{\fontsizeinfo}{%
    \thisfontsize{\infofontheight}{\infofontspace}%
}
\newcommand{\setfontsizeinfo}[2][1.2]{%
    \setfontsize{#1}{#2}{\infofontheight}{\infofontspace}%
}
\newcommand{\drawinfo}{
    \ifthenelse{\isundefined{\infox}}
        {\defaultx{\thisx}{\infoxratio}}
        {\setlength{\thisx}{\infox}}
    \ifthenelse{\isundefined{\infoy}}
        {\defaulty{\thisy}{\infoyratio}}
        {\setlength{\thisy}{\infoy}}
    \ifthenelse{\isundefined{\infowidth}}
        {\setlength{\thisw}{\fpeval{
            (1-2*min(\thisx/\paperwidth,1-\thisx/\paperwidth))*\standardheight*\pageratio
        }cm}}
        {\setlength{\thisw}{\infowidth}}
    \fontsizeinfo
    \setthiscolor{titlepagetext}{page}
    \setthiscolor{info}{this}
    \node[
        scale=\pagescale,
        inner sep=0cm,
        outer sep=0cm,
        anchor=\infoanchor,
        text width=\thisw,
        align=\infoalign,
        color=this,
        \iftoggle{info}{draw}{}
    ] at (\thisx, \thisy){\textbf{\infoname}};
    \fontsizecontent
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%             %%%%%%%%%%
%%%%%%%%%%   BANNERS   %%%%%%%%%%
%%%%%%%%%%             %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\banneropacity{0.75}
\newtoggle{banner}
\toggletrue{banner}
\newtoggle{topbanner}
\toggletrue{topbanner}
\newtoggle{bottombanner}
\toggletrue{bottombanner}
% Top
\def\topbannerheightratio{0.12}
\def\topbannerwidthratio{0.92}
\newlength\topbannerfontheight
\setlength{\topbannerfontheight}{1.2cm}
% Bottom
\def\bottombannerheightratio{0.055}
\def\bottombannerwidthratio{0.94}
\newlength\bottombannerfontheight
\setlength{\bottombannerfontheight}{0.6cm}
% Infos
\def\bannerheaderalign{left}
\def\bannertitlealign{left}
\def\bannerauthoralign{right}
\def\bannersectionalign{center}
\def\bannernumberalign{right}
\newtoggle{bannertext}
\toggletrue{bannertext}
\newtoggle{bannerheader}
\toggletrue{bannerheader}
\newtoggle{bannertitle}
\toggletrue{bannertitle}
\newtoggle{bannerauthor}
\toggletrue{bannerauthor}
\newtoggle{bannersection}
\toggletrue{bannersection}
\newtoggle{bannernumber}
% Progress
\def\progressopacity{0.5}
\def\progressalign{left}
\def\progressratio{0.005}
\newtoggle{progress}
\toggletrue{progress}

% Commands
\newcommand{\showbanner}{\toggletrue{banner}}
\newcommand{\hidebanner}{\togglefalse{banner}}
\newcommand{\drawbanner}{\iftoggle{banner}{\drawtopbanner\drawbottombanner}{}}
% Top
\newcommand{\showtopbanner}{\toggletrue{topbanner}}
\newcommand{\hidetopbanner}{\togglefalse{topbanner}}
\newcommand{\drawtopbanner}{\iftoggle{topbanner}{
    \setthiscolor{banner}{text}
    \setthiscolor{topbanner}{this}
    \ifthenelse{\isundefined{\topbannerheight}}
        {\ifthenelse{\isundefined{\bannerheight}}
            {\setlength{\thish}{\topbannerheightratio\paperheight}}
            {\setlength{\thish}{\bannerheight}}}
        {\setlength{\thish}{\topbannerheight}}
    \ifthenelse{\isundefined{\topbanneropacity}}
        {\def\thisopacity{\banneropacity}}
        {\def\thisopacity{\topbanneropacity}}
    \defaultx{\thisx}{0}
    \defaulty{\thisy}{\fpeval{1-\thish/\paperheight}}
    \draw[
        color=this,
        fill=this,
        line width=0cm,
        opacity=\thisopacity,
    ] (\thisx, \thisy) rectangle (\thisx + \paperwidth, \thisy + \pagereverse*\thish);
    \node[scale=0, opacity=0] (TLcontent) at (\thisx, \thisy){};
}{}}
% Bottom
\newcommand{\showbottombanner}{\toggletrue{bottombanner}}
\newcommand{\hidebottombanner}{\togglefalse{bottombanner}}
\newcommand{\drawbottombanner}{\iftoggle{bottombanner}{
    \setthiscolor{banner}{text}
    \setthiscolor{bottombanner}{this}
    \ifthenelse{\isundefined{\bottombannerheight}}
        {\ifthenelse{\isundefined{\bannerheight}}
            {\setlength{\thish}{\bottombannerheightratio\paperheight}}
            {\setlength{\thish}{\bannerheight}}}
        {\setlength{\thish}{\bottombannerheight}}
    \ifthenelse{\isundefined{\bottombanneropacity}}
        {\def\thisopacity{\banneropacity}}
        {\def\thisopacity{\bottombanneropacity}}
    \defaultx{\thisx}{1}
    \defaulty{\thisy}{\fpeval{\thish/\paperheight}}
    \draw[
        color=this,
        fill=this,
        line width=0cm,
        opacity=\thisopacity,
    ] (\thisx, \thisy) rectangle (\thisx - \paperwidth, \thisy - \pagereverse*\thish);
    \node[scale=0, opacity=0] (BRcontent) at (\thisx, \thisy){};
}{}}
% Progress
\newcommand{\showprogress}{\toggletrue{progress}}
\newcommand{\hideprogress}{\togglefalse{progress}}
\newcommand{\drawprogress}{\iftoggle{progress}{
    \setthiscolor{progress}{third}
    \setlength{\thisw}{\fpeval{(\insertpagenumber - 1)/(\insertdocumentendpage - 1)}\paperwidth}
    \ifthenelse{\isundefined{\progressheight}}
        {\setlength{\thish}{\progressratio\paperheight}}
        {\setlength{\thish}{\progressheight}}
    \ifthenelse{\equal{\progressalign}{right}}
        {\defaultx{\thisx}{1}\addtolength{\thisx}{-\thisw}}
        {\defaultx{\thisx}{0}}
    \ifthenelse{\pagereverse>0}
        {\ifthenelse{\isundefined{\bottombannerheight}}
            {\ifthenelse{\isundefined{\bannerheight}}
                {\setlength{\thisy}{\bottombannerheightratio\paperheight}}
                {\setlength{\thisy}{\bannerheight}}}
            {\setlength{\thisy}{\bottombannerheight}}
        \addtolength{\thisy}{-\pageshift\paperheight}}
        {\setlength{\thisy}{\paperheight}
        \ifthenelse{\isundefined{\bottombannerheight}}
            {\ifthenelse{\isundefined{\bannerheight}}
                {\addtolength{\thisy}{-\bottombannerheightratio\paperheight}}
                {\addtolength{\thisy}{-\bannerheight}}}
            {\addtolength{\thisy}{-\bottombannerheight}}
        \addtolength{\thisy}{-\thish}}
    \draw[
        line width=0cm,
        opacity=\progressopacity,
        color=this,
        fill=this,
    ] (\thisx, \thisy) rectangle (\thisx + \thisw, \thisy + \thish);
}{}}

% Text
\newcommand{\showbannertext}{\toggletrue{bannertext}}
\newcommand{\hidebannertext}{\togglefalse{bannertext}}
\newcommand{\drawtoporbottombannertext}[3]{
    \ifthenelse{\equal{#2}{right}}
        {\addtolength{\thisx}{0.5\thisw}
            \def\thisanchor{east}
            \def\thisalign{right}}
        {\addtolength{\thisx}{-0.5\thisw}
        \ifthenelse{\equal{#2}{left}}
            {\def\thisanchor{west}
                \def\thisalign{left}}
            {\def\thisanchor{center}
                \def\thisalign{center}
            \ifthenelse{\equal{#2}{center}}
                {\addtolength{\thisx}{0.5\thisw}}
                {\addtolength{\thisx}{#2\thisw}}}}
    \ifthenelse{\isundefined{#1}}
        {\node[
            scale=\pagescale,
            inner sep=0cm,
            outer sep=0cm,
            anchor=\thisanchor,
            align=\thisalign,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
        {\node[
            scale=\pagescale,
            inner sep=0cm,
            outer sep=0cm,
            anchor=\thisanchor,
            text width=#1/\pagescale,
            align=\thisalign,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
    at (\thisx, \thisy) {#3};
}
% Top
\newcommand{\fontsizetopbanner}{%
    \thisfontsize{\topbannerfontheight}{\topbannerfontspace}%
}
\newcommand{\setfontsizetopbanner}[2][1.2]{%
    \setfontsize{#1}{#2}{\topbannerfontheight}{\topbannerfontspace}%
}
\newcommand{\drawtopbannertext}[3][bannertext]{
    \setthiscolor{bannertext}{page}
    \setthiscolor{#1}{this}
    \ifthenelse{\isundefined{\topbannerx}}
        {\defaultx{\thisx}{0.5}}
        {\setlength{\thisx}{\topbannerx}}
    \ifthenelse{\isundefined{\topbannery}}
        {\ifthenelse{\isundefined{\topbannerheight}}
            {\ifthenelse{\isundefined{\bannerheight}}
                {\setlength{\thish}{\topbannerheightratio\paperheight}}
                {\setlength{\thish}{\bannerheight}}}
            {\setlength{\thish}{\topbannerheight}}
        \defaulty{\thisy}{\fpeval{1-0.5*\thish/\paperheight}}}
        {\setlength{\thisy}{\topbannery}}
    \ifthenelse{\isundefined{\topbannerwidth}}
        {\setlength{\thisw}{\topbannerwidthratio\paperwidth}}
        {\setlength{\thisw}{\topbannerwidth}}
    \fontsizetopbanner
    \drawtoporbottombannertext{\topbannerwidth}{#2}{#3}
    \fontsizecontent
}
% Bottom
\newcommand{\fontsizebottombanner}{%
    \thisfontsize{\bottombannerfontheight}{\bottombannerfontspace}%
}
\newcommand{\setfontsizebottombanner}[2][1.2]{%
    \setfontsize{#1}{#2}{\bottombannerfontheight}{\bottombannerfontspace}%
}
\newcommand{\drawbottombannertext}[3][bannertext]{
    \setthiscolor{bannertext}{page}
    \setthiscolor{#1}{this}
    \ifthenelse{\isundefined{\bottombannerx}}
        {\defaultx{\thisx}{0.5}}
        {\setlength{\thisx}{\bottombannerx}}
    \ifthenelse{\isundefined{\bottombannery}}
        {\ifthenelse{\isundefined{\bottombannerheight}}
            {\ifthenelse{\isundefined{\bannerheight}}
                {\setlength{\thish}{\bottombannerheightratio\paperheight}}
                {\setlength{\thish}{\bannerheight}}}
            {\setlength{\thish}{\bottombannerheight}}
        \defaulty{\thisy}{\fpeval{0.5*\thish/\paperheight}}}
        {\setlength{\thisy}{\bottombannery}}
    \ifthenelse{\isundefined{\bottombannerwidth}}
        {\setlength{\thisw}{\bottombannerwidthratio\paperwidth}}
        {\setlength{\thisw}{\bottombannerwidth}}
    \fontsizebottombanner
    \drawtoporbottombannertext{\bottombannerwidth}{#2}{#3}
    \fontsizecontent
}

% Header
\newcommand{\bannerheader}[1]{\def\bannerheaderalign{#1}}
\newcommand{\drawbannerheader}[1]{\iftoggle{bannertext}{\iftoggle{bannerheader}{
    \drawtopbannertext[bannerheader]{\bannerheaderalign}{\textbf{#1}}
}{}}{}}
% Footer
\newcommand{\showbannertitle}{\toggletrue{bannertitle}}
\newcommand{\hidebannertitle}{\togglefalse{bannertitle}}
\newcommand{\showbannerauthor}{\toggletrue{bannerauthor}}
\newcommand{\hidebannerauthor}{\togglefalse{bannerauthor}}
\newcommand{\showbannersection}{\toggletrue{bannersection}}
\newcommand{\hidebannersection}{\togglefalse{bannersection}}
\newcommand{\showbannernumber}{\toggletrue{bannernumber}}
\newcommand{\hidebannernumber}{\togglefalse{bannernumber}}
\newcommand{\drawbannertext}{\iftoggle{bannertext}{
    \drawbannertitle
    \drawbannerauthor
    \drawbannersection
    \drawbannernumber
}{}}
\newcommand{\drawbannertitle}{\iftoggle{bannertitle}{
    \drawbottombannertext[bannertitle]
        {\bannertitlealign}
        {\hyperlink{page:titlepage}{\titlename}}
}{}}
\newcommand{\drawbannerauthor}{\iftoggle{bannerauthor}{
    \drawbottombannertext[bannerauthor]
        {\bannerauthoralign}
        {\hyperlink{page:finalpage}{\authorname}}
}{}}
\newcommand{\drawbannersection}{\iftoggle{bannersection}{
    \drawbottombannertext[bannersection]
        {\bannersectionalign}
        {\hyperlink{section:\sectionname}{\sectionname}}
}{}}
\newcommand{\drawbannernumber}{\iftoggle{bannernumber}{
    \drawbottombannertext[bannernumber]
        {\bannernumberalign}
        {\insertpagenumber\,/\,\insertdocumentendpage}
}{}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                       %%%%%%%%%%
%%%%%%%%%%   TABLE OF CONTENTS   %%%%%%%%%%
%%%%%%%%%%                       %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\tocheadername{Table of contents}
\def\tocheightratio{0.4}
\def\tocopacity{0.2}
\newtoggle{toc}
\toggletrue{toc}
% Sections
\def\sectionname{}
\def\sectionlist{}
\def\sectionanchor{west}
\def\sectionxratio{0.13}
\newtoggle{section}
\toggletrue{section}
\newlength\sectionfontheight
\setlength{\sectionfontheight}{1cm}
\newcounter{sections}
\setcounter{sections}{0}
% Symbols
\def\symbollist{}
\def\symbolanchor{center}
\def\symbolxratio{0.1}
\newtoggle{symbol}
\toggletrue{symbol}
\newlength\symbolfontheight
\setlength{\symbolfontheight}{0.8cm}

% Commands
\newcommand{\showtoc}{\toggletrue{toc}}
\newcommand{\hidetoc}{\togglefalse{toc}}
\newcommand{\showtableofcontents}{\showtoc}
\newcommand{\hidetableofcontents}{\hidetoc}
\newcommand{\getsectionref}[2][1]{%
    \ifthenelse{\equal{\thethis}{#1}}%
        {\hyperlink{section:#2}{\color{this}#2}}{}%
    \stepcounter{this}%
}
\newcommand{\tosection}[1]{%
    \setthiscolor{tosection}{first}%
    \setcounter{this}{1}%
    \ifthenelse{\equal{#1}{}}%
        {\forlistloop{\getsectionref[\thesection]}{\sectionlist}}%
        {\forlistloop{\getsectionref[#1]}{\sectionlist}}%
}
\newcommand{\findsectionname}[1]{%
    \ifthenelse{\equal{\thethis}%
        {\thesection}}{\def\sectionname{#1}}{}%
    \stepcounter{this}%
}
\newcommand{\drawtoc}[1]{
    \begin{tikzslide}[\tocheadername]
        \ifthenelse{\isundefined{\tocheight}}
            {\setlength{\thish}{\tocheightratio\paperheight}}
            {\setlength{\thish}{\tocheight}}
        \ifthenelse{\isundefined{\tocy}}
            {\defaulty{\thisy}{0.5}
                \addtolength{\thisy}{\fpeval{\pagereverse/2}\thish}}
            {\setlength{\thisy}{\tocy}}
        \def\thisopacity{#1}
        \iftoggle{symbol}{\drawsymbols}{}
        \iftoggle{section}{\drawsections}{}
    \end{tikzslide}
}
\newcommand{\toc}[1][]{
    \ifthenelse{\equal{#1}{}}{}{\def\tocheadername{#1}}
    \drawtoc{1}
}
\renewcommand{\tableofcontents}[1][]{\toc[#1]}
% Sections
\newcommand{\showsection}{\toggletrue{section}}
\newcommand{\hidesection}{\togglefalse{section}}
\newcommand{\addsection}[2][$\bullet$]{%
    \listadd{\symbollist}{#1}%
    \listadd{\sectionlist}{#2}%
    \stepcounter{sections}%
}
\renewcommand{\section}{
    \setcounter{this}{0}
    \forlistloop{\findsectionname}{\sectionlist}
    \hypertarget{section:\sectionname}{}
    \iftoggle{toc}{\drawtoc{\tocopacity}}{}
    \stepcounter{section}
}
\newcommand{\fontsizesection}{%
    \thisfontsize{\sectionfontheight}{\sectionfontspace}%
}
\newcommand{\setfontsizesection}[2][1.2]{%
    \setfontsize{#1}{#2}{\sectionfontheight}{\sectionfontspace}%
}
\newcommand{\drawsection}[1]{
    \ifthenelse{\equal{\thethis}{\thesection}}
        {\node[
            inner sep=0cm,
            outer sep=0cm,
            anchor=\sectionanchor,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
        {\node[
            inner sep=0cm,
            outer sep=0cm,
            anchor=\sectionanchor,
            opacity=\thisopacity,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
    at (\thisx, \thisy - \fpeval{\pagereverse*\thethis/(\thesections - 1)}*\thish)
    {\hyperlink{section:#1}{\scalebox{\pagescale}{#1}}};
    \stepcounter{this}
}
\newcommand{\drawsections}{
    \ifthenelse{\isundefined{\sectionx}}
        {\defaultx{\thisx}{\sectionxratio}}
        {\setlength{\thisx}{\sectionx}}
    \setcounter{this}{0}
    \setthiscolor{section}{text}
    \fontsizesection
    \forlistloop{\drawsection}{\sectionlist}
    \fontsizecontent
}
% Symbols
\newcommand{\showsymbol}{\toggletrue{symbol}}
\newcommand{\hidesymbol}{\togglefalse{symbol}}
\newcommand{\fontsizesymbol}{%
    \thisfontsize{\symbolfontheight}{\symbolfontspace}%
}
\newcommand{\setfontsizesymbol}[2][1.2]{%
    \setfontsize{#1}{#2}{\symbolfontheight}{\symbolfontspace}%
}
\newcommand{\drawsymbol}[1]{
    \ifthenelse{\equal{\thethis}{\thesection}}
        {\node[
            scale=\pagescale,
            inner sep=0cm,
            outer sep=0cm,
            anchor=\symbolanchor,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
        {\node[
            scale=\pagescale,
            inner sep=0cm,
            outer sep=0cm,
            anchor=\symbolanchor,
            opacity=\thisopacity,
            color=this,
            \iftoggle{info}{draw}{}
        ]}
     at (\thisx, \thisy - \fpeval{\pagereverse*\thethis/(\thesections - 1)}*\thish){#1};
    \stepcounter{this}
}
\newcommand{\drawsymbols}{
    \ifthenelse{\isundefined{\symbolx}}
        {\defaultx{\thisx}{\symbolxratio}}
        {\setlength{\thisx}{\symbolx}}
    \setcounter{this}{0}
    \setthiscolor{symbol}{first}
    \fontsizesymbol
    \forlistloop{\drawsymbol}{\symbollist}
    \fontsizecontent
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                     %%%%%%%%%%
%%%%%%%%%%   GENERAL CONTENT   %%%%%%%%%%
%%%%%%%%%%                     %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\contentalign{justify}
\def\contentopacity{0.99}
\newlength\contentmargin
\setlength{\contentmargin}{1.8cm}
\newlength\contentfontheight
\setlength{\contentfontheight}{0.9cm}
% Commands
\newcommand{\fontsizecontent}{%
    \thisfontsize{\contentfontheight}{\contentfontspace}%
}
\newcommand{\setfontsizecontent}[2][1.2]{%
    \setfontsize{#1}{#2}{\contentfontheight}{\contentfontspace}%
}
\newcommand{\drawcontent}{
    \draw[color=page, fill=page, opacity=\contentopacity]
    (BRcontent.center) rectangle (TLcontent.center);
}
\newcommand{\content}[1]{
    \begin{scope}
        \clip (BRcontent.center) rectangle (TLcontent.center);
        \setlength{\thisw}{\fpeval{\pageratio*\standardheight}cm}
        \addtolength{\thisw}{-2\contentmargin}
        \node[
            scale=\pagescale,
            inner sep=\contentmargin,
            outer sep=0cm,
            anchor=north west,
            text width=\thisw,
            align=\contentalign,
            color=text,
            \iftoggle{info}{draw}{}
        ] at (TLcontent.center){#1};
    \end{scope}
}

% Item commands
\newcommand{\citem}[2][item]{%
    \setthiscolor{#1}{first}%
    \item[\color{this}#2]%
}
\newcommand{\fillitem}[1][item]{\citem[#1]{$\bullet$}}
\newcommand{\emptyitem}[1][item]{\citem[#1]{$\circ$}}
% Item environments
\renewenvironment{alert}[1][~\faExclamationTriangle~~]{%
    \settowidth{\thisw}{#1}%
    \begin{itemize}[leftmargin=\thisw, labelsep=0cm]%
    \item[\color{third}#1]%
}{%
    \end{itemize}%
}
\newenvironment{remark}[1][Note]{%
    \begin{alert}[\textbf{\underline{#1}}:~]%
}{%
    \end{alert}%
}
\newenvironment{pointer}[1][first]{%
    \contournumber{10}%
    \contourlength{0.015cm}%
    \begin{alert}[\color{#1}~\contour{#1}{$\rightarrow$}~]%
}{%
    \end{alert}%
}
\newenvironment{question}[1][first]{%
    \contournumber{10}%
    \contourlength{0.015cm}%
    \begin{alert}[\color{#1}~\textbf{Q:}~]%
}{%
    \end{alert}%
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%             %%%%%%%%%%
%%%%%%%%%%   FRAMING   %%%%%%%%%%
%%%%%%%%%%             %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\framingwidthratio{0.99}
\def\framingalign{justify}
\def\framingboxwidthratio{0.333}
\def\framingboxheightratio{0.333}
\newlength\framingspace
\setlength{\framingspace}{0.5cm}
\newlength\framingmargin
\setlength{\framingmargin}{1cm}
\newlength\framingboxlinewidth
\setlength{\framingboxlinewidth}{0.1cm}
\newlength\framingboxroundedcorners
\setlength{\framingboxroundedcorners}{1cm}
% Commands
\newcommand{\drawframingbox}{
    \setthiscolor{framing}{second}
    \setthiscolor{framingbox}{this}
    \ifthenelse{\isundefined{\framingboxwidth}}
        {\setlength{\thisw}{\framingboxwidthratio\thisw}}
        {\setlength{\thisw}{\framingboxwidth}}
    \ifthenelse{\isundefined{\framingboxheight}}
        {\setlength{\thish}{\framingboxheightratio\thisw}}
        {\setlength{\thish}{\framingboxheight}}
    \begin{scope}[shift=(framing.north west)]
        \draw[
            line width=\framingboxlinewidth,
            line cap=round,
            rounded corners=\framingboxroundedcorners,
            color=this,
        ] (0, -\thish/\pagescale) -- (0, 0) -- (\thisw/\pagescale, 0);
    \end{scope}
    \begin{scope}[shift=(framing.south east)]
        \draw[
            line width=\framingboxlinewidth,
            line cap=round,
            rounded corners=\framingboxroundedcorners,
            color=this,
        ] (0, \thish/\pagescale) -- (0, 0) -- (-\thisw/\pagescale, 0);
    \end{scope}begin
}
% Environments
\newenvironment{framing}{%
    \vspace{\framingspace}\par%
    \begin{tikzpicture}
    \setthiscolor{framing}{second}
    \setthiscolor{framingtext}{this}
    \ifthenelse{\isundefined{\framingwidth}}
        {\setlength{\thisw}{\paperwidth}
            \addtolength{\thisw}{-\pagescale\contentmargin}
            \addtolength{\thisw}{-\pagescale\contentmargin}
            \setlength{\thisw}{\framingwidthratio\thisw}}
        {\setlength{\thisw}{\framingwidth}}
    \node[
        inner sep=\framingmargin,
        outer sep=0cm,
        anchor=center,
        text width=\thisw/\pagescale-2*\framingmargin,
        align=\framingalign,
        color=this,
    ](framing) at (0,0)\bgroup%
}{%
    \spacing[-0.75]\,%
    \egroup;
    \drawframingbox
    \end{tikzpicture}
}
\newenvironment{result}[2]{%
    \begin{framing}%
    ~\textbf{#1}%
    ~\ifthenelse{\equal{#2}{}}{}{(#2)}%
    \spacing[0.25]%
}{\end{framing}}
\renewenvironment{theorem}[1][]{%
    \begin{result}{Theorem}{#1}%
}{\end{result}}
\renewenvironment{definition}[1][]{%
    \begin{result}{Definition}{#1}%
}{\end{result}}
\renewenvironment{problem}[1][]{%
    \begin{result}{Open problem}{#1}%
}{\end{result}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%   REFERENCES   %%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definitions
\def\reflist{}
\newtoggle{ref}
\togglefalse{ref}
\newlength\reffontheight
\setlength{\reffontheight}{0.8cm}
% Commands
\newcommand{\fontsizeref}{%
    \thisfontsize{\reffontheight}{\reffontspace}%
}
\newcommand{\setfontsizeref}[2][1.2]{%
    \setfontsize{#1}{#2}{\reffontheight}{\reffontspace}%
}
\newcommand{\drawref}[5]{\hyperlink{#1}{#2 (#3). \textbf{#4}. \textit{#5}.$^{\color{this}\mathrm{#1}}$}}
\newcommand{\writeref}[5]{%
    \setthiscolor{ref}{first}%
    \fillitem[this]%
    \raisebox{\ht\strutbox}{\hypertarget{#1-slide}{}}%
    \drawref{#1}{#2}{#3}{#4}{#5}%
}
\newcommand{\addref}[5]{%
    \toggletrue{ref}%
    \listgadd{\reflist}{\writeref{#1}{#2}{#3}{#4}{#5}}%
}
\newcommand{\citeref}[1]{%
    \setthiscolor{ref}{first}%
    \raisebox{\ht\strutbox}{\hypertarget{#1}{}}%
    \hyperlink{#1-slide}{$^{\color{this}\mathrm{#1}}$}%
}
\newcommand{\letref}[1]{#1}
\newcommand{\refslide}[1][References]{
    \iftoggle{ref}{
    \begin{slide}[#1]
        \fontsizeref
        \begin{itemize}
            \forlistloop{\letref}{\reflist}
        \end{itemize}
    \end{slide}
}{}}
\newcommand{\refpage}[1][References]{\refslide[#1]}
\newcommand{\makeref}[1][References]{\refslide[#1]}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%   FINAL PAGE   %%%%%%%%%%
%%%%%%%%%%                %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Commands
\newcommand{\finalslide}[1][Thank you!]{
    \hypertarget{page:finalpage}{}
    \begin{page}
    \drawbackground
    \drawtopbanner
    \drawbottombanner
    \foreach\a in {left, center, right} {
        \drawtopbannertext{\a}{\textbf{#1}}
        \drawbottombannertext{\a}{\textbf{#1}}
    }
    \drawprogress
    \defaultx{\thisx}{0.5}
    \defaulty{\thisy}{0.5}
    \setthiscolor{final}{page}
    \node[anchor=south](0) at (\thisx, \thisy){};
    \foreach\i  in {1,...,6}{
        \def\scale{\fpeval{1/1.25^(\i-1)}}
        \begin{scope}
        \node[
            this,
            opacity=\fpeval{\scale^2},
            scale=\fpeval{3.5*\scale*\pagescale}
        ]
        (\i) at (\fpeval{\i-1}.south){\textbf{#1}};
        \end{scope}
    }
    \end{page}
}
\newcommand{\finalpage}[1][Thank you!]{\finalslide[#1]}
\newcommand{\makefinal}[1][Thank you!]{\finalslide[#1]}