%%
%% This is file `whuthesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% whuthesis.dtx  (with options: `class')
%% 
%% -----------------------------------
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2015 by Eric Zhang
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Eric Zhang.
%% 
\NeedsTeXFormat{LaTeX2e}[1999/12/01]
\ProvidesClass{whuthesis}[2015/05/16 v1.0 Thesis Template of Wuhan University]
\RequirePackage{kvoptions}
\RequirePackage{etoolbox}
\SetupKeyvalOptions{family=whu, prefix=whu@}
\DeclareBoolOption[true]{zhstyle}
\DeclareComplementaryOption{enstyle}{zhstyle}
\DeclareBoolOption[true]{double}
\DeclareComplementaryOption{single}{double}
\DeclareBoolOption[false]{bwprint}
\DeclareComplementaryOption{colorprint}{bwprint}
\DeclareDefaultOption{\PassOptionsToPackage{\CurrentOption}{ctexbook}}
\ProcessKeyvalOptions*
\ifwhu@zhstyle
 \LoadClass[a4paper, cs4size, UTF8, openany, fancyhdr, hyperref]{ctexbook}
  \CTEXsetup[titleformat+={\zihao{-2}\heiti} ,
             number={\zihao{-2}\arabic{chapter}},
             name={,},
             afterskip={7.8pt},
             beforeskip={12.48pt}]{chapter}
  \CTEXsetup[format+={\zihao{4}\heiti\raggedright},
             beforeskip = {7.8pt},
             afterskip = {7.8pt}]{section}
  \CTEXsetup[format+={\zihao{-4}\heiti\raggedright}]{subsection}
  \CTEXsetup[format={\zihao{-4}\kaishu\raggedright}]{subsubsection}
  \CTEXoptions[contentsname={\zihao{-2}目\qquad 录}]
  \renewcommand\figurename{\bf\zihao{-4} 图}
  \renewcommand\tablename{\zihao{-4} 表}
  \CTEXsetup[name={\bf\heiti\zihao{-2}附录}]{appendix}
  \newcommand{\acknowledgement}{\chapter[致谢]{\ziju{2}\heiti 致谢}}
\else
  \LoadClass[a4paper, cs4size, UTF8, openany, fancyhdr, nocap, hyperref]{ctexbook}
\fi
\setcounter{tocdepth}{2}
\setcounter{secnumdepth}{2}
\RequirePackage{ifpdf,ifxetex}
\ifxetex
 \RequirePackage{graphicx}
\else
  \ifpdf
    \RequirePackage{graphicx}
  \RequirePackage{epstopdf}
   \else\relax
\fi
\fi
\RequirePackage{geometry}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{amsfonts}
\RequirePackage{amsbsy}
\RequirePackage{bm}
\RequirePackage[amsmath,thmmarks]{ntheorem}
\RequirePackage{caption}
\RequirePackage{array}
\RequirePackage{booktabs}
\RequirePackage{fontspec}
\RequirePackage{xcolor}
\RequirePackage{fancyhdr}
\RequirePackage{hyperref}
\ifwhu@double
  \PassOptionsToClass{twoside}{ctexbook}
  \geometry{top=25mm,bottom=20mm,left=30mm,right=30mm}
\else
  \geometry{top=25mm,bottom=20mm,left=30mm,right=30mm}
\fi
\ifwhu@double
 \AtBeginDocument{%
 \pagestyle{fancy}
 \fancyhf{}
 \renewcommand{\headrulewidth}{0pt}
 \fancyfoot[C]{-\,\thepage\,-}
 \fancypagestyle{plain}
{
\fancyhead{}
\renewcommand{\headrulewidth}{0pt}
\fancyfoot{}
\fancyfoot[C]{-\,\thepage\,-}
}
}
\else
 \AtBeginDocument{%
 \pagestyle{fancy}
 \fancyhf{}
 \renewcommand{\headrulewidth}{0pt}
 \fancyfoot[C]{-\,\thepage\,-}
 }
\fancypagestyle{plain}
{
\fancyhead{}
\renewcommand{\headrulewidth}{0pt}
\fancyfoot{}
\fancyfoot[C]{-\,\thepage\,-}
}
\fi
\linespread{1.4743}
\setlength{\parskip}{0.3ex}
\graphicspath{{figures/}{figure/}{pictures/}
  {picture/}{pic/}{pics/}{image/}{images/}}
\DeclareCaptionLabelSeparator{Ex}{\hspace{1ex}}
\DeclareCaptionFont{song}{\songti}
\captionsetup[figure]{
 format=hang,
 labelsep=Ex,
 textfont=song,
 figurewithin=chapter
 }
\renewcommand{\thefigure}{\bf\heiti\arabic{figure}}
\DeclareCaptionFont{hei}{\heiti}
\captionsetup[table]{
 format=hang,
 labelsep=Ex,
 labelfont={hei,bf},
 textfont={hei,bf},
 tablewithin=chapter
 }
\renewcommand{\thetable}{\bf\arabic{table}}
\newcommand{\upcite}[1]{\textsuperscript{\cite{#1}}}
\newcommand{\zhabstractname}{摘要}
\newcommand{\zhkeywordsname}{关键词}
\newcommand{\zhkeywords}[1]{
\vspace{1cm}{\noindent\heiti\zihao{-4}\zhkeywordsname: }#1}
\newenvironment{zhabstract}{
 \newpage
 \heiti\chapter*{\ziju{2}\zhabstractname}
 \list{}{
 \partopsep=0pt%
 \itemindent=2em \listparindent=\itemindent
 \leftmargin=0pt \rightmargin=\leftmargin
 \parsep=0pt}
 \songti\zihao{-4}\item
 \baselineskip=23pt
 \setlength{\parskip}{0.3ex}}{\endlist\clearpage}
\newcommand{\enabstractname}{ABSTRACT}
\newcommand{\enkeywordsname}{Key words}
\newcommand{\enkeywords}[1]{
 \vspace{1cm}{\noindent\bfseries\zihao{-4}\enkeywordsname: }#1}
\newenvironment{enabstract}{
 \newpage
 \heiti\chapter*{\zihao{-2}\enabstractname}
 \list{}{
 \partopsep=0pt
 \itemindent=2em \listparindent=\itemindent
 \leftmargin=0pt \rightmargin=\leftmargin
 \parsep=0pt}
 \songti\zihao{-4}\item
 \baselineskip=23pt
 \setlength{\parskip}{0.3ex}}{\endlist\clearpage}
\AtBeginDocument{
 \hypersetup{colorlinks=true, linkcolor=blue}
 }
\ifwhu@bwprint
 \AtBeginDocument{\hypersetup{hidelinks}}
\else\relax
\fi
\numberwithin{equation}{chapter}
\theoremstyle{plain}
\theoremheaderfont{\heiti}
\theorembodyfont{\songti} \theoremindent0em
\theorempreskip{0pt}
\theorempostskip{0pt}
\theoremnumbering{arabic}
\theoremsymbol{}
\newtheorem{theorem}{\hspace{2em}定理}[chapter]
\newtheorem{definition}{\hspace{2em}定义}[chapter]
\newtheorem{lemma}{\hspace{2em}引理}[chapter]
\newtheorem{corollary}{\hspace{2em}推论}[chapter]
\newtheorem{proposition}{\hspace{2em}性质}[chapter]
\newtheorem{example}{\hspace{2em}例}[chapter]
\newtheorem{remark}{\hspace{2em}注}[chapter]
\theoremstyle{nonumberplain}
\theoremheaderfont{\heiti}
\theorembodyfont{\normalfont \rm \songti}
\theoremindent0em \theoremseparator{\hspace{1em}}
\theoremsymbol{$\square$}
\newtheorem{proof}{\hspace{2em}证明}
\setmainfont{Times New Roman}
\setmonofont{Times New Roman}
\setsansfont{Times New Roman}
\input{whuthesis-cover.def}
\input{whuthesis-statement.def}
\endinput
%% 
%% Copyright (C) 2015 by Eric Zhang
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Eric Zhang.
%% 
%% -----------------------------------
%% 
%% This work consists of the file  whuthesis.dtx and whuthesis.ins
%% and the derived files           whuthesis.cls,
%%                                 whuthesis-cover.def,
%%                                 whuthesis-statement.def,
%%                                 figures/,
%%                                 whuthesis-manual.tex,
%%                                 README.md,
%%                                 LICENSE.md,
%%                                 whuthesis.pdf and
%%                                 whuthesis-manual.pdf.
%%
%% End of file `whuthesis.cls'.
