## InstallPaths.cmake
##
## Copyright (C) 2006-2018 Christian Schenk
## 
## This file is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; either version 2, or (at your
## option) any later version.
## 
## This file is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this file; if not, write to the Free Software
## Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
## USA.

if(MIKTEX_MACOS_BUNDLE)
  set(MIKTEX_MACOS_BUNDLE_NAME "MiKTeX Console")
  set(MIKTEX_MACOS_BUNDLE_DIR "${MIKTEX_MACOS_BUNDLE_NAME}.app/Contents")
endif()

if(MIKTEX_NATIVE_WINDOWS)
  set(MIKTEX_INSTALL_DIR "texmf")
elseif(MIKTEX_MACOS_BUNDLE)
  set(MIKTEX_INSTALL_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/texmf")
elseif(MIKTEX_SELF_CONTAINED)
  set(MIKTEX_INSTALL_DIR "texmfs/install")
else()
  set(MIKTEX_INSTALL_DIR "${CMAKE_INSTALL_DATAROOTDIR}/${MIKTEX_PREFIX}texmf")
endif()

if(MIKTEX_HOMEBREW)
  set(MIKTEX_DIST_DIR "${CMAKE_INSTALL_DATAROOTDIR}/${MIKTEX_PREFIX}dist")
else()
  set(MIKTEX_DIST_DIR "${MIKTEX_INSTALL_DIR}")
endif()

set(MIKTEX_PORTABLE_REL_TEXMF_ROOT "texmfs")
set(MIKTEX_PORTABLE_REL_INSTALL_DIR "${MIKTEX_PORTABLE_REL_TEXMF_ROOT}/install")
set(MIKTEX_PORTABLE_REL_CONFIG_DIR "${MIKTEX_PORTABLE_REL_TEXMF_ROOT}/config")
set(MIKTEX_PORTABLE_REL_DATA_DIR "${MIKTEX_PORTABLE_REL_TEXMF_ROOT}/data")

if(MIKTEX_NATIVE_WINDOWS AND NOT CMAKE_CL_64)
  set(MIKTEX_REL_MIKTEX_BIN_DIR "miktex/bin")
elseif(MIKTEX_NATIVE_WINDOWS AND CMAKE_CL_64)
  set(MIKTEX_REL_MIKTEX_BIN_DIR "miktex/bin/x64")
else()
  set(MIKTEX_REL_MIKTEX_BIN_DIR "miktex/bin/${MIKTEX_TARGET_SYSTEM_TAG}")
endif()

set(MIKTEX_REL_MIKTEX_INTERNAL_BIN_DIR "${MIKTEX_REL_MIKTEX_BIN_DIR}/internal")

if(MIKTEX_NATIVE_WINDOWS)
  set(MIKTEX_BINARY_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_BIN_DIR}")
  set(MIKTEX_INTERNAL_BINARY_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_INTERNAL_BIN_DIR}")
elseif(MIKTEX_MACOS_BUNDLE)
  set(MIKTEX_BINARY_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/${CMAKE_INSTALL_BINDIR}")
  set(MIKTEX_INTERNAL_BINARY_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/${CMAKE_INSTALL_LIBEXECDIR}")
  set(MIKTEX_MACOS_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/MacOS")
else()
  set(MIKTEX_BINARY_DESTINATION_DIR "${CMAKE_INSTALL_BINDIR}")
  if(MIKTEX_HOMEBREW)
    set(MIKTEX_INTERNAL_BINARY_DESTINATION_DIR "${CMAKE_INSTALL_LIBDIR}/miktex")
  else()
    set(MIKTEX_INTERNAL_BINARY_DESTINATION_DIR "${CMAKE_INSTALL_LIBEXECDIR}/miktex")
  endif()
endif()

if(MIKTEX_MACOS_BUNDLE)
  set(MIKTEX_HEADER_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/${CMAKE_INSTALL_INCLUDEDIR}")
  set(MIKTEX_LIBRARY_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/${MIKTEX_PREFIX}${CMAKE_INSTALL_LIBDIR}")
  set(MIKTEX_MAN_DESTINATION_DIR "${MIKTEX_MACOS_BUNDLE_DIR}/man")
else()
  set(MIKTEX_HEADER_DESTINATION_DIR ${CMAKE_INSTALL_INCLUDEDIR})
  set(MIKTEX_LIBRARY_DESTINATION_DIR ${CMAKE_INSTALL_LIBDIR})
  if(MIKTEX_SELF_CONTAINED OR MIKTEX_MACOS_BUNDLE)
    set(MIKTEX_MAN_DESTINATION_DIR "man")
  else()
    set(MIKTEX_MAN_DESTINATION_DIR "${CMAKE_INSTALL_MANDIR}")
  endif()
endif()

set(MIKTEX_XDG_APPLICATIONS_DIR "${CMAKE_INSTALL_DATAROOTDIR}/applications")

set(MIKTEX_POLKIT_ACTIONS_DIR "${CMAKE_INSTALL_DATAROOTDIR}/polkit-1/actions")

set(MIKTEX_REL_DOC_DIR "doc")

set(MIKTEX_REL_MIKTEX_DOC_DIR "${MIKTEX_REL_DOC_DIR}/miktex")

set(MIKTEX_DOC_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_DOC_DIR}")

set(MIKTEX_REL_MIKTEX_BOOTSTRAPPING_DIR "miktex/bootstrapping")

set(MIKTEX_BOOTSTRAPPING_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_BOOTSTRAPPING_DIR}")

set(MIKTEX_REL_MIKTEX_CONFIG_DIR "miktex/config")

set(MIKTEX_REL_MIKTEX_LOCK_DIR "miktex/lock")

set(MIKTEX_CONFIG_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_CONFIG_DIR}")

set(MIKTEX_REL_MIKTEX_TPM_DIR "tpm/packages")

set(MIKTEX_TPM_DESTINATION_DIR "${MIKTEX_DIST_DIR}/${MIKTEX_REL_MIKTEX_TPM_DIR}")
