//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.SparseIntArray;

public class Parsedocument{
	
	public static SparseBooleanArray error = new SparseBooleanArray();
	public static SparseArray<String> errormessage = new SparseArray<String>();
	    
	public void parsedocument(Canvas canvas, Header header, Symbol symbol2, SuperBlock superblock, Block block, ParagraphBlock paragraphblock, Integer tid, Integer startline, Integer endline, Integer containerwidth, Integer containerheight, Boolean twocolumns, Float ypos, ArrayList<Typeface> tf) {
	    
	    ArrayList<String> superblocktype = new ArrayList<String>();
	    SparseIntArray superblocknumline = new SparseIntArray();
	    SparseIntArray superblockstartline = new SparseIntArray();
	    SparseIntArray superblockendline = new SparseIntArray();
	    SparseArray<ArrayList<String>> superblockline = new SparseArray<ArrayList<String>>();
		
		int totalline=-1;
		int superblocknumber=-1;
	    int centerstartline=0;
	    int alignrightstartline=0;
	    int centerendline=0;
	    int alignrightendline=0;
	    
	    int ii = 0; 
	    int i=0;
		int j=0; 
	    int fontsize=0;
	    int tid2=tid*1000;

	    int viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
	    int tablelinenumber=-1;
	    
	    float indent=Header.indent;
	    
	    String line;
	    
	    error.put(tid,false);
	    errormessage.put(tid,"");
	    
	    ArrayList<Integer> tablehlinecounter = new ArrayList<Integer>();

	    Boolean dohyphenation=true;
	    String columnspec ="";

		ArrayList<String> tblockline = new ArrayList<String>();
		
		String sfontsize=Integer.toString(Header.fontsize);
		String attribute1="";
		String attribute0="";
		String attribute2="";
		
		if (sfontsize.length()==1){
			    attribute0 =  "000"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
				attribute1 =  "000"+sfontsize+"0010xff00000000+0.000xFF0000xFF000000";
				attribute2 =  "100"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
			} else if (sfontsize.length()==2){
				attribute0 =  "00"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
				attribute1 =  "00"+sfontsize+"0010xff00000000+0.000xFF0000xFF000000";
				attribute2 =  "10"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
			} else if (sfontsize.length()==3){
				attribute0 =  "0"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
				attribute1 =  "0"+sfontsize+"0010xff00000000+0.000xFF0000xFF000000";
				attribute2 =  "1"+sfontsize+"0000xff00000000+0.000xFF0000xFF000000";
		}			 

		for (int iii=startline;iii<=endline;iii++){
	
			line=Source.lineblock.get(iii);
		    line.trim();
		    if (line.substring(0,17).equals("!begin{lineblock}")){line=line.substring(17); line.trim();};
			j=line.indexOf("!end{lineblock}"); 
			if(j==-1){error.put(tid,true);errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+"The !end{lineblock} command missing, parse failed!!");return;}
			
		for (ii=0;j != 0; ii++){			
			if (line.length()>=16 && line.substring(0,16).equals("!begin{eqnarray}")  && (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {

				i=line.indexOf("}",16);
				columnspec=line.substring(17,i);
				line=line.substring(i+1); line=line.trim();
				superblocknumber++;superblocktype.add("eqnarray");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				
			} else if (line.length()>=14 && line.substring(0,14).equals("!end{eqnarray}")&& !superblocktype.get(superblocknumber).equals("verbatim")){
				
				superblockendline.put(superblocknumber,totalline);
	              if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
	            	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);

				Parseeqnarray eqnarray = new Parseeqnarray();
				   eqnarray.parseeqnarray(canvas, block, tid, containerwidth, containerheight, superblocknumber, superblock, superblockline, superblocknumline, superblockstartline, superblockendline,tf, columnspec, ypos, attribute1);
				   synchronized(this){error.put(tid, Parseeqnarray.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parseeqnarray.errormessage.get(tid)); return;};}
				   ypos=Parseeqnarray.thisypos.get(tid);
	              }
	              
				   line=line.substring(14); line=line.trim();superblocktype.set(superblocknumber,"text");
				   j=line.indexOf("!end{lineblock}");
				   tblockline.clear();
				   
			} else if (line.length()>=13 && line.substring(0,13).equals("!begin{table}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				synchronized(this){superblock.addtable(tid);}
				i=line.indexOf("}",13);
				columnspec=line.substring(14,i);
				line=line.substring(i+1); line=line.trim();
				
				superblocknumber++;superblocktype.add("table");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);

	  			tablehlinecounter.add(-1);tablelinenumber++;
	  			
				boolean noline=false;
				for (int k=0;noline==false && k < 1000;k++){
					if (line.substring(0,6).equals("!hline")){tablehlinecounter.set(tablelinenumber, tablehlinecounter.get(tablelinenumber)+1);  line=line.substring(6); line=line.trim();}
					else {noline=true;};
				}
				
			} else if (line.length()>=11 && line.substring(0,11).equals("!end{table}")&& !superblocktype.get(superblocknumber).equals("verbatim")){

				superblockendline.put(superblocknumber,totalline);
	            if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
	          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);

				Parsetable table = new Parsetable();
				
				   table.parsetable(canvas, block, paragraphblock, tid, containerwidth, containerheight, tablelinenumber, tablehlinecounter, superblocknumber, superblock, superblockline, superblocknumline, superblockstartline, superblockendline,tf, columnspec, ypos, attribute2, attribute0);
				   error.put(tid, Parsetable.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parsetable.errormessage.get(tid)); return;};               
				   ypos=Parsetable.thisypos.get(tid);
	               tablelinenumber=-1;
	               tablehlinecounter.clear();
	            }            
	            synchronized(this){totalline=SuperBlock.superblocklinenumber.get(tid);}
				line=line.substring(11); line=line.trim();;superblocktype.set(superblocknumber,"text");
				j=line.indexOf("!end{lineblock}");
				tblockline.clear();tablehlinecounter.clear();tablelinenumber=-1;
				
			} else if (line.length()>=21 && line.substring(0,21).equals("!begin{graphicstable}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				synchronized(this){superblock.addtable(tid);}
				i=line.indexOf("}",21);
				columnspec=line.substring(22,i);
				line=line.substring(i+1); line=line.trim();
				
				superblocknumber++;superblocktype.add("graphicstable");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);

	  			tablehlinecounter.add(-1);tablelinenumber++;
	  			
				boolean noline=false;
				for (int k=0;noline==false && k < 1000;k++){
					if (line.substring(0,6).equals("!hline")){tablehlinecounter.set(tablelinenumber, tablehlinecounter.get(tablelinenumber)+1);  line=line.substring(6); line=line.trim();}
					else {noline=true;};
				}
				
			} else if (line.length()>=19 && line.substring(0,19).equals("!end{graphicstable}")&& !superblocktype.get(superblocknumber).equals("verbatim")){

				superblockendline.put(superblocknumber,totalline);
	            if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
	          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);

				Parsegraphicstable graphicstable = new Parsegraphicstable();
				
				   graphicstable.parsegraphicstable(canvas, block, paragraphblock, tid, containerwidth, containerheight, tablelinenumber, tablehlinecounter, superblocknumber, superblock, superblockline, superblocknumline, superblockstartline, superblockendline,tf, columnspec, ypos, attribute2, attribute0);
				   error.put(tid, Parsegraphicstable.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parsegraphicstable.errormessage.get(tid)); return;};           
				   ypos=Parsegraphicstable.thisypos.get(tid);
	               tablelinenumber=-1;
	               tablehlinecounter.clear();
	            }            
	            synchronized(this){totalline=SuperBlock.superblocklinenumber.get(tid);}
				line=line.substring(19); line=line.trim();;superblocktype.set(superblocknumber,"text");
				j=line.indexOf("!end{lineblock}");
				tblockline.clear();tablehlinecounter.clear();tablelinenumber=-1;
				
			} else if (line.length()>=16 && line.substring(0,16).equals("!begin{equation}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				
				line=line.substring(16); line=line.trim();
				superblocknumber++;superblocktype.add("equation");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				
			} else if (line.length()>=14 && line.substring(0,14).equals("!end{equation}")&& !superblocktype.get(superblocknumber).equals("verbatim")){
				
				superblockendline.put(superblocknumber,totalline);
	            if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
	          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);
				Parseequation equation = new Parseequation();
				   equation.parseequation(canvas, block, tid, containerwidth, containerheight, superblocknumber, superblock, superblockline, superblocknumline, superblockstartline, superblockendline,tf, columnspec, ypos, attribute1);
					   error.put(tid, Parseequation.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parseequation.errormessage.get(tid)); return;};
				   ypos=Parseequation.thisypos.get(tid);
	            }
	  
				line=line.substring(14); line=line.trim();superblocktype.set(superblocknumber,"text");
				j=line.indexOf("!end{lineblock}");
				tblockline.clear();
			} else if (line.length()>=15 && line.substring(0,15).equals("!begin{caption}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(line.substring(0,15));}
					else {
						tblockline.add(line.substring(0,15));
					}
				totalline++;
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(15); line=line.trim();
				
				
			}else if (line.length()>=13 && line.substring(0,13).equals("!end{caption}")&& !superblocktype.get(superblocknumber).equals("verbatim")) {
			    if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(line.substring(0,13));}
					else {
						tblockline.add(line.substring(0,13));
					}
			    totalline++;
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(13); line=line.trim();

			}else if (line.length()>=10 && line.substring(0,10).equals("!pagebreak")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))){

				synchronized(this){SuperBlock.pagebreak.get(tid).add(SuperBlock.superblocklinenumber.get(tid)+1);}
				line=line.substring(10); line=line.trim();
				
			}else if (line.length()>=16 && line.substring(0,16).equals("!begin{verbatim}")) {
			    indent=0;
				line=line.substring(16); 
				superblocknumber++;superblocktype.add("verbatim");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				
			} else if (line.length()>=14 && line.substring(0,14).equals("!end{verbatim}")){
				superblockendline.put(superblocknumber,totalline);
				if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
		          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);
					  Parseverbatim verbatim = new Parseverbatim();				
					  verbatim.parseverbatim(canvas, block, tid, containerwidth, containerheight, superblocknumber, superblock, superblockline,(float)Header.leftsidemargin , ypos,tf, attribute2);
					  error.put(tid, Parseverbatim.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parseverbatim.errormessage.get(tid)); return;};
					  ypos=Parseverbatim.thisypos.get(tid);
		            }            
				line=line.substring(14); line=line.trim();;superblocktype.set(superblocknumber,"text");
				j=line.indexOf("!end{lineblock}");
				tblockline.clear(); 
			} else if (line.length()>=13 && line.substring(0,13).equals("!begin{title}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				synchronized(this){superblock.addtitle(tid);}
				indent=0;				
				line=line.substring(13); 
				superblocknumber++;superblocktype.add("title");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				
			} else if (line.length()>=11 && line.substring(0,11).equals("!end{title}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))){
				superblockendline.put(superblocknumber,totalline);
				if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
		          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);
		            }	            
				Parsetitle title = new Parsetitle();
				if (twocolumns){Integer containerwidth2=containerwidth*2-Header.rightsidemargin;
				title.parsetitle(canvas, block, paragraphblock, tid, containerwidth2, containerheight, superblocknumber, superblock, superblockline, superblocknumline,superblockstartline,superblockendline, ypos, tf,  attribute1);
				} else {
					title.parsetitle(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, superblockline, superblocknumline,superblockstartline,superblockendline, ypos, tf,  attribute1);
				}
				error.put(tid, Parsetitle.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parsetitle.errormessage.get(tid)); return;};
				synchronized(this){totalline=SuperBlock.superblocklinenumber.get(tid);}
				superblockendline.put(superblocknumber, totalline);
	            superblocktype.set(superblocknumber,"text");
				ypos=Parsetitle.thisypos.get(tid);
				line=line.substring(11); line=line.trim();
				j=line.indexOf("!end{lineblock}");
				tblockline.clear();
			} else if (line.length()>=16 && line.substring(0,16).equals("!begin{graphics}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))) {
				synchronized(this){superblock.addtable(tid);}
			    indent=0;
				line=line.substring(16); 				
				superblocknumber++;superblocktype.add("graphics");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				
			} else if (line.length()>=14 && line.substring(0,14).equals("!end{graphics}")&& (superblocknumber==-1 || !superblocktype.get(superblocknumber).equals("verbatim"))){
				superblockendline.put(superblocknumber,totalline);
				if (superblockendline.get(superblocknumber)>superblockstartline.get(superblocknumber)){
		          	  superblockstartline.put(superblocknumber,superblockstartline.get(superblocknumber)+1);
		            }	            
				Parsegraphics graphics = new Parsegraphics();
				graphics.parsegraphics(canvas, block, paragraphblock, tid, containerwidth, containerheight, tablelinenumber, tablehlinecounter, superblocknumber, superblock, superblockline, superblocknumline, superblockstartline, superblockendline,tf, ypos, attribute2, attribute0);
				error.put(tid, Parsegraphics.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parsegraphics.errormessage.get(tid)); return;};
	               superblockendline.put(superblocknumber, totalline);
	               superblocktype.set(superblocknumber,"text");
				   ypos=Parsegraphics.thisypos.get(tid);
				   synchronized(this){totalline=SuperBlock.superblocklinenumber.get(tid);}
				line=line.substring(14); line=line.trim();
				j=line.indexOf("!end{lineblock}");
				tblockline.clear();
			} else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("eqnarray")){
			    i=line.indexOf("!!");totalline++;
			    if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(" "+line.substring(0,i+2));}
					else {
						tblockline.add(" "+line.substring(0,i+2));
					}
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(i+2); line=line.trim();

			}else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("table")){
				i=line.indexOf("!!");totalline++;
				
				if (superblockline.indexOfKey(superblocknumber)>=0){
				tblockline=superblockline.get(superblocknumber);
				tblockline.add(" "+line.substring(0,i+2));}
				else {
					tblockline.add(" "+line.substring(0,i+2));
				}
				superblockline.put(superblocknumber, tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
	   			line=line.substring(i+2); line=line.trim();
	   			tablelinenumber++;
	   			tablehlinecounter.add(-1);
				boolean noline=false;
				for (int k=0;noline==false && k < 1000;k++){
					if (line.substring(0,6).equals("!hline")){tablehlinecounter.set(tablelinenumber, tablehlinecounter.get(tablelinenumber)+1); line=line.substring(6); line=line.trim();}
					else {noline=true;};
				}   			
			}else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("graphicstable")){
				i=line.indexOf("!!");totalline++;
				
				if (superblockline.indexOfKey(superblocknumber)>=0){
				tblockline=superblockline.get(superblocknumber);
				tblockline.add(" "+line.substring(0,i+2));}
				else {
					tblockline.add(" "+line.substring(0,i+2));
				}
				superblockline.put(superblocknumber, tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
	   			line=line.substring(i+2); line=line.trim();
	   			tablelinenumber++;
	   			tablehlinecounter.add(-1);
				boolean noline=false;
				for (int k=0;noline==false && k < 1000;k++){
					if (line.substring(0,6).equals("!hline")){tablehlinecounter.set(tablelinenumber, tablehlinecounter.get(tablelinenumber)+1); line=line.substring(6); line=line.trim();}
					else {noline=true;};
				}   			
			}else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("equation")){
				i=line.indexOf("!!");totalline++;
				if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(" "+line.substring(0,i+2));}
					else {
						tblockline.add(" "+line.substring(0,i+2));
					}
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(i+2); line=line.trim();
				
			}else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("graphics")){
				i=line.indexOf("!!");totalline++;
				if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(line.substring(0,i+2));}
					else {
						tblockline.add(line.substring(0,i+2));
					}
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(i+2);  
			} else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("title")){
				i=line.indexOf("!!");totalline++;
				if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(line.substring(0,i+2));}
					else {
						tblockline.add(line.substring(0,i+2));
					}
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(i+2);  
			} else if (superblocknumber>=0 && superblocktype.get(superblocknumber).equals("verbatim")){
				i=line.indexOf("!!");totalline++;
				if (superblockline.indexOfKey(superblocknumber)>=0){
					tblockline=superblockline.get(superblocknumber);
					tblockline.add(line.substring(0,i+2));}
					else {
						tblockline.add(line.substring(0,i+2));
					}
				superblockline.put(superblocknumber,tblockline);superblocknumline.put(superblocknumber,superblocknumline.get(superblocknumber)+1);
				line=line.substring(i+2);  
			} else if  (line.length()>=3 && line.substring(0,3).equals("!mo")){
				
				attribute2=attribute2.substring(0,4)+"003"+attribute2.substring(7);
				line=line.substring(3); line=line.trim();
				j=line.indexOf("!end{lineblock}");
			} else if  (line.length()>=3 && line.substring(0,3).equals("!bf")){
				
				attribute2=attribute2.substring(0,4)+"002"+attribute2.substring(7);
				line=line.substring(3); line=line.trim();
				j=line.indexOf("!end{lineblock}");
			}  else if  (line.length()>=3 && line.substring(0,3).equals("!it")){
				
				attribute2=attribute2.substring(0,4)+"001"+attribute2.substring(7);
				line=line.substring(3); line=line.trim();
				j=line.indexOf("!end{lineblock}");
			} else if  (line.length()>=3 && line.substring(0,3).equals("!ss")){
				
				attribute2=attribute2.substring(0,4)+"000"+attribute2.substring(7);
				line=line.substring(3); line=line.trim();
				j=line.indexOf("!end{lineblock}");
			} else if (line.length()>=5 && line.substring(0,5).equals("!Huge")){
				fontsize=(int)(Header.fontsize*Header.sizefactor.get("Huge"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(5); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=5 && line.substring(0,5).equals("!huge")){
			
		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("huge"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(5); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=6 && line.substring(0,6).equals("!Large")){
			
		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("Large"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(6); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=6 && line.substring(0,6).equals("!large")){

		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("large"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(6); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=6 && line.substring(0,6).equals("!small")){
			
		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("small"));if (fontsize<Header.minfontsize){fontsize=Header.minfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(6); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=11 && line.substring(0,11).equals("!scriptsize")){
		    	
		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("scriptsize"));if (fontsize<Header.minfontsize){fontsize=Header.minfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}							
				line=line.substring(11); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=5 && line.substring(0,5).equals("!tiny")){
		    	
		    	fontsize=(int)(Header.fontsize*Header.sizefactor.get("tiny")); if (fontsize<Header.minfontsize){fontsize=Header.minfontsize;};
				sfontsize=Integer.toString(fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}							
				line=line.substring(5); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=11 && line.substring(0,11).equals("!normalsize")){
			
				sfontsize=Integer.toString(Header.fontsize);
				if (sfontsize.length()==1){
				    attribute0 =  "000"+sfontsize+attribute0.substring(4);
					attribute1 =  "000"+sfontsize+attribute1.substring(4);
					attribute2 =  "100"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==2){
					attribute0 =  "00"+sfontsize+attribute0.substring(4);
					attribute1 =  "00"+sfontsize+attribute1.substring(4);
					attribute2 =  "10"+sfontsize+attribute2.substring(4);
				} else if (sfontsize.length()==3){
					attribute0 =  "0"+sfontsize+attribute0.substring(4);
					attribute1 =  "0"+sfontsize+attribute1.substring(4);
					attribute2 =  "1"+sfontsize+attribute2.substring(4);
				}					
				line=line.substring(11); line=line.trim();j=line.indexOf("!end{lineblock}");
		    } else if (line.length()>=7 && line.substring(0,7).equals("!vspace")){
			
			int ij=line.indexOf("}",7);
			float vspace=Integer.parseInt(line.substring(8,ij));
			ypos=ypos+vspace;
			line=line.substring(ij+1); line=line.trim();

		    } else if (line.length()>=14 && line.substring(0,14).equals("!begin{center}")){
			synchronized(this){centerstartline=SuperBlock.superblocklinenumber.get(tid);}
			dohyphenation=false;
			line=line.substring(14); line=line.trim();j=line.indexOf("!end{lineblock}");
			indent=0;
		    } else if (line.length()>=12 && line.substring(0,12).equals("!end{center}")){	    
		    	synchronized(this){
		    	viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
			centerendline=SuperBlock.superblocklinenumber.get(tid);
			
			if (centerendline > centerstartline){centerstartline=centerstartline+1;};
			for (i=centerstartline;i<=centerendline;i++){			
				float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}			
			}
		    	dohyphenation=true;
		    	line=line.substring(12); line=line.trim();j=line.indexOf("!end{lineblock}");
		    	indent=Header.indent;
		    	}
		    } else if (line.length()>=17 && line.substring(0,17).equals("!begin{alignleft}")){
			    indent=0;
		    	dohyphenation=false;
		    	line=line.substring(17); line=line.trim();
		    	
		    } else if (line.length()>=15 && line.substring(0,15).equals("!end{alignleft}")){
		    	dohyphenation=true;
		    	line=line.substring(15); line=line.trim();j=line.indexOf("!end{lineblock}");
		    	
		    } else if (line.length()>=18 && line.substring(0,18).equals("!begin{alignright}")){
			    indent=0;
				synchronized(this){alignrightstartline=SuperBlock.superblocklinenumber.get(tid);}
				dohyphenation=false;
				line=line.substring(18); line=line.trim();
				indent=0;
		    } else if (line.length()>=16 && line.substring(0,16).equals("!end{alignright}")){
		    	synchronized(this){
		    	viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
			alignrightendline=SuperBlock.superblocklinenumber.get(tid);
			
			if (alignrightendline > alignrightstartline){alignrightstartline=alignrightstartline+1;};
			for (i=alignrightstartline;i<=alignrightendline;i++){			
				float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i));
					for (ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}			
			}
		    	dohyphenation=true;
		    	line=line.substring(16); line=line.trim();j=line.indexOf("!end{lineblock}");
		    	indent=Header.indent;
		    	}
		    } else {
				i=line.indexOf("!!");

				tblockline.add(line.substring(0,i));
				totalline++;
				superblocknumber++;superblockline.put(superblocknumber,tblockline);superblocktype.add("text");superblocknumline.put(superblocknumber,0);
				superblockstartline.put(superblocknumber, totalline);
				Parsetext text = new Parsetext();
				   text.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, tblockline.get(0), (float)Header.leftsidemargin , ypos, tf, attribute2, attribute1, dohyphenation, indent);
					   error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+Parsetext.errormessage.get(tid)); return;};
				   synchronized(this){totalline=SuperBlock.superblocklinenumber.get(tid);}
	               superblockendline.put(superblocknumber, totalline);
				   ypos=Parsetext.thisypos.get(tid);
	
	         tblockline.clear();
	         line=line.substring(i+2); line=line.trim();
	         }
				j=line.indexOf("!end{lineblock}");
				if (j==0 && !superblocktype.get(superblocknumber).equals("text")){error.put(tid,true);errormessage.put(tid, "Lineblock "+Integer.toString(iii)+" : "+"The !end{"+superblocktype.get(superblocknumber)+"} "+"command missing, parse failed!!");return;}
			}
		}

		synchronized(this){SuperBlock.ypos.put(tid, ypos);}
		return;
	   
	 }}
