/*###########################################################################
 # =============================> hpcom.h <================================ #
 #**************************************************************************#
 # This file holds the font- and character descriptor structure definitions,#
 #                    common to `dvihp' and `crereshp'                      #
 ###########################################################################*/


/*==========================================================================*
 *                 global type definitions                                  *
 *==========================================================================*/

typedef struct                       /* Laserjet II font descriptor     */
      { ushort size;                 /* Font descriptor Size = 64    NU */
        ubyte  fmt;                  /* Descriptor Format            NU */
        ubyte  type;                 /* Font Type                       */
        short  res1;                 /* Reserved (set to zero)          */
        ushort baseline;             /* Baseline Distance            NU */
        ushort cell_width;           /* Cell Width in dots           NU */
        ushort cell_height;          /* Cell Height in dots          NU */
        ubyte  orientation;          /* 0=portrait,  1=landscape        */
        byte   spacing;              /* 0=fixed,     1=proportional     */
        ushort symbol_set;           /* legal values 0...2047           */
        ushort pitch;                /* in quarter-dots, for fixed only */
        ushort height;               /* in quarter-dots                 */
        ushort xheight;              /* height of x in q-dots        NU */
        byte   wtype;                /* With Type                    NU */
        ubyte  style;                /* 0=upright    1=italics          */
        byte   stroke_weight;        /* valid values -7...7             */
        ubyte  ltypeface;            /* lower byte of typeface value    */
        ubyte  htypeface;            /* higher byte of typeface value   */
        ubyte  serif_style;          /* legal values 0...8           NU */
        short  res2;                 /* Reserved (set to zero)          */
        byte   u_distance;           /* Underline Distance to baseline  */
        ubyte  u_height;             /* Underline Height             NU */
        ushort text_height;          /* in quarter-dots              NU */
        ushort text_width;           /* in quarter-dots              NU */
        short  res3;                 /* Reserved (set to zero)          */
        short  res4;                 /* Reserved (set to zero)          */
        byte   ext_pitch;            /* Pitch Extended,  in micro-dots  */
        byte   ext_height;           /* Height Extended, in mircor-dots */
        short  cap_height;           /* Cap Height Data              NU */
        short  res5;                 /* Reserved (set to zero)          */
        short  res6;                 /* Reserved (set to zero)          */
        char   name[16];             /* Font Name                       */
      } fdfmt;                      
                                     /* NU-marked members are ignored   */
                                     /* by the Laserjet IID, but should */
                                     /* be set to some legal value!     */

typedef struct                       /* LaserjetII character descriptor */
      { ubyte  fmt;                  /* Format = 4 for LaserJet II      */
	byte   cont;                 /* 0 for CD, 1 for data continue   */
	ubyte  size;                 /* Descriptor Size = 14            */
	ubyte  class;                /* Set to 1                        */
        ubyte  orientation;          /* 0 = portrait,   1 = landscape   */
	byte   res;                  /* Reserved, set to 0              */
        short  left_offset;          /* Left Offset from Ref-Point      */
        short  top_offset;           /* Top Offset from Ref-Point       */
        ushort char_width;           /* Character Width in dots         */ 
        ushort char_height;          /* Character Height in dots        */
        short  delta_x;              /* Next Char Position in q-dots    */
      } cdfmt;


