#
#       Copyright (C) 2018 On-Tapp-Networks Limited
#

import os
import subprocess
import stat

import xbmc
import xbmcaddon

import dixie
import download
import extract


#-------------------------------------------------------------


def install():
    dixie.log('============ Install FFMPEG ============')
    if dixie.GetSetting('SUDOPASS') == 'osmc':
        dixie.log('==== I AM: OSMC')
        return installOSMC()

    platform = getPlatform()
    if platform == 'android':
        dixie.DialogOK('On-Tapp.TV Recording does not currently work on Android.', 'We will add this at a future date.', 'For updates, check out our Facebbok Group.')
        return

    baseurl  = dixie.GetExtraUrl() + 'ffmpeg/'
    basedir  = xbmc.translatePath('special://profile/addon_data/script.tvguidedixie/ffmpeg/')
    binary   = os.path.join(basedir, 'ffmpeg')

    src = baseurl + platform + '/ffmpeg.zip'
    dixie.log(src)

    dst = os.path.join(basedir, 'ffmpeg.zip')
    dixie.log(dst)

    try:
        os.makedirs(basedir)
    except:
        pass

    dp = dixie.Progress('Installing Recording Feature', 'Please be patient this may take a few minutes')

    download.download(src, dst, dp)
    extract.all(dst, basedir)

    st = os.stat(binary)
    os.chmod(binary, st.st_mode | stat.S_IEXEC)

    try:
        os.remove(dst)
    except:
        pass

    success = os.path.exists(binary)

    if success:
        dixie.DialogOK('On-Tapp.TV Recording successfully installed')
        xbmcaddon.Addon(dixie.OTT_RECORD).setSetting('ENABLED', 'true')
    else:
        dixie.DialogOK('On-Tapp.TV Recording installation failed', 'Please contact support')


def installOSMC():
    cmdLine  = 'echo \'osmc\' | sudo -S '
    cmdLine +='apt-get update;'
    cmdLine +='sudo apt-get -y install ffmpeg v4l-utils;'

    dp = dixie.Progress('Installing Recording Feature', 'Please be patient this may take a few minutes')

    p = subprocess.Popen(cmdLine, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    (stdout, stderr) = p.communicate()

    # if silent:
    #     return

    xbmc.sleep(100)
    dp.close()

    binary  = '/usr/bin/ffmpeg'
    success =  os.path.exists(binary)

    if success:
        dixie.DialogOK('Recording Feature successfully installed')
        xbmcaddon.Addon(dixie.OTT_RECORD).setSetting('ENABLED', 'true')
    else:
        dixie.DialogOK('Recording Feature installation failed', 'Please contact support')


def getPlatform():
    if xbmc.getCondVisibility('system.platform.android'):
        dixie.log('==== I AM: Android')
        return 'android'
    if xbmc.getCondVisibility('system.platform.windows'):
        dixie.log('==== I AM: Windows')
        return 'windows'
    if xbmc.getCondVisibility('system.platform.osx'):
        dixie.log('==== I AM: OS X')
        return 'osx'
    if xbmc.getCondVisibility('system.platform.linux'):
        dixie.log('==== I AM: Linux')
        return 'linux'

    return ''


if __name__ == '__main__':
    install()
