# coding: utf-8
from os import path
from re import sub, findall
from urlparse import urlparse

import xbmcaddon

from utils import get_int, get_float, get_setting

__author__ = 'Mancuniancol'


# read provider xbmcaddon.Addon()
class MetaSettings(type):
    @classmethod
    def __getitem__(mcs, item):
        # default values
        if item is "max_magnets":
            return get_int(mcs.value.get(item, "10"))
        elif item is "separator":
            return mcs.value.get(item, "%20")
        elif item is "time_noti":
            return get_int(mcs.value.get(item, "750"))
        elif item.endswith("accept"):
            temp = mcs.value.get(item, "{*}")
            return "{*}" if temp is "" else temp
        elif item.endswith("max_size"):
            return get_float(mcs.value.get(item, "10"))
        elif item.endswith("min_size"):
            return get_float(mcs.value.get(item, "0"))
        else:
            return mcs.value.get(item, "")

    # General information
    idAddon = xbmcaddon.Addon().getAddonInfo('ID')  # gets name
    icon = xbmcaddon.Addon().getAddonInfo('icon')
    fanart = xbmcaddon.Addon().getAddonInfo('fanart')
    path_folder = xbmcaddon.Addon().getAddonInfo('path')
    name = xbmcaddon.Addon().getAddonInfo('name')  # gets name
    name_provider = sub('.COLOR (.*?)]', '', name.replace('[/COLOR]', ''))
    value = {}  # it contains all the settings from xml file
    fileName = path.join(path_folder, "resources", "settings.xml")
    if path.isfile(fileName):
        with open(fileName, 'r') as fp:
            data = fp.read()
        for key in findall('id="(\w+)"', data):
            value[key] = get_setting(key)  # reading the values from xbmcaddon.Addon().xml
    temp = urlparse(value.get('general_url', ""))
    url = '%s://%s' % (temp.scheme, temp.netloc)


class Settings(object):
    def __init__(self):
        pass

    __metaclass__ = MetaSettings
    pass

    @staticmethod
    def string(id_value):
        return xbmcaddon.Addon().getLocalizedString(id_value)
