import re
from md_request import open_url
import xbmc
import urllib
from ..scraper import Scraper
import urlparse

User_Agent = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36'


class moviegrabber(Scraper):
    domains = ['https://moviegrabber.tv/']
    name = "Moviegrabber"
    sources = []

    def __init__(self):
        self.base_link = 'https://moviegrabber.tv'
        self.info_link = 'https://moviegrabber.tv/api/media/getDetails?id='
        self.info_url = 'https://moviegrabber.tv/link/'
        self.sources = []

    def scrape_movie(self, title, year, imdb, debrid=False):
        try:
            xbmc.log('TITLE:'+title,xbmc.LOGNOTICE)
            xbmc.log('YEAR GOT:'+year,xbmc.LOGNOTICE)
            search_id = urllib.quote_plus(title.lower())
            start_url = self.base_link+'/searchaskforapi/?id=' + search_id
            headers = {'User_Agent':User_Agent}
            html = open_url(start_url,headers=headers,verify=False,timeout=5).content
            thumbs = re.compile('class="thumbnail">(.+?)</div>',re.DOTALL).findall(html)
            thumb = re.compile('href="(.+?)".+?class="text-center text-bold">(.+?)</p>',re.DOTALL).findall(str(thumbs))  
            for url,link_title in thumb:
                if not (title.lower() in link_title.lower() and year in link_title):
                    continue
                movie_link = self.base_link + url
                self.get_source(movie_link)
                
            return self.sources
        except Exception as e:
            print repr(e)
            return self.sources

    def scrape_episode(self,title, show_year, year, season, episode, imdb, tvdb, debrid = False):
        try:
            search_id = urllib.quote_plus(title.lower())
            start_url = self.base_link+'/searchaskforapi/?id=' + search_id
            headers = {'User_Agent':User_Agent}
            html = open_url(start_url,headers=headers,verify=False,timeout=3).content
            thumbs = re.compile('class="thumbnail">(.+?)</div>',re.DOTALL).findall(html)
            thumb = re.compile('href="(.+?)".+?class="text-center text-bold">(.+?)</p>',re.DOTALL).findall(str(thumbs))  
            for url,link_title in thumb:
                xbmc.log('LINK TITLE:'+link_title,xbmc.LOGNOTICE)
                xbmc.log('TITLE:'+title,xbmc.LOGNOTICE)
                if '(' in link_title:
                    pass
                else:
                    if title.lower() in link_title.lower():
                        movie_link = self.base_link + url
                        self.get_source(movie_link,episode=episode,season=season)
            return self.sources
        except Exception, argument:
            return self.sources

    def get_source(self,movie_link,episode=None,season=None):
        xbmc.log(movie_link,xbmc.LOGNOTICE)
        xbmc.log(str(episode),xbmc.LOGNOTICE)
        xbmc.log(str(season),xbmc.LOGNOTICE)
        headers = {'User_Agent':User_Agent}
        html2 = open_url(movie_link,headers=headers,verify=False,timeout=5).content
        showid = re.findall('showid.attr\("value", (\d+)',str(html2))[0]
        csrf = re.findall("var csrf =.+?value='(.+?)'",str(html2))[0]
        h = open_url(self.info_link+showid,headers=headers,verify=False,timeout=3).content
        match = re.findall('"id":"(.+?)","title":"(.+?)"',h)
        for epid,epname in match:
            if episode != None:
                if season != None:
                    if len(season)==1:
                        season = '0'+season
                    if len(episode)==1:
                        episode = '0'+episode
                    if 'S'+season+'E'+episode not in epname:
                        continue
            xbmc.log(epname,xbmc.LOGNOTICE)
            #print epname
            headers = {"Referer": movie_link,
                       "Cookie":"csrftoken=" + str(csrf)}
            quality = re.findall("\[(.*?)\]", epname)
            if not quality:
                quality = "unknown"
            else:
                quality = quality[0]
            data = {"epid": epid,"showid": showid,"epname": epname,"foo":"","csrfmiddlewaretoken":csrf}
             
            html = open_url(self.info_url, method='post', data=data, headers=headers,verify=False,timeout=3).content
            getblock = re.findall('<div class="list-group">(.+?)</div>',html,re.DOTALL)
            for block in getblock:
                xbmc.log(str(block),xbmc.LOGNOTICE)
                link_info_page = re.findall('<a href="(.+?)" class="list-group-item">\n(.+?)\(',str(block))
                for url_,qual_check in link_info_page:
                    if '1080p' in qual_check:
                        quality = '1080p'
                    elif '720p' in qual_check:
                        quality = '720p'
                    elif '360' in qual_check:
                        quality = '360p'
                    headers = {'User_Agent':User_Agent}
                    html_final = open_url('https://moviegrabber.tv'+url_,headers=headers,verify=False,timeout=3).content
                    playlink_list = re.compile('<source.+?src="(.+?)"',re.DOTALL).findall(html_final)
                    for playlink in playlink_list:
                        xbmc.log(playlink,xbmc.LOGNOTICE)
                        if '3D' not in quality:
                            self.sources.append({'source': 'GoogleVideo','quality': quality,'scraper': self.name,'url': playlink,'direct': True})
                    try:
                        end_url = re.compile('<iframe class.+?src="(.+?)"',re.DOTALL).findall(html_final)[0]
                        playlink = end_url.replace('/preview','/edit')
                        if 'google' in end_url:
                            source = 'GoogleVideo'
                        else:
                            source = 'moviegrabber'
                        xbmc.log(playlink,xbmc.LOGNOTICE)
                        if '3D' not in quality:
                            self.sources.append({'source': source,'quality': quality,'scraper': self.name,'url': playlink,'direct': True})
                    except:
                        pass
