# -*- coding: utf-8 -*-

'''
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import re, urllib, urlparse, hashlib, random, string, json, base64
from ..common import random_agent, clean_title, googletag, clean_search,non_func_hosts
import requests
import urlresolver
from ..scraper import Scraper
import xbmcaddon
import xbmc
from BeautifulSoup import BeautifulSoup


keys = ['7912675e249526c037e21a237863aba0', 'a7208628c92d40818d441105cfebddc6', '9252a8e0f8cb44564ff1a87b47477821', '73978dd7d836b3c0ec362a86ca561d41', '47106bcdd168c44d5aa440a52084e2a3', '72632925e32bf9097e387c9ef9c6fdc3', 
        '33f5d08c3591e605e487c4da9fe0b6ea', '63831b636197620f989df4da3f3c1b5e', 'd3bb8a6b38920be2ad77478589a1b400', '7d3f84d5f7526b08d966bd3b4cca464c','9500877da965b7568ae8f45e4f1a3b33', 'e746b9c2c02e86f10ffc1c7e37b37a04',
        'e22bf4590576c6db9d1963c58f27f020', 'eaadbe1a31b1c631b034ae1504716eff', '6376ba8b0a6bd8328457c690b06284b5', 'a5b305b962dd8cb3b3afd487e5826939', '0cb0779157886999907ddb5532b7b08b', 'c71857fea8902d64b6624ba6263bb09b',
        '5e1d64e8cd1a44a23fe1726aebfefe9a', '1501a2a73bc0e0ca2f7ee2a66a41257c', 'e141ba62757a7b53378ed6ccde2ec936', 'b5838228f475ffaa312a10a82d2ec15e']

alluc_rand=(random.choice(keys))

# %s&query=%s+host%3Arapidgator.net%2Cuploaded.net%2Cfilefactory.com&count=%s'
class Alluc(Scraper):
    name = "Alluc"

    def __init__(self):
        self.base_link = 'https://www.alluc.ee'
        self.api_link = 'https://www.alluc.ee/api/search/download/?apikey=%s&query=%s'
        #self.alluc_user = xbmcaddon.Addon('script.module.dandyscrapers').getSetting("%s_user" % (self.name))
        #self.alluc_pw = xbmcaddon.Addon('script.module.dandyscrapers').getSetting("%s_pw" % (self.name))
        self.max_items = int(xbmcaddon.Addon('script.module.dandyscrapers').getSetting("%s_max" % (self.name)))
        self.max_result_string = '&count=%s' % self.max_items

    def scrape_movie(self, title, year, imdb, debrid = False):
        try:
            self.api_link = 'https://www.alluc.ee/api/search/download/?apikey=%s&query=%s'
            url = self.movie(imdb, title, year)
            sources = self.sources(url, [], [])
            for source in sources:
                source["scraper"] = source["provider"]
            return sources
        except:
            return []

    def movie(self, imdb, title, year):
        self.zen_url = []
        try:
            headers = {'User-Agent': random_agent()}
            search_title = clean_search(title)
            #search_title = title
            cleanmovie = (clean_title(title) + year).translate(None, '\/:*?"\'<>|!,').replace(' ', '-').replace('--', '-').lower()
            query = "%s+%s" % (urllib.quote_plus(search_title), year)
            query = self.api_link % (random.choice(keys), query) + self.max_result_string
            query += "&getmeta=0"
            # xbmc.log("ALLUC r2" + query)
            html = requests.get(query, headers=headers, timeout=5).json()
            for result in html['result']:
                if len(result['hosterurls']) > 1: continue
                if result['extension'] == 'rar': continue

                stream_url = result['hosterurls'][0]['url'].encode('utf-8')
                stream_title = result['title'].encode('utf-8')
                stream_title = clean_search(stream_title)
                if cleanmovie in clean_title(stream_title):
                    self.zen_url.append([stream_url, stream_title])
                    print ("ALLUC r3", self.zen_url)
            return self.zen_url
        except:
            return

    def scrape_episode(self, title, show_year, year, season, episode, imdb, tvdb, debrid = False):
        try:
            self.api_link = 'https://www.alluc.ee/api/search/download/?apikey=%s&query=%s'
            show_url = self.tvshow(imdb, tvdb, title, show_year)
            url = self.episode(show_url, imdb, tvdb, title, year, season, episode)
            sources = self.sources(url, [], [])
            for source in sources:
                source["scraper"] = source["provider"]
            return sources
        except:
            return []

    def tvshow(self, imdb, tvdb, tvshowtitle, year):
        try:
            url = {'tvshowtitle': tvshowtitle, 'year': year}
            url = urllib.urlencode(url)
            return url
        except:
            return

    def episode(self, url, imdb, tvdb, title, premiered, season, episode):
        self.zen_url = []
        try:
            data = urlparse.parse_qs(url)
            data = dict([(i, data[i][0]) if data[i] else (i, '') for i in data])
            title = data['tvshowtitle'] if 'tvshowtitle' in data else data['title']
            cleanmovie = clean_title(title)
            data['season'], data['episode'] = season, episode
            year = data['year']
            ep_id = int(episode)
            season_id = int(season)
            ep_check = season_id + ep_id
            headers = {'User-Agent': random_agent()}
            search_title = title
            ep_check = "s%02de%02d" % (season_id, ep_id)
            cleanmovie = (clean_title(title) + ep_check).translate(None, '\/:*?"\'<>|!,').replace(' ', '-').replace('--', '-').lower()
            query = "%s+%s" % (urllib.quote_plus(search_title), ep_check)
            print ("ALLUC r1", query)
            query = self.api_link % (random.choice(keys), query) + self.max_result_string

            print ("ALLUC r2", query)
            html = requests.get(query, headers=headers, timeout=5).json()
            for result in html['result']:
                if len(result['hosterurls']) > 1: continue
                if result['extension'] == 'rar': continue
                stream_url = result['hosterurls'][0]['url'].encode('utf-8')
                stream_title = result['title'].encode('utf-8')
                stream_title = clean_search(stream_title)

                if cleanmovie in clean_title(stream_title):
                    self.zen_url.append([stream_url, stream_title])
                    print ("ALLUC r3", self.zen_url)
            return self.zen_url
        except:
            return

    def sources(self, url, hostDict, hostprDict):
        try:
            sources = []
            for url, quality in self.zen_url:
                if "1080" in quality:
                    quality = "1080p"
                elif "720" in quality:
                    quality = "720p"
                else:
                    quality = "SD"

                if urlresolver.HostedMediaFile(url).valid_url():
                    host = url.split('//')[1].replace('www.','')
                    host = host.split('/')[0].split('.')[0].title()
                    if not non_func_hosts(host.lower()):
                        continue 
                    sources.append({'source': host, 'quality': quality, 'provider': 'Alluc', 'url': url, 'direct': False})
            return sources

        except:
            return sources

    def resolve(self, url):
        return url

    @classmethod
    def get_settings_xml(clas):
        xml = [
            '<setting id="%s_enabled" ''type="bool" label="Enabled" default="true"/>' % (clas.name),
            '<setting id="%s_max" type="slider" label="Max Results for Search" default="20" range="5,200" option="int"/>' %(clas.name)
        ]
        return xml
