# -*- coding: utf-8 -*-
#
#      Copyright (C) 2012 Tommy Winther
#      http://tommy.winther.nu
#
#      Modified for FTV Guide (09/2014 onwards)
#      by Thomas Geppert [bluezed] - bluezed.apps@gmail.com
#
#      Modified for STVB Guide (2016)
#      by primaeval - primaeval.dev@gmail.com
#
#      Modified for StreamTVBox(2017)
#      by rolica, xunitytalk - rolica@stvbguide.com
#
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this Program; see the file LICENSE.txt.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

import sys
import xbmc,xbmcaddon,xbmcvfs
import os
import stat

ADDON = xbmcaddon.Addon(id='plugin.video.stvbguide')

ME=xbmc.translatePath(os.path.join('special://home/addons/plugin.video.stvbguide', 'removenewinstall.py'))
if os.path.exists(ME) == True:
    import removenewinstall
    try:
        os.unlink(ME)
    except:
        pass

                
ffmpeg = ADDON.getSetting('autoplaywiths.ffmpeg')
if ffmpeg:
    st = os.stat(ffmpeg)
    try:
        os.chmod(ffmpeg, st.st_mode | stat.S_IEXEC)
    except:
        pass

if len(sys.argv) > 1:
    category = sys.argv[1]
    if category:
        ADDON.setSetting('category',category)

if len(sys.argv) > 2:
    source = ADDON.getSetting('source.source')
    new_source = sys.argv[2]
    if new_source != source:
        ADDON.setSetting('source.source',new_source)

assets = [
('special://profile/addon_data/plugin.video.stvbguide/backgrounds/concept.png','http://rolica.co.uk/rtv/concept.png'),
('special://profile/addon_data/plugin.video.stvbguide/actions.json','special://home/addons/plugin.video.stvbguide/resources/actions.json')
]
for (dst,src) in assets:
    if not xbmcvfs.exists(dst):
        xbmcvfs.copy(src,dst)

try:
    import gui
    w = gui.TVGuide()
    w.doModal()
    del w

except:
    import sys
    import traceback as tb
    (etype, value, traceback) = sys.exc_info()
    tb.print_exception(etype, value, traceback)
