import os
import xbmc
import xbmcgui
import xbmcaddon
import xbmcvfs
import json

ACTIONS = {
"ACTION_ANALOG_FORWARD" : 113,
"ACTION_ANALOG_MOVE" : 49,
"ACTION_ANALOG_MOVE_X" : 601,
"ACTION_ANALOG_MOVE_Y" : 602,
"ACTION_ANALOG_REWIND" : 114,
"ACTION_ANALOG_SEEK_BACK" : 125,
"ACTION_ANALOG_SEEK_FORWARD" : 124,
"ACTION_ASPECT_RATIO" : 19,
"ACTION_AUDIO_DELAY" : 161,
"ACTION_AUDIO_DELAY_MIN" : 54,
"ACTION_AUDIO_DELAY_PLUS" : 55,
"ACTION_AUDIO_NEXT_LANGUAGE" : 56,
"ACTION_BACKSPACE" : 110,
"ACTION_BIG_STEP_BACK" : 23,
"ACTION_BIG_STEP_FORWARD" : 22,
"ACTION_BUILT_IN_FUNCTION" : 122,
"ACTION_CALIBRATE_RESET" : 48,
"ACTION_CALIBRATE_SWAP_ARROWS" : 47,
"ACTION_CHANGE_RESOLUTION" : 57,
"ACTION_CHANNEL_DOWN" : 185,
"ACTION_CHANNEL_SWITCH" : 183,
"ACTION_CHANNEL_UP" : 184,
"ACTION_CHAPTER_OR_BIG_STEP_BACK" : 98,
"ACTION_CHAPTER_OR_BIG_STEP_FORWARD" : 97,
"ACTION_CONTEXT_MENU" : 117,
"ACTION_COPY_ITEM" : 81,
"ACTION_CREATE_BOOKMARK" : 96,
"ACTION_CREATE_EPISODE_BOOKMARK" : 95,
"ACTION_CURSOR_LEFT" : 120,
"ACTION_CURSOR_RIGHT" : 121,
"ACTION_CYCLE_SUBTITLE" : 99,
"ACTION_DECREASE_PAR" : 220,
"ACTION_DECREASE_RATING" : 137,
"ACTION_DELETE_ITEM" : 80,
"ACTION_ENTER" : 135,
"ACTION_ERROR" : 998,
"ACTION_FILTER" : 233,
"ACTION_FILTER_CLEAR" : 150,
"ACTION_FILTER_SMS2" : 151,
"ACTION_FILTER_SMS3" : 152,
"ACTION_FILTER_SMS4" : 153,
"ACTION_FILTER_SMS5" : 154,
"ACTION_FILTER_SMS6" : 155,
"ACTION_FILTER_SMS7" : 156,
"ACTION_FILTER_SMS8" : 157,
"ACTION_FILTER_SMS9" : 158,
"ACTION_FIRST_PAGE" : 159,
"ACTION_FORWARD" : 16,
"ACTION_GESTURE_BEGIN" : 501,
"ACTION_GESTURE_END" : 599,
"ACTION_GESTURE_NOTIFY" : 500,
"ACTION_GESTURE_PAN" : 504,
"ACTION_GESTURE_ROTATE" : 503,
"ACTION_GESTURE_SWIPE_DOWN" : 541,
"ACTION_GESTURE_SWIPE_DOWN_TEN" : 550,
"ACTION_GESTURE_SWIPE_LEFT" : 511,
"ACTION_GESTURE_SWIPE_LEFT_TEN" : 520,
"ACTION_GESTURE_SWIPE_RIGHT" : 521,
"ACTION_GESTURE_SWIPE_RIGHT_TEN" : 530,
"ACTION_GESTURE_SWIPE_UP" : 531,
"ACTION_GESTURE_SWIPE_UP_TEN" : 540,
"ACTION_GESTURE_ZOOM" : 502,
"ACTION_GUIPROFILE_BEGIN" : 204,
"ACTION_HIGHLIGHT_ITEM" : 8,
"ACTION_INCREASE_PAR" : 219,
"ACTION_INCREASE_RATING" : 136,
"ACTION_INPUT_TEXT" : 244,
"ACTION_JUMP_SMS2" : 142,
"ACTION_JUMP_SMS3" : 143,
"ACTION_JUMP_SMS4" : 144,
"ACTION_JUMP_SMS5" : 145,
"ACTION_JUMP_SMS6" : 146,
"ACTION_JUMP_SMS7" : 147,
"ACTION_JUMP_SMS8" : 148,
"ACTION_JUMP_SMS9" : 149,
"ACTION_LAST_PAGE" : 160,
"ACTION_MENU" : 163,
"ACTION_MOUSE_DOUBLE_CLICK" : 103,
"ACTION_MOUSE_DRAG" : 106,
"ACTION_MOUSE_END" : 109,
"ACTION_MOUSE_LEFT_CLICK" : 100,
"ACTION_MOUSE_LONG_CLICK" : 108,
"ACTION_MOUSE_MIDDLE_CLICK" : 102,
"ACTION_MOUSE_MOVE" : 107,
"ACTION_MOUSE_RIGHT_CLICK" : 101,
"ACTION_MOUSE_WHEEL_DOWN" : 105,
"ACTION_MOUSE_WHEEL_UP" : 104,
"ACTION_MOVE_DOWN" : 4,
"ACTION_MOVE_ITEM" : 82,
"ACTION_MOVE_ITEM_DOWN" : 116,
"ACTION_MOVE_ITEM_UP" : 115,
"ACTION_MOVE_LEFT" : 1,
"ACTION_MOVE_RIGHT" : 2,
"ACTION_MOVE_UP" : 3,
"ACTION_MUTE" : 91,
"ACTION_NAV_BACK" : 92,
"ACTION_NEXT_CHANNELGROUP" : 186,
"ACTION_NEXT_CONTROL" : 181,
"ACTION_NEXT_ITEM" : 14,
"ACTION_NEXT_LETTER" : 140,
"ACTION_NEXT_PICTURE" : 28,
"ACTION_NEXT_SCENE" : 138,
"ACTION_NEXT_SUBTITLE" : 26,
"ACTION_NONE" : 0,
"ACTION_NOOP" : 999,
"ACTION_PAGE_DOWN" : 6,
"ACTION_PAGE_UP" : 5,
"ACTION_PARENT_DIR" : 9,
"ACTION_PASTE" : 180,
"ACTION_PAUSE" : 12,
"ACTION_PLAY" : 68,
"ACTION_PLAYER_FORWARD" : 77,
"ACTION_PLAYER_PLAY" : 79,
"ACTION_PLAYER_PLAYPAUSE" : 229,
"ACTION_PLAYER_REWIND" : 78,
"ACTION_PREVIOUS_CHANNELGROUP" : 187,
"ACTION_PREVIOUS_MENU" : 10,
"ACTION_PREV_CONTROL" : 182,
"ACTION_PREV_ITEM" : 15,
"ACTION_PREV_LETTER" : 141,
"ACTION_PREV_PICTURE" : 29,
"ACTION_PREV_SCENE" : 139,
"ACTION_PVR_PLAY" : 188,
"ACTION_PVR_PLAY_RADIO" : 190,
"ACTION_PVR_PLAY_TV" : 189,
"ACTION_QUEUE_ITEM" : 34,
"ACTION_RECORD" : 170,
"ACTION_RELOAD_KEYMAPS" : 203,
"ACTION_REMOVE_ITEM" : 35,
"ACTION_RENAME_ITEM" : 87,
"ACTION_REWIND" : 17,
"ACTION_ROTATE_PICTURE_CCW" : 51,
"ACTION_ROTATE_PICTURE_CW" : 50,
"ACTION_SCAN_ITEM" : 201,
"ACTION_SCROLL_DOWN" : 112,
"ACTION_SCROLL_UP" : 111,
"ACTION_SELECT_ITEM" : 7,
"ACTION_SETTINGS_LEVEL_CHANGE" : 242,
"ACTION_SETTINGS_RESET" : 241,
"ACTION_SHIFT" : 118,
"ACTION_SHOW_CODEC" : 27,
"ACTION_SHOW_FULLSCREEN" : 36,
"ACTION_SHOW_GUI" : 18,
"ACTION_SHOW_INFO" : 11,
"ACTION_SHOW_OSD" : 24,
"ACTION_SHOW_OSD_TIME" : 123,
"ACTION_SHOW_PLAYLIST" : 33,
"ACTION_SHOW_SUBTITLES" : 25,
"ACTION_SHOW_VIDEOMENU" : 134,
"ACTION_SMALL_STEP_BACK" : 76,
"ACTION_STEP_BACK" : 21,
"ACTION_STEP_FORWARD" : 20,
"ACTION_STEREOMODE_NEXT" : 235,
"ACTION_STEREOMODE_PREVIOUS" : 236,
"ACTION_STEREOMODE_SELECT" : 238,
"ACTION_STEREOMODE_SET" : 240,
"ACTION_STEREOMODE_TOGGLE" : 237,
"ACTION_STEREOMODE_TOMONO" : 239,
"ACTION_STOP" : 13,
"ACTION_SUBTITLE_ALIGN" : 232,
"ACTION_SUBTITLE_DELAY" : 162,
"ACTION_SUBTITLE_DELAY_MIN" : 52,
"ACTION_SUBTITLE_DELAY_PLUS" : 53,
"ACTION_SUBTITLE_VSHIFT_DOWN" : 231,
"ACTION_SUBTITLE_VSHIFT_UP" : 230,
"ACTION_SWITCH_PLAYER" : 234,
"ACTION_SYMBOLS" : 119,
"ACTION_TAKE_SCREENSHOT" : 85,
"ACTION_TELETEXT_BLUE" : 218,
"ACTION_TELETEXT_GREEN" : 216,
"ACTION_TELETEXT_RED" : 215,
"ACTION_TELETEXT_YELLOW" : 217,
"ACTION_TOGGLE_DIGITAL_ANALOG" : 202,
"ACTION_TOGGLE_FULLSCREEN" : 199,
"ACTION_TOGGLE_SOURCE_DEST" : 32,
"ACTION_TOGGLE_WATCHED" : 200,
"ACTION_TOUCH_LONGPRESS" : 411,
"ACTION_TOUCH_LONGPRESS_TEN" : 420,
"ACTION_TOUCH_TAP" : 401,
"ACTION_TOUCH_TAP_TEN" : 410,
"ACTION_TRIGGER_OSD" : 243,
"ACTION_VIS_PRESET_LOCK" : 130,
"ACTION_VIS_PRESET_NEXT" : 128,
"ACTION_VIS_PRESET_PREV" : 129,
"ACTION_VIS_PRESET_RANDOM" : 131,
"ACTION_VIS_PRESET_SHOW" : 126,
"ACTION_VIS_RATE_PRESET_MINUS" : 133,
"ACTION_VIS_RATE_PRESET_PLUS" : 132,
"ACTION_VOLAMP" : 90,
"ACTION_VOLAMP_DOWN" : 94,
"ACTION_VOLAMP_UP" : 93,
"ACTION_VOLUME_DOWN" : 89,
"ACTION_VOLUME_SET" : 245,
"ACTION_VOLUME_UP" : 88,
"ACTION_VSHIFT_DOWN" : 228,
"ACTION_VSHIFT_UP" : 227,
"ACTION_ZOOM_IN" : 31,
"ACTION_ZOOM_LEVEL_1" : 38,
"ACTION_ZOOM_LEVEL_2" : 39,
"ACTION_ZOOM_LEVEL_3" : 40,
"ACTION_ZOOM_LEVEL_4" : 41,
"ACTION_ZOOM_LEVEL_5" : 42,
"ACTION_ZOOM_LEVEL_6" : 43,
"ACTION_ZOOM_LEVEL_7" : 44,
"ACTION_ZOOM_LEVEL_8" : 45,
"ACTION_ZOOM_LEVEL_9" : 46,
"ACTION_ZOOM_LEVEL_NORMAL" : 37,
"ACTION_ZOOM_OUT" : 30,
"KEY_APPCOMMAND" : 53248,
"KEY_ASCII" : 61696,
"KEY_BUTTON_A" : 256,
"KEY_BUTTON_B" : 257,
"KEY_BUTTON_BACK" : 275,
"KEY_BUTTON_BLACK" : 260,
"KEY_BUTTON_DPAD_DOWN" : 271,
"KEY_BUTTON_DPAD_LEFT" : 272,
"KEY_BUTTON_DPAD_RIGHT" : 273,
"KEY_BUTTON_DPAD_UP" : 270,
"KEY_BUTTON_LEFT_ANALOG_TRIGGER" : 278,
"KEY_BUTTON_LEFT_THUMB_BUTTON" : 276,
"KEY_BUTTON_LEFT_THUMB_STICK" : 264,
"KEY_BUTTON_LEFT_THUMB_STICK_DOWN" : 281,
"KEY_BUTTON_LEFT_THUMB_STICK_LEFT" : 282,
"KEY_BUTTON_LEFT_THUMB_STICK_RIGHT" : 283,
"KEY_BUTTON_LEFT_THUMB_STICK_UP" : 280,
"KEY_BUTTON_LEFT_TRIGGER" : 262,
"KEY_BUTTON_RIGHT_ANALOG_TRIGGER" : 279,
"KEY_BUTTON_RIGHT_THUMB_BUTTON" : 277,
"KEY_BUTTON_RIGHT_THUMB_STICK" : 265,
"KEY_BUTTON_RIGHT_THUMB_STICK_DOWN" : 267,
"KEY_BUTTON_RIGHT_THUMB_STICK_LEFT" : 268,
"KEY_BUTTON_RIGHT_THUMB_STICK_RIGHT" : 269,
"KEY_BUTTON_RIGHT_THUMB_STICK_UP" : 266,
"KEY_BUTTON_RIGHT_TRIGGER" : 263,
"KEY_BUTTON_START" : 274,
"KEY_BUTTON_WHITE" : 261,
"KEY_BUTTON_X" : 258,
"KEY_BUTTON_Y" : 259,
"KEY_ESC" : 61467,
"KEY_INVALID" : 65535,
"KEY_MOUSE_CLICK" : 57344,
"KEY_MOUSE_DOUBLE_CLICK" : 57360,
"KEY_MOUSE_DRAG" : 57604,
"KEY_MOUSE_DRAG_END" : 57606,
"KEY_MOUSE_DRAG_START" : 57605,
"KEY_MOUSE_END" : 61439,
"KEY_MOUSE_LONG_CLICK" : 57376,
"KEY_MOUSE_MIDDLECLICK" : 57346,
"KEY_MOUSE_MOVE" : 57603,
"KEY_MOUSE_RDRAG" : 57607,
"KEY_MOUSE_RDRAG_END" : 57609,
"KEY_MOUSE_RDRAG_START" : 57608,
"KEY_MOUSE_RIGHTCLICK" : 57345,
"KEY_MOUSE_WHEEL_DOWN" : 57602,
"KEY_MOUSE_WHEEL_UP" : 57601,
"KEY_TOUCH" : 61440,
"KEY_UNICODE" : 61952,
"REMOTE_0" : 58,
"REMOTE_1" : 59,
"REMOTE_2" : 60,
"REMOTE_3" : 61,
"REMOTE_4" : 62,
"REMOTE_5" : 63,
"REMOTE_6" : 64,
"REMOTE_7" : 65,
"REMOTE_8" : 66,
"REMOTE_9" : 67,
}

COMMANDS = {
"CLOSE": ["ACTION_NAV_BACK", "ACTION_PARENT_DIR"],
"LEFT": ["ACTION_MOVE_LEFT"],
"RIGHT": ["ACTION_MOVE_RIGHT"],
"UP": ["ACTION_MOVE_UP"],
"DOWN": ["ACTION_MOVE_DOWN"],
"PAGE_DOWN": ["ACTION_PAGE_DOWN"],
"PAGE_UP": ["ACTION_PAGE_UP"],
"NEXT_DAY": ["ACTION_NEXT_ITEM"],
"PREV_DAY": ["ACTION_PREV_ITEM"],
"PLAY": ["ACTION_SELECT_ITEM"],
"STOP": ["ACTION_STOP"],
"PLAY_CHOOSE": ["ACTION_PLAY", "ACTION_PLAYER_PLAY"],
"GO_TO_NOW": ["ACTION_FIRST_PAGE"],
"NOW_LISTING": ["REMOTE_2", "ACTION_JUMP_SMS2"],
"NEXT_LISTING": ["REMOTE_3", "ACTION_JUMP_SMS3"],
"CHANNEL_LISTING": ["REMOTE_1"],
"SEARCH": ["REMOTE_4", "ACTION_JUMP_SMS4"],
"REMINDERS": ["REMOTE_5", "ACTION_JUMP_SMS5"],
"AUTOPLAYS": ["REMOTE_6", "ACTION_JUMP_SMS6"],
"AUTOPLAYWITHS": ["REMOTE_7", "ACTION_JUMP_SMS6"],
"PLAY_NEXT_CHANNEL": ["ACTION_PAGE_UP"],
"PLAY_PREV_CHANNEL": ["ACTION_PAGE_DOWN"],
"PLAY_LAST_CHANNEL": ["REMOTE_0"],
"MENU": ["ACTION_CONTEXT_MENU","ACTION_PREVIOUS_MENU"],
"LAST_CHANNEL": ["ACTION_MOVE_LEFT"],
"OSD": ["ACTION_SHOW_INFO"],
"QUICK_EPG": ["ACTION_MOVE_DOWN"],
"CATEGORIES": ["ACTION_MENU"],
"SCHEDULERS_MENU": ["ACTION_CREATE_BOOKMARK"],
"INFO": ["ACTION_SHOW_INFO"],
"EXTENDED_INFO": ["ACTION_SHOW_INFO"],
"DELETE_PROGRAM_IMAGE": ["ACTION_DELETE_ITEM"],
"PLAY_AUTOPLAYWITH": ["REMOTE_8", "ACTION_JUMP_SMS9"],
"STOP_AUTOPLAYWITH": ["REMOTE_9", "ACTION_JUMP_SMS8"],
"FULLSCREEN": ["ACTION_MOVE_RIGHT"],
"CHANNEL_NUMBER": ["ACTION_SHIFT"],
"GO_TO_FIRST_CHANNEL": ["ACTION_LAST_PAGE"],
"CHANNEL_DIALOG": ["ACTION_MOUSE_MIDDLE_CLICK"],
"CATEGORIES_BAR": ["ACTION_SHOW_OSD"],
"PROGRAM_SEARCH": ["ACTION_TELETEXT_BLUE"],
"DESCRIPTION_SEARCH": ["ACTION_TELETEXT_GREEN"],
"CATEGORY_SEARCH": ["ACTION_TELETEXT_RED"],
"CHANNEL_SEARCH": ["ACTION_TELETEXT_YELLOW"],
}


def log(x):
    xbmc.log(repr(x))

def getCommandActions():
    commands = COMMANDS.copy()
    for command in commands:
        actions = commands[command]
        actions = [ACTIONS[x] for x in actions]
        commands[command] = actions
    f = xbmcvfs.File('special://profile/addon_data/plugin.video.stvbguide/commands.json','rb')
    j = f.read()
    f.close()
    if j:
        new_commands = json.loads(j)
        for c in new_commands:
            if c in commands:
                commands[c] = new_commands[c]
    return commands


def translateActions(commands):
    ACTIONS_VALUES = dict((ACTIONS[s], s) for s in ACTIONS)
    new_commands = commands
    for c in commands:
        actions = commands[c]
        new_actions = [ACTIONS_VALUES[x] for x in actions]
        new_commands[c] = new_actions
    return new_commands

def loadCommandActions():
    commands = getCommandActions()
    if commands:
        edit_commands = translateActions(commands)
    else:
        edit_commands = COMMANDS
    return edit_commands

if __name__ == '__main__':
    v = ACTIONS.values()
    if len(v) != len(set(v)):
        count = {}
        for x in ACTIONS.values():
            if x in count:
                log(x)
            else:
                count[x] = 1
        xbmcgui.Dialog().notification("STVB Guide", "ACTIONS not unique")

    edit_commands = loadCommandActions()

    d = xbmcgui.Dialog()
    while True:
        main_action = d.select("Command Editor",["Edit","Defaults","Save"])
        if main_action == -1:
            quit()

        if main_action == 0:
            while True:
                labels = []
                command_keys = sorted(edit_commands.keys())
                for command in command_keys:
                    actions = ','.join(edit_commands[command])
                    label = "%s [COLOR dimgray]%s[/COLOR]" % (command.lower().replace('_',' '), actions)
                    labels.append(label)
                command_index = d.select("Commands",labels)

                if command == -1:
                    break

                edit_action = d.select(command_keys[command_index],["Add","Remove"])
                if edit_action == -1:
                    break

                elif edit_action == 0:
                    command = command_keys[command_index]
                    actions = edit_commands[command]
                    add_actions = sorted([x for x in ACTIONS.keys() if x not in actions])
                    selected_actions = d.multiselect(command,add_actions)
                    if selected_actions:
                        actions = actions + [add_actions[x] for x in selected_actions]
                        edit_commands[command] = actions
                elif edit_action == 1:
                    command = command_keys[command_index]
                    actions = edit_commands[command]
                    selected_actions = d.multiselect(command,actions)
                    if selected_actions:
                        new_actions = [actions[x] for x in range(len(actions)) if x not in selected_actions]
                        edit_commands[command] = new_actions
        elif main_action == 1:
            edit_commands = COMMANDS
        elif main_action == 2:
            save_commands = edit_commands.copy()
            for command in save_commands:
                actions = save_commands[command]
                actions = [ACTIONS[x] for x in actions]
                save_commands[command] = actions
            f = xbmcvfs.File('special://profile/addon_data/plugin.video.stvbguide/commands.json','wb')
            f.write(json.dumps(save_commands,indent=2))
            f.close()
            quit()