#!/usr/bin/python
# -*- coding: utf-8 -*-
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program. If not, see <http://www.gnu.org/licenses/>.

import os, re, sys
import urllib, urllib2, HTMLParser
import xbmcgui, xbmcplugin, xbmcaddon

pluginhandle	= int(sys.argv[1])
pluginid		= 'plugin.video.gameone-fork'
addon			= xbmcaddon.Addon(id=pluginid)
translation		= addon.getLocalizedString
path_plugin		= xbmc.translatePath(addon.getAddonInfo('path')).decode("utf-8")
path_icon		= path_plugin + '/icon.png'

# Log level - 0: None, 1: Error, 2: Debug, 3: Detailed debug
loglevel		= 2

user_agent		= 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:6.0) Gecko/20100101 Firefox/6.0'
url_base		= 'http://www.gameone.de'
url_year		= url_base + '/tv/year/'
url_podcast		= url_base + '/feed/podcast.xml'
url_episode		= 'http://www.gameone.de/api/mrss/mgid%3Agameone%3Avideo%3Amtvnn.com%3Atv_show-'
#url_swf			= 'https://playermtvnn-a.akamaihd.net/g2/g2player_2.1.7.swf'		# For some reason the new player doesn't appear to work on Windows (https?)
url_swf			= 'http://media.mtvnservices.com/player/prime/mediaplayerprime.1.9.0.swf'


def log(msg, level=1):
	if (level <= loglevel):
		print(pluginid + ': %s' % msg).encode('utf-8')

def parse_html_string(string):
	parser = HTMLParser.HTMLParser()
	string = parser.unescape(string)
	return string

def build_url(string):
	return sys.argv[0] + '?' + urllib.urlencode(string)

# Function to convert parameters in a URL to a dict
def get_parameters(string):
	parameters = {}
	if string:
		if (string[:1] == '?'):
			parameter_pairs = string[1:].split('&')
			for i in parameter_pairs:
				parameter_split = i.split('=')
				if (len(parameter_split) == 2):
					parameters[parameter_split[0]] = urllib.unquote(parameter_split[1])
				else:
					log('Couldn\'t split parameters correctly (wrong amount of array elements) [Elements: ' + len(parameter_split) + ' | String:' + string + ']', 1)
		else:
			url_split = string.split('?')
			if (len(url_split) == 2):
				parameter_pairs = url_split[1].split('&')
				for i in parameter_pairs:
					parameter_split = i.split('=')
					if (len(parameter_split) == 2):
						parameters[parameter_split[0]] = urllib.unquote(parameter_split[1])
					else:
						log('Couldn\'t split parameters correctly (wrong amount of array elements) [Elements: ' + len(parameter_split) + ' | String:' + string + ']', 1)
			else:
				log('Couldn\'t split parameters correctly (wrong amount of array elements) [Elements: ' + len(parameter_split) + ' | String:' + string + ']', 1)
	return parameters

# Function to extract contents with regular expressions either from a website or a committed string. If no regex pattern is passed, the whole content is returned.
def parse_content(string, pattern=False, dotall=False):
	log('Start parsing content...', 2)
	
	if (len(re.findall('http[s]?://', string[:8])) >= 1 or string[:4] == 'www.'):
		log('URL passed, scraping from URL: ' + string, 2)
		
		req = urllib2.Request(string)
		req.add_header('User-Agent', user_agent)
		response = urllib2.urlopen(req)
		content = response.read()
		response.close()
		if isinstance(content,str):
			content = content.decode('utf-8')
	else:
		log('Content passed, skip scraping...', 2)
		content = string	
	
	if (pattern != False):
		if (dotall == True):
			match = re.compile(pattern, re.DOTALL).findall(content)
		else:
			match = re.compile(pattern).findall(content)
		log('Parsing finished - ' + str(len(match)) + ' Elements', 2)
		return match
	else:
		log('No pattern found, returning whole content.', 2)
		return content

# Function to add an item to the XBMC GUI
def add_menu_item(type, name, url, mode, thumbIMG='', fanart=''):
	if not thumbIMG and addon.getSetting(id='showlogo') == 'true':
		thumbIMG = path_icon
	
	name = parse_html_string(name)
	
	if (type == 'ITEMTYPE_DIRECTORY' or type == 'ITEMTYPE_DUMMY_DIR'):
		iconIMG = 'DefaultFolder.png'
	elif (type == 'ITEMTYPE_VIDEO' or type == 'ITEMTYPE_DUMMY_VID'):
		iconIMG = 'DefaultVideo.png'
			
	list_item = xbmcgui.ListItem(name, iconImage=iconIMG, thumbnailImage=thumbIMG)
	#list_item.setInfo( type="Video", infoLabels={ "Title": name } )
	list_item.setProperty('fanart_image', fanart)
	if (type == 'ITEMTYPE_VIDEO'):
		list_item.setProperty('Video', 'true')
		list_item.setProperty('IsPlayable', 'true')
	
	url = sys.argv[0] + '?mode=' + str(mode) + '&url=' + urllib.quote_plus(url)
	 
	if (type == 'ITEMTYPE_DIRECTORY'):
		return xbmcplugin.addDirectoryItem(handle=pluginhandle, url=url, listitem=list_item, isFolder=True)
	else:
		return xbmcplugin.addDirectoryItem(handle=pluginhandle, url=url, listitem=list_item)

xbmcgui.Dialog().ok(translation(00003), translation(00004))

class functions():
	
	def show_menu_root(self):
		add_menu_item('ITEMTYPE_DIRECTORY', translation(10001), url_base + '/tv',		'show_menu_tv')
		add_menu_item('ITEMTYPE_DIRECTORY', translation(10002), url_base + '/blog',		'show_menu_blog')
		add_menu_item('ITEMTYPE_DIRECTORY', translation(10003), url_base + '/playtube',	'show_menu_playtube')
		add_menu_item('ITEMTYPE_DIRECTORY', translation(10004), url_podcast,			'show_menu_podcasts')
		
		if addon.getSetting(id='showsettings') == 'true':
			add_menu_item('ITEMTYPE_DUMMY_DIR', translation(10000), '', 'show_settings')
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)
	
	
	def show_settings(self):
		return xbmc.executebuiltin('Addon.OpenSettings(' + pluginid + ')')
	
	
	
	#CATEGORY: TV
	def show_menu_tv(self):
		log('Indexing years of TV episodes', 2)
		
		match_years = parse_content(url, '<h4 class=\'.+?>\n([0-9]{4})\n</h4>', True)
		for year in match_years:
			add_menu_item('ITEMTYPE_DIRECTORY', year, url_year + year, 'show_menu_tv_episodes')
			
		xbmcplugin.endOfDirectory(handle=pluginhandle)
	
	
	def show_menu_tv_episodes(self):
		log('Indexing TV episodes: ' + url, 2)
		
		match_episodes = parse_content(url, '<a href=".*?/tv/([0-9]+)" class="image_link"><img alt=".+?" src="(.+?)" /></a>\n<h5>\n<a href=\'.+?\' title=\'(.+?)\'', True)
		for episode,thumbnail,title in match_episodes:
			title = translation(00002) + ' ' + episode + ' - ' + title
			log(title, 3)
			add_menu_item('ITEMTYPE_VIDEO', title, url_episode + episode, 'play_tv_episode', thumbnail)
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)
	
	
	def play_tv_episode(self):
		log('Playing TV episode: ' + url, 2)
		
		match_video_xml = parse_content(url, "<media:content.+?url='(.+?)'></media:content>")
		for video_xml in match_video_xml:
			match_video = parse_content(video_xml, '<src>(.+?)</src>')
			try:
				video_quality = match_video[int(addon.getSetting(id='videoquality'))]
			except:
				log('Couldn\'t select stream quality: ' + addon.getSetting(id='videoquality') + ', falling back to highest.', 1)
				video_quality = match_video[-1]
			video_url = video_quality + ' swfurl=' + url_swf + ' swfvfy=true' + ' pageUrl=www.gameone.de app=ondemand?ovpfv=2.1.4'
			
			item = xbmcgui.ListItem(path=video_url)
			item.setProperty('mimetype', 'video/x-flv')
			return xbmcplugin.setResolvedUrl(pluginhandle, True, item)

		xbmcplugin.endOfDirectory(handle=pluginhandle)
	
	
	
	#CATEGORY: BLOG
	def show_menu_blog(self):
		log('Indexing blog categories: ' + url, 2)
		
		add_menu_item('ITEMTYPE_DIRECTORY', translation(20001), url, 'show_menu_blog_entries')
		
		match_teasers = parse_content(url, '<ul class="teasers">(.+?)</ul>', True)
		for teaser in match_teasers:
			match_categories = parse_content(teaser, '<a title="(.+?)" href="(.+?)">.+?<img.+?src="(.+?)"', True)
			for category,url_category,thumbnail in match_categories:
				add_menu_item('ITEMTYPE_DIRECTORY', category, url_base + url_category, 'show_menu_blog_entries', url_base + thumbnail)
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)
	
	
	def show_menu_blog_entries(self):
		log('Indexing blog entries: ' + url, 2)

		match_posts	= parse_content(url, '<li class="post teaser_box teaser".+?<div class=\'overlay\'.+?<a href="(.+?)">(.+?)</a>.+?<a class=\'image_link\' href=\'.+?\'>\n<img .+?src="(.+?)"', True)
		match_next	= parse_content(url, '<a class="next_page" rel="next" href="(.+?)">', True)
		
		for post_url,title,thumbnail in match_posts:
			match_content		= parse_content(url_base + post_url)
			match_videoposts	= parse_content(match_content, '<div class="player_swf".+?', True)
			match_blogpages		= parse_content(match_content, '<a class="forwards" href="(.+?)">', True)
			video_amount = len(match_videoposts)
			pages_amount = len(match_blogpages)
			
			if video_amount == 1:
				if pages_amount == 0:
					match_video_id = parse_content(match_content, 'video_meta-(.+?)"')
					add_menu_item('ITEMTYPE_VIDEO', title, match_video_id[0], 'play_blog_video', thumbnail)
				else:
					add_menu_item('ITEMTYPE_DIRECTORY', title, url_base + post_url, 'show_menu_blog_videos', thumbnail)
			elif video_amount>1:
				add_menu_item('ITEMTYPE_DIRECTORY', title, url_base + post_url, 'show_menu_blog_videos', thumbnail)
		
		for url_next in match_next:
			add_menu_item('ITEMTYPE_DIRECTORY', translation(00001), url_base + url_next, 'show_menu_blog_entries')
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)
		
		
	def show_menu_blog_videos(self):
		log('Indexing blog videos: ' + url, 2)
		
		match_content 	= parse_content(url)
		match_video		= parse_content(match_content, 'video_meta-(.+?)"')
		match_thumb		= parse_content(match_content, '"image", "(.+?)"', True)
		match_title		= parse_content(match_content, '<p><strong>(.+?):</strong>', True)
		match_next		= parse_content(match_content, '<a class="forwards" href="(.+?)">')
		
		i = 0
		for video_id in match_video:
			add_menu_item('ITEMTYPE_VIDEO', match_title[i], video_id, 'play_blog_video', match_thumb[i])
			i = i + 1
		
		for url_next in match_next:
			add_menu_item('ITEMTYPE_DIRECTORY', translation(00001), url_next, 'show_menu_blog_videos')
			
		xbmcplugin.endOfDirectory(handle=pluginhandle)


	def play_blog_video(self):
		log('Playing blog video: ' + url, 2)
		
		url_video = self.get_video(url)
		item = xbmcgui.ListItem(path=url_video)
		item.setProperty('mimetype', 'video/x-flv')
		xbmcplugin.setResolvedUrl(pluginhandle, True, item)
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)



	#CATEGORY: PLAYTUBE
	def show_menu_playtube(self):
		log('Indexing Playtube categories', 2)
		
		match_container	= parse_content(url, "<ul class='channels'>(.+?)</ul>", True)[0]
		match_channels	= parse_content(match_container, "<a class='name' href='(.+?)' title='(.+?)'>", True)
		
		for url_channel,title in match_channels:
			if not title == 'GameTrailers':
				add_menu_item('ITEMTYPE_DIRECTORY', title, url_channel, 'show_menu_playtube_videos')
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)


	def show_menu_playtube_videos(self):
		log('Indexing Playtube videos', 2)
		
		match_content	= parse_content(url)
		match_video		= parse_content(match_content, '<h3><a href="(.+?)">(.+?)</a></h3>\n<p><a href=".+?">.+?</a></p>\n</div>\n<a href=".+?" class="img_link"><img alt=".+?" src="(.+?)" /></a>', True)
		match_next		= parse_content(match_content, '<a class="next_page" rel="next" href="(.+?)"')
		
		for url_video,title,thumbnail in match_video:
			add_menu_item('ITEMTYPE_VIDEO', title, url_video, 'play_playtube_video', thumbnail)
			
		for url_next in match_next:
			add_menu_item('ITEMTYPE_DIRECTORY', translation(00001), url_base + url_next, 'show_menu_playtube_videos')

		xbmcplugin.endOfDirectory(handle=pluginhandle)
		
	
	def play_playtube_video(self):
		log('Playing Playtube video: ' + url, 2)
		
		match_video = parse_content(url, 'video_meta-(.+?)"')[0]
		url_video = self.get_video(match_video)

		self.play_media(url_video)
		
		
	
	#CATEGORY: PODCASTS
	def show_menu_podcasts(self):
		log('Indexing podcasts: ' + url)
		
		match_content	= parse_content(url, '</image>.+?</rss>', True)[0]
		match_podcasts	= parse_content(match_content, '<title>(.+?)</title>.+?<feedburner:origLink>(.+?)</feedburner:origLink>', True)
		
		for title,url_podcast in match_podcasts:
			add_menu_item('ITEMTYPE_VIDEO', title, url_podcast, 'play_media')
		
		xbmcplugin.endOfDirectory(handle=pluginhandle)
		
		
	#GENERAL FUNCTIONS:
	def play_media(self, url_media=''):
		log('Playing media: ' + url_media, 2)
		
		if not url_media:
			url_media = url
			
		item = xbmcgui.ListItem(path=url_media)
		xbmcplugin.setResolvedUrl(pluginhandle, True, item)
		#xbmc.Player().play(url_media, item)


	def get_video(self, video_id):
		log('Scraping video ID: ' + url, 2)
		
		match_video = parse_content('http://riptide.mtvnn.com/mediagen/' + video_id, '<src>(.+?)</src>')
		try:
			video_quality = match_video[int(addon.getSetting(id='videoquality'))]
		except:
			log('Couldn\'t select stream quality: ' + addon.getSetting(id='videoquality') + ', falling back to highest.', 1)
			video_quality = match_video[-1]
		video = video_quality + ' swfurl=' + url_swf + ' swfvfy=true' + ' pageUrl=www.gameone.de app=ondemand?ovpfv=2.1.4'
		return video



# Get parameters
parameters	= get_parameters(sys.argv[2]) 
url			= parameters.get('url')
mode		= parameters.get('mode')

navigate = functions()

if not sys.argv[2]:
	navigate.show_menu_root()
else:
	try:
		mode_splitted = mode.split('!')
		call_func	= getattr(navigate,mode_splitted[0])
		try:
			call_func(mode_splitted[1])
		except:
			call_func()
	except:
		log('Error: Failed executing function! [Mode: ' + mode + ']', 1)
