#! /usr/bin/python

_strings = {}

if __name__ == "__main__":
	import polib
	po = polib.pofile("resources/language/English/strings.po")
	try:
		import re, subprocess
		r = subprocess.check_output(["grep", "-hnr", "_([\'\"]", "."])
		strings = re.compile("_\([\"'](.*?)[\"']\)", re.IGNORECASE).findall(r)
		translated = [m.msgid.replace("'", "\\'") for m in po]
		missing = set([s for s in strings if s not in translated])
		if missing:
			ids_range = range(30000, 31000)
			ids_reserved = [int(m.msgctxt[1:]) for m in po]
			ids_available = [x for x in ids_range if x not in ids_reserved]
			print "WARNING: missing translation for '%s'" % missing
			for text in missing:
				id = ids_available.pop(0)
				entry = polib.POEntry(msgid=text, msgstr=u'', msgctxt="#{0}".format(id))
				po.append(entry)
			po.save("resources/language/English/strings.po")
	except: pass
	content = []
	with open(__file__, "r") as me:
		content = me.readlines()
		content = content[:content.index("#GENERATED\n")+1]
	with open(__file__, "w") as f:
		f.writelines(content)
		for m in po:
			line = "_strings['{0}'] = {1}\n".format(m.msgid.replace("'", "\\'"), m.msgctxt.replace("#", "").strip())
			f.write(line)
else:
	def get_string(t):
		import xbmc, xbmcaddon
		ADDON = xbmcaddon.Addon()
		ADDON_ID = ADDON.getAddonInfo("id")
		id = _strings.get(t)
		if not id:
			xbmc.log("LANGUAGE: missing translation for '%s'" % t)
			return t
		elif id in range(30000, 31000) and ADDON_ID.startswith("plugin"): return xbmcaddon.Addon().getLocalizedString(id).encode('utf-8')
		elif id in range(31000, 32000) and ADDON_ID.startswith("skin"): return xbmcaddon.Addon().getLocalizedString(id).encode('utf-8')
		elif id in range(32000, 33000) and ADDON_ID.startswith("script"): return xbmcaddon.Addon().getLocalizedString(id).encode('utf-8')
		elif not id in range(30000, 33000): return xbmc.getLocalizedString(id).encode('utf-8')
	#setattr(__builtin__, "_", get_string)

#SYSTEM
_strings['Programs'] = 0
_strings['Pictures'] = 1
_strings['Music'] = 2
_strings['Videos'] = 3
_strings['Settings'] = 5
_strings['File manager'] = 7
_strings['Weather'] = 8
_strings['Kodi media center'] = 9
_strings['Monday'] = 11
_strings['Tuesday'] = 12
_strings['Wednesday'] = 13
_strings['Thursday'] = 14
_strings['Friday'] = 15
_strings['Saturday'] = 16
_strings['Sunday'] = 17
_strings['January'] = 21
_strings['February'] = 22
_strings['March'] = 23
_strings['April'] = 24
_strings['May'] = 25
_strings['June'] = 26
_strings['July'] = 27
_strings['August'] = 28
_strings['September'] = 29
_strings['October'] = 30
_strings['November'] = 31
_strings['December'] = 32
_strings['Mon'] = 41
_strings['Tue'] = 42
_strings['Wed'] = 43
_strings['Thu'] = 44
_strings['Fri'] = 45
_strings['Sat'] = 46
_strings['Sun'] = 47
_strings['Jan'] = 51
_strings['Feb'] = 52
_strings['Mar'] = 53
_strings['Apr'] = 54
_strings['May'] = 55
_strings['Jun'] = 56
_strings['Jul'] = 57
_strings['Aug'] = 58
_strings['Sep'] = 59
_strings['Oct'] = 60
_strings['Nov'] = 61
_strings['Dec'] = 62
_strings['N'] = 71
_strings['NNE'] = 72
_strings['NE'] = 73
_strings['ENE'] = 74
_strings['E'] = 75
_strings['ESE'] = 76
_strings['SE'] = 77
_strings['SSE'] = 78
_strings['S'] = 79
_strings['SSW'] = 80
_strings['SW'] = 81
_strings['WSW'] = 82
_strings['W'] = 83
_strings['WNW'] = 84
_strings['NW'] = 85
_strings['NNW'] = 86
_strings['VAR'] = 87
_strings['South'] = 88
_strings['North'] = 89
_strings['West'] = 90
_strings['East'] = 91
_strings['Variable'] = 92
_strings['View: Auto'] = 98
_strings['View: Auto big'] = 99
_strings['View: Icons'] = 100
_strings['View: List'] = 101
_strings['Scan'] = 102
_strings['Sort by: Name'] = 103
_strings['Sort by: Date'] = 104
_strings['Sort by: Size'] = 105
_strings['No'] = 106
_strings['Yes'] = 107
_strings['Slideshow'] = 108
_strings['Create thumbs'] = 109
_strings['Create thumbnails'] = 110
_strings['Shortcuts'] = 111
_strings['Paused'] = 112
_strings['Update failed'] = 113
_strings['Installation failed'] = 114
_strings['Copy'] = 115
_strings['Move'] = 116
_strings['Delete'] = 117
_strings['Rename'] = 118
_strings['New folder'] = 119
_strings['Confirm delete'] = 122
_strings['Status'] = 126
_strings['Objects'] = 127
_strings['General'] = 128
_strings['Slideshow'] = 129
_strings['System info'] = 130
_strings['Display'] = 131
_strings['Albums'] = 132
_strings['Artists'] = 133
_strings['Songs'] = 134
_strings['Genres'] = 135
_strings['Playlists'] = 136
_strings['Search'] = 137
_strings['Temperatures:'] = 139
_strings['CPU:'] = 140
_strings['GPU:'] = 141
_strings['Time:'] = 142
_strings['Current:'] = 143
_strings['Build:'] = 144
_strings['Network:'] = 145
_strings['Type:'] = 146
_strings['Static'] = 147
_strings['DHCP'] = 148
_strings['MAC address'] = 149
_strings['IP address'] = 150
_strings['Link:'] = 151
_strings['Half duplex'] = 152
_strings['Full duplex'] = 153
_strings['Storage'] = 154
_strings['Drive'] = 155
_strings['Free'] = 156
_strings['Video'] = 157
_strings['Free memory'] = 158
_strings['No link'] = 159
_strings['Free'] = 160
_strings['Unavailable'] = 161
_strings['Tray open'] = 162
_strings['Reading'] = 163
_strings['No disc'] = 164
_strings['Disc present'] = 165
_strings['Skin'] = 166
_strings['Cancel file operations'] = 167
_strings['%s- %s'] = 168
_strings['Resolution'] = 169
_strings['Sort title'] = 171
_strings['Release date'] = 172
_strings['Display 4:3 videos as'] = 173
_strings['Moods'] = 175
_strings['Styles'] = 176
_strings['Song'] = 179
_strings['Duration'] = 180
_strings['Select album'] = 181
_strings['Tracks'] = 182
_strings['Review'] = 183
_strings['Refresh'] = 184
_strings['Searching album'] = 185
_strings['OK'] = 186
_strings['No albums found!'] = 187
_strings['Select all'] = 188
_strings['Save'] = 190
_strings['Shuffle'] = 191
_strings['Clear'] = 192
_strings['Scan'] = 193
_strings['Searching...'] = 194
_strings['Select movie:'] = 196
_strings['Loading movie details'] = 198
_strings['Web interface'] = 199
_strings['Audio encoders'] = 200
_strings['Tagline'] = 202
_strings['Plot outline'] = 203
_strings['Votes'] = 205
_strings['Cast'] = 206
_strings['Plot'] = 207
_strings['Play'] = 208
_strings['Next'] = 209
_strings['Previous'] = 210
_strings['Calibrate user interface...'] = 213
_strings['Video calibration...'] = 214
_strings['Soften'] = 215
_strings['Zoom amount'] = 216
_strings['Pixel ratio'] = 217
_strings['DVD drive'] = 218
_strings['Please insert disc'] = 219
_strings['Remote share'] = 220
_strings['Network is not connected'] = 221
_strings['Cancel'] = 222
_strings['Speed'] = 224
_strings['Test patterns...'] = 226
_strings['Shuffle playlist on load'] = 228
_strings['HDD spindown time'] = 229
_strings['Video filters'] = 230
_strings['None'] = 231
_strings['Point'] = 232
_strings['Linear'] = 233
_strings['Anisotropic'] = 234
_strings['Quincunx'] = 235
_strings['Gaussian cubic'] = 236
_strings['Minification'] = 237
_strings['Magnification'] = 238
_strings['Clear playlist on finish'] = 239
_strings['Windowed'] = 242
_strings['Full screen'] = 244
_strings['Sizing: (%i,%i)->(%i,%i) (Zoom x%2.2f) AR:%2.2f:1 (Pixels: %2.2f:1) (VShift: %2.2f)'] = 245
_strings['Monitor'] = 246
_strings['Scripts'] = 247
_strings['Language'] = 248
_strings['Music'] = 249
_strings['Visualisation'] = 250
_strings['Select destination directory'] = 251
_strings['Stereo upmix'] = 252
_strings['Number of channels'] = 253
_strings['DTS capable receiver'] = 254
_strings['CDDB'] = 255
_strings['Fetching CD information'] = 256
_strings['Error'] = 257
_strings['Enable tag reading'] = 258
_strings['Opening'] = 259
_strings['Shoutcast'] = 260
_strings['Waiting for start...'] = 261
_strings['Scripts output'] = 262
_strings['Record'] = 264
_strings['Stop Rec.'] = 265
_strings['Sort by: Track'] = 266
_strings['Sort by: Time'] = 267
_strings['Sort by: Title'] = 268
_strings['Sort by: Artist'] = 269
_strings['Sort by: Album'] = 270
_strings['Top 100'] = 271
_strings['Top-Left overscan compensation'] = 272
_strings['Bottom-Right overscan compensation'] = 273
_strings['Subtitle positioning'] = 274
_strings['Pixel ratio adjustment'] = 275
_strings['Adjust the arrow to change the amount of overscan'] = 276
_strings['Adjust the bar to change the subtitles position'] = 277
_strings['Adjust the rectangle so it is perfectly square'] = 278
_strings['Unable to load settings'] = 279
_strings['Using default settings'] = 280
_strings['Please check the XML files'] = 281
_strings['Found %i items'] = 282
_strings['Search results'] = 283
_strings['No results found'] = 284
_strings['Preferred audio language'] = 285
_strings['Preferred subtitle language'] = 286
_strings['Subtitles'] = 287
_strings['Font'] = 288
_strings['Size'] = 289
_strings['Dynamic range compression'] = 290
_strings['Video'] = 291
_strings['Audio'] = 292
_strings['Browse for subtitles'] = 293
_strings['Create bookmark'] = 294
_strings['Clear bookmarks'] = 296
_strings['Audio offset'] = 297
_strings['Bookmarks'] = 298
_strings['MP1 capable receiver'] = 300
_strings['MP2 capable receiver'] = 301
_strings['MP3 capable receiver'] = 302
_strings['Delay'] = 303
_strings['Language'] = 304
_strings['Enabled'] = 305
_strings['Non-interleaved'] = 306
_strings['Original stream\'s language'] = 308
_strings['User interface language'] = 309
_strings['Keyboard layouts'] = 310
_strings['(0=auto)'] = 312
_strings['Cleaning database'] = 313
_strings['Preparing...'] = 314
_strings['Database error'] = 315
_strings['Searching songs...'] = 316
_strings['Cleaned database successfully'] = 317
_strings['Cleaning songs...'] = 318
_strings['Error cleaning songs'] = 319
_strings['Cleaning artists...'] = 320
_strings['Error cleaning artists'] = 321
_strings['Cleaning genres...'] = 322
_strings['Error cleaning genres'] = 323
_strings['Cleaning paths...'] = 324
_strings['Error cleaning paths'] = 325
_strings['Cleaning albums...'] = 326
_strings['Error cleaning albums'] = 327
_strings['Writing changes...'] = 328
_strings['Error writing changes'] = 329
_strings['This may take some time...'] = 330
_strings['Compressing database...'] = 331
_strings['Error compressing database'] = 332
_strings['Do you want to clean the library?'] = 333
_strings['Clean library...'] = 334
_strings['Start'] = 335
_strings['Framerate conversion'] = 336
_strings['Output configuration'] = 337
_strings['Fixed'] = 338
_strings['Optimized'] = 339
_strings['Various artists'] = 340
_strings['Play disc'] = 341
_strings['Movies'] = 342
_strings['Adjust framerate'] = 343
_strings['Actors'] = 344
_strings['Year'] = 345
_strings['Maintain original volume on downmix'] = 346
_strings['DTS-HD capable receiver'] = 347
_strings['TrueHD capable receiver'] = 349
_strings['Programs'] = 350
_strings['Off'] = 351
_strings['Dim'] = 352
_strings['Black'] = 353
_strings['Matrix trails'] = 354
_strings['Screensaver mode'] = 356
_strings['Shutdown function timer'] = 357
_strings['All albums'] = 358
_strings['Recently added albums'] = 359
_strings['Screensaver'] = 360
_strings['Screensaver dim level'] = 362
_strings['Sort by: File'] = 363
_strings['Dolby Digital (AC3) capable receiver'] = 364
_strings['Sort by: Name'] = 365
_strings['Sort by: Year'] = 366
_strings['Sort by: Rating'] = 367
_strings['IMDb'] = 368
_strings['Title'] = 369
_strings['Thunderstorms'] = 370
_strings['Partly'] = 371
_strings['Mostly'] = 372
_strings['Sunny'] = 373
_strings['Cloudy'] = 374
_strings['Snow'] = 375
_strings['Rain'] = 376
_strings['Light'] = 377
_strings['AM'] = 378
_strings['PM'] = 379
_strings['Showers'] = 380
_strings['Few'] = 381
_strings['Scattered'] = 382
_strings['Wind'] = 383
_strings['Strong'] = 384
_strings['Fair'] = 385
_strings['Clear'] = 386
_strings['Clouds'] = 387
_strings['Early'] = 388
_strings['Shower'] = 389
_strings['Flurries'] = 390
_strings['Low'] = 391
_strings['Medium'] = 392
_strings['High'] = 393
_strings['Fog'] = 394
_strings['Haze'] = 395
_strings['Select location'] = 396
_strings['Refresh time'] = 397
_strings['Temperature units'] = 398
_strings['Speed units'] = 399
_strings['Weather'] = 400
_strings['Temp'] = 401
_strings['Feels like'] = 402
_strings['UV index'] = 403
_strings['Wind'] = 404
_strings['Dew point'] = 405
_strings['Humidity'] = 406
_strings['Defaults'] = 409
_strings['Accessing weather service'] = 410
_strings['Getting weather for:'] = 411
_strings['Unable to get weather data'] = 412
_strings['Manual'] = 413
_strings['No review for this album'] = 414
_strings['Downloading thumbnail...'] = 415
_strings['Not available'] = 416
_strings['View: Big icons'] = 417
_strings['Low'] = 418
_strings['High'] = 419
_strings['Keep audio device alive'] = 421
_strings['Delete CD information'] = 423
_strings['Select'] = 424
_strings['No album information found'] = 425
_strings['No CD information found'] = 426
_strings['Disc'] = 427
_strings['Please insert the following disc:'] = 429
_strings['Sort by: DVD#'] = 430
_strings['No cache'] = 431
_strings['Remove movie from library'] = 432
_strings['From %s at %i %s'] = 434
_strings['No optical disc drive detected'] = 435
_strings['You need an optical disc drive to play this video'] = 436
_strings['Removable disk'] = 437
_strings['Opening file'] = 438
_strings['Cache'] = 439
_strings['Hard disk'] = 440
_strings['UDF'] = 441
_strings['Local network'] = 442
_strings['Internet'] = 443
_strings['Video'] = 444
_strings['Audio'] = 445
_strings['DVD'] = 446
_strings['Autorun media'] = 447
_strings['Dolby Digital Plus (E-AC3) capable receiver'] = 448
_strings['Enabled'] = 449
_strings['Columns'] = 450
_strings['Row 1 address'] = 451
_strings['Row 2 address'] = 452
_strings['Row 3 address'] = 453
_strings['Row 4 address'] = 454
_strings['Rows'] = 455
_strings['Mode'] = 456
_strings['Switch view'] = 457
_strings['Limit sampling rate (kHz)'] = 458
_strings['Subs'] = 459
_strings['Audio stream'] = 460
_strings['[active]'] = 461
_strings['Subtitle'] = 462
_strings['Backlight'] = 463
_strings['Brightness'] = 464
_strings['Contrast'] = 465
_strings['Gamma'] = 466
_strings['Type'] = 467
_strings['Move the bar to change the OSD position'] = 468
_strings['OSD position'] = 469
_strings['Credits'] = 470
_strings['Off'] = 474
_strings['Music only'] = 475
_strings['Music & video'] = 476
_strings['Unable to load playlist'] = 477
_strings['OSD'] = 478
_strings['Skin & language'] = 479
_strings['Appearance'] = 480
_strings['Audio options'] = 481
_strings['About Kodi'] = 482
_strings['Delete album'] = 485
_strings['Repeat'] = 486
_strings['Repeat one'] = 487
_strings['Repeat folder'] = 488
_strings['- Use big icons'] = 491
_strings['Resize VobSubs'] = 492
_strings['Overall audio headroom'] = 494
_strings['Calibration'] = 496
_strings['Show file extensions'] = 497
_strings['Sort by: Type'] = 498
_strings['Unable to connect to online lookup service'] = 499
_strings['Downloading album information failed'] = 500
_strings['Looking for album names...'] = 501
_strings['Open'] = 502
_strings['Busy'] = 503
_strings['Empty'] = 504
_strings['Sort by: Usage'] = 507
_strings['Enable visualisations'] = 510
_strings['Enable video mode switching'] = 511
_strings['Startup window'] = 512
_strings['Home window'] = 513
_strings['Manual settings'] = 514
_strings['Genre'] = 515
_strings['Recently played albums'] = 517
_strings['Launch'] = 518
_strings['Launch in...'] = 519
_strings['Compilations'] = 521
_strings['Remove source'] = 522
_strings['Switch media'] = 523
_strings['Select playlist'] = 524
_strings['New playlist...'] = 525
_strings['Add to playlist'] = 526
_strings['Manually add to library'] = 527
_strings['Enter title'] = 528
_strings['Error: Duplicate title'] = 529
_strings['Select genre'] = 530
_strings['New genre'] = 531
_strings['Manual addition'] = 532
_strings['Enter genre'] = 533
_strings['View: %s'] = 534
_strings['List'] = 535
_strings['Icons'] = 536
_strings['Big list'] = 537
_strings['Big icons'] = 538
_strings['Wide'] = 539
_strings['Big wide'] = 540
_strings['Album icons'] = 541
_strings['DVD icons'] = 542
_strings['DVD'] = 543
_strings['Media info'] = 544
_strings['Audio output device'] = 545
_strings['Passthrough output device'] = 546
_strings['No biography for this artist'] = 547
_strings['Downmix multichannel audio to stereo'] = 548
_strings['Number'] = 549
_strings['Sort by: %s'] = 550
_strings['Name'] = 551
_strings['Date'] = 552
_strings['Size'] = 553
_strings['Track'] = 554
_strings['Time'] = 555
_strings['Title'] = 556
_strings['Artist'] = 557
_strings['Album'] = 558
_strings['Playlist'] = 559
_strings['ID'] = 560
_strings['File'] = 561
_strings['Year'] = 562
_strings['Rating'] = 563
_strings['Type'] = 564
_strings['Usage'] = 565
_strings['Album artist'] = 566
_strings['Play count'] = 567
_strings['Last played'] = 568
_strings['Comment'] = 569
_strings['Date added'] = 570
_strings['Default'] = 571
_strings['Studio'] = 572
_strings['Path'] = 573
_strings['Country'] = 574
_strings['In progress'] = 575
_strings['Times played'] = 576
_strings['Sort direction'] = 580
_strings['Sort method'] = 581
_strings['View mode'] = 582
_strings['Remember views for different folders'] = 583
_strings['Ascending'] = 584
_strings['Descending'] = 585
_strings['Edit playlist'] = 586
_strings['Filter'] = 587
_strings['Cancel party mode'] = 588
_strings['Party mode'] = 589
_strings['Random'] = 590
_strings['Off'] = 591
_strings['One'] = 592
_strings['All'] = 593
_strings['Off'] = 594
_strings['Repeat: Off'] = 595
_strings['Repeat: One'] = 596
_strings['Repeat: All'] = 597
_strings['Rip audio CD'] = 600
_strings['Medium'] = 601
_strings['Standard'] = 602
_strings['Extreme'] = 603
_strings['Constant bitrate'] = 604
_strings['Ripping...'] = 605
_strings['To:'] = 607
_strings['Rip audio track'] = 610
_strings['Enter number'] = 611
_strings['Bits/sample'] = 612
_strings['Sample rate'] = 613
_strings['Virtual folder'] = 614
_strings['Audio CDs'] = 620
_strings['Encoder'] = 621
_strings['Quality'] = 622
_strings['Bitrate'] = 623
_strings['Include track number'] = 624
_strings['All songs of'] = 625
_strings['In progress TV shows'] = 626
_strings['View mode'] = 629
_strings['Normal'] = 630
_strings['Zoom'] = 631
_strings['Stretch 4:3'] = 632
_strings['Stretch 16:9'] = 634
_strings['Custom'] = 636
_strings['ReplayGain'] = 637
_strings['Use track levels'] = 639
_strings['Use album levels'] = 640
_strings['Need to unpack a big file. Continue?'] = 645
_strings['Remove from library'] = 646
_strings['Export video library'] = 647
_strings['Import video library'] = 648
_strings['Importing'] = 649
_strings['Exporting'] = 650
_strings['Browse for library'] = 651
_strings['Years'] = 652
_strings['Update library'] = 653
_strings['Browse for executable'] = 655
_strings['Browse for playlist'] = 656
_strings['Browse for folder'] = 657
_strings['Song information'] = 658
_strings['Non-linear stretch'] = 659
_strings['Volume amplification'] = 660
_strings['Choose export folder'] = 661
_strings['This file is no longer available.'] = 662
_strings['Would you like to remove it from the library?'] = 663
_strings['Compression level'] = 665
_strings['Enable component-specific logging'] = 666
_strings['Specify component-specific logging...'] = 668
_strings['Cleaning up library'] = 700
_strings['Removing old songs from the library'] = 701
_strings['This path has been scanned before'] = 702
_strings['Network'] = 705
_strings['Server'] = 706
_strings['Internet Protocol (IP)'] = 711
_strings['Invalid port specified. Value must be between 1 and 65535.'] = 712
_strings['HTTP proxy'] = 713
_strings['Assignment'] = 715
_strings['Automatic (DHCP)'] = 716
_strings['IP address'] = 719
_strings['Netmask'] = 720
_strings['Default gateway'] = 721
_strings['DNS server'] = 722
_strings['Save & restart'] = 723
_strings['Invalid address specified. Value must be AAA.BBB.CCC.DDD'] = 724
_strings['with numbers between 0 and 255.'] = 725
_strings['Changes not saved. Continue without saving?'] = 726
_strings['Web server'] = 727
_strings['FTP server'] = 728
_strings['Port'] = 730
_strings['Save & apply'] = 732
_strings['Password'] = 733
_strings['No pass'] = 734
_strings['Character set'] = 735
_strings['Style'] = 736
_strings['Colour'] = 737
_strings['Normal'] = 738
_strings['Bold'] = 739
_strings['Italics'] = 740
_strings['Bold italics'] = 741
_strings['White'] = 742
_strings['Yellow'] = 743
_strings['Files'] = 744
_strings['Error loading image'] = 747
_strings['Edit path'] = 748
_strings['Mirror image'] = 749
_strings['Are you sure?'] = 750
_strings['Removing source'] = 751
_strings['Add program link'] = 754
_strings['Edit program path'] = 755
_strings['Edit program name'] = 756
_strings['Edit path depth'] = 757
_strings['View: Big list'] = 759
_strings['Yellow'] = 760
_strings['White'] = 761
_strings['Blue'] = 762
_strings['Bright green'] = 763
_strings['Yellow green'] = 764
_strings['Cyan'] = 765
_strings['Light grey'] = 766
_strings['Grey'] = 767
_strings['Error %i: share not available'] = 770
_strings['Seeking'] = 773
_strings['Slideshow folder'] = 774
_strings['Network interface'] = 775
_strings['Wireless network name (ESSID)'] = 776
_strings['Wireless password'] = 777
_strings['Wireless security'] = 778
_strings['Save and apply network interface settings'] = 779
_strings['No encryption'] = 780
_strings['WEP'] = 781
_strings['WPA'] = 782
_strings['WPA2'] = 783
_strings['Applying network interface settings. Please wait.'] = 784
_strings['Network interface restarted successfully.'] = 785
_strings['Network interface did not start successfully.'] = 786
_strings['Interface disabled'] = 787
_strings['Network interface disabled successfully.'] = 788
_strings['Wireless network name (ESSID)'] = 789
_strings['Remote control'] = 790
_strings['Port'] = 792
_strings['Port range'] = 793
_strings['Initial repeat delay (ms)'] = 795
_strings['Continuous repeat delay (ms)'] = 796
_strings['Maximum number of clients'] = 797
_strings['Internet access'] = 798
_strings['%s of %s available'] = 802
_strings['Invalid port number entered'] = 850
_strings['Valid port range is 1-65535'] = 851
_strings['Valid port range is 1024-65535'] = 852
_strings['Preview'] = 1000
_strings['Unable to connect'] = 1001
_strings['IP address'] = 1006
_strings['Add network location'] = 1007
_strings['Protocol'] = 1008
_strings['Server address'] = 1009
_strings['Server name'] = 1010
_strings['Remote path'] = 1011
_strings['Shared folder'] = 1012
_strings['Port'] = 1013
_strings['Username'] = 1014
_strings['Browse for network server'] = 1015
_strings['Enter the network address of the server'] = 1016
_strings['Enter the path on the server'] = 1017
_strings['Enter the port number'] = 1018
_strings['Enter the username'] = 1019
_strings['Enter the paths or browse for the media locations.'] = 1021
_strings['Browse for new share'] = 1023
_strings['Browse'] = 1024
_strings['Add source'] = 1026
_strings['Edit source'] = 1027
_strings['Enter the new label'] = 1029
_strings['Browse for image'] = 1030
_strings['Browse for image folder'] = 1031
_strings['Add network location...'] = 1032
_strings['Browse for file'] = 1033
_strings['Submenu'] = 1034
_strings['Enable submenu buttons'] = 1035
_strings['Favourites'] = 1036
_strings['Loading directory'] = 1040
_strings['Retrieved %i items'] = 1041
_strings['Retrieved %i of %i items'] = 1042
_strings['Set plug-in thumb'] = 1044
_strings['Access points'] = 1046
_strings['Other...'] = 1047
_strings['Username'] = 1048
_strings['Script settings'] = 1049
_strings['Singles'] = 1050
_strings['Enter web address'] = 1051
_strings['Proxy type'] = 1180
_strings['HTTP'] = 1181
_strings['SOCKS4'] = 1182
_strings['SOCKS4A'] = 1183
_strings['SOCKS5'] = 1184
_strings['SMB client'] = 1200
_strings['Workgroup'] = 1202
_strings['Default username'] = 1203
_strings['Default password'] = 1204
_strings['WINS server'] = 1207
_strings['Mount SMB shares'] = 1208
_strings['Remove'] = 1210
_strings['Music'] = 1211
_strings['Video'] = 1212
_strings['Pictures'] = 1213
_strings['Files'] = 1214
_strings['Music & video '] = 1215
_strings['Music & pictures'] = 1216
_strings['Music & files'] = 1217
_strings['Video & pictures'] = 1218
_strings['Video & files'] = 1219
_strings['Pictures & files'] = 1220
_strings['Music & video & pictures'] = 1221
_strings['Music & video & pictures & files'] = 1222
_strings['Disabled'] = 1223
_strings['Files & music & video'] = 1226
_strings['Files & pictures & music'] = 1227
_strings['Files & pictures & video'] = 1228
_strings['Music & programs'] = 1229
_strings['Video & programs'] = 1230
_strings['Pictures & programs'] = 1231
_strings['Music & video & pictures & programs'] = 1232
_strings['Programs & video & music'] = 1233
_strings['Programs & pictures & music'] = 1234
_strings['Programs & pictures & video'] = 1235
_strings['Zeroconf'] = 1259
_strings['Allow volume control'] = 1269
_strings['Device name'] = 1271
_strings['Use password protection'] = 1272
_strings['AirPlay'] = 1273
_strings['AirTunes'] = 1274
_strings['Filter %s'] = 1275
_strings['Custom audio device'] = 1300
_strings['Custom passthrough device'] = 1301
_strings['Temperature'] = 1375
_strings['Pressure'] = 1376
_strings['Proximity'] = 1377
_strings['Intensity'] = 1378
_strings['Ragged'] = 1379
_strings['Very'] = 1380
_strings['Extreme'] = 1381
_strings['Whirls'] = 1382
_strings['Broken'] = 1384
_strings['Tornado'] = 1385
_strings['Tropical'] = 1386
_strings['Hurricane'] = 1387
_strings['Cold'] = 1388
_strings['Windy'] = 1389
_strings['Settings'] = 1390
_strings['Breeze'] = 1391
_strings['Gentle'] = 1392
_strings['High wind, near gale'] = 1393
_strings['Severe'] = 1394
_strings['Violent'] = 1395
_strings['Drifting'] = 1396
_strings['and'] = 1397
_strings['Freezing'] = 1398
_strings['Late'] = 1399
_strings['Isolated'] = 1400
_strings['Thundershowers'] = 1401
_strings['Thunder'] = 1402
_strings['Sun'] = 1403
_strings['Heavy'] = 1404
_strings['in'] = 1405
_strings['the'] = 1406
_strings['Vicinity'] = 1407
_strings['Ice'] = 1408
_strings['Crystals'] = 1409
_strings['Calm'] = 1410
_strings['with'] = 1411
_strings['windy'] = 1412
_strings['Patches'] = 1413
_strings['Thunderstorm'] = 1414
_strings['Drizzle'] = 1415
_strings['Foggy'] = 1416
_strings['Grains'] = 1417
_strings['Thunderstorms'] = 1418
_strings['Shallow'] = 1419
_strings['Moderate'] = 1420
_strings['Windy'] = 1422
_strings['Mist'] = 1423
_strings['Overcast'] = 1424
_strings['Pellets'] = 1425
_strings['Hail'] = 1426
_strings['Smoke'] = 1427
_strings['Volcanic'] = 1428
_strings['Ash'] = 1429
_strings['Widespread'] = 1430
_strings['Dust'] = 1431
_strings['Sand'] = 1432
_strings['Spray'] = 1433
_strings['Whirls'] = 1434
_strings['Sandstorm'] = 1435
_strings['Blowing'] = 1436
_strings['Pellet'] = 1437
_strings['Small'] = 1438
_strings['and'] = 1439
_strings['Sleet'] = 1440
_strings['with'] = 1441
_strings['Chance'] = 1442
_strings['of'] = 1443
_strings['Funnel'] = 1444
_strings['Cloud'] = 1445
_strings['Unknown'] = 1446
_strings['Precipitation'] = 1448
_strings['Partial'] = 1449
_strings['Put display to sleep when idle'] = 1450
_strings['Runtime'] = 2050
_strings['Empty list'] = 2080
_strings['Went back to parent list because the active list has been emptied'] = 2081
_strings['Home'] = 10000
_strings['Programs'] = 10001
_strings['Pictures'] = 10002
_strings['File manager'] = 10003
_strings['Settings'] = 10004
_strings['Music'] = 10005
_strings['Videos'] = 10006
_strings['System information'] = 10007
_strings['Settings - General'] = 10008
_strings['Settings - Screen'] = 10009
_strings['Settings - Pictures'] = 10012
_strings['Settings - Programs'] = 10013
_strings['Settings - Weather'] = 10014
_strings['Settings - Music'] = 10015
_strings['Settings - System'] = 10016
_strings['Settings - Videos'] = 10017
_strings['Settings - Network'] = 10018
_strings['Settings - Appearance'] = 10019
_strings['Scripts'] = 10020
_strings['Videos'] = 10025
_strings['Login screen'] = 10029
_strings['Settings - Profiles'] = 10034
_strings['Reset'] = 10035
_strings['Basic'] = 10036
_strings['Standard'] = 10037
_strings['Advanced'] = 10038
_strings['Expert'] = 10039
_strings['Add-on browser'] = 10040
_strings['Reset above settings to default'] = 10041
_strings['Are you sure you want to reset the settings in this category?'] = 10042
_strings['Help'] = 10043
_strings['No help available'] = 10044
_strings['Resets all the visible settings to their default values.'] = 10045
_strings['No categories available'] = 10046
_strings['Try changing the setting level to see additional categories and settings.'] = 10047
_strings['Progress dialogue'] = 10101
_strings['File browser'] = 10126
_strings['Network setup'] = 10128
_strings['Media source'] = 10129
_strings['Profile settings'] = 10130
_strings['Lock settings'] = 10131
_strings['Content settings'] = 10132
_strings['Favourites'] = 10134
_strings['Smart playlist editor'] = 10136
_strings['Smart playlist rule editor'] = 10137
_strings['Add-on settings'] = 10140
_strings['Looking for subtitles...'] = 10210
_strings['Looking for or caching subtitles...'] = 10211
_strings['terminating'] = 10212
_strings['buffering'] = 10213
_strings['Opening stream'] = 10214
_strings['Playlist editor'] = 10503
_strings['Top 100 songs'] = 10504
_strings['Top 100 albums'] = 10505
_strings['Programs'] = 10506
_strings['Configuration'] = 10507
_strings['Weather forecast'] = 10508
_strings['Network gaming'] = 10509
_strings['Extensions'] = 10510
_strings['System info'] = 10511
_strings['Music - Library'] = 10516
_strings['Select dialogue'] = 12000
_strings['Dialogue OK'] = 12002
_strings['Fullscreen video'] = 12005
_strings['Audio visualisation'] = 12006
_strings['File stacking dialogue'] = 12008
_strings['Rebuild index...'] = 12009
_strings['Return to music window'] = 12010
_strings['Return to videos window'] = 12011
_strings['Resume from %s'] = 12022
_strings['0'] = 12310
_strings['1'] = 12311
_strings['2'] = 12312
_strings['3'] = 12313
_strings['4'] = 12314
_strings['5'] = 12315
_strings['6'] = 12316
_strings['7'] = 12317
_strings['8'] = 12318
_strings['9'] = 12319
_strings['c'] = 12320
_strings['*'] = 12322
_strings['Locked! Enter code...'] = 12325
_strings['Enter password'] = 12326
_strings['Enter master code'] = 12327
_strings['Enter unlock code'] = 12328
_strings['Enter gamepad button combo and'] = 12330
_strings['Set lock'] = 12332
_strings['Unlock'] = 12333
_strings['Reset lock'] = 12334
_strings['Remove lock'] = 12335
_strings['Numeric password'] = 12337
_strings['Gamepad button combo'] = 12338
_strings['Full-text password'] = 12339
_strings['Enter new password'] = 12340
_strings['Incorrect password,'] = 12342
_strings['retries left '] = 12343
_strings['Passwords entered did not match.'] = 12344
_strings['Access denied'] = 12345
_strings['Password retry limit exceeded.'] = 12346
_strings['The system will now power down.'] = 12347
_strings['Item locked'] = 12348
_strings['Reactivate lock'] = 12353
_strings['Change lock'] = 12356
_strings['Source lock'] = 12357
_strings['Password entry was blank. Try again.'] = 12358
_strings['Master lock'] = 12360
_strings['Settings & file manager'] = 12373
_strings['Amount of time to display each image'] = 12378
_strings['Use pan and zoom effects'] = 12379
_strings['System uptime'] = 12390
_strings['Minutes'] = 12391
_strings['Hours'] = 12392
_strings['Days'] = 12393
_strings['Total uptime'] = 12394
_strings['Battery level'] = 12395
_strings['Weather'] = 12600
_strings['Screensaver'] = 12900
_strings['Fullscreen OSD'] = 12901
_strings['System'] = 13000
_strings['Video only'] = 13002
_strings['- Delay'] = 13003
_strings['- Minimum file duration'] = 13004
_strings['Shutdown'] = 13005
_strings['Shutdown function'] = 13008
_strings['Quit'] = 13009
_strings['Hibernate'] = 13010
_strings['Suspend'] = 13011
_strings['Exit'] = 13012
_strings['Reboot'] = 13013
_strings['Minimise'] = 13014
_strings['Power button action'] = 13015
_strings['Inhibit idle shutdown'] = 13017
_strings['Allow idle shutdown'] = 13018
_strings['Is another session active, perhaps over ssh?'] = 13020
_strings['Joystick plugged'] = 13024
_strings['Joystick unplugged'] = 13025
_strings['Waiting for network to connect...'] = 13028
_strings['Waiting for server to wake up...'] = 13030
_strings['Extended wait for server to wake up...'] = 13031
_strings['Waiting for services to launch...'] = 13032
_strings['Updated for %s'] = 13034
_strings['Found for %s'] = 13035
_strings['Failed for %s'] = 13036
_strings['Running low on battery'] = 13050
_strings['Flicker filter'] = 13100
_strings['Let driver choose (requires restart)'] = 13101
_strings['Disabled'] = 13106
_strings['Enabled during video playback'] = 13107
_strings['Always enabled'] = 13108
_strings['Would you like to keep this change?'] = 13111
_strings['High quality upscaling'] = 13112
_strings['Disabled'] = 13113
_strings['Enabled for SD content'] = 13114
_strings['Always enabled'] = 13115
_strings['Upscaling method'] = 13116
_strings['Bicubic'] = 13117
_strings['Lanczos'] = 13118
_strings['Sinc'] = 13119
_strings['VDPAU'] = 13120
_strings['Keep skin?'] = 13123
_strings['Blank other displays'] = 13130
_strings['Disabled'] = 13131
_strings['Blank displays'] = 13132
_strings['Active connections detected!'] = 13140
_strings['Change Apple Remote mode?'] = 13144
_strings['Subnet mask'] = 13159
_strings['Gateway'] = 13160
_strings['Primary DNS'] = 13161
_strings['Initialise failed'] = 13162
_strings['Never'] = 13170
_strings['Immediately'] = 13171
_strings['After %i secs'] = 13172
_strings['HDD install date:'] = 13173
_strings['HDD power cycle count:'] = 13174
_strings['Profiles'] = 13200
_strings['Delete profile \'%s\'?'] = 13201
_strings['Last loaded profile:'] = 13204
_strings['Unknown'] = 13205
_strings['Overwrite'] = 13206
_strings['Alarm clock'] = 13208
_strings['Alarm clock interval (in minutes)'] = 13209
_strings['Started, alarm in %im'] = 13210
_strings['Alarm!'] = 13211
_strings['Cancelled with %im%is left'] = 13212
_strings['%2.0fm'] = 13213
_strings['%2.0fs'] = 13214
_strings['Search for subtitles in RARs'] = 13249
_strings['Browse for subtitle...'] = 13250
_strings['Move item'] = 13251
_strings['Move item here'] = 13252
_strings['Cancel move'] = 13253
_strings['Hardware:'] = 13270
_strings['Connected, but no DNS is available.'] = 13274
_strings['DVD-ROM'] = 13276
_strings['Storage'] = 13277
_strings['Default'] = 13278
_strings['Network'] = 13279
_strings['Video'] = 13280
_strings['Hardware'] = 13281
_strings['Operating system:'] = 13283
_strings['CPU speed:'] = 13284
_strings['Video encoder:'] = 13286
_strings['Screen resolution:'] = 13287
_strings['A/V cable:'] = 13292
_strings['DVD region:'] = 13294
_strings['Internet:'] = 13295
_strings['Connected'] = 13296
_strings['Not connected. Check network settings.'] = 13297
_strings['Target temperature'] = 13299
_strings['Fan speed'] = 13300
_strings['Auto temperature control'] = 13301
_strings['Fan speed override'] = 13302
_strings['Fonts'] = 13303
_strings['Enable flipping bi-directional strings'] = 13304
_strings['Show RSS news feeds'] = 13305
_strings['Show parent folder items'] = 13306
_strings['Track naming template'] = 13307
_strings['Zoom effect'] = 13310
_strings['Float effect'] = 13311
_strings['Black bar reduction'] = 13312
_strings['Restart'] = 13313
_strings['Crossfade between songs'] = 13314
_strings['Regenerate thumbnails'] = 13315
_strings['Recursive thumbnails'] = 13316
_strings['View slideshow'] = 13317
_strings['Recursive slideshow'] = 13318
_strings['Randomise'] = 13319
_strings['Stereo'] = 13320
_strings['Left only'] = 13321
_strings['Right only'] = 13322
_strings['Background transparency'] = 13324
_strings['Foreground transparency'] = 13325
_strings['A/V delay'] = 13326
_strings['%s not found'] = 13328
_strings['Error opening %s'] = 13329
_strings['Unable to load %s'] = 13330
_strings['Error: Out of memory'] = 13331
_strings['Move up'] = 13332
_strings['Move down'] = 13333
_strings['Edit label'] = 13334
_strings['Make default'] = 13335
_strings['Remove button'] = 13336
_strings['Leave as is'] = 13340
_strings['Green'] = 13341
_strings['Orange'] = 13342
_strings['Red'] = 13343
_strings['Cycle'] = 13344
_strings['Switch LED off on playback'] = 13345
_strings['Movie information'] = 13346
_strings['Queue item'] = 13347
_strings['Search IMDb...'] = 13348
_strings['Scan for new content'] = 13349
_strings['Current playlist'] = 13350
_strings['Album information'] = 13351
_strings['Scan item to library'] = 13352
_strings['Stop scanning'] = 13353
_strings['Render method'] = 13354
_strings['Low quality pixel shader'] = 13355
_strings['Hardware overlays'] = 13356
_strings['High quality pixel shader'] = 13357
_strings['Play item'] = 13358
_strings['Set artist thumb'] = 13359
_strings['Automatically generate thumbnails'] = 13360
_strings['Enable voice'] = 13361
_strings['Enable device'] = 13375
_strings['Volume'] = 13376
_strings['Default view mode'] = 13377
_strings['Default brightness'] = 13378
_strings['Default contrast'] = 13379
_strings['Default gamma'] = 13380
_strings['Resume video'] = 13381
_strings['Voice mask - Port 1'] = 13382
_strings['Voice mask - Port 2'] = 13383
_strings['Voice mask - Port 3'] = 13384
_strings['Voice mask - Port 4'] = 13385
_strings['Use time based seeking'] = 13386
_strings['Track naming template - right'] = 13387
_strings['Preset'] = 13388
_strings['There are no presets available\nfor this visualisation'] = 13389
_strings['There are no settings available\nfor this visualisation'] = 13390
_strings['Use visualisation if playing audio'] = 13392
_strings['Calculate size'] = 13393
_strings['Calculating folder size'] = 13394
_strings['Video settings'] = 13395
_strings['Audio and subtitle settings'] = 13396
_strings['Enable subtitles'] = 13397
_strings['Shortcuts'] = 13398
_strings['Crossfade between songs on the same album'] = 13400
_strings['Browse for %s'] = 13401
_strings['Show track position'] = 13402
_strings['Clear default'] = 13403
_strings['Resume'] = 13404
_strings['Get thumb'] = 13405
_strings['Picture information'] = 13406
_strings['%s presets'] = 13407
_strings['(IMDb user rating)'] = 13408
_strings['Top 250'] = 13409
_strings['Tune in on Last.fm'] = 13410
_strings['Minimum fan speed'] = 13411
_strings['Play from here'] = 13412
_strings['Downloading'] = 13413
_strings['Render method'] = 13415
_strings['Auto detect'] = 13416
_strings['Basic shaders (ARB)'] = 13417
_strings['Advanced shaders (GLSL)'] = 13418
_strings['Software'] = 13419
_strings['Remove safely'] = 13420
_strings['VDPAU'] = 13421
_strings['Start slideshow here'] = 13422
_strings['Remember for this path'] = 13423
_strings['Play only this'] = 13434
_strings['Use MPEG-2 VDPAU'] = 13441
_strings['Use MPEG-4 VDPAU'] = 13443
_strings['Use VC-1 VDPAU'] = 13445
_strings['Use MPEG-2 VAAPI'] = 13447
_strings['Use MPEG-4 VAAPI'] = 13449
_strings['Enable this option to use hardware acceleration for the MPEG-4 codec. If disabled the CPU will be used instead.'] = 13450
_strings['Use VC-1 VAAPI'] = 13451
_strings['Prefer VAAPI render method'] = 13457
_strings['Use OMXPlayer for decoding of video files.'] = 13459
_strings['Resample quality'] = 13505
_strings['Medium'] = 13507
_strings['High'] = 13508
_strings['Sync playback to display'] = 13510
_strings['Choose art'] = 13511
_strings['Current art'] = 13512
_strings['Remote art'] = 13513
_strings['Local art'] = 13514
_strings['No art'] = 13515
_strings['Add art'] = 13516
_strings['Off'] = 13551
_strings['%d Minute'] = 13554
_strings['%d Minutes'] = 13555
_strings['Allow start of Kodi using the remote'] = 13602
_strings['Sequence delay time'] = 13603
_strings['Disabled'] = 13610
_strings['Standard'] = 13611
_strings['Stack'] = 14000
_strings['Unstack'] = 14001
_strings['Downloading playlist file...'] = 14003
_strings['Downloading streams list...'] = 14004
_strings['Parsing streams list...'] = 14005
_strings['Downloading streams list failed'] = 14006
_strings['Downloading playlist file failed'] = 14007
_strings['Games directory'] = 14009
_strings['Auto switch to thumbs based on'] = 14010
_strings['Enable auto switching to thumbs view'] = 14011
_strings['- Use large icons'] = 14012
_strings['- Switch based on'] = 14013
_strings['- Percentage'] = 14014
_strings['No files and at least one thumb'] = 14015
_strings['At least one file and thumb'] = 14016
_strings['Percentage of thumbs'] = 14017
_strings['View options'] = 14018
_strings['Change area code 1'] = 14019
_strings['Change area code 2'] = 14020
_strings['Change area code 3'] = 14021
_strings['Library'] = 14022
_strings['No TV'] = 14023
_strings['Enter the nearest large town'] = 14024
_strings['Video/Audio/DVD cache - Hard disk'] = 14025
_strings['Video cache - DVD-ROM'] = 14026
_strings['Video cache - Internet'] = 14028
_strings['Audio cache - DVD-ROM'] = 14030
_strings['Audio cache - Internet'] = 14032
_strings['DVD cache - DVD-ROM'] = 14034
_strings['Services'] = 14036
_strings['Network settings changed'] = 14038
_strings['Internet connection bandwidth limitation'] = 14041
_strings['- Shutdown while playing'] = 14043
_strings['%i min'] = 14044
_strings['%i sec'] = 14045
_strings['%i ms'] = 14046
_strings['%i %%'] = 14047
_strings['%i kbps'] = 14048
_strings['%i kb'] = 14049
_strings['%i.0 dB'] = 14050
_strings['Time format'] = 14051
_strings['Date format'] = 14052
_strings['GUI filters'] = 14053
_strings['%2.1f dB'] = 14054
_strings['Use background scanning'] = 14055
_strings['Stop scan'] = 14056
_strings['Film grain effect'] = 14058
_strings['Search for thumbnails on remote shares'] = 14059
_strings['Unknown type cache - Internet'] = 14060
_strings['Auto'] = 14061
_strings['Enter username for'] = 14062
_strings['Date & time'] = 14063
_strings['Set date'] = 14064
_strings['Set time'] = 14065
_strings['Enter the date in DD/MM/YYYY format'] = 14067
_strings['Enter the IP address'] = 14068
_strings['Apply these settings now?'] = 14069
_strings['Apply changes now'] = 14070
_strings['Allow file renaming and deletion'] = 14071
_strings['Set timezone'] = 14074
_strings['Use daylight saving time'] = 14075
_strings['Add to favourites'] = 14076
_strings['Remove from favourites'] = 14077
_strings['Colours'] = 14078
_strings['Timezone country'] = 14079
_strings['Timezone'] = 14080
_strings['File lists'] = 14081
_strings['Queue songs on selection'] = 14084
_strings['Playback'] = 14086
_strings['Discs'] = 14087
_strings['Play DVDs automatically'] = 14088
_strings['Font to use for text subtitles'] = 14089
_strings['International'] = 14090
_strings['Character set'] = 14091
_strings['Security'] = 14093
_strings['Power saving'] = 14095
_strings['Rip'] = 14096
_strings['Play'] = 14098
_strings['Stop ripping CD'] = 14100
_strings['Blu-ray playback mode'] = 14102
_strings['Play main movie'] = 14103
_strings['Show simplified menu'] = 14104
_strings['Unavailable source'] = 15012
_strings['What would you like to do with media items from %s'] = 15013
_strings['Keep'] = 15014
_strings['Remove'] = 15015
_strings['Games'] = 15016
_strings['Add'] = 15019
_strings['Password'] = 15052
_strings['Library'] = 15100
_strings['Database'] = 15101
_strings['* All albums'] = 15102
_strings['* All artists'] = 15103
_strings['* All songs'] = 15104
_strings['* All genres'] = 15105
_strings['Buffering...'] = 15107
_strings['Skin default'] = 15109
_strings['Larger font size'] = 15110
_strings['Theme'] = 15111
_strings['Default theme'] = 15112
_strings['Last.fm'] = 15200
_strings['Connected'] = 15207
_strings['Not connected'] = 15208
_strings['Play using...'] = 15213
_strings['Use smoothed A/V synchronisation'] = 15214
_strings['Hide file names in thumbs view'] = 15215
_strings['Play in party mode'] = 15216
_strings['Path not found or invalid'] = 15300
_strings['No servers found'] = 15302
_strings['Workgroup not found'] = 15303
_strings['Opening multi-path source'] = 15310
_strings['Path:'] = 15311
_strings['General'] = 16000
_strings['Internet lookup'] = 16002
_strings['Player'] = 16003
_strings['Play media from disc'] = 16004
_strings['Enter new title'] = 16008
_strings['Enter the movie name'] = 16009
_strings['Enter the profile name'] = 16010
_strings['Enter the album name'] = 16011
_strings['Enter the playlist name'] = 16012
_strings['Enter new filename'] = 16013
_strings['Enter folder name'] = 16014
_strings['Enter directory'] = 16015
_strings['Available options: %A, %T, %N, %B, %D, %G, %Y, %F, %S'] = 16016
_strings['Enter search string'] = 16017
_strings['None'] = 16018
_strings['Auto select'] = 16019
_strings['Bob'] = 16021
_strings['Cancelling...'] = 16024
_strings['Enter the artist name'] = 16025
_strings['Playback failed'] = 16026
_strings['Enter value'] = 16028
_strings['Party mode aborted.'] = 16030
_strings['No matching songs in the library.'] = 16031
_strings['Party mode playlist'] = 16035
_strings['Deinterlace video'] = 16037
_strings['Deinterlace method'] = 16038
_strings['Off'] = 16039
_strings['On'] = 16041
_strings['Unwatched'] = 16101
_strings['Watched'] = 16102
_strings['Mark as watched'] = 16103
_strings['Mark as unwatched'] = 16104
_strings['Edit title'] = 16105
_strings['Manage...'] = 16106
_strings['Edit sort title'] = 16107
_strings['Operation was aborted'] = 16200
_strings['Copy failed'] = 16201
_strings['Move failed'] = 16203
_strings['Delete failed'] = 16205
_strings['Video scaling method'] = 16300
_strings['Nearest neighbour'] = 16301
_strings['Bilinear'] = 16302
_strings['Bicubic'] = 16303
_strings['Lanczos2'] = 16304
_strings['Lanczos3'] = 16305
_strings['Sinc8'] = 16306
_strings['Bicubic (software)'] = 16307
_strings['Lanczos (software)'] = 16308
_strings['Sinc (software)'] = 16309
_strings['Temporal'] = 16310
_strings['Auto'] = 16316
_strings['DXVA'] = 16319
_strings['Spline36'] = 16322
_strings['VDPAU - Bob'] = 16325
_strings['MMAL - Advanced'] = 16330
_strings['MMAL - Bob'] = 16332
_strings['Post-processing'] = 16400
_strings['Display sleep timeout'] = 17500
_strings['%i MByte'] = 17997
_strings['%i hours'] = 17998
_strings['%i days'] = 17999
_strings['Switch to channel'] = 19000
_strings['or use phrases to find an exact match, like \"The wizard of Oz\".'] = 19002
_strings['Find similar'] = 19003
_strings['PVR stream information'] = 19005
_strings['Receiving device'] = 19006
_strings['Device status'] = 19007
_strings['Signal quality'] = 19008
_strings['SNR'] = 19009
_strings['BER'] = 19010
_strings['UNC'] = 19011
_strings['Free to air'] = 19013
_strings['Fixed'] = 19014
_strings['Encryption'] = 19015
_strings['Recordings'] = 19017
_strings['Folder with channel icons'] = 19018
_strings['Channels'] = 19019
_strings['TV'] = 19020
_strings['Radio'] = 19021
_strings['Hidden'] = 19022
_strings['TV channels'] = 19023
_strings['Radio channels'] = 19024
_strings['Upcoming recordings'] = 19025
_strings['Add timer...'] = 19026
_strings['No search results'] = 19027
_strings['Channel'] = 19029
_strings['Now'] = 19030
_strings['Next'] = 19031
_strings['Timeline'] = 19032
_strings['Information'] = 19033
_strings['Show signal quality'] = 19037
_strings['Not supported by the PVR backend.'] = 19038
_strings['Are you sure you want to hide this channel?'] = 19039
_strings['Are you sure you want to rename this recording?'] = 19041
_strings['Are you sure you want to rename this timer?'] = 19042
_strings['Recording'] = 19043
_strings['New channel'] = 19046
_strings['Show channel'] = 19049
_strings['Show visible channels'] = 19050
_strings['Show hidden channels'] = 19051
_strings['Move channel to:'] = 19052
_strings['Recording information'] = 19053
_strings['Hide channel'] = 19054
_strings['No information available'] = 19055
_strings['New timer'] = 19056
_strings['Timer enabled'] = 19058
_strings['Stop recording'] = 19059
_strings['Delete timer'] = 19060
_strings['Add timer'] = 19061
_strings['Sort by: Channel'] = 19062
_strings['Go to end'] = 19064
_strings['Channel icons'] = 19066
_strings['This event is already being recorded.'] = 19067
_strings['Go to now'] = 19070
_strings['Delay channel switch'] = 19073
_strings['Unknown channel %u'] = 19085
_strings['Service'] = 19099
_strings['Mux'] = 19100
_strings['Provider'] = 19101
_strings['Please switch to another channel.'] = 19102
_strings['Go to channel'] = 19103
_strings['Enter the name of the folder for the recording'] = 19104
_strings['Please select a channel'] = 19105
_strings['Next timer on'] = 19106
_strings['at'] = 19107
_strings['Delete this recording?'] = 19112
_strings['Delete all recordings in this folder?'] = 19113
_strings['Version'] = 19114
_strings['Address'] = 19115
_strings['Disksize'] = 19116
_strings['Search for channels'] = 19117
_strings['Client number'] = 19120
_strings['Avoid repeats'] = 19121
_strings['This timer is still recording. Are you sure you want to delete this timer?'] = 19122
_strings['Free to air channels only'] = 19123
_strings['Ignore present timers'] = 19124
_strings['Ignore present recordings'] = 19125
_strings['Start time'] = 19126
_strings['End time'] = 19127
_strings['Start date'] = 19128
_strings['End date'] = 19129
_strings['Minimum duration'] = 19130
_strings['Maximum duration'] = 19131
_strings['Include unknown genres'] = 19132
_strings['Search string'] = 19133
_strings['Include description'] = 19134
_strings['Case sensitive'] = 19135
_strings['Channel unavailable'] = 19136
_strings['Name of the new group'] = 19139
_strings['Search...'] = 19140
_strings['Group'] = 19141
_strings['Search guide'] = 19142
_strings['Group management'] = 19143
_strings['No groups defined'] = 19144
_strings['Grouped'] = 19145
_strings['Groups'] = 19146
_strings['Channel'] = 19148
_strings['Mo'] = 19149
_strings['Tu'] = 19150
_strings['We'] = 19151
_strings['Th'] = 19152
_strings['Fr'] = 19153
_strings['Sa'] = 19154
_strings['Su'] = 19155
_strings['from'] = 19156
_strings['Next recording'] = 19157
_strings['Currently recording'] = 19158
_strings['from'] = 19159
_strings['to'] = 19160
_strings['Recording active'] = 19162
_strings['Recordings'] = 19163
_strings['Switch'] = 19165
_strings['PVR information'] = 19166
_strings['Scan for missing icons'] = 19167
_strings['Hide video information box'] = 19169
_strings['Timeout when starting playback'] = 19170
_strings['Instant recording duration'] = 19172
_strings['Default recording priority'] = 19173
_strings['Default recording lifetime'] = 19174
_strings['Playback'] = 19177
_strings['Show channel information when switching channels'] = 19178
_strings['Continue last channel on startup'] = 19189
_strings['Background'] = 19190
_strings['PVR service'] = 19191
_strings['None of the connected PVR backends supports scanning for channels.'] = 19192
_strings['Continue?'] = 19194
_strings['Client actions'] = 19195
_strings['PVR client specific actions'] = 19196
_strings['Recording started on: %s'] = 19197
_strings['Recording finished on: %s'] = 19198
_strings['Channel manager'] = 19199
_strings['Channel name:'] = 19201
_strings['Channel icon:'] = 19202
_strings['Edit channel'] = 19203
_strings['New channel'] = 19204
_strings['Group management'] = 19205
_strings['Group:'] = 19207
_strings['Enter the name of the new channel'] = 19208
_strings['Kodi virtual backend'] = 19209
_strings['Client'] = 19210
_strings['Delete channel'] = 19211
_strings['This list contains changes'] = 19212
_strings['Select backend'] = 19213
_strings['Enter a valid URL for the new channel'] = 19214
_strings['The PVR backend does not support timers.'] = 19215
_strings['All radio channels'] = 19216
_strings['All TV channels'] = 19217
_strings['Visible'] = 19218
_strings['Ungrouped channels'] = 19219
_strings['Channels in'] = 19220
_strings['Synchronise channel groups with backend(s)'] = 19221
_strings['Recording aborted'] = 19224
_strings['Recording scheduled'] = 19225
_strings['Recording started'] = 19226
_strings['Recording completed'] = 19227
_strings['Close channel OSD after switching channels'] = 19229
_strings['Clear search results'] = 19232
_strings['Display a notification on timer updates'] = 19233
_strings['PVR manager is starting up'] = 19235
_strings['Loading channels from clients'] = 19236
_strings['Loading timers from clients'] = 19237
_strings['Loading recordings from clients'] = 19238
_strings['Starting background threads'] = 19239
_strings['Backend idle time'] = 19244
_strings['Wakeup before recording'] = 19246
_strings['Daily wakeup'] = 19247
_strings['Daily wakeup time (HH:MM:SS)'] = 19248
_strings['Filter channels'] = 19249
_strings['Lock channel'] = 19257
_strings['Unlock channel'] = 19258
_strings['Parental control'] = 19259
_strings['Unlock duration'] = 19260
_strings['Change PIN'] = 19261
_strings['Parental control. Enter PIN:'] = 19262
_strings['Locked channel. Enter PIN:'] = 19263
_strings['Incorrect PIN'] = 19264
_strings['Parental locked'] = 19266
_strings['Parental locked:'] = 19267
_strings['Group Items'] = 19270
_strings['Conflict warning'] = 19275
_strings['Conflict error'] = 19276
_strings['Recording conflict'] = 19277
_strings['Recording error'] = 19278
_strings['Client specific'] = 19279
_strings['Client specific settings'] = 19280
_strings['Current icon'] = 19282
_strings['No icon'] = 19283
_strings['Choose icon'] = 19284
_strings['Browse for icon'] = 19285
_strings['Searching for channel icons'] = 19286
_strings['All channels'] = 19287
_strings['Foreground'] = 19288
_strings['Comedy'] = 19504
_strings['Romance'] = 19506
_strings['Documentary'] = 19519
_strings['Sports'] = 19548
_strings['Football'] = 19551
_strings['Athletics'] = 19554
_strings['Equestrian'] = 19558
_strings['Ballet'] = 19585
_strings['Religion'] = 19599
_strings['Literature'] = 19601
_strings['Fashion'] = 19607
_strings['Languages'] = 19635
_strings['Handicraft'] = 19646
_strings['Motoring'] = 19647
_strings['Cooking'] = 19649
_strings['Gardening'] = 19651
_strings['Unpublished'] = 19663
_strings['Drama'] = 19676
_strings['Comedy'] = 19680
_strings['Romance'] = 19682
_strings['Adult'] = 19684
_strings['Saved music folder'] = 20000
_strings['Use external DVD player'] = 20001
_strings['External DVD player'] = 20002
_strings['Trainers folder'] = 20003
_strings['Screenshot folder'] = 20004
_strings['Playlists folder'] = 20006
_strings['Recordings'] = 20007
_strings['Screenshots'] = 20008
_strings['Use Kodi'] = 20009
_strings['Music playlists'] = 20011
_strings['Video playlists'] = 20012
_strings['Do you wish to launch the game?'] = 20013
_strings['Sort by: Playlist'] = 20014
_strings['Remote thumb'] = 20015
_strings['Current thumb'] = 20016
_strings['Local thumb'] = 20017
_strings['No thumb'] = 20018
_strings['Choose thumbnail'] = 20019
_strings['Conflict'] = 20023
_strings['Scan new'] = 20024
_strings['Scan all'] = 20025
_strings['Region'] = 20026
_strings['Summary'] = 20037
_strings['Lock music window'] = 20038
_strings['Lock videos window'] = 20039
_strings['Lock pictures window'] = 20040
_strings['Lock programs & scripts windows'] = 20041
_strings['Lock file manager'] = 20042
_strings['Lock settings'] = 20043
_strings['Start fresh'] = 20044
_strings['Enter master mode'] = 20045
_strings['Leave master mode'] = 20046
_strings['Create profile \'%s\'?'] = 20047
_strings['Best available'] = 20049
_strings['Auto-switch between 16x9 and 4x3'] = 20050
_strings['Treat stacked files as single file'] = 20051
_strings['Caution'] = 20052
_strings['Left master mode'] = 20053
_strings['Entered master mode'] = 20054
_strings['Allmusic.com thumb'] = 20055
_strings['Remove thumbnail'] = 20057
_strings['Add profile...'] = 20058
_strings['Query info for all albums'] = 20059
_strings['Media info'] = 20060
_strings['Separate'] = 20061
_strings['Shares with default'] = 20062
_strings['Shares with default (read only)'] = 20063
_strings['Copy default'] = 20064
_strings['Profile picture'] = 20065
_strings['Lock preferences'] = 20066
_strings['Edit profile'] = 20067
_strings['Profile lock'] = 20068
_strings['Profile directory'] = 20070
_strings['MPAA rating'] = 20074
_strings['Enter master lock code'] = 20075
_strings['Ask for master lock code on startup'] = 20076
_strings['Skin settings'] = 20077
_strings['- no link set -'] = 20078
_strings['Enable animations'] = 20079
_strings['Disable RSS during music'] = 20080
_strings['Enable shortcut buttons'] = 20081
_strings['Show programs in main menu'] = 20082
_strings['Show available disk space C: E: F:'] = 20086
_strings['Show available disk space E: F: G:'] = 20087
_strings['Drive space free'] = 20089
_strings['Enter the name of an existing share'] = 20090
_strings['Lock code'] = 20091
_strings['Load profile'] = 20092
_strings['Profile name'] = 20093
_strings['Media sources'] = 20094
_strings['Enter profile lock code'] = 20095
_strings['Login screen'] = 20096
_strings['Master lock code and settings'] = 20100
_strings['Entering master lock code always enables master mode'] = 20101
_strings['Save changes to profile?'] = 20103
_strings['Separate (locked)'] = 20107
_strings['Root'] = 20108
_strings['Zoom'] = 20109
_strings['UPnP settings'] = 20110
_strings['Autostart UPnP client'] = 20111
_strings['Last login: %s'] = 20112
_strings['Never logged on'] = 20113
_strings['Profile %i / %i'] = 20114
_strings['User login / Select a profile'] = 20115
_strings['Use lock on login screen'] = 20116
_strings['Invalid lock code.'] = 20117
_strings['Loading program information'] = 20120
_strings['Party on!'] = 20121
_strings['True'] = 20122
_strings['Mixing drinks'] = 20123
_strings['Filling glasses'] = 20124
_strings['Logged on as'] = 20125
_strings['Log off'] = 20126
_strings['Weave'] = 20129
_strings['Blend'] = 20131
_strings['Restart video'] = 20132
_strings['Edit network location'] = 20133
_strings['Remove network location'] = 20134
_strings['Do you want to scan the folder?'] = 20135
_strings['Memory unit'] = 20136
_strings['Memory unit mounted'] = 20137
_strings['Unable to mount memory unit'] = 20138
_strings['In port %i, slot %i'] = 20139
_strings['Lock screensaver'] = 20140
_strings['Set'] = 20141
_strings['Username'] = 20142
_strings['Enter password for'] = 20143
_strings['Shutdown timer'] = 20144
_strings['Shutdown interval (in minutes)'] = 20145
_strings['Started, shutdown in %im'] = 20146
_strings['Shutdown in 30 minutes'] = 20147
_strings['Shutdown in 60 minutes'] = 20148
_strings['Shutdown in 120 minutes'] = 20149
_strings['Custom shutdown timer'] = 20150
_strings['Cancel shutdown timer'] = 20151
_strings['Lock preferences for %s'] = 20152
_strings['Browse...'] = 20153
_strings['Summary information'] = 20154
_strings['Storage information'] = 20155
_strings['Hard disk information'] = 20156
_strings['DVD-ROM information'] = 20157
_strings['Network information'] = 20158
_strings['Video information'] = 20159
_strings['Hardware information'] = 20160
_strings['Total'] = 20161
_strings['Used'] = 20162
_strings['of'] = 20163
_strings['Locking not supported'] = 20164
_strings['Not locked'] = 20165
_strings['Locked'] = 20166
_strings['Frozen'] = 20167
_strings['Requires reset'] = 20168
_strings['Week'] = 20169
_strings['Line'] = 20170
_strings['Windows network (SMB)'] = 20171
_strings['XBMSP server'] = 20172
_strings['FTP server'] = 20173
_strings['UPnP server'] = 20175
_strings['Done'] = 20177
_strings['Shift'] = 20178
_strings['Caps Lock'] = 20179
_strings['Symbols'] = 20180
_strings['Backspace'] = 20181
_strings['Space'] = 20182
_strings['Reload skin'] = 20183
_strings['Use poster view styles for TV shows'] = 20185
_strings['Please wait'] = 20186
_strings['Enable auto scrolling for plot & review'] = 20189
_strings['Enable debug logging'] = 20191
_strings['Export music library'] = 20196
_strings['Import music library'] = 20197
_strings['No artist found!'] = 20198
_strings['With this enabled, any information that is downloaded for albums and artists will override anything you have set in your song tags, such as genres, year, song artists etc. Useful if you have MusicBrainz identifiers in your song tags.'] = 20221
_strings['Android music'] = 20240
_strings['Android videos'] = 20241
_strings['Android pictures'] = 20242
_strings['Android photos'] = 20243
_strings['Party on! (videos)'] = 20250
_strings['Mixing drinks (videos)'] = 20251
_strings['Filling glasses (videos)'] = 20252
_strings['WebDAV server (HTTP)'] = 20253
_strings['WebDAV server (HTTPS)'] = 20254
_strings['First logon, edit your profile'] = 20255
_strings['Web server directory (HTTP)'] = 20300
_strings['Web server directory (HTTPS)'] = 20301
_strings['Unable to write to folder:'] = 20302
_strings['RSS Feed'] = 20304
_strings['Secondary DNS'] = 20307
_strings['DHCP server:'] = 20308
_strings['Make new folder'] = 20309
_strings['Unknown or onboard (protected)'] = 20311
_strings['Videos - Library'] = 20314
_strings['Sort by: ID'] = 20316
_strings['Scanning movies using %s'] = 20317
_strings['Scanning music videos using %s'] = 20318
_strings['Scanning artists using %s'] = 20320
_strings['Scanning albums using %s'] = 20321
_strings['Movie plot'] = 20323
_strings['Play part...'] = 20324
_strings['Calibration reset'] = 20325
_strings['This will reset the calibration values for %s'] = 20326
_strings['to its default values.'] = 20327
_strings['Browse for destination'] = 20328
_strings['Movies are in separate folders that match the movie title'] = 20329
_strings['Use folder names for lookups'] = 20330
_strings['File'] = 20331
_strings['Use file or folder names in lookups?'] = 20332
_strings['Set content'] = 20333
_strings['Folder'] = 20334
_strings['Look for content recursively?'] = 20335
_strings['Unlock sources'] = 20336
_strings['Actor'] = 20337
_strings['Movie'] = 20338
_strings['Director'] = 20339
_strings['Movies'] = 20342
_strings['TV shows'] = 20343
_strings['This directory contains'] = 20344
_strings['Run automated scan'] = 20345
_strings['Scan recursively'] = 20346
_strings['as'] = 20347
_strings['Directors'] = 20348
_strings['No video files found in this path!'] = 20349
_strings['TV show information'] = 20351
_strings['Episode information'] = 20352
_strings['Loading TV show details'] = 20353
_strings['Fetching episode guide'] = 20354
_strings['Select TV show:'] = 20356
_strings['Enter the TV show name'] = 20357
_strings['Season %i'] = 20358
_strings['Episode'] = 20359
_strings['Episodes'] = 20360
_strings['Loading episode details'] = 20361
_strings['Remove episode from library'] = 20362
_strings['Remove TV show from library'] = 20363
_strings['TV show'] = 20364
_strings['Episode plot'] = 20365
_strings['* All seasons'] = 20366
_strings['Hide watched'] = 20367
_strings['Prod code'] = 20368
_strings['Show plot for unwatched items'] = 20369
_strings['* Hidden to prevent spoilers *'] = 20370
_strings['Set season thumb'] = 20371
_strings['Season image'] = 20372
_strings['Season'] = 20373
_strings['Downloading movie information'] = 20374
_strings['Unassign content'] = 20375
_strings['Original title'] = 20376
_strings['Refresh TV show information'] = 20377
_strings['Selected folder contains a single TV show'] = 20379
_strings['Exclude selected folder from scans'] = 20380
_strings['Specials'] = 20381
_strings['Selected folder contains a single video'] = 20383
_strings['Link to TV show'] = 20384
_strings['Remove link to TV show'] = 20385
_strings['Recently added movies'] = 20386
_strings['Recently added episodes'] = 20387
_strings['Studios'] = 20388
_strings['Music videos'] = 20389
_strings['Recently added music videos'] = 20390
_strings['Music video'] = 20391
_strings['Remove music video from library'] = 20392
_strings['Music video information'] = 20393
_strings['Loading music video information'] = 20394
_strings['Mixed'] = 20395
_strings['Go to albums by artist'] = 20396
_strings['Go to album'] = 20397
_strings['Play song'] = 20398
_strings['Go to music videos from album'] = 20399
_strings['Go to music videos by artist'] = 20400
_strings['Play music video'] = 20401
_strings['Set actor thumb'] = 20403
_strings['Remove bookmark'] = 20404
_strings['Remove episode bookmark'] = 20405
_strings['Set episode bookmark'] = 20406
_strings['Downloading music video information'] = 20408
_strings['Downloading TV show information'] = 20409
_strings['Trailer'] = 20410
_strings['Flatten'] = 20411
_strings['Flatten TV show seasons'] = 20412
_strings['Get fanart'] = 20413
_strings['Show fanart in video and music libraries'] = 20414
_strings['Scanning for new content'] = 20415
_strings['First aired'] = 20416
_strings['Writer'] = 20417
_strings['Writers'] = 20418
_strings['Replace file names with library titles'] = 20419
_strings['Never'] = 20420
_strings['If only one season'] = 20421
_strings['Always'] = 20422
_strings['Has trailer'] = 20423
_strings['False'] = 20424
_strings['Fanart slideshow'] = 20425
_strings['Single file'] = 20428
_strings['Separate'] = 20429
_strings['Export thumbnails and fanart?'] = 20430
_strings['Overwrite old files?'] = 20431
_strings['Exclude path from library updates'] = 20432
_strings['Extract thumbnails and video information'] = 20433
_strings['Sets'] = 20434
_strings['Combine split video items'] = 20435
_strings['Export actor thumbs?'] = 20436
_strings['Choose fanart'] = 20437
_strings['Local fanart'] = 20438
_strings['No fanart'] = 20439
_strings['Current fanart'] = 20440
_strings['Remote fanart'] = 20441
_strings['Change content'] = 20442
_strings['Fanart'] = 20445
_strings['Unable to connect to remote server'] = 20449
_strings['Countries'] = 20451
_strings['episode'] = 20452
_strings['episodes'] = 20453
_strings['Listener'] = 20454
_strings['Listeners'] = 20455
_strings['Movie set'] = 20457
_strings['Tags'] = 20459
_strings['Add %s'] = 20460
_strings['Remove %s'] = 20461
_strings['New tag...'] = 20462
_strings['A tag with the name \'%s\' already exists.'] = 20463
_strings['Select %s'] = 20464
_strings['Manage movie set'] = 20465
_strings['Select movie set'] = 20466
_strings['Add movie to a new set'] = 20468
_strings['Keep current set (%s)'] = 20469
_strings['Show hidden files and directories'] = 21330
_strings['Connecting to: %s'] = 21336
_strings['Add media share...'] = 21359
_strings['Look for remote UPnP players'] = 21361
_strings['Bookmark created'] = 21362
_strings['Edit media share'] = 21364
_strings['Remove media share'] = 21365
_strings['Custom subtitle folder'] = 21366
_strings['Movie & alternate subtitle directory'] = 21367
_strings['Enable mouse and touch screen support'] = 21369
_strings['Thumbnail'] = 21371
_strings['Forced DVD player region'] = 21372
_strings['Video aspect'] = 21374
_strings['Normal'] = 21375
_strings['Letterbox'] = 21376
_strings['Widescreen'] = 21377
_strings['Enable 480p'] = 21378
_strings['Enable 720p'] = 21379
_strings['Enable 1080i'] = 21380
_strings['Enter name of new playlist'] = 21381
_strings['Enable scrollbars'] = 21383
_strings['Make watched filtering a toggle in video library'] = 21384
_strings['Open'] = 21385
_strings['Acoustic management level'] = 21386
_strings['Fast'] = 21387
_strings['Quiet'] = 21388
_strings['Enable custom background'] = 21389
_strings['Power management level'] = 21390
_strings['High power'] = 21391
_strings['Low power'] = 21392
_strings['High standby'] = 21393
_strings['Low standby'] = 21394
_strings['Unable to cache files bigger than 4GB'] = 21395
_strings['Chapter'] = 21396
_strings['High quality pixel shader v2'] = 21397
_strings['Use tween animations'] = 21399
_strings['contains'] = 21400
_strings['does not contain'] = 21401
_strings['is'] = 21402
_strings['is not'] = 21403
_strings['starts with'] = 21404
_strings['ends with'] = 21405
_strings['greater than'] = 21406
_strings['less than'] = 21407
_strings['after'] = 21408
_strings['before'] = 21409
_strings['in the last'] = 21410
_strings['not in the last'] = 21411
_strings['Settings'] = 21417
_strings['Multilingual'] = 21418
_strings['Value to match'] = 21420
_strings['Smart playlist rule'] = 21421
_strings['Match items where'] = 21422
_strings['New rule...'] = 21423
_strings['Items must match'] = 21424
_strings['all of the rules'] = 21425
_strings['one or more of the rules'] = 21426
_strings['Limit to'] = 21427
_strings['No limit'] = 21428
_strings['Order by'] = 21429
_strings['ascending'] = 21430
_strings['descending'] = 21431
_strings['Edit smart playlist'] = 21432
_strings['Find items where'] = 21434
_strings['Edit'] = 21435
_strings['%i items'] = 21436
_strings['New smart playlist...'] = 21437
_strings['%c Drive'] = 21438
_strings['Edit party mode rules'] = 21439
_strings['Home folder'] = 21440
_strings['Watched count'] = 21441
_strings['Episode title'] = 21442
_strings['Video resolution'] = 21443
_strings['Audio channels'] = 21444
_strings['Video codec'] = 21445
_strings['Audio codec'] = 21446
_strings['Audio language'] = 21447
_strings['Subtitle language'] = 21448
_strings['Remote control sends keyboard presses'] = 21449
_strings['Edit'] = 21450
_strings['Internet connection required.'] = 21451
_strings['Root filesystem'] = 21453
_strings['External storage'] = 21456
_strings['Watched episode count'] = 21457
_strings['Group by'] = 21458
_strings['mixed'] = 21459
_strings['Subtitle position on screen'] = 21460
_strings['Fixed'] = 21461
_strings['Bottom of video'] = 21462
_strings['Below video'] = 21463
_strings['Top of video'] = 21464
_strings['Above video'] = 21465
_strings['%.1f to %.1f'] = 21467
_strings['%d to %d'] = 21468
_strings['%s to %s'] = 21469
_strings['%s [%d]'] = 21470
_strings['(External)'] = 21602
_strings['File name'] = 21800
_strings['File path'] = 21801
_strings['File size'] = 21802
_strings['Slide index'] = 21804
_strings['Resolution'] = 21805
_strings['Comment'] = 21806
_strings['JPEG process'] = 21808
_strings['Description'] = 21821
_strings['Camera make'] = 21822
_strings['Camera model'] = 21823
_strings['EXIF comment'] = 21824
_strings['Firmware'] = 21825
_strings['Aperture'] = 21826
_strings['Focal length'] = 21827
_strings['Focus distance'] = 21828
_strings['Exposure'] = 21829
_strings['Exposure time'] = 21830
_strings['Exposure bias'] = 21831
_strings['Exposure mode'] = 21832
_strings['Flash used'] = 21833
_strings['White-balance'] = 21834
_strings['Light source'] = 21835
_strings['Metering mode'] = 21836
_strings['ISO'] = 21837
_strings['Digital zoom'] = 21838
_strings['CCD width'] = 21839
_strings['GPS latitude'] = 21840
_strings['GPS longitude'] = 21841
_strings['GPS altitude'] = 21842
_strings['Orientation'] = 21843
_strings['Sub-location'] = 21857
_strings['Image type'] = 21858
_strings['Time created'] = 21859
_strings['Supplemental categories'] = 21860
_strings['Keywords'] = 21861
_strings['Caption'] = 21862
_strings['Author'] = 21863
_strings['Headline'] = 21864
_strings['Special instructions'] = 21865
_strings['Category'] = 21866
_strings['Byline'] = 21867
_strings['Byline title'] = 21868
_strings['Credit'] = 21869
_strings['Source'] = 21870
_strings['Copyright notice'] = 21871
_strings['Object name'] = 21872
_strings['City'] = 21873
_strings['State'] = 21874
_strings['Country'] = 21875
_strings['Date created'] = 21877
_strings['Urgency'] = 21878
_strings['Country code'] = 21879
_strings['Reference service'] = 21880
_strings['Attempt to skip introduction before DVD menu'] = 21882
_strings['Saved music'] = 21883
_strings['Query info for all artists'] = 21884
_strings['Downloading album information'] = 21885
_strings['Downloading artist information'] = 21886
_strings['Biography'] = 21887
_strings['Discography'] = 21888
_strings['Searching artist'] = 21889
_strings['Select artist'] = 21890
_strings['Artist information'] = 21891
_strings['Instruments'] = 21892
_strings['Born'] = 21893
_strings['Formed'] = 21894
_strings['Themes'] = 21895
_strings['Disbanded'] = 21896
_strings['Died'] = 21897
_strings['Years active'] = 21898
_strings['Label'] = 21899
_strings['Update library on startup'] = 22000
_strings['Hide progress of library updates'] = 22001
_strings['DNS suffix'] = 22002
_strings['%2.3fs'] = 22003
_strings['Delayed by: %2.3fs'] = 22004
_strings['Ahead by: %2.3fs'] = 22005
_strings['Subtitle offset'] = 22006
_strings['OpenGL vendor:'] = 22007
_strings['OpenGL renderer:'] = 22008
_strings['OpenGL version:'] = 22009
_strings['GPU temperature:'] = 22010
_strings['CPU temperature:'] = 22011
_strings['Total memory'] = 22012
_strings['Profile data'] = 22013
_strings['Use dim if paused during video playback'] = 22014
_strings['All recordings'] = 22015
_strings['By title'] = 22016
_strings['By group'] = 22017
_strings['Recordings by title'] = 22019
_strings['Guide'] = 22020
_strings['Show video files in listings'] = 22022
_strings['Direct3D version:'] = 22024
_strings['Font'] = 22030
_strings['Size'] = 22031
_strings['Colours'] = 22032
_strings['Charset'] = 22033
_strings['Default select action'] = 22079
_strings['Choose'] = 22080
_strings['More...'] = 22082
_strings['Play all'] = 22083
_strings['Teletext not available'] = 23049
_strings['Part %i'] = 23051
_strings['Buffering %i bytes'] = 23052
_strings['Stopping'] = 23053
_strings['Running'] = 23054
_strings['Add-on'] = 24000
_strings['Add-ons'] = 24001
_strings['Add-on options'] = 24002
_strings['Media sources'] = 24005
_strings['Movie information'] = 24007
_strings['Screensaver'] = 24008
_strings['Script'] = 24009
_strings['Visualisation'] = 24010
_strings['Add-on repository'] = 24011
_strings['Subtitles'] = 24012
_strings['Lyrics'] = 24013
_strings['TV information'] = 24014
_strings['Music video information'] = 24015
_strings['Album information'] = 24016
_strings['Artist information'] = 24017
_strings['Services'] = 24018
_strings['PVR clients'] = 24019
_strings['Configure'] = 24020
_strings['Disable'] = 24021
_strings['Enable'] = 24022
_strings['Disabled'] = 24023
_strings['Add-on disabled'] = 24024
_strings['Weather'] = 24027
_strings['Weather.com (standard)'] = 24028
_strings['Service for weather information'] = 24029
_strings['Error loading settings'] = 24031
_strings['Check for updates'] = 24034
_strings['Uninstall'] = 24037
_strings['Install'] = 24038
_strings['(Clear the current setting)'] = 24040
_strings['Install from zip file'] = 24041
_strings['Downloading %i%%'] = 24042
_strings['Version:'] = 24051
_strings['Disclaimer'] = 24052
_strings['License:'] = 24053
_strings['Check for updates'] = 24055
_strings['Last updated %s'] = 24056
_strings['Auto update'] = 24063
_strings['Add-on enabled'] = 24064
_strings['Add-on updated'] = 24065
_strings['Update available'] = 24068
_strings['Update'] = 24069
_strings['An unknown error has occurred.'] = 24071
_strings['Settings required'] = 24072
_strings['Needs to restart'] = 24074
_strings['Disable'] = 24075
_strings['Try to reconnect?'] = 24080
_strings['Add-on libraries'] = 24082
_strings['Information libraries'] = 24083
_strings['Add-on restarts'] = 24089
_strings['Add-on is incompatible or has been marked broken in repository.'] = 24096
_strings['Would you like to disable it on your system?'] = 24097
_strings['Broken'] = 24098
_strings['Would you like to switch to this skin?'] = 24099
_strings['Unable to load skin'] = 24102
_strings['Skin is missing some files'] = 24103
_strings['Add-on is incompatible due to unmet dependencies.'] = 24104
_strings['Pause when searching for subtitles'] = 24105
_strings['Specify where downloaded subtitles should be saved, the same location as the video or a custom location.'] = 24106
_strings['Searching for subtitles ...'] = 24107
_strings['%d subtitles found'] = 24108
_strings['No subtitles found'] = 24109
_strings['Downloading subtitles ...'] = 24110
_strings['Languages to download subtitles for'] = 24111
_strings['Failed to download subtitle'] = 24113
_strings['No subtitle services installed'] = 24114
_strings['Subtitle storage location'] = 24115
_strings['Manual search string'] = 24120
_strings['Enter search string'] = 24121
_strings['Update all'] = 24122
_strings['Pause the current video while searching for subtitles and resume once the subtitle is available.'] = 24123
_strings['Next to the video'] = 24124
_strings['Custom location'] = 24125
_strings['Auto download first subtitle'] = 24126
_strings['Automatically download first subtitle from the search result list'] = 24127
_strings['Configuration has been moved'] = 24128
_strings['The configuration of XBMC has been moved to the new location for Kodi. Please refer to http://kodi.wiki/view/Migration - this message will not be shown again!'] = 24129
_strings['Hide incompatible'] = 24999
_strings['Notifications'] = 25000
_strings['Hide foreign'] = 25001
_strings['Select from all titles ...'] = 25002
_strings['Show Blu-ray menu'] = 25003
_strings['Play main title: %d'] = 25004
_strings['Title: %d'] = 25005
_strings['Select playback item'] = 25006
_strings['Chapters: %u - duration: %s'] = 25007
_strings['Playback of Blu-ray failed'] = 25008
_strings['The menu of this Blu-ray is not supported'] = 25009
_strings['QWERTY keyboard'] = 29801
_strings['Trailer quality'] = 33001
_strings['Stream'] = 33002
_strings['Download'] = 33003
_strings['Download & play'] = 33004
_strings['Download & save'] = 33005
_strings['Today'] = 33006
_strings['Tomorrow'] = 33007
_strings['Saving'] = 33008
_strings['Copying'] = 33009
_strings['Set download directory'] = 33010
_strings['Search duration'] = 33011
_strings['Short'] = 33012
_strings['Long'] = 33013
_strings['Use DVD player instead of regular player'] = 33014
_strings['Ask for download before playing video'] = 33015
_strings['Clips'] = 33016
_strings['Restart plug-in to enable'] = 33017
_strings['Tonight'] = 33018
_strings['Condition'] = 33020
_strings['Precipitation'] = 33021
_strings['Precip'] = 33022
_strings['Humid'] = 33023
_strings['Feels'] = 33024
_strings['Observed'] = 33025
_strings['Departure from normal'] = 33026
_strings['Sunrise'] = 33027
_strings['Sunset'] = 33028
_strings['Details'] = 33029
_strings['Outlook'] = 33030
_strings['Coverflow'] = 33031
_strings['Translate text'] = 33032
_strings['Map list %s category'] = 33033
_strings['Maps'] = 33035
_strings['Hourly'] = 33036
_strings['Weekend'] = 33037
_strings['%s day'] = 33038
_strings['Alert'] = 33049
_strings['Alerts'] = 33050
_strings['Check'] = 33052
_strings['Configure the'] = 33053
_strings['Seasons'] = 33054
_strings['Use your'] = 33055
_strings['Watch your'] = 33056
_strings['Listen to'] = 33057
_strings['View your'] = 33058
_strings['Configure the'] = 33059
_strings['Power'] = 33060
_strings['Menu'] = 33061
_strings['Play the'] = 33062
_strings['Options'] = 33063
_strings['Editor'] = 33065
_strings['About your'] = 33066
_strings['Star rating'] = 33067
_strings['Background'] = 33068
_strings['Backgrounds'] = 33069
_strings['Custom background'] = 33070
_strings['Custom backgrounds'] = 33071
_strings['No data found!'] = 33077
_strings['Next page'] = 33078
_strings['Love'] = 33079
_strings['Hate'] = 33080
_strings['Path to script'] = 33082
_strings['Enable custom script button'] = 33083
_strings['Auto login'] = 33084
_strings['Failed to start'] = 33100
_strings['Remote communication server'] = 33103
_strings['Lame'] = 34000
_strings['Vorbis'] = 34001
_strings['Wav'] = 34002
_strings['DXVA2'] = 34003
_strings['VAAPI'] = 34004
_strings['Number of channels'] = 34100
_strings['2.0'] = 34101
_strings['2.1'] = 34102
_strings['3.0'] = 34103
_strings['3.1'] = 34104
_strings['4.0'] = 34105
_strings['4.1'] = 34106
_strings['5.0'] = 34107
_strings['5.1'] = 34108
_strings['7.0'] = 34109
_strings['7.1'] = 34110
_strings['Play GUI sounds'] = 34120
_strings['Only when playback stopped'] = 34121
_strings['Always'] = 34122
_strings['Never'] = 34123
_strings['44.1'] = 34124
_strings['48.0'] = 34125
_strings['88.2'] = 34126
_strings['96.0'] = 34127
_strings['192.0'] = 34128
_strings['Can\'t find a next item to play'] = 34201
_strings['Can\'t find a previous item to play'] = 34202
_strings['Failed to start Zeroconf'] = 34300
_strings['Failed to initialise audio device'] = 34402
_strings['Use gestures for navigation:'] = 34404
_strings['Peripherals'] = 35000
_strings['Generic HID device'] = 35001
_strings['Generic disk'] = 35003
_strings['New device configured'] = 35005
_strings['Device removed'] = 35006
_strings['Keymap to use for this device'] = 35007
_strings['Keymap enabled'] = 35008
_strings['Enable joystick and gamepad support'] = 35100
_strings['Disable joystick when this device is present'] = 35102
_strings['Pulse-Eight Nyxboard'] = 36001
_strings['Switch to keyboard side command'] = 36002
_strings['Switch to remote side command'] = 36003
_strings['Press \"user\" button command'] = 36004
_strings['Enable switch side commands'] = 36005
_strings['HDMI port number'] = 36015
_strings['Connected'] = 36016
_strings['Use the TV\'s language setting'] = 36018
_strings['Connected to HDMI device'] = 36019
_strings['Physical address (overrules HDMI port)'] = 36021
_strings['Configuration updated'] = 36023
_strings['Failed to set the new configuration. Please check your settings.'] = 36024
_strings['This device needs servicing'] = 36027
_strings['Ignore'] = 36028
_strings['When the TV is switched off'] = 36029
_strings['Connection lost'] = 36030
_strings['Always'] = 36035
_strings['TV'] = 36037
_strings['Amplifier / AVR device'] = 36038
_strings['TV and AVR device (explicit)'] = 36039
_strings['* Item folder'] = 36041
_strings['Use limited colour range (16-235)'] = 36042
_strings['Change the look and feel of the user interface.'] = 36101
_strings['Change the theme associated with your selected skin.'] = 36105
_strings['Change the colours of your selected skin.'] = 36106
_strings['Choose the fonts displayed in the user interface. The font sets are configured by your skin.'] = 36107
_strings['Resize the view of the user interface.'] = 36108
_strings['Turn this off to remove the scrolling RSS news ticker.'] = 36111
_strings['Edit the RSS feeds.'] = 36112
_strings['Chooses the language of the user interface.'] = 36114
_strings['Select the formats for temperature, time and date. The available options depend on the selected language.'] = 36115
_strings['Select country location.'] = 36117
_strings['Select your current timezone.'] = 36118
_strings['Display the (..) item in lists for visiting the parent folder.'] = 36122
_strings['Show the add source button in root sections of the user interface.'] = 36126
_strings['Show hidden files and directories when listing files.'] = 36127
_strings['Preview the selected screensaver.'] = 36132
_strings['No info available yet.'] = 36135
_strings['No info available yet.'] = 36136
_strings['No info available yet.'] = 36137
_strings['Section that contains settings related to videos and how they are handled.'] = 36138
_strings['Hide the library scanning progress bar during scans.'] = 36147
_strings['Remove items from your library that can\'t be found (either renamed, deleted, or on removable storage that is currently unplugged).'] = 36148
_strings['Enable automatic playback of the next file in the list.'] = 36152
_strings['Adjust the method used to process and display video.'] = 36153
_strings['Enable VDPAU hardware decoding of video files, mainly used for NVIDIA graphics and in some circumstances AMD graphics.'] = 36155
_strings['Enable VAAPI hardware decoding of video files, mainly used for Intel graphics and in some circumstances AMD graphics.'] = 36156
_strings['Enable DXVA2 hardware decoding of video files.'] = 36158
_strings['Enable CrystalHD decoding of video files.'] = 36159
_strings['Enable OpenMax hardware decoding of video files.'] = 36161
_strings['Enable VideoToolbox hardware decoding of video files.'] = 36162
_strings['Allow the refresh rate of the display to be changed so that it best matches the video frame rate. This may yield smoother video playback.'] = 36164
_strings['Select the zoom level that 4:3 videos are shown on widescreen displays.'] = 36171
_strings['Extract thumbnails and metadata information such as codec and aspect ratio from videos.'] = 36178
_strings['When a file is scanned into the library it will display the metadata title instead of the file name.'] = 36179
_strings['No info available yet.'] = 36181
_strings['Set the font size to be used for subtitles.'] = 36186
_strings['Set the font style to be used for subtitles.'] = 36187
_strings['Set the font colour to be used for subtitles.'] = 36188
_strings['Set the font character set to be used for subtitles.'] = 36189
_strings['Set a custom directory for your subtitles. This can be a file share.'] = 36191
_strings['Location of subtitles on the screen.'] = 36192
_strings['Autorun DVD video when inserted in drive.'] = 36194
_strings['Force a region for DVD playback.'] = 36195
_strings['No info available yet.'] = 36197
_strings['Import channel groups from the PVR backend (if supported). Will delete user created groups if they\'re not found on the backend.'] = 36204
_strings['Open the channel manager, which allows modifying the channel order, channel name, icon, etc.'] = 36207
_strings['Instruct the backend to search for channels (if supported).'] = 36208
_strings['Display programming information when changing channels, such as the current TV show.'] = 36212
_strings['Close the on screen display controls after switching channels.'] = 36214
_strings['Folder where channel icons are stored.'] = 36216
_strings['Scan for missing channel icons.'] = 36217
_strings['Continue with the last viewed channel on startup.'] = 36228
_strings['When pressing channel up or down, the actual channel switch is delayed, allowing the user to flip to a channel number without waiting for each channel switch.'] = 36232
_strings['Display a notification when timers are added, finished or removed by the backend.'] = 36239
_strings['The command will not be executed when a recording will be started within this timeout.'] = 36242
_strings['Time to subtract from the start time of the next scheduled recording.'] = 36244
_strings['Execute the wakeup command every day at the given time.'] = 36245
_strings['When to execute the daily wakeup command.'] = 36246
_strings['Enter a new pin code to unlock parental locked channels.'] = 36249
_strings['Ask for the pin code again when trying to access a parental locked channel and the code hasn\'t been asked for this duration.'] = 36250
_strings['Section that contains settings related to music files and how they are handled.'] = 36253
_strings['No info available yet.'] = 36260
_strings['When songs are selected they are queued instead of playback starting immediately.'] = 36266
_strings['Smoothly fade from one audio track to the next. You can set the amount of overlap from 1-15 seconds.'] = 36271
_strings['Allow crossfading to occur when both tracks are from the same album.'] = 36272
_strings['Select the visualisation that will be displayed while listening to music.'] = 36273
_strings['Control the way that the names of songs are displayed in the user interface. In order to function properly, tag reading needs to be enabled.'] = 36275
_strings['Used for formatting the second column in file lists.'] = 36276
_strings['Control the way that the names of songs are displayed in the now playing list.'] = 36277
_strings['Used for formatting the second column in the now playing list.'] = 36278
_strings['Control the way that the names of songs are displayed in library lists.'] = 36279
_strings['Used for formatting the second column in library lists.'] = 36280
_strings['Autorun CDs when inserted in drive.'] = 36283
_strings['Select the location on your hard drive where ripped tracks will be saved to.'] = 36285
_strings['Control how saved music is named from the tags. Tags: [B]%N[/B]: TrackNumber, [B]%S[/B]: DiscNumber, [B]%A[/B]: Artist, [B]%T[/B]: Title, [B]%B[/B]: Album, [B]%G[/B]: Genre, [B]%Y[/B]: Year, [B]%F[/B]: FileName, [B]%D[/B]: Duration, [B]%J[/B]: Date, [B]%R[/B]: Rating, [B]%I[/B]: FileSize.'] = 36286
_strings['Select which audio encoder to use when ripping.'] = 36287
_strings['Select which quality you want to rip your files.'] = 36288
_strings['Select which bitrate to use for the specified audio encoder for audio compression.'] = 36289
_strings['For FLAC define compression level, default 5.'] = 36290
_strings['Auto eject disc after rip is complete.'] = 36291
_strings['No info available yet.'] = 36302
_strings['No info available yet.'] = 36303
_strings['Section that contains settings related to pictures and how they are handled.'] = 36304
_strings['Automatically generate picture thumbnails when entering picture folder.'] = 36307
_strings['Show videos in picture file lists.'] = 36309
_strings['No info available yet.'] = 36310
_strings['Select the amount of time that each image is displayed in a slideshow.'] = 36312
_strings['Images in a slideshow will pan and zoom while displayed.'] = 36313
_strings['View slideshow images in a random order.'] = 36314
_strings['Section that contains weather related settings.'] = 36315
_strings['Select up to three locations for which the weather can be displayed.'] = 36317
_strings['Enable the UPnP client. This allows you to stream media from any UPnP server with a control point and control playback from that server.'] = 36325
_strings['Define the remote control port.'] = 36335
_strings['Define the remote control port range.'] = 36336
_strings['Define the maximum number of clients that can connect.'] = 36337
_strings['Initial repeat delay (ms).'] = 36339
_strings['Continuous repeat delay (ms).'] = 36340
_strings['Enable AirPlay password protection.'] = 36344
_strings['Sets the AirPlay password.'] = 36345
_strings['If a WINS server is running on the network, enter its IP address here. Otherwise, leave blank.'] = 36347
_strings['If a WINS server is running on the network, enter its workgroup name here. Otherwise, leave blank.'] = 36348
_strings['Changes the resolution that the user interface is displayed in.'] = 36352
_strings['Changes the refresh rate that the user interface is displayed in.'] = 36353
_strings['Calibrate the user interface by adjusting the overscan. Use this tool if the image being displayed is too large or small for your display.'] = 36357
_strings['Test patterns for display hardware calibration.'] = 36358
_strings['Use limited colour range (16-235) instead of full colour range (0-255). Limited range should be used if your display is a regular HDMI TV and doesn\'t have a PC or other mode to display full range colour, however if your display is a PC monitor then leave this disabled to get proper blacks.'] = 36359
_strings['Boost AC3 streams that have been downmixed to 2 channels.'] = 36363
_strings['Select to enable upmixing of 2 channel audio to the number of audio channels specified by the channel configuration.'] = 36364
_strings['Select this option if your receiver is capable of decoding TrueHD streams.'] = 36369
_strings['Select the device to be used for playback of audio that has been decoded such as mp3.'] = 36371
_strings['Configure how interface sounds are handled, such as menu navigation and important notifications.'] = 36373
_strings['Configure any attached peripheral devices.'] = 36375
_strings['When activated, your keyboard arrows will move the selection on the virtual keyboard. When deactivated, they will move the cursor from your text.'] = 36376
_strings['Configure which proxy type is used.'] = 36381
_strings['Configure the proxy server address.'] = 36382
_strings['Configure the proxy server port.'] = 36383
_strings['Configure the proxy server username.'] = 36384
_strings['Configure the proxy server password.'] = 36385
_strings['Turn off display when idle. Useful for TVs that turn off when there is no display signal detected.'] = 36388
_strings['Turn debug logging on or off. Useful for troubleshooting.'] = 36392
_strings['Enable cache for playback of DVD from DVD-ROM.'] = 36407
_strings['Enable cache of unknown types from Internet.'] = 36409
_strings['No info available yet.'] = 36410
_strings['No info available yet.'] = 36411
_strings['No info available yet.'] = 36412
_strings['No info available yet.'] = 36413
_strings['No info available yet.'] = 36414
_strings['No info available yet.'] = 36415
_strings['Specify the type of remote used.'] = 36416
_strings['Specify the delay between button sequences on a universal remote.'] = 36418
_strings['Define locations used for retrieving weather information.'] = 36419
_strings['Bypassing VDPAU mixer saves resources on low power systems but slightly reduces picture quality.'] = 36421
_strings['Show context menu'] = 36425
_strings['Switch to channel'] = 36426
_strings['Show information'] = 36427
_strings['Record'] = 36428
_strings['Configure how video processing will be accelerated. This includes things like decoding and scaling.'] = 36430
_strings['Select virtual keyboard layouts.'] = 36432
_strings['Stereoscopic 3D mode'] = 36501
_strings['Disabled'] = 36502
_strings['Side by side'] = 36504
_strings['Interlaced'] = 36507
_strings['Playback mode of stereoscopic 3D videos'] = 36520
_strings['Ask me'] = 36521
_strings['Preferred mode'] = 36524
_strings['Same as movie (autodetect)'] = 36525
_strings['Disable stereoscopic 3D mode when playback ended'] = 36526
_strings['Select playback mode'] = 36527
_strings['Select stereoscopic 3D mode'] = 36528
_strings['Select alternate mode...'] = 36531
_strings['Same as movie'] = 36532
_strings['Stereoscopic 3D mode of video'] = 36535
_strings['Changes the stereoscopic 3D mode of the user interface.'] = 36539
_strings['The preferred mode in which stereoscopic 3D media such as videos should be played.'] = 36540
_strings['Allows volume control from AirPlay clients.'] = 36541
_strings['Output to both analogue (headphones) and HDMI'] = 36542
_strings['Enable this to make dialogue louder compared to background sounds when downmixing multichannel audio'] = 36543
_strings['Enable hardware decoding of video files.'] = 36544
_strings['Stereoscopic 3D depth of subtitles'] = 36545
_strings['Sets the visual depth of subtitles for stereoscopic 3D videos. The higher the value, the closer the subtitles will appear to the viewer.'] = 36546
_strings['Use higher quality textures for covers and fanart (uses more memory)'] = 36547
_strings['Limits resolution of GUI to save memory. Does not affect video playback. Requires restart.'] = 36548
_strings['movie'] = 36900
_strings['movies'] = 36901
_strings['TV show'] = 36902
_strings['season'] = 36904
_strings['seasons'] = 36905
_strings['episode'] = 36906
_strings['episodes'] = 36907
_strings['set'] = 36910
_strings['sets'] = 36911
_strings['video'] = 36912
_strings['videos'] = 36913
_strings['music'] = 36914
_strings['music'] = 36915
_strings['artist'] = 36916
_strings['artists'] = 36917
_strings['album'] = 36918
_strings['albums'] = 36919
_strings['song'] = 36920
_strings['songs'] = 36921
_strings['(CC)'] = 37011
_strings['(Forced)'] = 37012
_strings['Last used profile'] = 37014
_strings['Dual audio output'] = 37017
_strings['Boost centre channel when downmixing'] = 37018
_strings['Enable higher colour depth artwork'] = 37020
_strings['Set GUI resolution limit'] = 37021
_strings['Do you wish to stop playback on the remote device?'] = 37023
_strings['Configure audio encoder settings such as quality and compression level'] = 37025
_strings['Auto'] = 37026
_strings['540'] = 37027
_strings['720'] = 37028
_strings['900'] = 37029
_strings['Unlimited'] = 37030
_strings['GPU accelerated'] = 38010

#GENERATED
