/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.jdr.commands.JdrCommand;
import org.jboss.as.jdr.util.Sanitizer;
import org.jboss.as.jdr.util.Utils;
import org.jboss.as.jdr.vfs.Filters;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class CollectFiles
extends JdrCommand {
    private VirtualFileFilter filter = Filters.TRUE;
    private Filters.BlacklistFilter blacklistFilter = Filters.wildcardBlackList();
    private LinkedList<Sanitizer> sanitizers = new LinkedList();
    private Comparator<VirtualFile> sorter = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile resource, VirtualFile resource1) {
            return Long.signum(resource.getLastModified() - resource1.getLastModified());
        }
    };
    private long limit = -1L;

    public CollectFiles(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public CollectFiles(String pattern) {
        this.filter = Filters.wildcard(pattern);
    }

    public CollectFiles sanitizer(Sanitizer ... sanitizers) {
        for (Sanitizer s : sanitizers) {
            this.sanitizers.add(s);
        }
        return this;
    }

    public CollectFiles sorter(Comparator<VirtualFile> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CollectFiles limit(long limit) {
        this.limit = limit;
        return this;
    }

    public CollectFiles omit(String pattern) {
        this.blacklistFilter.add(pattern);
        return this;
    }

    @Override
    public void execute() throws Exception {
        VirtualFile root = VFS.getChild((String)this.env.getJbossHome());
        List matches = root.getChildrenRecursively(Filters.and(this.filter, this.blacklistFilter));
        if (this.sorter != null) {
            Collections.sort(matches, this.sorter);
        }
        Limiter limiter = new Limiter(this.limit);
        Iterator iter = matches.iterator();
        while (iter.hasNext() && !limiter.isDone()) {
            VirtualFile f = (VirtualFile)iter.next();
            InputStream stream = limiter.limit(f);
            Throwable throwable = null;
            try {
                InputStream modifiedStream = stream;
                for (Sanitizer sanitizer : this.sanitizers) {
                    if (!sanitizer.accepts(f)) continue;
                    modifiedStream = sanitizer.sanitize(modifiedStream);
                }
                this.env.getZip().add(f, modifiedStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    private static class Limiter {
        private long amountRead = 0L;
        private long limit = -1L;
        private boolean done = false;

        public Limiter(long limit) {
            this.limit = limit;
        }

        public boolean isDone() {
            return this.done;
        }

        public InputStream limit(VirtualFile resource) throws IOException {
            InputStream is = resource.openStream();
            long resourceSize = resource.getSize();
            if (this.limit != -1L) {
                long leftToRead = this.limit - this.amountRead;
                if (leftToRead < resourceSize) {
                    Utils.skip(is, resourceSize - leftToRead);
                    this.done = true;
                } else {
                    this.amountRead += resourceSize;
                }
            }
            return is;
        }
    }
}

