/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public abstract class FileBasedNodeManager
extends NodeManager {
    protected static final byte FIRST_TIME_START = 48;
    public static final String SERVER_LOCK_NAME = "server.lock";
    private static final String ACCESS_MODE = "rw";
    private final File directory;
    protected FileChannel channel;

    public FileBasedNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup);
        this.directory = directory;
    }

    protected synchronized void setUpServerLockFile() throws IOException {
        File serverLockFile = this.newFile(SERVER_LOCK_NAME);
        boolean fileCreated = false;
        int count = 0;
        while (!serverLockFile.exists()) {
            try {
                fileCreated = serverLockFile.createNewFile();
            }
            catch (RuntimeException e) {
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
            catch (IOException e) {
                if (count < 5) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++count;
                    continue;
                }
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
        }
        RandomAccessFile raFile = new RandomAccessFile(serverLockFile, ACCESS_MODE);
        this.channel = raFile.getChannel();
        if (fileCreated) {
            ByteBuffer id = ByteBuffer.allocateDirect(3);
            byte[] bytes = new byte[]{48, 48, 48};
            id.put(bytes, 0, 3);
            id.position(0);
            this.channel.write(id, 0L);
            this.channel.force(true);
        }
        this.createNodeId();
    }

    protected final File newFile(String fileName) {
        File file = new File(this.directory, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void createNodeId() throws IOException {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = this.channel.read(id, 3L);
            if (this.replicatedBackup) {
                id.position(0);
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else if (read != 16) {
                this.setUUID(UUIDGenerator.getInstance().generateUUID());
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else {
                byte[] bytes = new byte[16];
                id.position(0);
                id.get(bytes);
                this.setUUID(new UUID(1, bytes));
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        FileChannel channelCopy = this.channel;
        if (channelCopy != null) {
            channelCopy.close();
        }
        super.stop();
    }

    @Override
    public void stopBackup() throws NodeManager.NodeManagerException {
        if (this.replicatedBackup && this.getNodeId() != null) {
            try {
                this.setUpServerLockFile();
            }
            catch (IOException e) {
                throw new NodeManager.NodeManagerException(e);
            }
        }
        super.stopBackup();
    }
}

