/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.dmr.ModelNode;

public class ServerGroupChooser
extends JPanel {
    private List<JCheckBox> serverGroups = new ArrayList<JCheckBox>();
    private JPanel serverGroupsPanel = new JPanel(new FlowLayout());

    public ServerGroupChooser(CliGuiContext cliGuiCtx) {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Server Groups"));
        this.setServerGroups(cliGuiCtx);
        this.add((Component)this.serverGroupsPanel, "Center");
    }

    private void setServerGroups(CliGuiContext cliGuiCtx) {
        TreeSet<String> serverGroupNames = new TreeSet<String>();
        try {
            ModelNode serverGroupQuery = cliGuiCtx.getExecutor().doCommand("/:read-children-names(child-type=server-group)");
            if (serverGroupQuery.get("outcome").asString().equals("failed")) {
                return;
            }
            for (ModelNode node : serverGroupQuery.get("result").asList()) {
                serverGroupNames.add(node.asString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String name : serverGroupNames) {
            JCheckBox serverGroupCheckBox = new JCheckBox(name);
            this.serverGroups.add(serverGroupCheckBox);
            this.serverGroupsPanel.add(serverGroupCheckBox);
        }
    }

    public String getCmdLineArg() {
        StringBuilder builder = new StringBuilder("  --server-groups=");
        boolean foundSelected = false;
        for (JCheckBox serverGroup : this.serverGroups) {
            if (!serverGroup.isSelected()) continue;
            foundSelected = true;
            builder.append(serverGroup.getText());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        if (!foundSelected) {
            return "";
        }
        return builder.toString();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (JCheckBox serverGroup : this.serverGroups) {
            serverGroup.setEnabled(isEnabled);
        }
    }
}

