/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;

class AttributeParsers {
    static final AttributeParser VALUE = new AttributeParser(){

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            ModelNode valueNode = ParseUtils.parseAttributeValue((String)AttributeParsers.readValueAttribute(reader), (boolean)attribute.isAllowExpression(), (ModelType)attribute.getType());
            operation.get(attribute.getName()).set(valueNode);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        public boolean isParseAsElement() {
            return true;
        }
    };

    AttributeParsers() {
    }

    static String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return AttributeParsers.readRequiredAttributes(reader, EnumSet.of(Attribute.NAME)).get((Object)Attribute.NAME);
    }

    static String readValueAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return AttributeParsers.readRequiredAttributes(reader, EnumSet.of(Attribute.VALUE)).get((Object)Attribute.VALUE);
    }

    static Map<Attribute, String> readRequiredAttributes(XMLExtendedStreamReader reader, Set<Attribute> attributes) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        EnumMap<Attribute, String> result = new EnumMap<Attribute, String>(Attribute.class);
        for (int i = 0; i < attributeCount; ++i) {
            Attribute current = Attribute.forName(reader.getAttributeLocalName(i));
            if (attributes.contains((Object)current)) {
                if (result.put(current, reader.getAttributeValue(i)) == null) continue;
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)current.getLocalName());
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i, attributes.stream().map(Attribute::getLocalName).collect(Collectors.toSet()));
        }
        if (result.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, attributes.stream().map(Attribute::getLocalName).collect(Collectors.toSet()));
        }
        return result;
    }
}

