/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Promise;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;

public class NetSocketImpl
extends ConnectionBase
implements NetSocketInternal {
    private static final Handler<Object> DEFAULT_MSG_HANDLER = new InvalidMessageHandler();
    private static final Logger log = LoggerFactory.getLogger(NetSocketImpl.class);
    private final String writeHandlerID;
    private final SSLHelper helper;
    private final SocketAddress remoteAddress;
    private final TCPMetrics metrics;
    private final InboundBuffer<Object> pending;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private MessageConsumer registration;
    private Handler<Object> messageHandler;

    public NetSocketImpl(ContextInternal context, ChannelHandlerContext channel, SSLHelper helper, TCPMetrics metrics) {
        this(context, channel, null, helper, metrics);
    }

    public NetSocketImpl(ContextInternal context, ChannelHandlerContext channel, SocketAddress remoteAddress, SSLHelper helper, TCPMetrics metrics) {
        super(context, channel);
        this.helper = helper;
        this.writeHandlerID = "__vertx.net." + UUID.randomUUID().toString();
        this.remoteAddress = remoteAddress;
        this.metrics = metrics;
        this.messageHandler = DEFAULT_MSG_HANDLER;
        this.pending = new InboundBuffer(context);
        this.pending.drainHandler((Void v) -> this.doResume());
        this.pending.exceptionHandler(context::reportException);
        this.pending.handler((E obj) -> {
            if (obj == InboundBuffer.END_SENTINEL) {
                Handler<Void> handler = this.endHandler();
                if (handler != null) {
                    handler.handle(null);
                }
            } else {
                Handler<Object> handler = this.messageHandler();
                if (handler != null) {
                    handler.handle(obj);
                }
            }
        });
    }

    synchronized void registerEventBusHandler() {
        Handler<Message> writeHandler = msg -> this.write((Buffer)msg.body());
        this.registration = this.vertx.eventBus().localConsumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public TCPMetrics metrics() {
        return this.metrics;
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public synchronized Future<Void> writeMessage(Object message) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeMessage(message, promise);
        return promise.future();
    }

    @Override
    public NetSocketInternal writeMessage(Object message, Handler<AsyncResult<Void>> handler) {
        this.writeToChannel(message, handler == null ? null : this.context.promise(handler));
        return this;
    }

    @Override
    protected void reportsBytesWritten(Object msg) {
        if (msg instanceof ByteBuf) {
            this.reportBytesWritten(((ByteBuf)msg).readableBytes());
        }
    }

    @Override
    protected void reportBytesRead(Object msg) {
        if (msg instanceof ByteBuf) {
            this.reportBytesRead(((ByteBuf)msg).readableBytes());
        }
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeMessage(data.getByteBuf());
    }

    @Override
    public void write(String str, Handler<AsyncResult<Void>> handler) {
        this.write(Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8), handler);
    }

    @Override
    public Future<Void> write(String str) {
        return this.writeMessage(Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8));
    }

    @Override
    public Future<Void> write(String str, String enc) {
        return this.writeMessage(Unpooled.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc)));
    }

    @Override
    public void write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        Charset cs = enc != null ? Charset.forName(enc) : CharsetUtil.UTF_8;
        this.write(Unpooled.copiedBuffer((CharSequence)str, (Charset)cs), handler);
    }

    @Override
    public void write(Buffer message, Handler<AsyncResult<Void>> handler) {
        this.write(message.getByteBuf(), handler);
    }

    @Override
    private void write(ByteBuf buff, Handler<AsyncResult<Void>> handler) {
        this.reportBytesWritten(buff.readableBytes());
        this.writeMessage(buff, handler);
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
        if (dataHandler != null) {
            this.messageHandler(new DataMessageHandler(dataHandler));
        } else {
            this.messageHandler(null);
        }
        return this;
    }

    private synchronized Handler<Object> messageHandler() {
        return this.messageHandler;
    }

    @Override
    public synchronized NetSocketInternal messageHandler(Handler<Object> handler) {
        this.messageHandler = handler;
        return this;
    }

    @Override
    public synchronized NetSocket pause() {
        this.pending.pause();
        return this;
    }

    @Override
    public NetSocket fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    @Override
    public synchronized NetSocket resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    private synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(v -> this.callDrainHandler());
        return this;
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise = this.context.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        File f = this.vertx.resolveFile(filename);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("filename must point to a file and not to a directory");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            ChannelFuture future = super.sendFile(raf, Math.min(offset, f.length()), Math.min(length, f.length() - offset));
            if (resultHandler != null) {
                future.addListener(fut -> {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    this.vertx.runOnContext(v -> resultHandler.handle(res));
                });
            }
        }
        catch (IOException e) {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resultHandler != null) {
                this.vertx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
            }
            log.error("Failed to send file", e);
        }
        return this;
    }

    @Override
    public NetSocketImpl exceptionHandler(Handler<Throwable> handler) {
        return (NetSocketImpl)super.exceptionHandler(handler);
    }

    @Override
    public NetSocketImpl closeHandler(Handler<Void> handler) {
        return (NetSocketImpl)super.closeHandler(handler);
    }

    @Override
    public Future<Void> upgradeToSsl() {
        PromiseInternal<Void> promise = this.context.promise();
        this.upgradeToSsl(promise);
        return promise.future();
    }

    @Override
    public Future<Void> upgradeToSsl(String serverName) {
        PromiseInternal<Void> promise = this.context.promise();
        this.upgradeToSsl(serverName, promise);
        return promise.future();
    }

    @Override
    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        return this.upgradeToSsl(null, handler);
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<AsyncResult<Void>> handler) {
        ChannelOutboundHandler sslHandler = (ChannelOutboundHandler)this.chctx.pipeline().get("ssl");
        if (sslHandler == null) {
            ChannelPromise p = this.chctx.newPromise();
            this.chctx.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler((Promise<Void>)p));
            p.addListener(future -> {
                if (handler != null) {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    this.context.emit(res, handler);
                }
            });
            if (this.remoteAddress != null) {
                sslHandler = new SslHandler(this.helper.createEngine(this.vertx, this.remoteAddress, serverName));
                ((SslHandler)sslHandler).setHandshakeTimeout(this.helper.getSslHandshakeTimeout(), this.helper.getSslHandshakeTimeoutUnit());
            } else if (this.helper.isSNI()) {
                sslHandler = new SniHandler(this.helper.serverNameMapper(this.vertx));
            } else {
                sslHandler = new SslHandler(this.helper.createEngine(this.vertx));
                ((SslHandler)sslHandler).setHandshakeTimeout(this.helper.getSslHandshakeTimeout(), this.helper.getSslHandshakeTimeoutUnit());
            }
            this.chctx.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
        }
        return this;
    }

    @Override
    protected void handleInterestedOpsChanged() {
        this.context.emit(null, v -> this.callDrainHandler());
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.close(handler);
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        MessageConsumer consumer;
        NetSocketImpl netSocketImpl = this;
        synchronized (netSocketImpl) {
            consumer = this.registration;
            this.registration = null;
        }
        this.context.emit(InboundBuffer.END_SENTINEL, this.pending::write);
        super.handleClosed();
        if (consumer != null) {
            consumer.unregister();
        }
    }

    @Override
    public void handleMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            msg = VertxHandler.safeBuffer((ByteBuf)msg);
        }
        this.context.emit(msg, elt -> {
            if (!this.pending.write(elt)) {
                this.doPause();
            }
        });
    }

    private synchronized void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            this.drainHandler.handle(null);
        }
    }

    private static class InvalidMessageHandler
    implements Handler<Object> {
        private InvalidMessageHandler() {
        }

        @Override
        public void handle(Object msg) {
            if (msg instanceof ReferenceCounted && !(msg instanceof ByteBuf)) {
                ReferenceCounted refCounter = (ReferenceCounted)msg;
                refCounter.release();
            }
        }
    }

    private static class DataMessageHandler
    implements Handler<Object> {
        private final Handler<Buffer> dataHandler;

        DataMessageHandler(Handler<Buffer> dataHandler) {
            this.dataHandler = dataHandler;
        }

        @Override
        public void handle(Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)msg;
                Buffer data = Buffer.buffer(byteBuf);
                this.dataHandler.handle(data);
            }
        }
    }
}

