/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeBody;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpReadableBuffer;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;

public class AMQPLargeMessage
extends AMQPMessage
implements LargeServerMessage {
    private ByteBuf temporaryBuffer;
    private final LargeBody largeBody;
    private Boolean fileDurable;
    private volatile AmqpReadableBuffer parsingData;
    private StorageManager storageManager;

    @Override
    public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        LargeBodyReader reader = this.largeBody.getLargeBodyReader();
        try {
            long size = reader.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new RuntimeException("AMQP Large Message Body is too large to be converted into core");
            }
            byte[] buffer = new byte[(int)size];
            ByteBuffer wrapbuffer = ByteBuffer.wrap(buffer);
            reader.open();
            reader.readInto(wrapbuffer);
            AMQPStandardMessage standardMessage = new AMQPStandardMessage(this.messageFormat, buffer, this.extraProperties, coreMessageObjectPools);
            standardMessage.setMessageID(this.messageID);
            ICoreMessage iCoreMessage = standardMessage.toCore();
            return iCoreMessage;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public AMQPLargeMessage(long id, long messageFormat, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools, StorageManager storageManager) {
        super(messageFormat, extraProperties, coreMessageObjectPools);
        this.setMessageID(id);
        this.largeBody = new LargeBody((LargeServerMessage)this, storageManager);
        this.storageManager = storageManager;
    }

    public AMQPLargeMessage(long id, long messageFormat, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools, StorageManager storageManager, LargeBody largeBody) {
        super(messageFormat, extraProperties, coreMessageObjectPools);
        this.setMessageID(id);
        this.largeBody = largeBody;
        this.storageManager = storageManager;
    }

    private AMQPLargeMessage(AMQPLargeMessage copy, SequentialFile fileCopy, long newID) {
        super(copy);
        this.largeBody = new LargeBody((LargeServerMessage)this, copy.largeBody.getStorageManager(), fileCopy);
        this.largeBody.setBodySize(copy.largeBody.getStoredBodySize());
        this.storageManager = copy.largeBody.getStorageManager();
        this.setMessageID(newID);
    }

    public void openLargeMessage() throws Exception {
        this.parsingData = new AmqpReadableBuffer(this.largeBody.map());
    }

    public void closeLargeMessage() throws Exception {
        this.largeBody.releaseResources(false);
        this.parsingData.freeDirectBuffer();
        this.parsingData = null;
    }

    public void releaseEncodedBuffer() {
        this.internalReleaseBuffer(1);
    }

    public void releaseEncodedBufferAfterWrite() {
        this.internalReleaseBuffer(2);
    }

    public void checkReference(MessageReference reference) {
        if (reference.getProtocolData() == null && this.deliveryAnnotationsForSendBuffer != null) {
            reference.setProtocolData((Object)this.deliveryAnnotationsForSendBuffer);
        }
    }

    public int getPositionAfterDeliveryAnnotations() {
        return this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReleaseBuffer(int releases) {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            for (int i = 0; i < releases; ++i) {
                if (this.temporaryBuffer == null || !this.temporaryBuffer.release()) continue;
                this.temporaryBuffer = null;
            }
        }
    }

    public ByteBuf inspectTemporaryBuffer() {
        return this.temporaryBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getSavedEncodeBuffer() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            if (this.temporaryBuffer == null) {
                this.temporaryBuffer = PooledByteBufAllocator.DEFAULT.buffer(this.getEstimateSavedEncode());
                this.saveEncoding(this.temporaryBuffer);
            }
            return this.temporaryBuffer.retain(1);
        }
    }

    public void finishParse() throws Exception {
        this.openLargeMessage();
        try {
            this.ensureMessageDataScanned();
            this.parsingData.rewind();
            this.lazyDecodeApplicationProperties();
        }
        finally {
            this.closeLargeMessage();
        }
    }

    public void validateFile() throws ActiveMQException {
        this.largeBody.validateFile();
    }

    public void setFileDurable(boolean value) {
        this.fileDurable = value;
    }

    public StorageManager getStorageManager() {
        return this.largeBody.getStorageManager();
    }

    public void setStorageManager(StorageManager storageManager) {
        this.largeBody.setStorageManager(storageManager);
        this.storageManager = storageManager;
    }

    @Override
    public final boolean isDurable() {
        if (this.fileDurable != null) {
            return this.fileDurable;
        }
        return super.isDurable();
    }

    @Override
    public ReadableBuffer getData() {
        if (this.parsingData == null) {
            throw new RuntimeException("AMQP Large Message is not open");
        }
        return this.parsingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHeader(ReadableBuffer buffer) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(buffer);
        try {
            int constructorPos = buffer.position();
            TypeConstructor constructor = decoder.readConstructor();
            if (Header.class.equals((Object)constructor.getTypeClass())) {
                this.header = (Header)constructor.readValue();
                if (this.header.getTtl() != null) {
                    this.expiration = System.currentTimeMillis() + (long)this.header.getTtl().intValue();
                }
            }
        }
        finally {
            decoder.setBuffer(null);
            buffer.rewind();
        }
    }

    public void addBytes(ReadableBuffer data) throws Exception {
        if (this.header == null && this.largeBody.getStoredBodySize() <= 0L) {
            this.parseHeader(data);
        }
        if (data.hasArray() && data.remaining() == data.array().length) {
            this.largeBody.addBytes(data.array());
        } else {
            byte[] bytes = new byte[data.remaining()];
            data.get(bytes);
            this.largeBody.addBytes(bytes);
        }
    }

    @Override
    public ReadableBuffer getSendBuffer(int deliveryCount, MessageReference reference) {
        return this.getData().rewind();
    }

    public Message toMessage() {
        return this;
    }

    public void addBytes(byte[] bytes) throws Exception {
        this.largeBody.addBytes(bytes);
    }

    public void addBytes(ActiveMQBuffer bytes) throws Exception {
        this.largeBody.addBytes(bytes);
    }

    public void setPaged() {
        this.largeBody.setPaged();
    }

    public void releaseResources(boolean sync) {
        this.largeBody.releaseResources(sync);
    }

    public void deleteFile() throws Exception {
        this.largeBody.deleteFile();
    }

    public SequentialFile getAppendFile() throws ActiveMQException {
        return this.largeBody.getAppendFile();
    }

    public boolean isLargeMessage() {
        return true;
    }

    public LargeBodyReader getLargeBodyReader() {
        return this.largeBody.getLargeBodyReader();
    }

    public LargeBody getLargeBody() {
        return this.largeBody;
    }

    public void clearPendingRecordID() {
        this.largeBody.clearPendingRecordID();
    }

    public boolean hasPendingRecord() {
        return this.largeBody.hasPendingRecord();
    }

    public void setPendingRecordID(long pendingRecordID) {
        this.largeBody.setPendingRecordID(pendingRecordID);
    }

    public long getPendingRecordID() {
        return this.largeBody.getPendingRecordID();
    }

    protected void releaseComplete() {
        this.largeBody.deleteFile();
    }

    @Override
    public Message copy() {
        SequentialFile newfile = this.largeBody.createFile();
        AMQPLargeMessage newMessage = new AMQPLargeMessage(this, newfile, this.messageID);
        newMessage.setParentRef(this);
        newMessage.setFileDurable(this.isDurable());
        return newMessage;
    }

    public Message copy(long newID) {
        try {
            AMQPLargeMessage copy = new AMQPLargeMessage(newID, this.messageFormat, null, this.coreMessageObjectPools, this.storageManager);
            copy.setDurable(this.isDurable());
            this.largeBody.copyInto((LargeServerMessage)copy);
            copy.finishParse();
            copy.releaseResources(true);
            return copy;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.lareMessageErrorCopying(e, (LargeServerMessage)this);
            return null;
        }
    }

    @Override
    public void messageChanged() {
    }

    @Override
    public int getEncodeSize() {
        return 0;
    }

    public long getWholeMessageSize() {
        try {
            return this.largeBody.getBodySize();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            return -1L;
        }
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 704 + (this.extraProperties != null ? this.extraProperties.getEncodeSize() : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
    }

    @Override
    public int getPersistSize() {
        return 0;
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return 0L;
    }

    @Override
    public Persister<Message> getPersister() {
        return AMQPLargeMessagePersister.getInstance();
    }

    @Override
    public void reencode() {
    }

    @Override
    protected void ensureDataIsValid() {
    }

    @Override
    protected void encodeMessage() {
    }

    public void referenceOriginalMessage(Message original, String originalQueue) {
        super.referenceOriginalMessage(original, originalQueue);
        if (original instanceof LargeServerMessageImpl) {
            this.largeBody.referenceOriginalMessage(((AMQPLargeMessage)original).largeBody);
        }
    }
}

