/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.timer.TimerTask;

public class TimerTimeoutWatcher
implements TimeoutWatcher {
    private final Timer timer;

    public TimerTimeoutWatcher(Timer timer) {
        this.timer = timer;
    }

    @Override
    public TimeoutWatch schedule(TimeoutExecution execution) {
        final TimerTask task = this.timer.schedule(execution.timeoutInMillis(), execution::timeoutAndInterrupt);
        return new TimeoutWatch(){

            @Override
            public boolean isRunning() {
                return !task.isDone();
            }

            @Override
            public void cancel() {
                task.cancel();
            }
        };
    }
}

