// ============================================================================
//
// Copyright (c) 2006-2015, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.statisticssync_4_4;

import routines.Numeric;
import routines.DataOperation;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.TalendString;
import routines.StringHandling;
import routines.Relational;
import routines.TalendDate;
import routines.Mathematical;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: StatisticsSync Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 6.1.1.20151214_1327
 * @status 
 */
public class StatisticsSync implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runInterleave != null) {

				this.setProperty("runInterleave", runInterleave.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public Integer runInterleave;

		public Integer getRunInterleave() {
			return this.runInterleave;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "4.4";
	private final String jobName = "StatisticsSync";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private Exception exception;

	public Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					StatisticsSync.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(StatisticsSync.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (TalendException e) {
					// do nothing

				} catch (Exception e) {
					this.e.printStackTrace();
				}
			}
		}
	}

	public void tJDBCInput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_8_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_13_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_10_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_8_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_14_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_12_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_15_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_18_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_7_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_7_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_20_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_21_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row43_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row42_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row45_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row47_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row48_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row50_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row3_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_6_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_8_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_13_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_10_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_9_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_14_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_12_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_15_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_18_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_20_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_21_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public static class storage_historyStruct implements
			routines.system.IPersistableRow<storage_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Short storage_domain_status;

		public Short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public int seconds_in_status;

		public int getSeconds_in_status() {
			return this.seconds_in_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		public Integer storage_configuration_version;

		public Integer getStorage_configuration_version() {
			return this.storage_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.storage_domain_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_status = null;
					} else {
						this.storage_domain_status = dis.readShort();
					}

					this.seconds_in_status = dis.readInt();

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

					this.storage_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Short

				if (this.storage_domain_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_status);
				}

				// int

				dos.writeInt(this.seconds_in_status);

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

				// Integer

				writeInteger(this.storage_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",seconds_in_status=" + String.valueOf(seconds_in_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append(",storage_configuration_version="
					+ String.valueOf(storage_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(storage_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row44Struct implements
			routines.system.IPersistableRow<row44Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Short storage_domain_status;

		public Short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_status = null;
					} else {
						this.storage_domain_status = dis.readShort();
					}

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Short

				if (this.storage_domain_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_status);
				}

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row44Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_4Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Short storage_domain_status;

		public Short getStorage_domain_status() {
			return this.storage_domain_status;
		}

		public Integer available_disk_size_gb;

		public Integer getAvailable_disk_size_gb() {
			return this.available_disk_size_gb;
		}

		public Integer used_disk_size_gb;

		public Integer getUsed_disk_size_gb() {
			return this.used_disk_size_gb;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_status = null;
					} else {
						this.storage_domain_status = dis.readShort();
					}

					this.available_disk_size_gb = readInteger(dis);

					this.used_disk_size_gb = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Short

				if (this.storage_domain_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_status);
				}

				// Integer

				writeInteger(this.available_disk_size_gb, dos);

				// Integer

				writeInteger(this.used_disk_size_gb, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_status="
					+ String.valueOf(storage_domain_status));
			sb.append(",available_disk_size_gb="
					+ String.valueOf(available_disk_size_gb));
			sb.append(",used_disk_size_gb=" + String.valueOf(used_disk_size_gb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_3Process(globalMap);

				row44Struct row44 = new row44Struct();
				storage_historyStruct storage_history = new storage_historyStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "storage_domain_samples_history"
						+ " (history_datetime,storage_domain_id,storage_domain_status,seconds_in_status,available_disk_size_gb,used_disk_size_gb,storage_configuration_version) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());

				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row43Struct> tHash_Lookup_row43 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row43Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row43Struct>) globalMap
						.get("tHash_Lookup_row43"));

				row43Struct row43HashKey = new row43Struct();
				row43Struct row43Default = new row43Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				storage_historyStruct storage_history_tmp = new storage_historyStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT \n  storage_domain_id, \n  upper(cast(storage_domain_id as char(36))) as storage_domain_join_id,\n  storage_domain_status,\n  available_disk_size_gb, \n  used_disk_size_gb\nFROM dwh_storage_domain_history_view";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);

				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						if (colQtyInRs_tJDBCInput_4 < 1) {
							row44.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_4.getObject(1) != null) {
								row44.storage_domain_id = rs_tJDBCInput_4
										.getObject(1);
							} else {
								row44.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 2) {
							row44.storage_domain_join_id = null;
						} else {

							row44.storage_domain_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 2, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 3) {
							row44.storage_domain_status = null;
						} else {

							if (rs_tJDBCInput_4.getObject(3) != null) {
								row44.storage_domain_status = rs_tJDBCInput_4
										.getShort(3);
							} else {
								row44.storage_domain_status = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 4) {
							row44.available_disk_size_gb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(4) != null) {
								row44.available_disk_size_gb = rs_tJDBCInput_4
										.getInt(4);
							} else {
								row44.available_disk_size_gb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 5) {
							row44.used_disk_size_gb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(5) != null) {
								row44.used_disk_size_gb = rs_tJDBCInput_4
										.getInt(5);
							} else {
								row44.used_disk_size_gb = null;
							}
						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */

						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tMap_2 main ] start
						 */

						currentComponent = "tMap_2";

						boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_2 = false;
						boolean mainRowRejected_tMap_2 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row43"
						// /////////////////////////////////////////////

						boolean forceLooprow43 = false;

						row43Struct row43ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_2) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_2 = false;

							row43HashKey.storage_domain_join_id = row44.storage_domain_join_id;

							row43HashKey.hashCodeDirty = true;

							tHash_Lookup_row43.lookup(row43HashKey);

							if (!tHash_Lookup_row43.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_2 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row43 != null
								&& tHash_Lookup_row43.getCount(row43HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row43' and it contains more one result from keys :  row43.storage_domain_join_id = '"
							// + row43HashKey.storage_domain_join_id + "'");
						} // G 071

						row43Struct row43 = null;

						row43Struct fromLookup_row43 = null;
						row43 = row43Default;

						if (tHash_Lookup_row43 != null
								&& tHash_Lookup_row43.hasNext()) { // G 099

							fromLookup_row43 = tHash_Lookup_row43.next();

						} // G 099

						if (fromLookup_row43 != null) {
							row43 = fromLookup_row43;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
							// ###############################
							// # Output tables

							storage_history = null;

							if (!rejectedInnerJoin_tMap_2) {

								// # Output table : 'storage_history'
								storage_history_tmp.history_datetime = context.runTime;
								storage_history_tmp.storage_domain_id = row44.storage_domain_id;
								storage_history_tmp.storage_domain_status = row44.storage_domain_status;
								storage_history_tmp.seconds_in_status = context.runInterleave;
								storage_history_tmp.available_disk_size_gb = row44.available_disk_size_gb;
								storage_history_tmp.used_disk_size_gb = row44.used_disk_size_gb;
								storage_history_tmp.storage_configuration_version = row43.history_id;
								storage_history = storage_history_tmp;
							} // closing inner join bracket (2)
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_2 = false;

						tos_count_tMap_2++;

						/**
						 * [tMap_2 main ] stop
						 */
						// Start of branch "storage_history"
						if (storage_history != null) {

							/**
							 * [tJDBCOutput_2 main ] start
							 */

							currentComponent = "tJDBCOutput_2";

							whetherReject_tJDBCOutput_2 = false;
							if (storage_history.history_datetime != null) {
								pstmt_tJDBCOutput_2
										.setTimestamp(
												1,
												new java.sql.Timestamp(
														storage_history.history_datetime
																.getTime()));
							} else {
								pstmt_tJDBCOutput_2.setNull(1,
										java.sql.Types.DATE);
							}

							if (storage_history.storage_domain_id == null) {
								pstmt_tJDBCOutput_2.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_2.setObject(2,
										storage_history.storage_domain_id);
							}

							if (storage_history.storage_domain_status == null) {
								pstmt_tJDBCOutput_2.setNull(3,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_2.setShort(3,
										storage_history.storage_domain_status);
							}

							pstmt_tJDBCOutput_2.setInt(4,
									storage_history.seconds_in_status);

							if (storage_history.available_disk_size_gb == null) {
								pstmt_tJDBCOutput_2.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_2.setInt(5,
										storage_history.available_disk_size_gb);
							}

							if (storage_history.used_disk_size_gb == null) {
								pstmt_tJDBCOutput_2.setNull(6,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_2.setInt(6,
										storage_history.used_disk_size_gb);
							}

							if (storage_history.storage_configuration_version == null) {
								pstmt_tJDBCOutput_2.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_2
										.setInt(7,
												storage_history.storage_configuration_version);
							}

							try {
								insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
										+ pstmt_tJDBCOutput_2.executeUpdate();
								nb_line_tJDBCOutput_2++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_2 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_2++;

							/**
							 * [tJDBCOutput_2 main ] stop
							 */

						} // End of branch "storage_history"

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					if (rs_tJDBCInput_4 != null) {
						rs_tJDBCInput_4.close();
					}
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row43 != null) {
					tHash_Lookup_row43.endGet();
				}
				globalMap.remove("tHash_Lookup_row43");

				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_2"
			globalMap.remove("tHash_Lookup_row43");

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tMap_2 finally ] start
				 */

				currentComponent = "tMap_2";

				/**
				 * [tMap_2 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class row43Struct implements
			routines.system.IPersistableComparableLookupRow<row43Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_domain_join_id == null) ? 0
								: this.storage_domain_join_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row43Struct other = (row43Struct) obj;

			if (this.storage_domain_join_id == null) {
				if (other.storage_domain_join_id != null)
					return false;

			} else if (!this.storage_domain_join_id
					.equals(other.storage_domain_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row43Struct other) {

			other.history_id = this.history_id;
			other.storage_domain_join_id = this.storage_domain_join_id;

		}

		public void copyKeysDataTo(row43Struct other) {

			other.storage_domain_join_id = this.storage_domain_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.storage_domain_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.storage_domain_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row43Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_domain_join_id,
					other.storage_domain_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row43Struct row43 = new row43Struct();

				/**
				 * [tAdvancedHash_row43 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row43", false);
				start_Hash.put("tAdvancedHash_row43",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row43";

				int tos_count_tAdvancedHash_row43 = 0;

				// connection name:row43
				// source node:tJDBCInput_3 - inputs:(after_tJDBCInput_4)
				// outputs:(row43,row43) | target node:tAdvancedHash_row43 -
				// inputs:(row43) outputs:()
				// linked node: tMap_2 - inputs:(row44,row43)
				// outputs:(storage_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row43 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row43Struct> tHash_Lookup_row43 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row43Struct> getLookup(matchingModeEnum_row43);

				globalMap.put("tHash_Lookup_row43", tHash_Lookup_row43);

				/**
				 * [tAdvancedHash_row43 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT history_id, upper(cast(storage_domain_id as char(36))) as storage_domain_join_id\nFROM  v4_4_latest_configuration_storage_domains";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);

				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						if (colQtyInRs_tJDBCInput_3 < 1) {
							row43.history_id = null;
						} else {

							if (rs_tJDBCInput_3.getObject(1) != null) {
								row43.history_id = rs_tJDBCInput_3.getInt(1);
							} else {
								row43.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 2) {
							row43.storage_domain_join_id = null;
						} else {

							row43.storage_domain_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_3, 2, false);
						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */

						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tAdvancedHash_row43 main ] start
						 */

						currentComponent = "tAdvancedHash_row43";

						row43Struct row43_HashRow = new row43Struct();

						row43_HashRow.history_id = row43.history_id;

						row43_HashRow.storage_domain_join_id = row43.storage_domain_join_id;

						tHash_Lookup_row43.put(row43_HashRow);

						tos_count_tAdvancedHash_row43++;

						/**
						 * [tAdvancedHash_row43 main ] stop
						 */

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					if (rs_tJDBCInput_3 != null) {
						rs_tJDBCInput_3.close();
					}
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tAdvancedHash_row43 end ] start
				 */

				currentComponent = "tAdvancedHash_row43";

				tHash_Lookup_row43.endPut();

				ok_Hash.put("tAdvancedHash_row43", true);
				end_Hash.put("tAdvancedHash_row43", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row43 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row43 finally ] start
				 */

				currentComponent = "tAdvancedHash_row43";

				/**
				 * [tAdvancedHash_row43 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class host_historyStruct implements
			routines.system.IPersistableRow<host_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public short host_status;

		public short getHost_status() {
			return this.host_status;
		}

		public int seconds_in_status;

		public int getSeconds_in_status() {
			return this.seconds_in_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Short active_vms;

		public Short getActive_vms() {
			return this.active_vms;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_id = (Object) dis.readObject();

					this.host_status = dis.readShort();

					this.seconds_in_status = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.active_vms = null;
					} else {
						this.active_vms = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

					this.cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_id);

				// short

				dos.writeShort(this.host_status);

				// int

				dos.writeInt(this.seconds_in_status);

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Short

				if (this.active_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.active_vms);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

				// Integer

				writeInteger(this.cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",seconds_in_status=" + String.valueOf(seconds_in_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",active_vms=" + String.valueOf(active_vms));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row10Struct implements
			routines.system.IPersistableRow<row10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_status;

		public Short getHost_status() {
			return this.host_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Short vm_active;

		public Short getVm_active() {
			return this.vm_active;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_status = null;
					} else {
						this.host_status = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					this.cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_active = null;
					} else {
						this.vm_active = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_status);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Integer

				writeInteger(this.cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Short

				if (this.vm_active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_active);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",vm_active=" + String.valueOf(vm_active));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row10Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_5Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_status;

		public Short getHost_status() {
			return this.host_status;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Long ksm_shared_memory_mb;

		public Long getKsm_shared_memory_mb() {
			return this.ksm_shared_memory_mb;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short ksm_cpu_percent;

		public Short getKsm_cpu_percent() {
			return this.ksm_cpu_percent;
		}

		public Integer cpu_load;

		public Integer getCpu_load() {
			return this.cpu_load;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Integer swap_used_mb;

		public Integer getSwap_used_mb() {
			return this.swap_used_mb;
		}

		public Short vm_active;

		public Short getVm_active() {
			return this.vm_active;
		}

		public Short total_vms;

		public Short getTotal_vms() {
			return this.total_vms;
		}

		public Integer total_vms_vcpus;

		public Integer getTotal_vms_vcpus() {
			return this.total_vms_vcpus;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_status = null;
					} else {
						this.host_status = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_shared_memory_mb = null;
					} else {
						this.ksm_shared_memory_mb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.ksm_cpu_percent = null;
					} else {
						this.ksm_cpu_percent = dis.readShort();
					}

					this.cpu_load = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.swap_used_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_active = null;
					} else {
						this.vm_active = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.total_vms = null;
					} else {
						this.total_vms = dis.readShort();
					}

					this.total_vms_vcpus = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_status);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Long

				if (this.ksm_shared_memory_mb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.ksm_shared_memory_mb);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.ksm_cpu_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.ksm_cpu_percent);
				}

				// Integer

				writeInteger(this.cpu_load, dos);

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Integer

				writeInteger(this.swap_used_mb, dos);

				// Short

				if (this.vm_active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_active);
				}

				// Short

				if (this.total_vms == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.total_vms);
				}

				// Integer

				writeInteger(this.total_vms_vcpus, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_status=" + String.valueOf(host_status));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",ksm_shared_memory_mb="
					+ String.valueOf(ksm_shared_memory_mb));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",ksm_cpu_percent=" + String.valueOf(ksm_cpu_percent));
			sb.append(",cpu_load=" + String.valueOf(cpu_load));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",swap_used_mb=" + String.valueOf(swap_used_mb));
			sb.append(",vm_active=" + String.valueOf(vm_active));
			sb.append(",total_vms=" + String.valueOf(total_vms));
			sb.append(",total_vms_vcpus=" + String.valueOf(total_vms_vcpus));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_6Process(globalMap);

				row10Struct row10 = new row10Struct();
				host_historyStruct host_history = new host_historyStruct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_3 = "INSERT INTO "
						+ "host_samples_history"
						+ " (history_datetime,host_id,host_status,seconds_in_status,memory_usage_percent,ksm_shared_memory_mb,cpu_usage_percent,ksm_cpu_percent,active_vms,total_vms,total_vms_vcpus,cpu_load,system_cpu_usage_percent,user_cpu_usage_percent,swap_used_mb,host_configuration_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(insert_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row42Struct> tHash_Lookup_row42 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row42Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row42Struct>) globalMap
						.get("tHash_Lookup_row42"));

				row42Struct row42HashKey = new row42Struct();
				row42Struct row42Default = new row42Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_historyStruct host_history_tmp = new host_historyStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT \n  host_id,\n  upper(cast(host_id as char(36))) as host_join_id,\n  host_status, \n  memory_usage_percent, \n  ksm_shared_memory_mb,\n  cpu_usage_percent, \n  ksm_cpu_percent, \n  cpu_load, \n  system_cpu_usage_percent, \n  user_cpu_usage_percent, \n  swap_used_mb, \n  vm_active, \n  total_vms, \n  total_vms_vcpus\nFROM dwh_host_history_view";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);

				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						if (colQtyInRs_tJDBCInput_5 < 1) {
							row10.host_id = null;
						} else {

							if (rs_tJDBCInput_5.getObject(1) != null) {
								row10.host_id = rs_tJDBCInput_5.getObject(1);
							} else {
								row10.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 2) {
							row10.host_join_id = null;
						} else {

							row10.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 2, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 3) {
							row10.host_status = null;
						} else {

							if (rs_tJDBCInput_5.getObject(3) != null) {
								row10.host_status = rs_tJDBCInput_5.getShort(3);
							} else {
								row10.host_status = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 4) {
							row10.memory_usage_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(4) != null) {
								row10.memory_usage_percent = rs_tJDBCInput_5
										.getShort(4);
							} else {
								row10.memory_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 5) {
							row10.ksm_shared_memory_mb = null;
						} else {

							if (rs_tJDBCInput_5.getObject(5) != null) {
								row10.ksm_shared_memory_mb = rs_tJDBCInput_5
										.getLong(5);
							} else {
								row10.ksm_shared_memory_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 6) {
							row10.cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(6) != null) {
								row10.cpu_usage_percent = rs_tJDBCInput_5
										.getShort(6);
							} else {
								row10.cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 7) {
							row10.ksm_cpu_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(7) != null) {
								row10.ksm_cpu_percent = rs_tJDBCInput_5
										.getShort(7);
							} else {
								row10.ksm_cpu_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 8) {
							row10.cpu_load = null;
						} else {

							if (rs_tJDBCInput_5.getObject(8) != null) {
								row10.cpu_load = rs_tJDBCInput_5.getInt(8);
							} else {
								row10.cpu_load = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 9) {
							row10.system_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(9) != null) {
								row10.system_cpu_usage_percent = rs_tJDBCInput_5
										.getShort(9);
							} else {
								row10.system_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 10) {
							row10.user_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_5.getObject(10) != null) {
								row10.user_cpu_usage_percent = rs_tJDBCInput_5
										.getShort(10);
							} else {
								row10.user_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 11) {
							row10.swap_used_mb = null;
						} else {

							if (rs_tJDBCInput_5.getObject(11) != null) {
								row10.swap_used_mb = rs_tJDBCInput_5.getInt(11);
							} else {
								row10.swap_used_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 12) {
							row10.vm_active = null;
						} else {

							if (rs_tJDBCInput_5.getObject(12) != null) {
								row10.vm_active = rs_tJDBCInput_5.getShort(12);
							} else {
								row10.vm_active = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 13) {
							row10.total_vms = null;
						} else {

							if (rs_tJDBCInput_5.getObject(13) != null) {
								row10.total_vms = rs_tJDBCInput_5.getShort(13);
							} else {
								row10.total_vms = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 14) {
							row10.total_vms_vcpus = null;
						} else {

							if (rs_tJDBCInput_5.getObject(14) != null) {
								row10.total_vms_vcpus = rs_tJDBCInput_5
										.getInt(14);
							} else {
								row10.total_vms_vcpus = null;
							}
						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */

						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tMap_3 main ] start
						 */

						currentComponent = "tMap_3";

						boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_3 = false;
						boolean mainRowRejected_tMap_3 = false;

						if (

						(

						row10.host_status != 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row10'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row42"
							// /////////////////////////////////////////////

							boolean forceLooprow42 = false;

							row42Struct row42ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_3) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_3 = false;

								row42HashKey.host_join_id = row10.host_join_id;

								row42HashKey.hashCodeDirty = true;

								tHash_Lookup_row42.lookup(row42HashKey);

								if (!tHash_Lookup_row42.hasNext()) { // G_TM_M_090

									rejectedInnerJoin_tMap_3 = true;

								} // G_TM_M_090

							} // G_TM_M_020

							if (tHash_Lookup_row42 != null
									&& tHash_Lookup_row42
											.getCount(row42HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row42' and it contains more one result from keys :  row42.host_join_id = '"
								// + row42HashKey.host_join_id + "'");
							} // G 071

							row42Struct row42 = null;

							row42Struct fromLookup_row42 = null;
							row42 = row42Default;

							if (tHash_Lookup_row42 != null
									&& tHash_Lookup_row42.hasNext()) { // G 099

								fromLookup_row42 = tHash_Lookup_row42.next();

							} // G 099

							if (fromLookup_row42 != null) {
								row42 = fromLookup_row42;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
								// ###############################
								// # Output tables

								host_history = null;

								if (!rejectedInnerJoin_tMap_3) {

									// # Output table : 'host_history'
									host_history_tmp.history_datetime = context.runTime;
									host_history_tmp.host_id = row10.host_id;
									host_history_tmp.host_status = (row10.host_status == 3
											|| row10.host_status == 8
											|| row10.host_status == 12 || row10.host_status == 9) ? (short) 1
											: (row10.host_status == 2
													|| row10.host_status == 6 || row10.host_status == 11) ? (short) 2
													: (row10.host_status == 5
															|| row10.host_status == 10
															|| row10.host_status == 4
															|| row10.host_status == 7
															|| row10.host_status == 1 || row10.host_status == 13) ? (short) 3
															: (short) -1;
									host_history_tmp.seconds_in_status = context.runInterleave;
									host_history_tmp.memory_usage_percent = row10.memory_usage_percent;
									host_history_tmp.ksm_shared_memory_mb = row10.ksm_shared_memory_mb;
									host_history_tmp.cpu_usage_percent = row10.cpu_usage_percent;
									host_history_tmp.ksm_cpu_percent = row10.ksm_cpu_percent;
									host_history_tmp.active_vms = row10.vm_active;
									host_history_tmp.total_vms = row10.total_vms;
									host_history_tmp.total_vms_vcpus = row10.total_vms_vcpus;
									host_history_tmp.cpu_load = row10.cpu_load;
									host_history_tmp.system_cpu_usage_percent = row10.system_cpu_usage_percent;
									host_history_tmp.user_cpu_usage_percent = row10.user_cpu_usage_percent;
									host_history_tmp.swap_used_mb = row10.swap_used_mb;
									host_history_tmp.host_configuration_version = row42.history_id;
									host_history = host_history_tmp;
								} // closing inner join bracket (2)
									// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_3 = false;

							tos_count_tMap_3++;

							/**
							 * [tMap_3 main ] stop
							 */
							// Start of branch "host_history"
							if (host_history != null) {

								/**
								 * [tJDBCOutput_3 main ] start
								 */

								currentComponent = "tJDBCOutput_3";

								whetherReject_tJDBCOutput_3 = false;
								if (host_history.history_datetime != null) {
									pstmt_tJDBCOutput_3
											.setTimestamp(
													1,
													new java.sql.Timestamp(
															host_history.history_datetime
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_3.setNull(1,
											java.sql.Types.DATE);
								}

								if (host_history.host_id == null) {
									pstmt_tJDBCOutput_3.setNull(2,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_3.setObject(2,
											host_history.host_id);
								}

								pstmt_tJDBCOutput_3.setShort(3,
										host_history.host_status);

								pstmt_tJDBCOutput_3.setInt(4,
										host_history.seconds_in_status);

								if (host_history.memory_usage_percent == null) {
									pstmt_tJDBCOutput_3.setNull(5,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setShort(5,
											host_history.memory_usage_percent);
								}

								if (host_history.ksm_shared_memory_mb == null) {
									pstmt_tJDBCOutput_3.setNull(6,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setLong(6,
											host_history.ksm_shared_memory_mb);
								}

								if (host_history.cpu_usage_percent == null) {
									pstmt_tJDBCOutput_3.setNull(7,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setShort(7,
											host_history.cpu_usage_percent);
								}

								if (host_history.ksm_cpu_percent == null) {
									pstmt_tJDBCOutput_3.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setShort(8,
											host_history.ksm_cpu_percent);
								}

								if (host_history.active_vms == null) {
									pstmt_tJDBCOutput_3.setNull(9,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setShort(9,
											host_history.active_vms);
								}

								if (host_history.total_vms == null) {
									pstmt_tJDBCOutput_3.setNull(10,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setShort(10,
											host_history.total_vms);
								}

								if (host_history.total_vms_vcpus == null) {
									pstmt_tJDBCOutput_3.setNull(11,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setInt(11,
											host_history.total_vms_vcpus);
								}

								if (host_history.cpu_load == null) {
									pstmt_tJDBCOutput_3.setNull(12,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setInt(12,
											host_history.cpu_load);
								}

								if (host_history.system_cpu_usage_percent == null) {
									pstmt_tJDBCOutput_3.setNull(13,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3
											.setShort(
													13,
													host_history.system_cpu_usage_percent);
								}

								if (host_history.user_cpu_usage_percent == null) {
									pstmt_tJDBCOutput_3.setNull(14,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3
											.setShort(
													14,
													host_history.user_cpu_usage_percent);
								}

								if (host_history.swap_used_mb == null) {
									pstmt_tJDBCOutput_3.setNull(15,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3.setInt(15,
											host_history.swap_used_mb);
								}

								if (host_history.host_configuration_version == null) {
									pstmt_tJDBCOutput_3.setNull(16,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_3
											.setInt(16,
													host_history.host_configuration_version);
								}

								try {
									insertedCount_tJDBCOutput_3 = insertedCount_tJDBCOutput_3
											+ pstmt_tJDBCOutput_3
													.executeUpdate();
									nb_line_tJDBCOutput_3++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_3 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_3++;

								/**
								 * [tJDBCOutput_3 main ] stop
								 */

							} // End of branch "host_history"

						} // G_TM_M_280 close main tMap filter for table 'row10'

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					if (rs_tJDBCInput_5 != null) {
						rs_tJDBCInput_5.close();
					}
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row42 != null) {
					tHash_Lookup_row42.endGet();
				}
				globalMap.remove("tHash_Lookup_row42");

				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_3"
			globalMap.remove("tHash_Lookup_row42");

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row42Struct implements
			routines.system.IPersistableComparableLookupRow<row42Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.host_join_id == null) ? 0 : this.host_join_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row42Struct other = (row42Struct) obj;

			if (this.host_join_id == null) {
				if (other.host_join_id != null)
					return false;

			} else if (!this.host_join_id.equals(other.host_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row42Struct other) {

			other.history_id = this.history_id;
			other.host_join_id = this.host_join_id;

		}

		public void copyKeysDataTo(row42Struct other) {

			other.host_join_id = this.host_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.host_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row42Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.host_join_id,
					other.host_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row42Struct row42 = new row42Struct();

				/**
				 * [tAdvancedHash_row42 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row42", false);
				start_Hash.put("tAdvancedHash_row42",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row42";

				int tos_count_tAdvancedHash_row42 = 0;

				// connection name:row42
				// source node:tJDBCInput_6 - inputs:(after_tJDBCInput_5)
				// outputs:(row42,row42) | target node:tAdvancedHash_row42 -
				// inputs:(row42) outputs:()
				// linked node: tMap_3 - inputs:(row10,row42)
				// outputs:(host_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row42 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row42Struct> tHash_Lookup_row42 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row42Struct> getLookup(matchingModeEnum_row42);

				globalMap.put("tHash_Lookup_row42", tHash_Lookup_row42);

				/**
				 * [tAdvancedHash_row42 begin ] stop
				 */

				/**
				 * [tJDBCInput_6 begin ] start
				 */

				ok_Hash.put("tJDBCInput_6", false);
				start_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				currentComponent = "tJDBCInput_6";

				int tos_count_tJDBCInput_6 = 0;

				int nb_line_tJDBCInput_6 = 0;
				java.sql.Connection conn_tJDBCInput_6 = null;
				conn_tJDBCInput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_6 = conn_tJDBCInput_6
						.createStatement();

				String dbquery_tJDBCInput_6 = "SELECT history_id, upper(cast(host_id as char(36))) as host_join_id\nFROM v4_4_latest_configuration_hosts";

				globalMap.put("tJDBCInput_6_QUERY", dbquery_tJDBCInput_6);

				java.sql.ResultSet rs_tJDBCInput_6 = null;
				try {
					rs_tJDBCInput_6 = stmt_tJDBCInput_6
							.executeQuery(dbquery_tJDBCInput_6);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_6 = rs_tJDBCInput_6
							.getMetaData();
					int colQtyInRs_tJDBCInput_6 = rsmd_tJDBCInput_6
							.getColumnCount();

					String tmpContent_tJDBCInput_6 = null;

					while (rs_tJDBCInput_6.next()) {
						nb_line_tJDBCInput_6++;

						if (colQtyInRs_tJDBCInput_6 < 1) {
							row42.history_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(1) != null) {
								row42.history_id = rs_tJDBCInput_6.getInt(1);
							} else {
								row42.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 2) {
							row42.host_join_id = null;
						} else {

							row42.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 2, false);
						}

						/**
						 * [tJDBCInput_6 begin ] stop
						 */

						/**
						 * [tJDBCInput_6 main ] start
						 */

						currentComponent = "tJDBCInput_6";

						tos_count_tJDBCInput_6++;

						/**
						 * [tJDBCInput_6 main ] stop
						 */

						/**
						 * [tAdvancedHash_row42 main ] start
						 */

						currentComponent = "tAdvancedHash_row42";

						row42Struct row42_HashRow = new row42Struct();

						row42_HashRow.history_id = row42.history_id;

						row42_HashRow.host_join_id = row42.host_join_id;

						tHash_Lookup_row42.put(row42_HashRow);

						tos_count_tAdvancedHash_row42++;

						/**
						 * [tAdvancedHash_row42 main ] stop
						 */

						/**
						 * [tJDBCInput_6 end ] start
						 */

						currentComponent = "tJDBCInput_6";

					}
				} finally {
					if (rs_tJDBCInput_6 != null) {
						rs_tJDBCInput_6.close();
					}
					stmt_tJDBCInput_6.close();

				}
				globalMap.put("tJDBCInput_6_NB_LINE", nb_line_tJDBCInput_6);

				ok_Hash.put("tJDBCInput_6", true);
				end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				/**
				 * [tJDBCInput_6 end ] stop
				 */

				/**
				 * [tAdvancedHash_row42 end ] start
				 */

				currentComponent = "tAdvancedHash_row42";

				tHash_Lookup_row42.endPut();

				ok_Hash.put("tAdvancedHash_row42", true);
				end_Hash.put("tAdvancedHash_row42", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row42 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_6 finally ] start
				 */

				currentComponent = "tJDBCInput_6";

				/**
				 * [tJDBCInput_6 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row42 finally ] start
				 */

				currentComponent = "tAdvancedHash_row42";

				/**
				 * [tAdvancedHash_row42 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 1);
	}

	public static class hinterface_historyStruct implements
			routines.system.IPersistableRow<hinterface_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer host_interface_configuration_version;

		public Integer getHost_interface_configuration_version() {
			return this.host_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.host_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					this.host_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.host_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",host_interface_configuration_version="
					+ String.valueOf(host_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(hinterface_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row11Struct implements
			routines.system.IPersistableRow<row11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row11Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_8Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_13Process(globalMap);

				row11Struct row11 = new row11Struct();
				hinterface_historyStruct hinterface_history = new hinterface_historyStruct();

				/**
				 * [tJDBCOutput_4 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_4", false);
				start_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_4";

				int tos_count_tJDBCOutput_4 = 0;

				int nb_line_tJDBCOutput_4 = 0;
				int nb_line_update_tJDBCOutput_4 = 0;
				int nb_line_inserted_tJDBCOutput_4 = 0;
				int nb_line_deleted_tJDBCOutput_4 = 0;
				int nb_line_rejected_tJDBCOutput_4 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_4 = 0;

				int deletedCount_tJDBCOutput_4 = 0;
				int updatedCount_tJDBCOutput_4 = 0;
				int insertedCount_tJDBCOutput_4 = 0;
				int rejectedCount_tJDBCOutput_4 = 0;

				boolean whetherReject_tJDBCOutput_4 = false;

				java.sql.Connection connection_tJDBCOutput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_4 = "INSERT INTO "
						+ "host_interface_samples_history"
						+ " (history_datetime,host_interface_id,receive_rate_percent,transmit_rate_percent,host_interface_configuration_version,received_total_byte,transmitted_total_byte,received_dropped_total_packets,transmitted_dropped_total_packets) VALUES (?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_4 = connection_tJDBCOutput_4
						.prepareStatement(insert_tJDBCOutput_4);

				/**
				 * [tJDBCOutput_4 begin ] stop
				 */

				/**
				 * [tMap_4 begin ] start
				 */

				ok_Hash.put("tMap_4", false);
				start_Hash.put("tMap_4", System.currentTimeMillis());

				currentComponent = "tMap_4";

				int tos_count_tMap_4 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row45Struct> tHash_Lookup_row45 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row45Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row45Struct>) globalMap
						.get("tHash_Lookup_row45"));

				row45Struct row45HashKey = new row45Struct();
				row45Struct row45Default = new row45Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_4__Struct {
				}
				Var__tMap_4__Struct Var__tMap_4 = new Var__tMap_4__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				hinterface_historyStruct hinterface_history_tmp = new hinterface_historyStruct();
				// ###############################

				/**
				 * [tMap_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_8 begin ] start
				 */

				ok_Hash.put("tJDBCInput_8", false);
				start_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				currentComponent = "tJDBCInput_8";

				int tos_count_tJDBCInput_8 = 0;

				int nb_line_tJDBCInput_8 = 0;
				java.sql.Connection conn_tJDBCInput_8 = null;
				conn_tJDBCInput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_8 = conn_tJDBCInput_8
						.createStatement();

				String dbquery_tJDBCInput_8 = "SELECT \n  host_interface_id, \n  upper(cast(host_interface_id as char(36))) as host_interface_join_id,\n  receive_rate_percent, \n  transmit_rate_percent,\n  received_total_byte,\n  transmitted_total_byte,\n  received_dropped_total_packets,\n  transmitted_dropped_total_packets\nFROM dwh_host_interface_history_view";

				globalMap.put("tJDBCInput_8_QUERY", dbquery_tJDBCInput_8);

				java.sql.ResultSet rs_tJDBCInput_8 = null;
				try {
					rs_tJDBCInput_8 = stmt_tJDBCInput_8
							.executeQuery(dbquery_tJDBCInput_8);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_8 = rs_tJDBCInput_8
							.getMetaData();
					int colQtyInRs_tJDBCInput_8 = rsmd_tJDBCInput_8
							.getColumnCount();

					String tmpContent_tJDBCInput_8 = null;

					while (rs_tJDBCInput_8.next()) {
						nb_line_tJDBCInput_8++;

						if (colQtyInRs_tJDBCInput_8 < 1) {
							row11.host_interface_id = null;
						} else {

							if (rs_tJDBCInput_8.getObject(1) != null) {
								row11.host_interface_id = rs_tJDBCInput_8
										.getObject(1);
							} else {
								row11.host_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 2) {
							row11.host_interface_join_id = null;
						} else {

							row11.host_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_8, 2, false);
						}
						if (colQtyInRs_tJDBCInput_8 < 3) {
							row11.receive_rate_percent = null;
						} else {

							if (rs_tJDBCInput_8.getObject(3) != null) {
								row11.receive_rate_percent = rs_tJDBCInput_8
										.getDouble(3);
							} else {
								row11.receive_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 4) {
							row11.transmit_rate_percent = null;
						} else {

							if (rs_tJDBCInput_8.getObject(4) != null) {
								row11.transmit_rate_percent = rs_tJDBCInput_8
										.getDouble(4);
							} else {
								row11.transmit_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 5) {
							row11.received_total_byte = null;
						} else {

							if (rs_tJDBCInput_8.getObject(5) != null) {
								row11.received_total_byte = rs_tJDBCInput_8
										.getLong(5);
							} else {
								row11.received_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 6) {
							row11.transmitted_total_byte = null;
						} else {

							if (rs_tJDBCInput_8.getObject(6) != null) {
								row11.transmitted_total_byte = rs_tJDBCInput_8
										.getLong(6);
							} else {
								row11.transmitted_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 7) {
							row11.received_dropped_total_packets = null;
						} else {

							if (rs_tJDBCInput_8.getObject(7) != null) {
								row11.received_dropped_total_packets = rs_tJDBCInput_8
										.getDouble(7);
							} else {
								row11.received_dropped_total_packets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 8) {
							row11.transmitted_dropped_total_packets = null;
						} else {

							if (rs_tJDBCInput_8.getObject(8) != null) {
								row11.transmitted_dropped_total_packets = rs_tJDBCInput_8
										.getDouble(8);
							} else {
								row11.transmitted_dropped_total_packets = null;
							}
						}

						/**
						 * [tJDBCInput_8 begin ] stop
						 */

						/**
						 * [tJDBCInput_8 main ] start
						 */

						currentComponent = "tJDBCInput_8";

						tos_count_tJDBCInput_8++;

						/**
						 * [tJDBCInput_8 main ] stop
						 */

						/**
						 * [tMap_4 main ] start
						 */

						currentComponent = "tMap_4";

						boolean hasCasePrimitiveKeyWithNull_tMap_4 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_4 = false;
						boolean mainRowRejected_tMap_4 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row45"
						// /////////////////////////////////////////////

						boolean forceLooprow45 = false;

						row45Struct row45ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_4) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_4 = false;

							row45HashKey.host_interface_join_id = row11.host_interface_join_id;

							row45HashKey.hashCodeDirty = true;

							tHash_Lookup_row45.lookup(row45HashKey);

							if (!tHash_Lookup_row45.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_4 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row45 != null
								&& tHash_Lookup_row45.getCount(row45HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row45' and it contains more one result from keys :  row45.host_interface_join_id = '"
							// + row45HashKey.host_interface_join_id + "'");
						} // G 071

						row45Struct row45 = null;

						row45Struct fromLookup_row45 = null;
						row45 = row45Default;

						if (tHash_Lookup_row45 != null
								&& tHash_Lookup_row45.hasNext()) { // G 099

							fromLookup_row45 = tHash_Lookup_row45.next();

						} // G 099

						if (fromLookup_row45 != null) {
							row45 = fromLookup_row45;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_4__Struct Var = Var__tMap_4;// ###############################
							// ###############################
							// # Output tables

							hinterface_history = null;

							if (!rejectedInnerJoin_tMap_4) {

								// # Output table : 'hinterface_history'
								hinterface_history_tmp.history_datetime = context.runTime;
								hinterface_history_tmp.host_interface_id = row11.host_interface_id;
								hinterface_history_tmp.receive_rate_percent = row11.receive_rate_percent;
								hinterface_history_tmp.transmit_rate_percent = row11.transmit_rate_percent;
								hinterface_history_tmp.host_interface_configuration_version = row45.history_id;
								hinterface_history_tmp.received_total_byte = row11.received_total_byte;
								hinterface_history_tmp.transmitted_total_byte = row11.transmitted_total_byte;
								hinterface_history_tmp.received_dropped_total_packets = row11.received_dropped_total_packets;
								hinterface_history_tmp.transmitted_dropped_total_packets = row11.transmitted_dropped_total_packets;
								hinterface_history = hinterface_history_tmp;
							} // closing inner join bracket (2)
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_4 = false;

						tos_count_tMap_4++;

						/**
						 * [tMap_4 main ] stop
						 */
						// Start of branch "hinterface_history"
						if (hinterface_history != null) {

							/**
							 * [tJDBCOutput_4 main ] start
							 */

							currentComponent = "tJDBCOutput_4";

							whetherReject_tJDBCOutput_4 = false;
							if (hinterface_history.history_datetime != null) {
								pstmt_tJDBCOutput_4
										.setTimestamp(
												1,
												new java.sql.Timestamp(
														hinterface_history.history_datetime
																.getTime()));
							} else {
								pstmt_tJDBCOutput_4.setNull(1,
										java.sql.Types.DATE);
							}

							if (hinterface_history.host_interface_id == null) {
								pstmt_tJDBCOutput_4.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_4.setObject(2,
										hinterface_history.host_interface_id);
							}

							if (hinterface_history.receive_rate_percent == null) {
								pstmt_tJDBCOutput_4.setNull(3,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_4
										.setDouble(
												3,
												hinterface_history.receive_rate_percent);
							}

							if (hinterface_history.transmit_rate_percent == null) {
								pstmt_tJDBCOutput_4.setNull(4,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_4
										.setDouble(
												4,
												hinterface_history.transmit_rate_percent);
							}

							if (hinterface_history.host_interface_configuration_version == null) {
								pstmt_tJDBCOutput_4.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4
										.setInt(5,
												hinterface_history.host_interface_configuration_version);
							}

							if (hinterface_history.received_total_byte == null) {
								pstmt_tJDBCOutput_4.setNull(6,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4.setLong(6,
										hinterface_history.received_total_byte);
							}

							if (hinterface_history.transmitted_total_byte == null) {
								pstmt_tJDBCOutput_4.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4
										.setLong(
												7,
												hinterface_history.transmitted_total_byte);
							}

							if (hinterface_history.received_dropped_total_packets == null) {
								pstmt_tJDBCOutput_4.setNull(8,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_4
										.setDouble(
												8,
												hinterface_history.received_dropped_total_packets);
							}

							if (hinterface_history.transmitted_dropped_total_packets == null) {
								pstmt_tJDBCOutput_4.setNull(9,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_4
										.setDouble(
												9,
												hinterface_history.transmitted_dropped_total_packets);
							}

							try {
								insertedCount_tJDBCOutput_4 = insertedCount_tJDBCOutput_4
										+ pstmt_tJDBCOutput_4.executeUpdate();
								nb_line_tJDBCOutput_4++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_4 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_4++;

							/**
							 * [tJDBCOutput_4 main ] stop
							 */

						} // End of branch "hinterface_history"

						/**
						 * [tJDBCInput_8 end ] start
						 */

						currentComponent = "tJDBCInput_8";

					}
				} finally {
					if (rs_tJDBCInput_8 != null) {
						rs_tJDBCInput_8.close();
					}
					stmt_tJDBCInput_8.close();

				}
				globalMap.put("tJDBCInput_8_NB_LINE", nb_line_tJDBCInput_8);

				ok_Hash.put("tJDBCInput_8", true);
				end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				/**
				 * [tJDBCInput_8 end ] stop
				 */

				/**
				 * [tMap_4 end ] start
				 */

				currentComponent = "tMap_4";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row45 != null) {
					tHash_Lookup_row45.endGet();
				}
				globalMap.remove("tHash_Lookup_row45");

				// ###############################

				ok_Hash.put("tMap_4", true);
				end_Hash.put("tMap_4", System.currentTimeMillis());

				/**
				 * [tMap_4 end ] stop
				 */

				/**
				 * [tJDBCOutput_4 end ] start
				 */

				currentComponent = "tJDBCOutput_4";

				if (pstmt_tJDBCOutput_4 != null) {

					pstmt_tJDBCOutput_4.close();

				}

				nb_line_deleted_tJDBCOutput_4 = nb_line_deleted_tJDBCOutput_4
						+ deletedCount_tJDBCOutput_4;
				nb_line_update_tJDBCOutput_4 = nb_line_update_tJDBCOutput_4
						+ updatedCount_tJDBCOutput_4;
				nb_line_inserted_tJDBCOutput_4 = nb_line_inserted_tJDBCOutput_4
						+ insertedCount_tJDBCOutput_4;
				nb_line_rejected_tJDBCOutput_4 = nb_line_rejected_tJDBCOutput_4
						+ rejectedCount_tJDBCOutput_4;

				globalMap.put("tJDBCOutput_4_NB_LINE", nb_line_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_4);

				ok_Hash.put("tJDBCOutput_4", true);
				end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_4 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_4"
			globalMap.remove("tHash_Lookup_row45");

			try {

				/**
				 * [tJDBCInput_8 finally ] start
				 */

				currentComponent = "tJDBCInput_8";

				/**
				 * [tJDBCInput_8 finally ] stop
				 */

				/**
				 * [tMap_4 finally ] start
				 */

				currentComponent = "tMap_4";

				/**
				 * [tMap_4 finally ] stop
				 */

				/**
				 * [tJDBCOutput_4 finally ] start
				 */

				currentComponent = "tJDBCOutput_4";

				/**
				 * [tJDBCOutput_4 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 1);
	}

	public static class row45Struct implements
			routines.system.IPersistableComparableLookupRow<row45Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.host_interface_join_id == null) ? 0
								: this.host_interface_join_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row45Struct other = (row45Struct) obj;

			if (this.host_interface_join_id == null) {
				if (other.host_interface_join_id != null)
					return false;

			} else if (!this.host_interface_join_id
					.equals(other.host_interface_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row45Struct other) {

			other.history_id = this.history_id;
			other.host_interface_join_id = this.host_interface_join_id;

		}

		public void copyKeysDataTo(row45Struct other) {

			other.host_interface_join_id = this.host_interface_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_interface_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.host_interface_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row45Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.host_interface_join_id,
					other.host_interface_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_13Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row45Struct row45 = new row45Struct();

				/**
				 * [tAdvancedHash_row45 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row45", false);
				start_Hash.put("tAdvancedHash_row45",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row45";

				int tos_count_tAdvancedHash_row45 = 0;

				// connection name:row45
				// source node:tJDBCInput_13 - inputs:(after_tJDBCInput_8)
				// outputs:(row45,row45) | target node:tAdvancedHash_row45 -
				// inputs:(row45) outputs:()
				// linked node: tMap_4 - inputs:(row11,row45)
				// outputs:(hinterface_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row45 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row45Struct> tHash_Lookup_row45 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row45Struct> getLookup(matchingModeEnum_row45);

				globalMap.put("tHash_Lookup_row45", tHash_Lookup_row45);

				/**
				 * [tAdvancedHash_row45 begin ] stop
				 */

				/**
				 * [tJDBCInput_13 begin ] start
				 */

				ok_Hash.put("tJDBCInput_13", false);
				start_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				currentComponent = "tJDBCInput_13";

				int tos_count_tJDBCInput_13 = 0;

				int nb_line_tJDBCInput_13 = 0;
				java.sql.Connection conn_tJDBCInput_13 = null;
				conn_tJDBCInput_13 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_13 = conn_tJDBCInput_13
						.createStatement();

				String dbquery_tJDBCInput_13 = "SELECT history_id, upper(cast(host_interface_id as char(36))) as host_interface_join_id\nFROM v4_4_latest_configuration_hosts_interfaces";

				globalMap.put("tJDBCInput_13_QUERY", dbquery_tJDBCInput_13);

				java.sql.ResultSet rs_tJDBCInput_13 = null;
				try {
					rs_tJDBCInput_13 = stmt_tJDBCInput_13
							.executeQuery(dbquery_tJDBCInput_13);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_13 = rs_tJDBCInput_13
							.getMetaData();
					int colQtyInRs_tJDBCInput_13 = rsmd_tJDBCInput_13
							.getColumnCount();

					String tmpContent_tJDBCInput_13 = null;

					while (rs_tJDBCInput_13.next()) {
						nb_line_tJDBCInput_13++;

						if (colQtyInRs_tJDBCInput_13 < 1) {
							row45.history_id = null;
						} else {

							if (rs_tJDBCInput_13.getObject(1) != null) {
								row45.history_id = rs_tJDBCInput_13.getInt(1);
							} else {
								row45.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_13 < 2) {
							row45.host_interface_join_id = null;
						} else {

							row45.host_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_13, 2, false);
						}

						/**
						 * [tJDBCInput_13 begin ] stop
						 */

						/**
						 * [tJDBCInput_13 main ] start
						 */

						currentComponent = "tJDBCInput_13";

						tos_count_tJDBCInput_13++;

						/**
						 * [tJDBCInput_13 main ] stop
						 */

						/**
						 * [tAdvancedHash_row45 main ] start
						 */

						currentComponent = "tAdvancedHash_row45";

						row45Struct row45_HashRow = new row45Struct();

						row45_HashRow.history_id = row45.history_id;

						row45_HashRow.host_interface_join_id = row45.host_interface_join_id;

						tHash_Lookup_row45.put(row45_HashRow);

						tos_count_tAdvancedHash_row45++;

						/**
						 * [tAdvancedHash_row45 main ] stop
						 */

						/**
						 * [tJDBCInput_13 end ] start
						 */

						currentComponent = "tJDBCInput_13";

					}
				} finally {
					if (rs_tJDBCInput_13 != null) {
						rs_tJDBCInput_13.close();
					}
					stmt_tJDBCInput_13.close();

				}
				globalMap.put("tJDBCInput_13_NB_LINE", nb_line_tJDBCInput_13);

				ok_Hash.put("tJDBCInput_13", true);
				end_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				/**
				 * [tJDBCInput_13 end ] stop
				 */

				/**
				 * [tAdvancedHash_row45 end ] start
				 */

				currentComponent = "tAdvancedHash_row45";

				tHash_Lookup_row45.endPut();

				ok_Hash.put("tAdvancedHash_row45", true);
				end_Hash.put("tAdvancedHash_row45", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row45 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_13 finally ] start
				 */

				currentComponent = "tJDBCInput_13";

				/**
				 * [tJDBCInput_13 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row45 finally ] start
				 */

				currentComponent = "tAdvancedHash_row45";

				/**
				 * [tAdvancedHash_row45 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 1);
	}

	public static class vm_historyStruct implements
			routines.system.IPersistableRow<vm_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public short vm_status;

		public short getVm_status() {
			return this.vm_status;
		}

		public int seconds_in_status;

		public int getSeconds_in_status() {
			return this.seconds_in_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Boolean user_logged_in_to_guest;

		public Boolean getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer current_host_configuration_version;

		public Integer getCurrent_host_configuration_version() {
			return this.current_host_configuration_version;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_status = dis.readShort();

					this.seconds_in_status = dis.readInt();

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readBoolean();
					}

					this.currently_running_on_host = (Object) dis.readObject();

					this.vm_configuration_version = readInteger(dis);

					this.current_host_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// short

				dos.writeShort(this.vm_status);

				// int

				dos.writeInt(this.seconds_in_status);

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Boolean

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.currently_running_on_host);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.current_host_configuration_version, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",seconds_in_status=" + String.valueOf(seconds_in_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",current_host_configuration_version="
					+ String.valueOf(current_host_configuration_version));
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class disk_usage_historyStruct implements
			routines.system.IPersistableRow<disk_usage_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_id = (Object) dis.readObject();

					this.disks_usage = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.disks_usage, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",disks_usage=" + disks_usage);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(disk_usage_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row12Struct implements
			routines.system.IPersistableRow<row12Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_status;

		public Short getVm_status() {
			return this.vm_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Boolean user_logged_in_to_guest;

		public Boolean getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public String running_on_host_join_id;

		public String getRunning_on_host_join_id() {
			return this.running_on_host_join_id;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_status = null;
					} else {
						this.vm_status = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.disks_usage = readString(dis);

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readBoolean();
					}

					this.currently_running_on_host = (Object) dis.readObject();

					this.running_on_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_status);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// String

				writeString(this.disks_usage, dos);

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Boolean

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.currently_running_on_host);

				// String

				writeString(this.running_on_host_join_id, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",disks_usage=" + disks_usage);
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",running_on_host_join_id=" + running_on_host_join_id);
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row12Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_10Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_status;

		public Short getVm_status() {
			return this.vm_status;
		}

		public Short cpu_usage_percent;

		public Short getCpu_usage_percent() {
			return this.cpu_usage_percent;
		}

		public Short memory_usage_percent;

		public Short getMemory_usage_percent() {
			return this.memory_usage_percent;
		}

		public Short system_cpu_usage_percent;

		public Short getSystem_cpu_usage_percent() {
			return this.system_cpu_usage_percent;
		}

		public Short user_cpu_usage_percent;

		public Short getUser_cpu_usage_percent() {
			return this.user_cpu_usage_percent;
		}

		public String disks_usage;

		public String getDisks_usage() {
			return this.disks_usage;
		}

		public String vm_ip;

		public String getVm_ip() {
			return this.vm_ip;
		}

		public String vm_client_ip;

		public String getVm_client_ip() {
			return this.vm_client_ip;
		}

		public Object current_user_id;

		public Object getCurrent_user_id() {
			return this.current_user_id;
		}

		public Boolean user_logged_in_to_guest;

		public Boolean getUser_logged_in_to_guest() {
			return this.user_logged_in_to_guest;
		}

		public Object currently_running_on_host;

		public Object getCurrently_running_on_host() {
			return this.currently_running_on_host;
		}

		public String running_on_host_join_id;

		public String getRunning_on_host_join_id() {
			return this.running_on_host_join_id;
		}

		public Long memory_buffered_kb;

		public Long getMemory_buffered_kb() {
			return this.memory_buffered_kb;
		}

		public Long memory_cached_kb;

		public Long getMemory_cached_kb() {
			return this.memory_cached_kb;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_status = null;
					} else {
						this.vm_status = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_usage_percent = null;
					} else {
						this.cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_usage_percent = null;
					} else {
						this.memory_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.system_cpu_usage_percent = null;
					} else {
						this.system_cpu_usage_percent = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.user_cpu_usage_percent = null;
					} else {
						this.user_cpu_usage_percent = dis.readShort();
					}

					this.disks_usage = readString(dis);

					this.vm_ip = readString(dis);

					this.vm_client_ip = readString(dis);

					this.current_user_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.user_logged_in_to_guest = null;
					} else {
						this.user_logged_in_to_guest = dis.readBoolean();
					}

					this.currently_running_on_host = (Object) dis.readObject();

					this.running_on_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.memory_buffered_kb = null;
					} else {
						this.memory_buffered_kb = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.memory_cached_kb = null;
					} else {
						this.memory_cached_kb = dis.readLong();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_status);
				}

				// Short

				if (this.cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_usage_percent);
				}

				// Short

				if (this.memory_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.memory_usage_percent);
				}

				// Short

				if (this.system_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.system_cpu_usage_percent);
				}

				// Short

				if (this.user_cpu_usage_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.user_cpu_usage_percent);
				}

				// String

				writeString(this.disks_usage, dos);

				// String

				writeString(this.vm_ip, dos);

				// String

				writeString(this.vm_client_ip, dos);

				// Object

				dos.writeObject(this.current_user_id);

				// Boolean

				if (this.user_logged_in_to_guest == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.user_logged_in_to_guest);
				}

				// Object

				dos.writeObject(this.currently_running_on_host);

				// String

				writeString(this.running_on_host_join_id, dos);

				// Long

				if (this.memory_buffered_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_buffered_kb);
				}

				// Long

				if (this.memory_cached_kb == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.memory_cached_kb);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_status=" + String.valueOf(vm_status));
			sb.append(",cpu_usage_percent=" + String.valueOf(cpu_usage_percent));
			sb.append(",memory_usage_percent="
					+ String.valueOf(memory_usage_percent));
			sb.append(",system_cpu_usage_percent="
					+ String.valueOf(system_cpu_usage_percent));
			sb.append(",user_cpu_usage_percent="
					+ String.valueOf(user_cpu_usage_percent));
			sb.append(",disks_usage=" + disks_usage);
			sb.append(",vm_ip=" + vm_ip);
			sb.append(",vm_client_ip=" + vm_client_ip);
			sb.append(",current_user_id=" + String.valueOf(current_user_id));
			sb.append(",user_logged_in_to_guest="
					+ String.valueOf(user_logged_in_to_guest));
			sb.append(",currently_running_on_host="
					+ String.valueOf(currently_running_on_host));
			sb.append(",running_on_host_join_id=" + running_on_host_join_id);
			sb.append(",memory_buffered_kb="
					+ String.valueOf(memory_buffered_kb));
			sb.append(",memory_cached_kb=" + String.valueOf(memory_cached_kb));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_10Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_10Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_9Process(globalMap);
				tJDBCInput_14Process(globalMap);

				row12Struct row12 = new row12Struct();
				vm_historyStruct vm_history = new vm_historyStruct();
				disk_usage_historyStruct disk_usage_history = new disk_usage_historyStruct();

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_5 = "INSERT INTO "
						+ "vm_samples_history"
						+ " (history_datetime,vm_id,vm_status,seconds_in_status,cpu_usage_percent,memory_usage_percent,user_cpu_usage_percent,system_cpu_usage_percent,vm_ip,vm_client_ip,current_user_id,user_logged_in_to_guest,currently_running_on_host,vm_configuration_version,current_host_configuration_version,memory_buffered_kb,memory_cached_kb) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(insert_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tJDBCOutput_8 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_8", false);
				start_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_8";

				int tos_count_tJDBCOutput_8 = 0;

				int nb_line_tJDBCOutput_8 = 0;
				int nb_line_update_tJDBCOutput_8 = 0;
				int nb_line_inserted_tJDBCOutput_8 = 0;
				int nb_line_deleted_tJDBCOutput_8 = 0;
				int nb_line_rejected_tJDBCOutput_8 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_8 = 0;

				int deletedCount_tJDBCOutput_8 = 0;
				int updatedCount_tJDBCOutput_8 = 0;
				int insertedCount_tJDBCOutput_8 = 0;
				int rejectedCount_tJDBCOutput_8 = 0;

				boolean whetherReject_tJDBCOutput_8 = false;

				java.sql.Connection connection_tJDBCOutput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_8 = "INSERT INTO "
						+ "vm_disks_usage_samples_history"
						+ " (history_datetime,vm_id,disks_usage) VALUES (?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_8 = connection_tJDBCOutput_8
						.prepareStatement(insert_tJDBCOutput_8);

				/**
				 * [tJDBCOutput_8 begin ] stop
				 */

				/**
				 * [tMap_5 begin ] start
				 */

				ok_Hash.put("tMap_5", false);
				start_Hash.put("tMap_5", System.currentTimeMillis());

				currentComponent = "tMap_5";

				int tos_count_tMap_5 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct> tHash_Lookup_row47 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct>) globalMap
						.get("tHash_Lookup_row47"));

				row47Struct row47HashKey = new row47Struct();
				row47Struct row47Default = new row47Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row48Struct> tHash_Lookup_row48 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row48Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row48Struct>) globalMap
						.get("tHash_Lookup_row48"));

				row48Struct row48HashKey = new row48Struct();
				row48Struct row48Default = new row48Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_5__Struct {
				}
				Var__tMap_5__Struct Var__tMap_5 = new Var__tMap_5__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_historyStruct vm_history_tmp = new vm_historyStruct();
				disk_usage_historyStruct disk_usage_history_tmp = new disk_usage_historyStruct();
				// ###############################

				/**
				 * [tMap_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_10 begin ] start
				 */

				ok_Hash.put("tJDBCInput_10", false);
				start_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				currentComponent = "tJDBCInput_10";

				int tos_count_tJDBCInput_10 = 0;

				int nb_line_tJDBCInput_10 = 0;
				java.sql.Connection conn_tJDBCInput_10 = null;
				conn_tJDBCInput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_10 = conn_tJDBCInput_10
						.createStatement();

				String dbquery_tJDBCInput_10 = "SELECT \n  vm_id, \n  upper(cast(vm_id as char(36))) as vm_join_id,\n  vm_status, \n  cpu_usage_percent, \n  memory_usage_percent, \n  system_cpu_usage_percent, \n  user_cpu_usage_percent, \n  disks_usage,\n  vm_ip, \n  vm_client_ip,\n  current_user_id,\n  user_logged_in_to_guest,\n  currently_running_on_host,\n  upper(cast(currently_running_on_host as char(36))) as running_on_host_join_id,\n  memory_buffered_kb,\n  memory_cached_kb\nFROM dwh_vm_history_view";

				globalMap.put("tJDBCInput_10_QUERY", dbquery_tJDBCInput_10);

				java.sql.ResultSet rs_tJDBCInput_10 = null;
				try {
					rs_tJDBCInput_10 = stmt_tJDBCInput_10
							.executeQuery(dbquery_tJDBCInput_10);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_10 = rs_tJDBCInput_10
							.getMetaData();
					int colQtyInRs_tJDBCInput_10 = rsmd_tJDBCInput_10
							.getColumnCount();

					String tmpContent_tJDBCInput_10 = null;

					while (rs_tJDBCInput_10.next()) {
						nb_line_tJDBCInput_10++;

						if (colQtyInRs_tJDBCInput_10 < 1) {
							row12.vm_id = null;
						} else {

							if (rs_tJDBCInput_10.getObject(1) != null) {
								row12.vm_id = rs_tJDBCInput_10.getObject(1);
							} else {
								row12.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 2) {
							row12.vm_join_id = null;
						} else {

							row12.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 2, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 3) {
							row12.vm_status = null;
						} else {

							if (rs_tJDBCInput_10.getObject(3) != null) {
								row12.vm_status = rs_tJDBCInput_10.getShort(3);
							} else {
								row12.vm_status = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 4) {
							row12.cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(4) != null) {
								row12.cpu_usage_percent = rs_tJDBCInput_10
										.getShort(4);
							} else {
								row12.cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 5) {
							row12.memory_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(5) != null) {
								row12.memory_usage_percent = rs_tJDBCInput_10
										.getShort(5);
							} else {
								row12.memory_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 6) {
							row12.system_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(6) != null) {
								row12.system_cpu_usage_percent = rs_tJDBCInput_10
										.getShort(6);
							} else {
								row12.system_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 7) {
							row12.user_cpu_usage_percent = null;
						} else {

							if (rs_tJDBCInput_10.getObject(7) != null) {
								row12.user_cpu_usage_percent = rs_tJDBCInput_10
										.getShort(7);
							} else {
								row12.user_cpu_usage_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 8) {
							row12.disks_usage = null;
						} else {

							row12.disks_usage = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 8, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 9) {
							row12.vm_ip = null;
						} else {

							row12.vm_ip = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_10, 9, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 10) {
							row12.vm_client_ip = null;
						} else {

							row12.vm_client_ip = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 10, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 11) {
							row12.current_user_id = null;
						} else {

							if (rs_tJDBCInput_10.getObject(11) != null) {
								row12.current_user_id = rs_tJDBCInput_10
										.getObject(11);
							} else {
								row12.current_user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 12) {
							row12.user_logged_in_to_guest = null;
						} else {

							if (rs_tJDBCInput_10.getObject(12) != null) {
								row12.user_logged_in_to_guest = rs_tJDBCInput_10
										.getBoolean(12);
							} else {
								row12.user_logged_in_to_guest = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 13) {
							row12.currently_running_on_host = null;
						} else {

							if (rs_tJDBCInput_10.getObject(13) != null) {
								row12.currently_running_on_host = rs_tJDBCInput_10
										.getObject(13);
							} else {
								row12.currently_running_on_host = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 14) {
							row12.running_on_host_join_id = null;
						} else {

							row12.running_on_host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_10, 14, false);
						}
						if (colQtyInRs_tJDBCInput_10 < 15) {
							row12.memory_buffered_kb = null;
						} else {

							if (rs_tJDBCInput_10.getObject(15) != null) {
								row12.memory_buffered_kb = rs_tJDBCInput_10
										.getLong(15);
							} else {
								row12.memory_buffered_kb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_10 < 16) {
							row12.memory_cached_kb = null;
						} else {

							if (rs_tJDBCInput_10.getObject(16) != null) {
								row12.memory_cached_kb = rs_tJDBCInput_10
										.getLong(16);
							} else {
								row12.memory_cached_kb = null;
							}
						}

						/**
						 * [tJDBCInput_10 begin ] stop
						 */

						/**
						 * [tJDBCInput_10 main ] start
						 */

						currentComponent = "tJDBCInput_10";

						tos_count_tJDBCInput_10++;

						/**
						 * [tJDBCInput_10 main ] stop
						 */

						/**
						 * [tMap_5 main ] start
						 */

						currentComponent = "tMap_5";

						boolean hasCasePrimitiveKeyWithNull_tMap_5 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_5 = false;
						boolean mainRowRejected_tMap_5 = false;

						if (

						(

						row12.vm_status != -1 && row12.vm_status != 6

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row12'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row47"
							// /////////////////////////////////////////////

							boolean forceLooprow47 = false;

							row47Struct row47ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_5) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_5 = false;

								row47HashKey.vm_join_id = row12.vm_join_id;

								row47HashKey.hashCodeDirty = true;

								tHash_Lookup_row47.lookup(row47HashKey);

								if (!tHash_Lookup_row47.hasNext()) { // G_TM_M_090

									rejectedInnerJoin_tMap_5 = true;

								} // G_TM_M_090

							} // G_TM_M_020

							if (tHash_Lookup_row47 != null
									&& tHash_Lookup_row47
											.getCount(row47HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row47' and it contains more one result from keys :  row47.vm_join_id = '"
								// + row47HashKey.vm_join_id + "'");
							} // G 071

							row47Struct row47 = null;

							row47Struct fromLookup_row47 = null;
							row47 = row47Default;

							if (tHash_Lookup_row47 != null
									&& tHash_Lookup_row47.hasNext()) { // G 099

								fromLookup_row47 = tHash_Lookup_row47.next();

							} // G 099

							if (fromLookup_row47 != null) {
								row47 = fromLookup_row47;
							}

							// /////////////////////////////////////////////
							// Starting Lookup Table "row48"
							// /////////////////////////////////////////////

							boolean forceLooprow48 = false;

							row48Struct row48ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_5) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_5 = false;

								row48HashKey.host_join_id = row12.running_on_host_join_id;

								row48HashKey.hashCodeDirty = true;

								tHash_Lookup_row48.lookup(row48HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row48 != null
									&& tHash_Lookup_row48
											.getCount(row48HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row48' and it contains more one result from keys :  row48.host_join_id = '"
								// + row48HashKey.host_join_id + "'");
							} // G 071

							row48Struct row48 = null;

							row48Struct fromLookup_row48 = null;
							row48 = row48Default;

							if (tHash_Lookup_row48 != null
									&& tHash_Lookup_row48.hasNext()) { // G 099

								fromLookup_row48 = tHash_Lookup_row48.next();

							} // G 099

							if (fromLookup_row48 != null) {
								row48 = fromLookup_row48;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_5__Struct Var = Var__tMap_5;// ###############################
								// ###############################
								// # Output tables

								vm_history = null;
								disk_usage_history = null;

								if (!rejectedInnerJoin_tMap_5) {

									// # Output table : 'vm_history'
									vm_history_tmp.history_datetime = context.runTime;
									vm_history_tmp.vm_id = row12.vm_id;
									vm_history_tmp.vm_status = (row12.vm_status == 0
											|| row12.vm_status == 15 || row12.vm_status == 9) ? (short) 0
											: (row12.vm_status == 1
													|| row12.vm_status == 2
													|| row12.vm_status == 3
													|| row12.vm_status == 5
													|| row12.vm_status == 10
													|| row12.vm_status == 11
													|| row12.vm_status == 12 || row12.vm_status == 16) ? (short) 1
													: (row12.vm_status == 4 || row12.vm_status == 13) ? (short) 2
															: (row12.vm_status == 14
																	|| row12.vm_status == 7 || row12.vm_status == 8) ? (short) 3
																	: (short) -1;
									vm_history_tmp.seconds_in_status = context.runInterleave;
									vm_history_tmp.cpu_usage_percent = row12.cpu_usage_percent;
									vm_history_tmp.memory_usage_percent = row12.memory_usage_percent;
									vm_history_tmp.user_cpu_usage_percent = row12.user_cpu_usage_percent;
									vm_history_tmp.system_cpu_usage_percent = row12.system_cpu_usage_percent;
									vm_history_tmp.vm_ip = row12.vm_ip;
									vm_history_tmp.vm_client_ip = row12.vm_client_ip;
									vm_history_tmp.current_user_id = row12.current_user_id;
									vm_history_tmp.user_logged_in_to_guest = row12.user_logged_in_to_guest;
									vm_history_tmp.currently_running_on_host = row12.currently_running_on_host;
									vm_history_tmp.vm_configuration_version = row47.history_id;
									vm_history_tmp.current_host_configuration_version = row48.history_id;
									vm_history_tmp.memory_buffered_kb = row12.memory_buffered_kb;
									vm_history_tmp.memory_cached_kb = row12.memory_cached_kb;
									vm_history = vm_history_tmp;

									// # Output table : 'disk_usage_history'
									disk_usage_history_tmp.history_datetime = context.runTime;
									disk_usage_history_tmp.vm_id = row12.vm_id;
									disk_usage_history_tmp.disks_usage = row12.disks_usage;
									disk_usage_history = disk_usage_history_tmp;
								} // closing inner join bracket (2)
									// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_5 = false;

							tos_count_tMap_5++;

							/**
							 * [tMap_5 main ] stop
							 */
							// Start of branch "vm_history"
							if (vm_history != null) {

								/**
								 * [tJDBCOutput_5 main ] start
								 */

								currentComponent = "tJDBCOutput_5";

								whetherReject_tJDBCOutput_5 = false;
								if (vm_history.history_datetime != null) {
									pstmt_tJDBCOutput_5.setTimestamp(
											1,
											new java.sql.Timestamp(
													vm_history.history_datetime
															.getTime()));
								} else {
									pstmt_tJDBCOutput_5.setNull(1,
											java.sql.Types.DATE);
								}

								if (vm_history.vm_id == null) {
									pstmt_tJDBCOutput_5.setNull(2,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_5.setObject(2,
											vm_history.vm_id);
								}

								pstmt_tJDBCOutput_5.setShort(3,
										vm_history.vm_status);

								pstmt_tJDBCOutput_5.setInt(4,
										vm_history.seconds_in_status);

								if (vm_history.cpu_usage_percent == null) {
									pstmt_tJDBCOutput_5.setNull(5,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setShort(5,
											vm_history.cpu_usage_percent);
								}

								if (vm_history.memory_usage_percent == null) {
									pstmt_tJDBCOutput_5.setNull(6,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setShort(6,
											vm_history.memory_usage_percent);
								}

								if (vm_history.user_cpu_usage_percent == null) {
									pstmt_tJDBCOutput_5.setNull(7,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setShort(7,
											vm_history.user_cpu_usage_percent);
								}

								if (vm_history.system_cpu_usage_percent == null) {
									pstmt_tJDBCOutput_5.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setShort(
													8,
													vm_history.system_cpu_usage_percent);
								}

								if (vm_history.vm_ip == null) {
									pstmt_tJDBCOutput_5.setNull(9,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5.setString(9,
											vm_history.vm_ip);
								}

								if (vm_history.vm_client_ip == null) {
									pstmt_tJDBCOutput_5.setNull(10,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5.setString(10,
											vm_history.vm_client_ip);
								}

								if (vm_history.current_user_id == null) {
									pstmt_tJDBCOutput_5.setNull(11,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_5.setObject(11,
											vm_history.current_user_id);
								}

								if (vm_history.user_logged_in_to_guest == null) {
									pstmt_tJDBCOutput_5.setNull(12,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_5.setBoolean(12,
											vm_history.user_logged_in_to_guest);
								}

								if (vm_history.currently_running_on_host == null) {
									pstmt_tJDBCOutput_5.setNull(13,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_5
											.setObject(
													13,
													vm_history.currently_running_on_host);
								}

								if (vm_history.vm_configuration_version == null) {
									pstmt_tJDBCOutput_5.setNull(14,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setInt(14,
													vm_history.vm_configuration_version);
								}

								if (vm_history.current_host_configuration_version == null) {
									pstmt_tJDBCOutput_5.setNull(15,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setInt(15,
													vm_history.current_host_configuration_version);
								}

								if (vm_history.memory_buffered_kb == null) {
									pstmt_tJDBCOutput_5.setNull(16,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setLong(16,
											vm_history.memory_buffered_kb);
								}

								if (vm_history.memory_cached_kb == null) {
									pstmt_tJDBCOutput_5.setNull(17,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setLong(17,
											vm_history.memory_cached_kb);
								}

								try {
									insertedCount_tJDBCOutput_5 = insertedCount_tJDBCOutput_5
											+ pstmt_tJDBCOutput_5
													.executeUpdate();
									nb_line_tJDBCOutput_5++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_5 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_5++;

								/**
								 * [tJDBCOutput_5 main ] stop
								 */

							} // End of branch "vm_history"

							// Start of branch "disk_usage_history"
							if (disk_usage_history != null) {

								/**
								 * [tJDBCOutput_8 main ] start
								 */

								currentComponent = "tJDBCOutput_8";

								whetherReject_tJDBCOutput_8 = false;
								if (disk_usage_history.history_datetime != null) {
									pstmt_tJDBCOutput_8
											.setTimestamp(
													1,
													new java.sql.Timestamp(
															disk_usage_history.history_datetime
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_8.setNull(1,
											java.sql.Types.DATE);
								}

								if (disk_usage_history.vm_id == null) {
									pstmt_tJDBCOutput_8.setNull(2,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_8.setObject(2,
											disk_usage_history.vm_id);
								}

								if (disk_usage_history.disks_usage == null) {
									pstmt_tJDBCOutput_8.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_8.setString(3,
											disk_usage_history.disks_usage);
								}

								try {
									insertedCount_tJDBCOutput_8 = insertedCount_tJDBCOutput_8
											+ pstmt_tJDBCOutput_8
													.executeUpdate();
									nb_line_tJDBCOutput_8++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_8 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_8++;

								/**
								 * [tJDBCOutput_8 main ] stop
								 */

							} // End of branch "disk_usage_history"

						} // G_TM_M_280 close main tMap filter for table 'row12'

						/**
						 * [tJDBCInput_10 end ] start
						 */

						currentComponent = "tJDBCInput_10";

					}
				} finally {
					if (rs_tJDBCInput_10 != null) {
						rs_tJDBCInput_10.close();
					}
					stmt_tJDBCInput_10.close();

				}
				globalMap.put("tJDBCInput_10_NB_LINE", nb_line_tJDBCInput_10);

				ok_Hash.put("tJDBCInput_10", true);
				end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				/**
				 * [tJDBCInput_10 end ] stop
				 */

				/**
				 * [tMap_5 end ] start
				 */

				currentComponent = "tMap_5";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row47 != null) {
					tHash_Lookup_row47.endGet();
				}
				globalMap.remove("tHash_Lookup_row47");

				if (tHash_Lookup_row48 != null) {
					tHash_Lookup_row48.endGet();
				}
				globalMap.remove("tHash_Lookup_row48");

				// ###############################

				ok_Hash.put("tMap_5", true);
				end_Hash.put("tMap_5", System.currentTimeMillis());

				/**
				 * [tMap_5 end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmt_tJDBCOutput_5 != null) {

					pstmt_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

				/**
				 * [tJDBCOutput_8 end ] start
				 */

				currentComponent = "tJDBCOutput_8";

				if (pstmt_tJDBCOutput_8 != null) {

					pstmt_tJDBCOutput_8.close();

				}

				nb_line_deleted_tJDBCOutput_8 = nb_line_deleted_tJDBCOutput_8
						+ deletedCount_tJDBCOutput_8;
				nb_line_update_tJDBCOutput_8 = nb_line_update_tJDBCOutput_8
						+ updatedCount_tJDBCOutput_8;
				nb_line_inserted_tJDBCOutput_8 = nb_line_inserted_tJDBCOutput_8
						+ insertedCount_tJDBCOutput_8;
				nb_line_rejected_tJDBCOutput_8 = nb_line_rejected_tJDBCOutput_8
						+ rejectedCount_tJDBCOutput_8;

				globalMap.put("tJDBCOutput_8_NB_LINE", nb_line_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_8);

				ok_Hash.put("tJDBCOutput_8", true);
				end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_8 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_5"
			globalMap.remove("tHash_Lookup_row47");

			// free memory for "tMap_5"
			globalMap.remove("tHash_Lookup_row48");

			try {

				/**
				 * [tJDBCInput_10 finally ] start
				 */

				currentComponent = "tJDBCInput_10";

				/**
				 * [tJDBCInput_10 finally ] stop
				 */

				/**
				 * [tMap_5 finally ] start
				 */

				currentComponent = "tMap_5";

				/**
				 * [tMap_5 finally ] stop
				 */

				/**
				 * [tJDBCOutput_5 finally ] start
				 */

				currentComponent = "tJDBCOutput_5";

				/**
				 * [tJDBCOutput_5 finally ] stop
				 */

				/**
				 * [tJDBCOutput_8 finally ] start
				 */

				currentComponent = "tJDBCOutput_8";

				/**
				 * [tJDBCOutput_8 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 1);
	}

	public static class row47Struct implements
			routines.system.IPersistableComparableLookupRow<row47Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.vm_join_id == null) ? 0 : this.vm_join_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row47Struct other = (row47Struct) obj;

			if (this.vm_join_id == null) {
				if (other.vm_join_id != null)
					return false;

			} else if (!this.vm_join_id.equals(other.vm_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row47Struct other) {

			other.history_id = this.history_id;
			other.vm_join_id = this.vm_join_id;

		}

		public void copyKeysDataTo(row47Struct other) {

			other.vm_join_id = this.vm_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.vm_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row47Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_join_id,
					other.vm_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_9Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row47Struct row47 = new row47Struct();

				/**
				 * [tAdvancedHash_row47 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row47", false);
				start_Hash.put("tAdvancedHash_row47",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row47";

				int tos_count_tAdvancedHash_row47 = 0;

				// connection name:row47
				// source node:tJDBCInput_9 - inputs:(after_tJDBCInput_10)
				// outputs:(row47,row47) | target node:tAdvancedHash_row47 -
				// inputs:(row47) outputs:()
				// linked node: tMap_5 - inputs:(row12,row47,row48)
				// outputs:(vm_history,disk_usage_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row47 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct> tHash_Lookup_row47 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row47Struct> getLookup(matchingModeEnum_row47);

				globalMap.put("tHash_Lookup_row47", tHash_Lookup_row47);

				/**
				 * [tAdvancedHash_row47 begin ] stop
				 */

				/**
				 * [tJDBCInput_9 begin ] start
				 */

				ok_Hash.put("tJDBCInput_9", false);
				start_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				currentComponent = "tJDBCInput_9";

				int tos_count_tJDBCInput_9 = 0;

				int nb_line_tJDBCInput_9 = 0;
				java.sql.Connection conn_tJDBCInput_9 = null;
				conn_tJDBCInput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_9 = conn_tJDBCInput_9
						.createStatement();

				String dbquery_tJDBCInput_9 = "SELECT history_id, upper(cast(vm_id as char(36))) as vm_join_id\nFROM  v4_4_latest_configuration_vms";

				globalMap.put("tJDBCInput_9_QUERY", dbquery_tJDBCInput_9);

				java.sql.ResultSet rs_tJDBCInput_9 = null;
				try {
					rs_tJDBCInput_9 = stmt_tJDBCInput_9
							.executeQuery(dbquery_tJDBCInput_9);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_9 = rs_tJDBCInput_9
							.getMetaData();
					int colQtyInRs_tJDBCInput_9 = rsmd_tJDBCInput_9
							.getColumnCount();

					String tmpContent_tJDBCInput_9 = null;

					while (rs_tJDBCInput_9.next()) {
						nb_line_tJDBCInput_9++;

						if (colQtyInRs_tJDBCInput_9 < 1) {
							row47.history_id = null;
						} else {

							if (rs_tJDBCInput_9.getObject(1) != null) {
								row47.history_id = rs_tJDBCInput_9.getInt(1);
							} else {
								row47.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_9 < 2) {
							row47.vm_join_id = null;
						} else {

							row47.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 2, false);
						}

						/**
						 * [tJDBCInput_9 begin ] stop
						 */

						/**
						 * [tJDBCInput_9 main ] start
						 */

						currentComponent = "tJDBCInput_9";

						tos_count_tJDBCInput_9++;

						/**
						 * [tJDBCInput_9 main ] stop
						 */

						/**
						 * [tAdvancedHash_row47 main ] start
						 */

						currentComponent = "tAdvancedHash_row47";

						row47Struct row47_HashRow = new row47Struct();

						row47_HashRow.history_id = row47.history_id;

						row47_HashRow.vm_join_id = row47.vm_join_id;

						tHash_Lookup_row47.put(row47_HashRow);

						tos_count_tAdvancedHash_row47++;

						/**
						 * [tAdvancedHash_row47 main ] stop
						 */

						/**
						 * [tJDBCInput_9 end ] start
						 */

						currentComponent = "tJDBCInput_9";

					}
				} finally {
					if (rs_tJDBCInput_9 != null) {
						rs_tJDBCInput_9.close();
					}
					stmt_tJDBCInput_9.close();

				}
				globalMap.put("tJDBCInput_9_NB_LINE", nb_line_tJDBCInput_9);

				ok_Hash.put("tJDBCInput_9", true);
				end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				/**
				 * [tJDBCInput_9 end ] stop
				 */

				/**
				 * [tAdvancedHash_row47 end ] start
				 */

				currentComponent = "tAdvancedHash_row47";

				tHash_Lookup_row47.endPut();

				ok_Hash.put("tAdvancedHash_row47", true);
				end_Hash.put("tAdvancedHash_row47", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row47 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_9 finally ] start
				 */

				currentComponent = "tJDBCInput_9";

				/**
				 * [tJDBCInput_9 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row47 finally ] start
				 */

				currentComponent = "tAdvancedHash_row47";

				/**
				 * [tAdvancedHash_row47 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 1);
	}

	public static class row48Struct implements
			routines.system.IPersistableComparableLookupRow<row48Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.host_join_id == null) ? 0 : this.host_join_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row48Struct other = (row48Struct) obj;

			if (this.host_join_id == null) {
				if (other.host_join_id != null)
					return false;

			} else if (!this.host_join_id.equals(other.host_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row48Struct other) {

			other.history_id = this.history_id;
			other.host_join_id = this.host_join_id;

		}

		public void copyKeysDataTo(row48Struct other) {

			other.host_join_id = this.host_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.host_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.host_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row48Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.host_join_id,
					other.host_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_14Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row48Struct row48 = new row48Struct();

				/**
				 * [tAdvancedHash_row48 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row48", false);
				start_Hash.put("tAdvancedHash_row48",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row48";

				int tos_count_tAdvancedHash_row48 = 0;

				// connection name:row48
				// source node:tJDBCInput_14 - inputs:(after_tJDBCInput_10)
				// outputs:(row48,row48) | target node:tAdvancedHash_row48 -
				// inputs:(row48) outputs:()
				// linked node: tMap_5 - inputs:(row12,row47,row48)
				// outputs:(vm_history,disk_usage_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row48 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row48Struct> tHash_Lookup_row48 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row48Struct> getLookup(matchingModeEnum_row48);

				globalMap.put("tHash_Lookup_row48", tHash_Lookup_row48);

				/**
				 * [tAdvancedHash_row48 begin ] stop
				 */

				/**
				 * [tJDBCInput_14 begin ] start
				 */

				ok_Hash.put("tJDBCInput_14", false);
				start_Hash.put("tJDBCInput_14", System.currentTimeMillis());

				currentComponent = "tJDBCInput_14";

				int tos_count_tJDBCInput_14 = 0;

				int nb_line_tJDBCInput_14 = 0;
				java.sql.Connection conn_tJDBCInput_14 = null;
				conn_tJDBCInput_14 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_14 = conn_tJDBCInput_14
						.createStatement();

				String dbquery_tJDBCInput_14 = "SELECT history_id, upper(cast(host_id as char(36))) as host_join_id\nFROM v4_4_latest_configuration_hosts";

				globalMap.put("tJDBCInput_14_QUERY", dbquery_tJDBCInput_14);

				java.sql.ResultSet rs_tJDBCInput_14 = null;
				try {
					rs_tJDBCInput_14 = stmt_tJDBCInput_14
							.executeQuery(dbquery_tJDBCInput_14);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_14 = rs_tJDBCInput_14
							.getMetaData();
					int colQtyInRs_tJDBCInput_14 = rsmd_tJDBCInput_14
							.getColumnCount();

					String tmpContent_tJDBCInput_14 = null;

					while (rs_tJDBCInput_14.next()) {
						nb_line_tJDBCInput_14++;

						if (colQtyInRs_tJDBCInput_14 < 1) {
							row48.history_id = null;
						} else {

							if (rs_tJDBCInput_14.getObject(1) != null) {
								row48.history_id = rs_tJDBCInput_14.getInt(1);
							} else {
								row48.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_14 < 2) {
							row48.host_join_id = null;
						} else {

							row48.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_14, 2, false);
						}

						/**
						 * [tJDBCInput_14 begin ] stop
						 */

						/**
						 * [tJDBCInput_14 main ] start
						 */

						currentComponent = "tJDBCInput_14";

						tos_count_tJDBCInput_14++;

						/**
						 * [tJDBCInput_14 main ] stop
						 */

						/**
						 * [tAdvancedHash_row48 main ] start
						 */

						currentComponent = "tAdvancedHash_row48";

						row48Struct row48_HashRow = new row48Struct();

						row48_HashRow.history_id = row48.history_id;

						row48_HashRow.host_join_id = row48.host_join_id;

						tHash_Lookup_row48.put(row48_HashRow);

						tos_count_tAdvancedHash_row48++;

						/**
						 * [tAdvancedHash_row48 main ] stop
						 */

						/**
						 * [tJDBCInput_14 end ] start
						 */

						currentComponent = "tJDBCInput_14";

					}
				} finally {
					if (rs_tJDBCInput_14 != null) {
						rs_tJDBCInput_14.close();
					}
					stmt_tJDBCInput_14.close();

				}
				globalMap.put("tJDBCInput_14_NB_LINE", nb_line_tJDBCInput_14);

				ok_Hash.put("tJDBCInput_14", true);
				end_Hash.put("tJDBCInput_14", System.currentTimeMillis());

				/**
				 * [tJDBCInput_14 end ] stop
				 */

				/**
				 * [tAdvancedHash_row48 end ] start
				 */

				currentComponent = "tAdvancedHash_row48";

				tHash_Lookup_row48.endPut();

				ok_Hash.put("tAdvancedHash_row48", true);
				end_Hash.put("tAdvancedHash_row48", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row48 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_14 finally ] start
				 */

				currentComponent = "tJDBCInput_14";

				/**
				 * [tJDBCInput_14 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row48 finally ] start
				 */

				currentComponent = "tAdvancedHash_row48";

				/**
				 * [tAdvancedHash_row48 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", 1);
	}

	public static class vinterface_historyStruct implements
			routines.system.IPersistableRow<vinterface_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Integer vm_interface_configuration_version;

		public Integer getVm_interface_configuration_version() {
			return this.vm_interface_configuration_version;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_interface_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					this.vm_interface_configuration_version = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Integer

				writeInteger(this.vm_interface_configuration_version, dos);

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",vm_interface_configuration_version="
					+ String.valueOf(vm_interface_configuration_version));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vinterface_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row13Struct implements
			routines.system.IPersistableRow<row13Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row13Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_12Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_12Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public Double receive_rate_percent;

		public Double getReceive_rate_percent() {
			return this.receive_rate_percent;
		}

		public Double transmit_rate_percent;

		public Double getTransmit_rate_percent() {
			return this.transmit_rate_percent;
		}

		public Long received_total_byte;

		public Long getReceived_total_byte() {
			return this.received_total_byte;
		}

		public Long transmitted_total_byte;

		public Long getTransmitted_total_byte() {
			return this.transmitted_total_byte;
		}

		public Double received_dropped_total_packets;

		public Double getReceived_dropped_total_packets() {
			return this.received_dropped_total_packets;
		}

		public Double transmitted_dropped_total_packets;

		public Double getTransmitted_dropped_total_packets() {
			return this.transmitted_dropped_total_packets;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.receive_rate_percent = null;
					} else {
						this.receive_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmit_rate_percent = null;
					} else {
						this.transmit_rate_percent = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_total_byte = null;
					} else {
						this.received_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_total_byte = null;
					} else {
						this.transmitted_total_byte = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.received_dropped_total_packets = null;
					} else {
						this.received_dropped_total_packets = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.transmitted_dropped_total_packets = null;
					} else {
						this.transmitted_dropped_total_packets = dis
								.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// Double

				if (this.receive_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.receive_rate_percent);
				}

				// Double

				if (this.transmit_rate_percent == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmit_rate_percent);
				}

				// Long

				if (this.received_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.received_total_byte);
				}

				// Long

				if (this.transmitted_total_byte == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.transmitted_total_byte);
				}

				// Double

				if (this.received_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.received_dropped_total_packets);
				}

				// Double

				if (this.transmitted_dropped_total_packets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.transmitted_dropped_total_packets);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",receive_rate_percent="
					+ String.valueOf(receive_rate_percent));
			sb.append(",transmit_rate_percent="
					+ String.valueOf(transmit_rate_percent));
			sb.append(",received_total_byte="
					+ String.valueOf(received_total_byte));
			sb.append(",transmitted_total_byte="
					+ String.valueOf(transmitted_total_byte));
			sb.append(",received_dropped_total_packets="
					+ String.valueOf(received_dropped_total_packets));
			sb.append(",transmitted_dropped_total_packets="
					+ String.valueOf(transmitted_dropped_total_packets));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_12Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_12Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_15Process(globalMap);

				row13Struct row13 = new row13Struct();
				vinterface_historyStruct vinterface_history = new vinterface_historyStruct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_6 = "INSERT INTO "
						+ "vm_interface_samples_history"
						+ " (history_datetime,vm_interface_id,receive_rate_percent,transmit_rate_percent,vm_interface_configuration_version,received_total_byte,transmitted_total_byte,received_dropped_total_packets,transmitted_dropped_total_packets) VALUES (?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(insert_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tMap_6 begin ] start
				 */

				ok_Hash.put("tMap_6", false);
				start_Hash.put("tMap_6", System.currentTimeMillis());

				currentComponent = "tMap_6";

				int tos_count_tMap_6 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row50Struct> tHash_Lookup_row50 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row50Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row50Struct>) globalMap
						.get("tHash_Lookup_row50"));

				row50Struct row50HashKey = new row50Struct();
				row50Struct row50Default = new row50Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_6__Struct {
				}
				Var__tMap_6__Struct Var__tMap_6 = new Var__tMap_6__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vinterface_historyStruct vinterface_history_tmp = new vinterface_historyStruct();
				// ###############################

				/**
				 * [tMap_6 begin ] stop
				 */

				/**
				 * [tJDBCInput_12 begin ] start
				 */

				ok_Hash.put("tJDBCInput_12", false);
				start_Hash.put("tJDBCInput_12", System.currentTimeMillis());

				currentComponent = "tJDBCInput_12";

				int tos_count_tJDBCInput_12 = 0;

				int nb_line_tJDBCInput_12 = 0;
				java.sql.Connection conn_tJDBCInput_12 = null;
				conn_tJDBCInput_12 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_12 = conn_tJDBCInput_12
						.createStatement();

				String dbquery_tJDBCInput_12 = "SELECT \n  vm_interface_id, \n  upper(cast(vm_interface_id as char(36))) as vm_interface_join_id,\n  receive_rate_percent, \n  transmit_rate_percent,\n  received_total_byte,\n  transmitted_total_byte,\n  received_dropped_total_packets,\n  transmitted_dropped_total_packets\nFROM dwh_vm_interface_history_view";

				globalMap.put("tJDBCInput_12_QUERY", dbquery_tJDBCInput_12);

				java.sql.ResultSet rs_tJDBCInput_12 = null;
				try {
					rs_tJDBCInput_12 = stmt_tJDBCInput_12
							.executeQuery(dbquery_tJDBCInput_12);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_12 = rs_tJDBCInput_12
							.getMetaData();
					int colQtyInRs_tJDBCInput_12 = rsmd_tJDBCInput_12
							.getColumnCount();

					String tmpContent_tJDBCInput_12 = null;

					while (rs_tJDBCInput_12.next()) {
						nb_line_tJDBCInput_12++;

						if (colQtyInRs_tJDBCInput_12 < 1) {
							row13.vm_interface_id = null;
						} else {

							if (rs_tJDBCInput_12.getObject(1) != null) {
								row13.vm_interface_id = rs_tJDBCInput_12
										.getObject(1);
							} else {
								row13.vm_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 2) {
							row13.vm_interface_join_id = null;
						} else {

							row13.vm_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_12, 2, false);
						}
						if (colQtyInRs_tJDBCInput_12 < 3) {
							row13.receive_rate_percent = null;
						} else {

							if (rs_tJDBCInput_12.getObject(3) != null) {
								row13.receive_rate_percent = rs_tJDBCInput_12
										.getDouble(3);
							} else {
								row13.receive_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 4) {
							row13.transmit_rate_percent = null;
						} else {

							if (rs_tJDBCInput_12.getObject(4) != null) {
								row13.transmit_rate_percent = rs_tJDBCInput_12
										.getDouble(4);
							} else {
								row13.transmit_rate_percent = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 5) {
							row13.received_total_byte = null;
						} else {

							if (rs_tJDBCInput_12.getObject(5) != null) {
								row13.received_total_byte = rs_tJDBCInput_12
										.getLong(5);
							} else {
								row13.received_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 6) {
							row13.transmitted_total_byte = null;
						} else {

							if (rs_tJDBCInput_12.getObject(6) != null) {
								row13.transmitted_total_byte = rs_tJDBCInput_12
										.getLong(6);
							} else {
								row13.transmitted_total_byte = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 7) {
							row13.received_dropped_total_packets = null;
						} else {

							if (rs_tJDBCInput_12.getObject(7) != null) {
								row13.received_dropped_total_packets = rs_tJDBCInput_12
										.getDouble(7);
							} else {
								row13.received_dropped_total_packets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_12 < 8) {
							row13.transmitted_dropped_total_packets = null;
						} else {

							if (rs_tJDBCInput_12.getObject(8) != null) {
								row13.transmitted_dropped_total_packets = rs_tJDBCInput_12
										.getDouble(8);
							} else {
								row13.transmitted_dropped_total_packets = null;
							}
						}

						/**
						 * [tJDBCInput_12 begin ] stop
						 */

						/**
						 * [tJDBCInput_12 main ] start
						 */

						currentComponent = "tJDBCInput_12";

						tos_count_tJDBCInput_12++;

						/**
						 * [tJDBCInput_12 main ] stop
						 */

						/**
						 * [tMap_6 main ] start
						 */

						currentComponent = "tMap_6";

						boolean hasCasePrimitiveKeyWithNull_tMap_6 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_6 = false;
						boolean mainRowRejected_tMap_6 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row50"
						// /////////////////////////////////////////////

						boolean forceLooprow50 = false;

						row50Struct row50ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_6) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_6 = false;

							row50HashKey.vm_interface_join_id = row13.vm_interface_join_id;

							row50HashKey.hashCodeDirty = true;

							tHash_Lookup_row50.lookup(row50HashKey);

							if (!tHash_Lookup_row50.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_6 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row50 != null
								&& tHash_Lookup_row50.getCount(row50HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row50' and it contains more one result from keys :  row50.vm_interface_join_id = '"
							// + row50HashKey.vm_interface_join_id + "'");
						} // G 071

						row50Struct row50 = null;

						row50Struct fromLookup_row50 = null;
						row50 = row50Default;

						if (tHash_Lookup_row50 != null
								&& tHash_Lookup_row50.hasNext()) { // G 099

							fromLookup_row50 = tHash_Lookup_row50.next();

						} // G 099

						if (fromLookup_row50 != null) {
							row50 = fromLookup_row50;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_6__Struct Var = Var__tMap_6;// ###############################
							// ###############################
							// # Output tables

							vinterface_history = null;

							if (!rejectedInnerJoin_tMap_6) {

								// # Output table : 'vinterface_history'
								vinterface_history_tmp.history_datetime = context.runTime;
								vinterface_history_tmp.vm_interface_id = row13.vm_interface_id;
								vinterface_history_tmp.receive_rate_percent = row13.receive_rate_percent;
								vinterface_history_tmp.transmit_rate_percent = row13.transmit_rate_percent;
								vinterface_history_tmp.vm_interface_configuration_version = row50.history_id;
								vinterface_history_tmp.received_total_byte = row13.received_total_byte;
								vinterface_history_tmp.transmitted_total_byte = row13.transmitted_total_byte;
								vinterface_history_tmp.received_dropped_total_packets = row13.received_dropped_total_packets;
								vinterface_history_tmp.transmitted_dropped_total_packets = row13.transmitted_dropped_total_packets;
								vinterface_history = vinterface_history_tmp;
							} // closing inner join bracket (2)
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_6 = false;

						tos_count_tMap_6++;

						/**
						 * [tMap_6 main ] stop
						 */
						// Start of branch "vinterface_history"
						if (vinterface_history != null) {

							/**
							 * [tJDBCOutput_6 main ] start
							 */

							currentComponent = "tJDBCOutput_6";

							whetherReject_tJDBCOutput_6 = false;
							if (vinterface_history.history_datetime != null) {
								pstmt_tJDBCOutput_6
										.setTimestamp(
												1,
												new java.sql.Timestamp(
														vinterface_history.history_datetime
																.getTime()));
							} else {
								pstmt_tJDBCOutput_6.setNull(1,
										java.sql.Types.DATE);
							}

							if (vinterface_history.vm_interface_id == null) {
								pstmt_tJDBCOutput_6.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(2,
										vinterface_history.vm_interface_id);
							}

							if (vinterface_history.receive_rate_percent == null) {
								pstmt_tJDBCOutput_6.setNull(3,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_6
										.setDouble(
												3,
												vinterface_history.receive_rate_percent);
							}

							if (vinterface_history.transmit_rate_percent == null) {
								pstmt_tJDBCOutput_6.setNull(4,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_6
										.setDouble(
												4,
												vinterface_history.transmit_rate_percent);
							}

							if (vinterface_history.vm_interface_configuration_version == null) {
								pstmt_tJDBCOutput_6.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6
										.setInt(5,
												vinterface_history.vm_interface_configuration_version);
							}

							if (vinterface_history.received_total_byte == null) {
								pstmt_tJDBCOutput_6.setNull(6,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setLong(6,
										vinterface_history.received_total_byte);
							}

							if (vinterface_history.transmitted_total_byte == null) {
								pstmt_tJDBCOutput_6.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6
										.setLong(
												7,
												vinterface_history.transmitted_total_byte);
							}

							if (vinterface_history.received_dropped_total_packets == null) {
								pstmt_tJDBCOutput_6.setNull(8,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_6
										.setDouble(
												8,
												vinterface_history.received_dropped_total_packets);
							}

							if (vinterface_history.transmitted_dropped_total_packets == null) {
								pstmt_tJDBCOutput_6.setNull(9,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_6
										.setDouble(
												9,
												vinterface_history.transmitted_dropped_total_packets);
							}

							try {
								insertedCount_tJDBCOutput_6 = insertedCount_tJDBCOutput_6
										+ pstmt_tJDBCOutput_6.executeUpdate();
								nb_line_tJDBCOutput_6++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_6 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_6++;

							/**
							 * [tJDBCOutput_6 main ] stop
							 */

						} // End of branch "vinterface_history"

						/**
						 * [tJDBCInput_12 end ] start
						 */

						currentComponent = "tJDBCInput_12";

					}
				} finally {
					if (rs_tJDBCInput_12 != null) {
						rs_tJDBCInput_12.close();
					}
					stmt_tJDBCInput_12.close();

				}
				globalMap.put("tJDBCInput_12_NB_LINE", nb_line_tJDBCInput_12);

				ok_Hash.put("tJDBCInput_12", true);
				end_Hash.put("tJDBCInput_12", System.currentTimeMillis());

				/**
				 * [tJDBCInput_12 end ] stop
				 */

				/**
				 * [tMap_6 end ] start
				 */

				currentComponent = "tMap_6";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row50 != null) {
					tHash_Lookup_row50.endGet();
				}
				globalMap.remove("tHash_Lookup_row50");

				// ###############################

				ok_Hash.put("tMap_6", true);
				end_Hash.put("tMap_6", System.currentTimeMillis());

				/**
				 * [tMap_6 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmt_tJDBCOutput_6 != null) {

					pstmt_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_6"
			globalMap.remove("tHash_Lookup_row50");

			try {

				/**
				 * [tJDBCInput_12 finally ] start
				 */

				currentComponent = "tJDBCInput_12";

				/**
				 * [tJDBCInput_12 finally ] stop
				 */

				/**
				 * [tMap_6 finally ] start
				 */

				currentComponent = "tMap_6";

				/**
				 * [tMap_6 finally ] stop
				 */

				/**
				 * [tJDBCOutput_6 finally ] start
				 */

				currentComponent = "tJDBCOutput_6";

				/**
				 * [tJDBCOutput_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", 1);
	}

	public static class row50Struct implements
			routines.system.IPersistableComparableLookupRow<row50Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.vm_interface_join_id == null) ? 0
								: this.vm_interface_join_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row50Struct other = (row50Struct) obj;

			if (this.vm_interface_join_id == null) {
				if (other.vm_interface_join_id != null)
					return false;

			} else if (!this.vm_interface_join_id
					.equals(other.vm_interface_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row50Struct other) {

			other.history_id = this.history_id;
			other.vm_interface_join_id = this.vm_interface_join_id;

		}

		public void copyKeysDataTo(row50Struct other) {

			other.vm_interface_join_id = this.vm_interface_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_interface_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.vm_interface_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row50Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_interface_join_id,
					other.vm_interface_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_15Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row50Struct row50 = new row50Struct();

				/**
				 * [tAdvancedHash_row50 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row50", false);
				start_Hash.put("tAdvancedHash_row50",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row50";

				int tos_count_tAdvancedHash_row50 = 0;

				// connection name:row50
				// source node:tJDBCInput_15 - inputs:(after_tJDBCInput_12)
				// outputs:(row50,row50) | target node:tAdvancedHash_row50 -
				// inputs:(row50) outputs:()
				// linked node: tMap_6 - inputs:(row13,row50)
				// outputs:(vinterface_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row50 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row50Struct> tHash_Lookup_row50 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row50Struct> getLookup(matchingModeEnum_row50);

				globalMap.put("tHash_Lookup_row50", tHash_Lookup_row50);

				/**
				 * [tAdvancedHash_row50 begin ] stop
				 */

				/**
				 * [tJDBCInput_15 begin ] start
				 */

				ok_Hash.put("tJDBCInput_15", false);
				start_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				currentComponent = "tJDBCInput_15";

				int tos_count_tJDBCInput_15 = 0;

				int nb_line_tJDBCInput_15 = 0;
				java.sql.Connection conn_tJDBCInput_15 = null;
				conn_tJDBCInput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_15 = conn_tJDBCInput_15
						.createStatement();

				String dbquery_tJDBCInput_15 = "SELECT history_id, upper(cast(vm_interface_id as char(36))) as vm_interface_join_id\nFROM  v4_4_latest_configuration_vms_interfaces";

				globalMap.put("tJDBCInput_15_QUERY", dbquery_tJDBCInput_15);

				java.sql.ResultSet rs_tJDBCInput_15 = null;
				try {
					rs_tJDBCInput_15 = stmt_tJDBCInput_15
							.executeQuery(dbquery_tJDBCInput_15);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_15 = rs_tJDBCInput_15
							.getMetaData();
					int colQtyInRs_tJDBCInput_15 = rsmd_tJDBCInput_15
							.getColumnCount();

					String tmpContent_tJDBCInput_15 = null;

					while (rs_tJDBCInput_15.next()) {
						nb_line_tJDBCInput_15++;

						if (colQtyInRs_tJDBCInput_15 < 1) {
							row50.history_id = null;
						} else {

							if (rs_tJDBCInput_15.getObject(1) != null) {
								row50.history_id = rs_tJDBCInput_15.getInt(1);
							} else {
								row50.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_15 < 2) {
							row50.vm_interface_join_id = null;
						} else {

							row50.vm_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_15, 2, false);
						}

						/**
						 * [tJDBCInput_15 begin ] stop
						 */

						/**
						 * [tJDBCInput_15 main ] start
						 */

						currentComponent = "tJDBCInput_15";

						tos_count_tJDBCInput_15++;

						/**
						 * [tJDBCInput_15 main ] stop
						 */

						/**
						 * [tAdvancedHash_row50 main ] start
						 */

						currentComponent = "tAdvancedHash_row50";

						row50Struct row50_HashRow = new row50Struct();

						row50_HashRow.history_id = row50.history_id;

						row50_HashRow.vm_interface_join_id = row50.vm_interface_join_id;

						tHash_Lookup_row50.put(row50_HashRow);

						tos_count_tAdvancedHash_row50++;

						/**
						 * [tAdvancedHash_row50 main ] stop
						 */

						/**
						 * [tJDBCInput_15 end ] start
						 */

						currentComponent = "tJDBCInput_15";

					}
				} finally {
					if (rs_tJDBCInput_15 != null) {
						rs_tJDBCInput_15.close();
					}
					stmt_tJDBCInput_15.close();

				}
				globalMap.put("tJDBCInput_15_NB_LINE", nb_line_tJDBCInput_15);

				ok_Hash.put("tJDBCInput_15", true);
				end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				/**
				 * [tJDBCInput_15 end ] stop
				 */

				/**
				 * [tAdvancedHash_row50 end ] start
				 */

				currentComponent = "tAdvancedHash_row50";

				tHash_Lookup_row50.endPut();

				ok_Hash.put("tAdvancedHash_row50", true);
				end_Hash.put("tAdvancedHash_row50", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row50 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_15 finally ] start
				 */

				currentComponent = "tJDBCInput_15";

				/**
				 * [tJDBCInput_15 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row50 finally ] start
				 */

				currentComponent = "tAdvancedHash_row50";

				/**
				 * [tAdvancedHash_row50 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 1);
	}

	public static class vm_disk_historyStruct implements
			routines.system.IPersistableRow<vm_disk_historyStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date history_datetime;

		public java.util.Date getHistory_datetime() {
			return this.history_datetime;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public int seconds_in_status;

		public int getSeconds_in_status() {
			return this.seconds_in_status;
		}

		public int vm_disk_actual_size_mb;

		public int getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Integer read_rate_bytes_per_second;

		public Integer getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Integer write_rate_bytes_per_second;

		public Integer getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Long read_ops_per_second;

		public Long getRead_ops_per_second() {
			return this.read_ops_per_second;
		}

		public Long write_ops_per_second;

		public Long getWrite_ops_per_second() {
			return this.write_ops_per_second;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		public Integer vm_disk_configuration_version;

		public Integer getVm_disk_configuration_version() {
			return this.vm_disk_configuration_version;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.history_datetime = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.seconds_in_status = dis.readInt();

					this.vm_disk_actual_size_mb = dis.readInt();

					this.read_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					this.write_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_ops_per_second = null;
					} else {
						this.read_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_ops_per_second = null;
					} else {
						this.write_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

					this.vm_disk_configuration_version = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.history_datetime, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// int

				dos.writeInt(this.seconds_in_status);

				// int

				dos.writeInt(this.vm_disk_actual_size_mb);

				// Integer

				writeInteger(this.read_rate_bytes_per_second, dos);

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Integer

				writeInteger(this.write_rate_bytes_per_second, dos);

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Long

				if (this.read_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_ops_per_second);
				}

				// Long

				if (this.write_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_ops_per_second);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

				// Integer

				writeInteger(this.vm_disk_configuration_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_datetime=" + String.valueOf(history_datetime));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",seconds_in_status=" + String.valueOf(seconds_in_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",read_ops_per_second="
					+ String.valueOf(read_ops_per_second));
			sb.append(",write_ops_per_second="
					+ String.valueOf(write_ops_per_second));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append(",vm_disk_configuration_version="
					+ String.valueOf(vm_disk_configuration_version));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_disk_historyStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public Integer vm_disk_actual_size_mb;

		public Integer getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Integer read_rate_bytes_per_second;

		public Integer getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Integer write_rate_bytes_per_second;

		public Integer getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Long read_ops_per_second;

		public Long getRead_ops_per_second() {
			return this.read_ops_per_second;
		}

		public Long write_ops_per_second;

		public Long getWrite_ops_per_second() {
			return this.write_ops_per_second;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.vm_disk_actual_size_mb = readInteger(dis);

					this.read_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					this.write_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_ops_per_second = null;
					} else {
						this.read_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_ops_per_second = null;
					} else {
						this.write_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// Integer

				writeInteger(this.vm_disk_actual_size_mb, dos);

				// Integer

				writeInteger(this.read_rate_bytes_per_second, dos);

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Integer

				writeInteger(this.write_rate_bytes_per_second, dos);

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Long

				if (this.read_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_ops_per_second);
				}

				// Long

				if (this.write_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_ops_per_second);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",read_ops_per_second="
					+ String.valueOf(read_ops_per_second));
			sb.append(",write_ops_per_second="
					+ String.valueOf(write_ops_per_second));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_18Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_18Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Short vm_disk_status;

		public Short getVm_disk_status() {
			return this.vm_disk_status;
		}

		public Integer vm_disk_actual_size_mb;

		public Integer getVm_disk_actual_size_mb() {
			return this.vm_disk_actual_size_mb;
		}

		public Integer read_rate_bytes_per_second;

		public Integer getRead_rate_bytes_per_second() {
			return this.read_rate_bytes_per_second;
		}

		public Double read_latency_seconds;

		public Double getRead_latency_seconds() {
			return this.read_latency_seconds;
		}

		public Integer write_rate_bytes_per_second;

		public Integer getWrite_rate_bytes_per_second() {
			return this.write_rate_bytes_per_second;
		}

		public Double write_latency_seconds;

		public Double getWrite_latency_seconds() {
			return this.write_latency_seconds;
		}

		public Long read_ops_per_second;

		public Long getRead_ops_per_second() {
			return this.read_ops_per_second;
		}

		public Long write_ops_per_second;

		public Long getWrite_ops_per_second() {
			return this.write_ops_per_second;
		}

		public Double flush_latency_seconds;

		public Double getFlush_latency_seconds() {
			return this.flush_latency_seconds;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.image_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_status = null;
					} else {
						this.vm_disk_status = dis.readShort();
					}

					this.vm_disk_actual_size_mb = readInteger(dis);

					this.read_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.read_latency_seconds = null;
					} else {
						this.read_latency_seconds = dis.readDouble();
					}

					this.write_rate_bytes_per_second = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.write_latency_seconds = null;
					} else {
						this.write_latency_seconds = dis.readDouble();
					}

					length = dis.readByte();
					if (length == -1) {
						this.read_ops_per_second = null;
					} else {
						this.read_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.write_ops_per_second = null;
					} else {
						this.write_ops_per_second = dis.readLong();
					}

					length = dis.readByte();
					if (length == -1) {
						this.flush_latency_seconds = null;
					} else {
						this.flush_latency_seconds = dis.readDouble();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.image_id);

				// Short

				if (this.vm_disk_status == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_status);
				}

				// Integer

				writeInteger(this.vm_disk_actual_size_mb, dos);

				// Integer

				writeInteger(this.read_rate_bytes_per_second, dos);

				// Double

				if (this.read_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.read_latency_seconds);
				}

				// Integer

				writeInteger(this.write_rate_bytes_per_second, dos);

				// Double

				if (this.write_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.write_latency_seconds);
				}

				// Long

				if (this.read_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.read_ops_per_second);
				}

				// Long

				if (this.write_ops_per_second == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeLong(this.write_ops_per_second);
				}

				// Double

				if (this.flush_latency_seconds == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.flush_latency_seconds);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",vm_disk_status=" + String.valueOf(vm_disk_status));
			sb.append(",vm_disk_actual_size_mb="
					+ String.valueOf(vm_disk_actual_size_mb));
			sb.append(",read_rate_bytes_per_second="
					+ String.valueOf(read_rate_bytes_per_second));
			sb.append(",read_latency_seconds="
					+ String.valueOf(read_latency_seconds));
			sb.append(",write_rate_bytes_per_second="
					+ String.valueOf(write_rate_bytes_per_second));
			sb.append(",write_latency_seconds="
					+ String.valueOf(write_latency_seconds));
			sb.append(",read_ops_per_second="
					+ String.valueOf(read_ops_per_second));
			sb.append(",write_ops_per_second="
					+ String.valueOf(write_ops_per_second));
			sb.append(",flush_latency_seconds="
					+ String.valueOf(flush_latency_seconds));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_18Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_18Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_20Process(globalMap);

				row1Struct row1 = new row1Struct();
				vm_disk_historyStruct vm_disk_history = new vm_disk_historyStruct();

				/**
				 * [tJDBCOutput_7 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_7", false);
				start_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_7";

				int tos_count_tJDBCOutput_7 = 0;

				int nb_line_tJDBCOutput_7 = 0;
				int nb_line_update_tJDBCOutput_7 = 0;
				int nb_line_inserted_tJDBCOutput_7 = 0;
				int nb_line_deleted_tJDBCOutput_7 = 0;
				int nb_line_rejected_tJDBCOutput_7 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_7 = 0;

				int deletedCount_tJDBCOutput_7 = 0;
				int updatedCount_tJDBCOutput_7 = 0;
				int insertedCount_tJDBCOutput_7 = 0;
				int rejectedCount_tJDBCOutput_7 = 0;

				boolean whetherReject_tJDBCOutput_7 = false;

				java.sql.Connection connection_tJDBCOutput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_7 = "INSERT INTO "
						+ "vm_disk_samples_history"
						+ " (history_datetime,vm_disk_id,image_id,vm_disk_status,seconds_in_status,vm_disk_actual_size_mb,read_rate_bytes_per_second,read_latency_seconds,write_rate_bytes_per_second,write_latency_seconds,read_ops_per_second,write_ops_per_second,flush_latency_seconds,vm_disk_configuration_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_7 = connection_tJDBCOutput_7
						.prepareStatement(insert_tJDBCOutput_7);

				/**
				 * [tJDBCOutput_7 begin ] stop
				 */

				/**
				 * [tMap_7 begin ] start
				 */

				ok_Hash.put("tMap_7", false);
				start_Hash.put("tMap_7", System.currentTimeMillis());

				currentComponent = "tMap_7";

				int tos_count_tMap_7 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row3Struct> tHash_Lookup_row3 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row3Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row3Struct>) globalMap
						.get("tHash_Lookup_row3"));

				row3Struct row3HashKey = new row3Struct();
				row3Struct row3Default = new row3Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_7__Struct {
				}
				Var__tMap_7__Struct Var__tMap_7 = new Var__tMap_7__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_disk_historyStruct vm_disk_history_tmp = new vm_disk_historyStruct();
				// ###############################

				/**
				 * [tMap_7 begin ] stop
				 */

				/**
				 * [tJDBCInput_18 begin ] start
				 */

				ok_Hash.put("tJDBCInput_18", false);
				start_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				currentComponent = "tJDBCInput_18";

				int tos_count_tJDBCInput_18 = 0;

				int nb_line_tJDBCInput_18 = 0;
				java.sql.Connection conn_tJDBCInput_18 = null;
				conn_tJDBCInput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_18 = conn_tJDBCInput_18
						.createStatement();

				String dbquery_tJDBCInput_18 = "SELECT vm_disk_id,\n		upper(cast(vm_disk_id as char(36))) as vm_disk_join_id,\n        image_id,\n		vm_disk_status,\n		vm_disk_actual_size_mb,\n		read_rate_bytes_per_second,\n		read_latency_seconds,\n		write_rate_bytes_per_second,\n		write_latency_seconds,\n        read_ops_per_second,\n        write_ops_per_second,\n		flush_latency_seconds\nFROM dwh_vm_disks_history_view";

				globalMap.put("tJDBCInput_18_QUERY", dbquery_tJDBCInput_18);

				java.sql.ResultSet rs_tJDBCInput_18 = null;
				try {
					rs_tJDBCInput_18 = stmt_tJDBCInput_18
							.executeQuery(dbquery_tJDBCInput_18);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_18 = rs_tJDBCInput_18
							.getMetaData();
					int colQtyInRs_tJDBCInput_18 = rsmd_tJDBCInput_18
							.getColumnCount();

					String tmpContent_tJDBCInput_18 = null;

					while (rs_tJDBCInput_18.next()) {
						nb_line_tJDBCInput_18++;

						if (colQtyInRs_tJDBCInput_18 < 1) {
							row1.vm_disk_id = null;
						} else {

							if (rs_tJDBCInput_18.getObject(1) != null) {
								row1.vm_disk_id = rs_tJDBCInput_18.getObject(1);
							} else {
								row1.vm_disk_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 2) {
							row1.vm_disk_join_id = null;
						} else {

							row1.vm_disk_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 2, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 3) {
							row1.image_id = null;
						} else {

							if (rs_tJDBCInput_18.getObject(3) != null) {
								row1.image_id = rs_tJDBCInput_18.getObject(3);
							} else {
								row1.image_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 4) {
							row1.vm_disk_status = null;
						} else {

							if (rs_tJDBCInput_18.getObject(4) != null) {
								row1.vm_disk_status = rs_tJDBCInput_18
										.getShort(4);
							} else {
								row1.vm_disk_status = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 5) {
							row1.vm_disk_actual_size_mb = null;
						} else {

							if (rs_tJDBCInput_18.getObject(5) != null) {
								row1.vm_disk_actual_size_mb = rs_tJDBCInput_18
										.getInt(5);
							} else {
								row1.vm_disk_actual_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 6) {
							row1.read_rate_bytes_per_second = null;
						} else {

							if (rs_tJDBCInput_18.getObject(6) != null) {
								row1.read_rate_bytes_per_second = rs_tJDBCInput_18
										.getInt(6);
							} else {
								row1.read_rate_bytes_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 7) {
							row1.read_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_18.getObject(7) != null) {
								row1.read_latency_seconds = rs_tJDBCInput_18
										.getDouble(7);
							} else {
								row1.read_latency_seconds = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 8) {
							row1.write_rate_bytes_per_second = null;
						} else {

							if (rs_tJDBCInput_18.getObject(8) != null) {
								row1.write_rate_bytes_per_second = rs_tJDBCInput_18
										.getInt(8);
							} else {
								row1.write_rate_bytes_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 9) {
							row1.write_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_18.getObject(9) != null) {
								row1.write_latency_seconds = rs_tJDBCInput_18
										.getDouble(9);
							} else {
								row1.write_latency_seconds = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 10) {
							row1.read_ops_per_second = null;
						} else {

							if (rs_tJDBCInput_18.getObject(10) != null) {
								row1.read_ops_per_second = rs_tJDBCInput_18
										.getLong(10);
							} else {
								row1.read_ops_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 11) {
							row1.write_ops_per_second = null;
						} else {

							if (rs_tJDBCInput_18.getObject(11) != null) {
								row1.write_ops_per_second = rs_tJDBCInput_18
										.getLong(11);
							} else {
								row1.write_ops_per_second = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 12) {
							row1.flush_latency_seconds = null;
						} else {

							if (rs_tJDBCInput_18.getObject(12) != null) {
								row1.flush_latency_seconds = rs_tJDBCInput_18
										.getDouble(12);
							} else {
								row1.flush_latency_seconds = null;
							}
						}

						/**
						 * [tJDBCInput_18 begin ] stop
						 */

						/**
						 * [tJDBCInput_18 main ] start
						 */

						currentComponent = "tJDBCInput_18";

						tos_count_tJDBCInput_18++;

						/**
						 * [tJDBCInput_18 main ] stop
						 */

						/**
						 * [tMap_7 main ] start
						 */

						currentComponent = "tMap_7";

						boolean hasCasePrimitiveKeyWithNull_tMap_7 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_7 = false;
						boolean mainRowRejected_tMap_7 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row3"
						// /////////////////////////////////////////////

						boolean forceLooprow3 = false;

						row3Struct row3ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_7) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_7 = false;

							row3HashKey.vm_disk_join_id = row1.vm_disk_join_id;

							row3HashKey.hashCodeDirty = true;

							tHash_Lookup_row3.lookup(row3HashKey);

							if (!tHash_Lookup_row3.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_7 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row3 != null
								&& tHash_Lookup_row3.getCount(row3HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row3' and it contains more one result from keys :  row3.vm_disk_join_id = '"
							// + row3HashKey.vm_disk_join_id + "'");
						} // G 071

						row3Struct row3 = null;

						row3Struct fromLookup_row3 = null;
						row3 = row3Default;

						if (tHash_Lookup_row3 != null
								&& tHash_Lookup_row3.hasNext()) { // G 099

							fromLookup_row3 = tHash_Lookup_row3.next();

						} // G 099

						if (fromLookup_row3 != null) {
							row3 = fromLookup_row3;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_7__Struct Var = Var__tMap_7;// ###############################
							// ###############################
							// # Output tables

							vm_disk_history = null;

							if (!rejectedInnerJoin_tMap_7) {

								// # Output table : 'vm_disk_history'
								vm_disk_history_tmp.history_datetime = context.runTime;
								vm_disk_history_tmp.vm_disk_id = row1.vm_disk_id;
								vm_disk_history_tmp.image_id = row1.image_id;
								vm_disk_history_tmp.vm_disk_status = row1.vm_disk_status;
								vm_disk_history_tmp.seconds_in_status = context.runInterleave;
								vm_disk_history_tmp.vm_disk_actual_size_mb = row1.vm_disk_actual_size_mb;
								vm_disk_history_tmp.read_rate_bytes_per_second = row1.read_rate_bytes_per_second;
								vm_disk_history_tmp.read_latency_seconds = row1.read_latency_seconds;
								vm_disk_history_tmp.write_rate_bytes_per_second = row1.write_rate_bytes_per_second;
								vm_disk_history_tmp.write_latency_seconds = row1.write_latency_seconds;
								vm_disk_history_tmp.read_ops_per_second = row1.read_ops_per_second;
								vm_disk_history_tmp.write_ops_per_second = row1.write_ops_per_second;
								vm_disk_history_tmp.flush_latency_seconds = row1.flush_latency_seconds;
								vm_disk_history_tmp.vm_disk_configuration_version = row3.history_id;
								vm_disk_history = vm_disk_history_tmp;
							} // closing inner join bracket (2)
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_7 = false;

						tos_count_tMap_7++;

						/**
						 * [tMap_7 main ] stop
						 */
						// Start of branch "vm_disk_history"
						if (vm_disk_history != null) {

							/**
							 * [tJDBCOutput_7 main ] start
							 */

							currentComponent = "tJDBCOutput_7";

							whetherReject_tJDBCOutput_7 = false;
							if (vm_disk_history.history_datetime != null) {
								pstmt_tJDBCOutput_7
										.setTimestamp(
												1,
												new java.sql.Timestamp(
														vm_disk_history.history_datetime
																.getTime()));
							} else {
								pstmt_tJDBCOutput_7.setNull(1,
										java.sql.Types.DATE);
							}

							if (vm_disk_history.vm_disk_id == null) {
								pstmt_tJDBCOutput_7.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_7.setObject(2,
										vm_disk_history.vm_disk_id);
							}

							if (vm_disk_history.image_id == null) {
								pstmt_tJDBCOutput_7.setNull(3,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_7.setObject(3,
										vm_disk_history.image_id);
							}

							if (vm_disk_history.vm_disk_status == null) {
								pstmt_tJDBCOutput_7.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setShort(4,
										vm_disk_history.vm_disk_status);
							}

							pstmt_tJDBCOutput_7.setInt(5,
									vm_disk_history.seconds_in_status);

							pstmt_tJDBCOutput_7.setInt(6,
									vm_disk_history.vm_disk_actual_size_mb);

							if (vm_disk_history.read_rate_bytes_per_second == null) {
								pstmt_tJDBCOutput_7.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7
										.setInt(7,
												vm_disk_history.read_rate_bytes_per_second);
							}

							if (vm_disk_history.read_latency_seconds == null) {
								pstmt_tJDBCOutput_7.setNull(8,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_7.setDouble(8,
										vm_disk_history.read_latency_seconds);
							}

							if (vm_disk_history.write_rate_bytes_per_second == null) {
								pstmt_tJDBCOutput_7.setNull(9,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7
										.setInt(9,
												vm_disk_history.write_rate_bytes_per_second);
							}

							if (vm_disk_history.write_latency_seconds == null) {
								pstmt_tJDBCOutput_7.setNull(10,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_7.setDouble(10,
										vm_disk_history.write_latency_seconds);
							}

							if (vm_disk_history.read_ops_per_second == null) {
								pstmt_tJDBCOutput_7.setNull(11,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setLong(11,
										vm_disk_history.read_ops_per_second);
							}

							if (vm_disk_history.write_ops_per_second == null) {
								pstmt_tJDBCOutput_7.setNull(12,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setLong(12,
										vm_disk_history.write_ops_per_second);
							}

							if (vm_disk_history.flush_latency_seconds == null) {
								pstmt_tJDBCOutput_7.setNull(13,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_7.setDouble(13,
										vm_disk_history.flush_latency_seconds);
							}

							if (vm_disk_history.vm_disk_configuration_version == null) {
								pstmt_tJDBCOutput_7.setNull(14,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7
										.setInt(14,
												vm_disk_history.vm_disk_configuration_version);
							}

							try {
								insertedCount_tJDBCOutput_7 = insertedCount_tJDBCOutput_7
										+ pstmt_tJDBCOutput_7.executeUpdate();
								nb_line_tJDBCOutput_7++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_7 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_7++;

							/**
							 * [tJDBCOutput_7 main ] stop
							 */

						} // End of branch "vm_disk_history"

						/**
						 * [tJDBCInput_18 end ] start
						 */

						currentComponent = "tJDBCInput_18";

					}
				} finally {
					if (rs_tJDBCInput_18 != null) {
						rs_tJDBCInput_18.close();
					}
					stmt_tJDBCInput_18.close();

				}
				globalMap.put("tJDBCInput_18_NB_LINE", nb_line_tJDBCInput_18);

				ok_Hash.put("tJDBCInput_18", true);
				end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				/**
				 * [tJDBCInput_18 end ] stop
				 */

				/**
				 * [tMap_7 end ] start
				 */

				currentComponent = "tMap_7";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row3 != null) {
					tHash_Lookup_row3.endGet();
				}
				globalMap.remove("tHash_Lookup_row3");

				// ###############################

				ok_Hash.put("tMap_7", true);
				end_Hash.put("tMap_7", System.currentTimeMillis());

				/**
				 * [tMap_7 end ] stop
				 */

				/**
				 * [tJDBCOutput_7 end ] start
				 */

				currentComponent = "tJDBCOutput_7";

				if (pstmt_tJDBCOutput_7 != null) {

					pstmt_tJDBCOutput_7.close();

				}

				nb_line_deleted_tJDBCOutput_7 = nb_line_deleted_tJDBCOutput_7
						+ deletedCount_tJDBCOutput_7;
				nb_line_update_tJDBCOutput_7 = nb_line_update_tJDBCOutput_7
						+ updatedCount_tJDBCOutput_7;
				nb_line_inserted_tJDBCOutput_7 = nb_line_inserted_tJDBCOutput_7
						+ insertedCount_tJDBCOutput_7;
				nb_line_rejected_tJDBCOutput_7 = nb_line_rejected_tJDBCOutput_7
						+ rejectedCount_tJDBCOutput_7;

				globalMap.put("tJDBCOutput_7_NB_LINE", nb_line_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_7);

				ok_Hash.put("tJDBCOutput_7", true);
				end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_7 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_7"
			globalMap.remove("tHash_Lookup_row3");

			try {

				/**
				 * [tJDBCInput_18 finally ] start
				 */

				currentComponent = "tJDBCInput_18";

				/**
				 * [tJDBCInput_18 finally ] stop
				 */

				/**
				 * [tMap_7 finally ] start
				 */

				currentComponent = "tMap_7";

				/**
				 * [tMap_7 finally ] stop
				 */

				/**
				 * [tJDBCOutput_7 finally ] start
				 */

				currentComponent = "tJDBCOutput_7";

				/**
				 * [tJDBCOutput_7 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableComparableLookupRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.vm_disk_join_id == null) ? 0
								: this.vm_disk_join_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row3Struct other = (row3Struct) obj;

			if (this.vm_disk_join_id == null) {
				if (other.vm_disk_join_id != null)
					return false;

			} else if (!this.vm_disk_join_id.equals(other.vm_disk_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row3Struct other) {

			other.history_id = this.history_id;
			other.vm_disk_join_id = this.vm_disk_join_id;

		}

		public void copyKeysDataTo(row3Struct other) {

			other.vm_disk_join_id = this.vm_disk_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.vm_disk_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.vm_disk_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_disk_join_id,
					other.vm_disk_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_20Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tAdvancedHash_row3 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row3", false);
				start_Hash
						.put("tAdvancedHash_row3", System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row3";

				int tos_count_tAdvancedHash_row3 = 0;

				// connection name:row3
				// source node:tJDBCInput_20 - inputs:(after_tJDBCInput_18)
				// outputs:(row3,row3) | target node:tAdvancedHash_row3 -
				// inputs:(row3) outputs:()
				// linked node: tMap_7 - inputs:(row1,row3)
				// outputs:(vm_disk_history)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row3 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row3Struct> tHash_Lookup_row3 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row3Struct> getLookup(matchingModeEnum_row3);

				globalMap.put("tHash_Lookup_row3", tHash_Lookup_row3);

				/**
				 * [tAdvancedHash_row3 begin ] stop
				 */

				/**
				 * [tJDBCInput_20 begin ] start
				 */

				ok_Hash.put("tJDBCInput_20", false);
				start_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				currentComponent = "tJDBCInput_20";

				int tos_count_tJDBCInput_20 = 0;

				int nb_line_tJDBCInput_20 = 0;
				java.sql.Connection conn_tJDBCInput_20 = null;
				conn_tJDBCInput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_20 = conn_tJDBCInput_20
						.createStatement();

				String dbquery_tJDBCInput_20 = "SELECT history_id, upper(cast(vm_disk_id as char(36))) as vm_disk_join_id\nFROM  v4_4_latest_configuration_vms_disks";

				globalMap.put("tJDBCInput_20_QUERY", dbquery_tJDBCInput_20);

				java.sql.ResultSet rs_tJDBCInput_20 = null;
				try {
					rs_tJDBCInput_20 = stmt_tJDBCInput_20
							.executeQuery(dbquery_tJDBCInput_20);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_20 = rs_tJDBCInput_20
							.getMetaData();
					int colQtyInRs_tJDBCInput_20 = rsmd_tJDBCInput_20
							.getColumnCount();

					String tmpContent_tJDBCInput_20 = null;

					while (rs_tJDBCInput_20.next()) {
						nb_line_tJDBCInput_20++;

						if (colQtyInRs_tJDBCInput_20 < 1) {
							row3.history_id = null;
						} else {

							if (rs_tJDBCInput_20.getObject(1) != null) {
								row3.history_id = rs_tJDBCInput_20.getInt(1);
							} else {
								row3.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_20 < 2) {
							row3.vm_disk_join_id = null;
						} else {

							row3.vm_disk_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_20, 2, false);
						}

						/**
						 * [tJDBCInput_20 begin ] stop
						 */

						/**
						 * [tJDBCInput_20 main ] start
						 */

						currentComponent = "tJDBCInput_20";

						tos_count_tJDBCInput_20++;

						/**
						 * [tJDBCInput_20 main ] stop
						 */

						/**
						 * [tAdvancedHash_row3 main ] start
						 */

						currentComponent = "tAdvancedHash_row3";

						row3Struct row3_HashRow = new row3Struct();

						row3_HashRow.history_id = row3.history_id;

						row3_HashRow.vm_disk_join_id = row3.vm_disk_join_id;

						tHash_Lookup_row3.put(row3_HashRow);

						tos_count_tAdvancedHash_row3++;

						/**
						 * [tAdvancedHash_row3 main ] stop
						 */

						/**
						 * [tJDBCInput_20 end ] start
						 */

						currentComponent = "tJDBCInput_20";

					}
				} finally {
					if (rs_tJDBCInput_20 != null) {
						rs_tJDBCInput_20.close();
					}
					stmt_tJDBCInput_20.close();

				}
				globalMap.put("tJDBCInput_20_NB_LINE", nb_line_tJDBCInput_20);

				ok_Hash.put("tJDBCInput_20", true);
				end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				/**
				 * [tJDBCInput_20 end ] stop
				 */

				/**
				 * [tAdvancedHash_row3 end ] start
				 */

				currentComponent = "tAdvancedHash_row3";

				tHash_Lookup_row3.endPut();

				ok_Hash.put("tAdvancedHash_row3", true);
				end_Hash.put("tAdvancedHash_row3", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row3 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_20 finally ] start
				 */

				currentComponent = "tJDBCInput_20";

				/**
				 * [tJDBCInput_20 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row3 finally ] start
				 */

				currentComponent = "tAdvancedHash_row3";

				/**
				 * [tAdvancedHash_row3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 1);
	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */

				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */

				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "engine";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCConnection_2Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_2 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_2 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_2 = decryptedPassword_tJDBCConnection_2;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_2, dbUser_tJDBCConnection_2,
						dbPwd_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// dbUser_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// dbPwd_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */

				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */

				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				tJDBCInput_21Process(globalMap);

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_21Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_21 begin ] start
				 */

				ok_Hash.put("tJDBCInput_21", false);
				start_Hash.put("tJDBCInput_21", System.currentTimeMillis());

				currentComponent = "tJDBCInput_21";

				int tos_count_tJDBCInput_21 = 0;

				int nb_line_tJDBCInput_21 = 0;
				java.sql.Connection conn_tJDBCInput_21 = null;
				conn_tJDBCInput_21 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_21 = conn_tJDBCInput_21
						.createStatement();

				String dbquery_tJDBCInput_21 = "select distinct 'runTime', CURRENT_TIMESTAMP(6)";

				globalMap.put("tJDBCInput_21_QUERY", dbquery_tJDBCInput_21);

				java.sql.ResultSet rs_tJDBCInput_21 = null;
				try {
					rs_tJDBCInput_21 = stmt_tJDBCInput_21
							.executeQuery(dbquery_tJDBCInput_21);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_21 = rs_tJDBCInput_21
							.getMetaData();
					int colQtyInRs_tJDBCInput_21 = rsmd_tJDBCInput_21
							.getColumnCount();

					String tmpContent_tJDBCInput_21 = null;

					while (rs_tJDBCInput_21.next()) {
						nb_line_tJDBCInput_21++;

						if (colQtyInRs_tJDBCInput_21 < 1) {
							row2.key = null;
						} else {

							row2.key = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_21, 1, false);
						}
						if (colQtyInRs_tJDBCInput_21 < 2) {
							row2.value = null;
						} else {

							java.util.Date date_tJDBCInput_21 = null;
							try {
								date_tJDBCInput_21 = rs_tJDBCInput_21
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_21 = rs_tJDBCInput_21
										.getDate(2);
							}
							row2.value = date_tJDBCInput_21;
						}

						/**
						 * [tJDBCInput_21 begin ] stop
						 */

						/**
						 * [tJDBCInput_21 main ] start
						 */

						currentComponent = "tJDBCInput_21";

						tos_count_tJDBCInput_21++;

						/**
						 * [tJDBCInput_21 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;
						String key_tContextLoad_1 = null;
						if (row2.key != null) {
							tmp_key_tContextLoad_1 = row2.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row2.key = tmp_key_tContextLoad_1;
							}
						}
						if (row2.key != null) {
							key_tContextLoad_1 = row2.key;
						}
						String value_tContextLoad_1 = null;
						if (row2.value != null) {
							value_tContextLoad_1 = FormatterUtils.format_Date(
									row2.value, "yyyy-MM-dd HH:mm:ss.SSSSSS");
						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runInterleave"
												.equals(key_tContextLoad_1)) {

									context.runInterleave = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "runTime".equals(key_tContextLoad_1)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_1));

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								if (value_tContextLoad_1 == null) {
									context.setProperty(key_tContextLoad_1, "");
								} else {
									context.setProperty(key_tContextLoad_1,
											value_tContextLoad_1);
								}
							} catch (java.lang.Exception e) {
								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;
						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tJDBCInput_21 end ] start
						 */

						currentComponent = "tJDBCInput_21";

					}
				} finally {
					if (rs_tJDBCInput_21 != null) {
						rs_tJDBCInput_21.close();
					}
					stmt_tJDBCInput_21.close();

				}
				globalMap.put("tJDBCInput_21_NB_LINE", nb_line_tJDBCInput_21);

				ok_Hash.put("tJDBCInput_21", true);
				end_Hash.put("tJDBCInput_21", System.currentTimeMillis());

				/**
				 * [tJDBCInput_21 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				List<String> parametersToEncrypt_tContextLoad_1 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_1.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_1
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_1));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_21 finally ] start
				 */

				currentComponent = "tJDBCInput_21";

				/**
				 * [tJDBCInput_21 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_StatisticsSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_StatisticsSync) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}
					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final StatisticsSync StatisticsSyncClass = new StatisticsSync();

		int exitCode = StatisticsSyncClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = StatisticsSync.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/statisticssync_4_4/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			String pwd_ovirtEngineDbPassword_value = context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbPassword = null;
			if (pwd_ovirtEngineDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineDbPassword")) {// no
																			// need
																			// to
																			// decrypt
																			// if
																			// it
																			// come
																			// from
																			// program
																			// argument
																			// or
																			// parent
																			// job
																			// runtime
					context.ovirtEngineDbPassword = pwd_ovirtEngineDbPassword_value;
				} else if (!pwd_ovirtEngineDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineDbPassword_value);
						context.put("ovirtEngineDbPassword",
								context.ovirtEngineDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				context.runInterleave = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runInterleave"));
			} catch (NumberFormatException e) {
				context.runInterleave = null;
			}
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runInterleave")) {
				context.runInterleave = (Integer) parentContextMap
						.get("runInterleave");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineDbPassword");
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		try {
			errorCode = null;
			tPrejob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPrejob_1) {
			globalMap.put("tPrejob_1_SUBPROCESS_STATE", -1);

			e_tPrejob_1.printStackTrace();

		}

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_4Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} catch (Error e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_5Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} catch (Error e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_8Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_8) {
					globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", -1);

					e_tJDBCInput_8.printStackTrace();

				} catch (Error e_tJDBCInput_8) {
					globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", -1);

					e_tJDBCInput_8.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_10Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} catch (Error e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_12Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_12) {
					globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", -1);

					e_tJDBCInput_12.printStackTrace();

				} catch (Error e_tJDBCInput_12) {
					globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", -1);

					e_tJDBCInput_12.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_18Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_18) {
					globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", -1);

					e_tJDBCInput_18.printStackTrace();

				} catch (Error e_tJDBCInput_18) {
					globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", -1);

					e_tJDBCInput_18.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : StatisticsSync");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();

	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_2");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));
		connections.put("conn_tJDBCConnection_2",
				globalMap.get("conn_tJDBCConnection_2"));

		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 463100 characters generated by Talend Open Studio for Data Integration on the
 * May 20, 2021 3:10:22 PM IDT
 ************************************************************************************************/
