/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.util.List;

public interface OpenStackNetworkProvider extends OpenStackProvider {
    AgentConfiguration agentConfiguration();
    
    boolean agentConfigurationPresent();
    
    boolean autoSync();
    
    boolean autoSyncPresent();
    
    String externalPluginType();
    
    boolean externalPluginTypePresent();
    
    NetworkPluginType pluginType();
    
    boolean pluginTypePresent();
    
    String projectDomainName();
    
    boolean projectDomainNamePresent();
    
    String projectName();
    
    boolean projectNamePresent();
    
    boolean readOnly();
    
    boolean readOnlyPresent();
    
    OpenStackNetworkProviderType type();
    
    boolean typePresent();
    
    boolean unmanaged();
    
    boolean unmanagedPresent();
    
    String userDomainName();
    
    boolean userDomainNamePresent();
    
    List<Certificate> certificates();
    
    boolean certificatesPresent();
    
    List<OpenStackNetwork> networks();
    
    boolean networksPresent();
    
    List<OpenStackSubnet> subnets();
    
    boolean subnetsPresent();
    
}
