/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import org.ovirt.engine.sdk4.types.Watchdog;
import org.ovirt.engine.sdk4.types.WatchdogAction;
import org.ovirt.engine.sdk4.types.WatchdogModel;

public class WatchdogContainer extends DeviceContainer implements Watchdog {
    private WatchdogAction action;
    private WatchdogModel model;
    
    public WatchdogAction action() {
        return action;
    }
    
    public void action(WatchdogAction newAction) {
        action = newAction;
    }
    
    public boolean actionPresent() {
        return action != null;
    }
    
    public WatchdogModel model() {
        return model;
    }
    
    public void model(WatchdogModel newModel) {
        model = newModel;
    }
    
    public boolean modelPresent() {
        return model != null;
    }
    
}
