/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.util.List;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Payload;
import org.ovirt.engine.sdk4.types.VmDeviceType;

public class PayloadContainer extends Container implements Payload {
    private List<File> files;
    private VmDeviceType type;
    private String volumeId;
    
    public List<File> files() {
        return makeUnmodifiableList(files);
    }
    
    public void files(List<File> newFiles) {
        files = makeArrayList(newFiles);
    }
    
    public boolean filesPresent() {
        return files != null && !files.isEmpty();
    }
    
    public VmDeviceType type() {
        return type;
    }
    
    public void type(VmDeviceType newType) {
        type = newType;
    }
    
    public boolean typePresent() {
        return type != null;
    }
    
    public String volumeId() {
        return volumeId;
    }
    
    public void volumeId(String newVolumeId) {
        volumeId = newVolumeId;
    }
    
    public boolean volumeIdPresent() {
        return volumeId != null;
    }
    
}
