/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.List;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityLabelContainer extends IdentifiedContainer implements AffinityLabel {
    private Boolean hasImplicitAffinityGroup;
    private Boolean readOnly;
    private List<Host> hosts;
    private List<Vm> vms;
    
    public boolean hasImplicitAffinityGroup() {
        return hasImplicitAffinityGroup;
    }
    
    public void hasImplicitAffinityGroup(boolean newHasImplicitAffinityGroup) {
        hasImplicitAffinityGroup = Boolean.valueOf(newHasImplicitAffinityGroup);
    }
    
    public void hasImplicitAffinityGroup(Boolean newHasImplicitAffinityGroup) {
        hasImplicitAffinityGroup = newHasImplicitAffinityGroup;
    }
    
    public boolean hasImplicitAffinityGroupPresent() {
        return hasImplicitAffinityGroup != null;
    }
    
    public boolean readOnly() {
        return readOnly;
    }
    
    public void readOnly(boolean newReadOnly) {
        readOnly = Boolean.valueOf(newReadOnly);
    }
    
    public void readOnly(Boolean newReadOnly) {
        readOnly = newReadOnly;
    }
    
    public boolean readOnlyPresent() {
        return readOnly != null;
    }
    
    public List<Host> hosts() {
        return makeUnmodifiableList(hosts);
    }
    
    public void hosts(List<Host> newHosts) {
        hosts = makeArrayList(newHosts);
    }
    
    public boolean hostsPresent() {
        return hosts != null && !hosts.isEmpty();
    }
    
    public List<Vm> vms() {
        return makeUnmodifiableList(vms);
    }
    
    public void vms(List<Vm> newVms) {
        vms = makeArrayList(newVms);
    }
    
    public boolean vmsPresent() {
        return vms != null && !vms.isEmpty();
    }
    
}
