/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.TemplateVersionContainer;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.TemplateVersion;

public class TemplateVersionBuilder {
    private Template baseTemplate;
    private String versionName;
    private BigInteger versionNumber;
    
    public TemplateVersionBuilder baseTemplate(Template newBaseTemplate) {
        baseTemplate = newBaseTemplate;
        return this;
    }
    
    public TemplateVersionBuilder baseTemplate(TemplateBuilder newBaseTemplate) {
        if (newBaseTemplate == null) {
            baseTemplate = null;
        }
        else {
            baseTemplate = newBaseTemplate.build();
        }
        return this;
    }
    
    
    public TemplateVersionBuilder versionName(String newVersionName) {
        versionName = newVersionName;
        return this;
    }
    
    
    public TemplateVersionBuilder versionNumber(int newVersionNumber) {
        versionNumber = BigInteger.valueOf((long) newVersionNumber);
        return this;
    }
    
    public TemplateVersionBuilder versionNumber(Integer newVersionNumber) {
        if (newVersionNumber == null) {
            versionNumber = null;
        }
        else {
            versionNumber = BigInteger.valueOf(newVersionNumber.longValue());
        }
        return this;
    }
    
    public TemplateVersionBuilder versionNumber(long newVersionNumber) {
        versionNumber = BigInteger.valueOf(newVersionNumber);
        return this;
    }
    
    public TemplateVersionBuilder versionNumber(Long newVersionNumber) {
        if (newVersionNumber == null) {
            versionNumber = null;
        }
        else {
            versionNumber = BigInteger.valueOf(newVersionNumber.longValue());
        }
        return this;
    }
    
    public TemplateVersionBuilder versionNumber(BigInteger newVersionNumber) {
        versionNumber = newVersionNumber;
        return this;
    }
    
    
    public TemplateVersion build() {
        TemplateVersionContainer container = new TemplateVersionContainer();
        container.baseTemplate(baseTemplate);
        container.versionName(versionName);
        container.versionNumber(versionNumber);
        return container;
    }
}
