/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.HighAvailabilityContainer;
import org.ovirt.engine.sdk4.types.HighAvailability;

public class HighAvailabilityBuilder {
    private Boolean enabled;
    private BigInteger priority;
    
    public HighAvailabilityBuilder enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
        return this;
    }
    
    public HighAvailabilityBuilder enabled(Boolean newEnabled) {
        enabled = newEnabled;
        return this;
    }
    
    
    public HighAvailabilityBuilder priority(int newPriority) {
        priority = BigInteger.valueOf((long) newPriority);
        return this;
    }
    
    public HighAvailabilityBuilder priority(Integer newPriority) {
        if (newPriority == null) {
            priority = null;
        }
        else {
            priority = BigInteger.valueOf(newPriority.longValue());
        }
        return this;
    }
    
    public HighAvailabilityBuilder priority(long newPriority) {
        priority = BigInteger.valueOf(newPriority);
        return this;
    }
    
    public HighAvailabilityBuilder priority(Long newPriority) {
        if (newPriority == null) {
            priority = null;
        }
        else {
            priority = BigInteger.valueOf(newPriority.longValue());
        }
        return this;
    }
    
    public HighAvailabilityBuilder priority(BigInteger newPriority) {
        priority = newPriority;
        return this;
    }
    
    
    public HighAvailability build() {
        HighAvailabilityContainer container = new HighAvailabilityContainer();
        container.enabled(enabled);
        container.priority(priority);
        return container;
    }
}
