/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;


/**
 * Represents a tag in the system.
 */
public interface Tag extends Identified {
    Group group();
    
    boolean groupPresent();
    
    Host host();
    
    boolean hostPresent();
    
    Tag parent();
    
    boolean parentPresent();
    
    Template template();
    
    boolean templatePresent();
    
    User user();
    
    boolean userPresent();
    
    Vm vm();
    
    boolean vmPresent();
    
}
