/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.util.List;

public interface Initialization {
    String activeDirectoryOu();
    
    boolean activeDirectoryOuPresent();
    
    String authorizedSshKeys();
    
    boolean authorizedSshKeysPresent();
    
    CloudInit cloudInit();
    
    boolean cloudInitPresent();
    
    CloudInitNetworkProtocol cloudInitNetworkProtocol();
    
    boolean cloudInitNetworkProtocolPresent();
    
    Configuration configuration();
    
    boolean configurationPresent();
    
    String customScript();
    
    boolean customScriptPresent();
    
    String dnsSearch();
    
    boolean dnsSearchPresent();
    
    String dnsServers();
    
    boolean dnsServersPresent();
    
    String domain();
    
    boolean domainPresent();
    
    String hostName();
    
    boolean hostNamePresent();
    
    String inputLocale();
    
    boolean inputLocalePresent();
    
    List<NicConfiguration> nicConfigurations();
    
    boolean nicConfigurationsPresent();
    
    String orgName();
    
    boolean orgNamePresent();
    
    boolean regenerateIds();
    
    boolean regenerateIdsPresent();
    
    boolean regenerateSshKeys();
    
    boolean regenerateSshKeysPresent();
    
    String rootPassword();
    
    boolean rootPasswordPresent();
    
    String systemLocale();
    
    boolean systemLocalePresent();
    
    String timezone();
    
    boolean timezonePresent();
    
    String uiLanguage();
    
    boolean uiLanguagePresent();
    
    String userLocale();
    
    boolean userLocalePresent();
    
    String userName();
    
    boolean userNamePresent();
    
    String windowsLicenseKey();
    
    boolean windowsLicenseKeyPresent();
    
}
