/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;
import java.util.List;

public interface GlusterVolume extends Identified {
    BigInteger disperseCount();
    Byte disperseCountAsByte();
    Short disperseCountAsShort();
    Integer disperseCountAsInteger();
    Long disperseCountAsLong();
    
    boolean disperseCountPresent();
    
    List<Option> options();
    
    boolean optionsPresent();
    
    BigInteger redundancyCount();
    Byte redundancyCountAsByte();
    Short redundancyCountAsShort();
    Integer redundancyCountAsInteger();
    Long redundancyCountAsLong();
    
    boolean redundancyCountPresent();
    
    BigInteger replicaCount();
    Byte replicaCountAsByte();
    Short replicaCountAsShort();
    Integer replicaCountAsInteger();
    Long replicaCountAsLong();
    
    boolean replicaCountPresent();
    
    GlusterVolumeStatus status();
    
    boolean statusPresent();
    
    BigInteger stripeCount();
    Byte stripeCountAsByte();
    Short stripeCountAsShort();
    Integer stripeCountAsInteger();
    Long stripeCountAsLong();
    
    boolean stripeCountPresent();
    
    List<TransportType> transportTypes();
    
    boolean transportTypesPresent();
    
    GlusterVolumeType volumeType();
    
    boolean volumeTypePresent();
    
    List<GlusterBrick> bricks();
    
    boolean bricksPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    List<Statistic> statistics();
    
    boolean statisticsPresent();
    
}
