/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.VlanContainer;
import org.ovirt.engine.sdk4.types.Vlan;

public class VlanBuilder {
    private BigInteger id;
    
    public VlanBuilder id(int newId) {
        id = BigInteger.valueOf((long) newId);
        return this;
    }
    
    public VlanBuilder id(Integer newId) {
        if (newId == null) {
            id = null;
        }
        else {
            id = BigInteger.valueOf(newId.longValue());
        }
        return this;
    }
    
    public VlanBuilder id(long newId) {
        id = BigInteger.valueOf(newId);
        return this;
    }
    
    public VlanBuilder id(Long newId) {
        if (newId == null) {
            id = null;
        }
        else {
            id = BigInteger.valueOf(newId.longValue());
        }
        return this;
    }
    
    public VlanBuilder id(BigInteger newId) {
        id = newId;
        return this;
    }
    
    
    public Vlan build() {
        VlanContainer container = new VlanContainer();
        container.id(id);
        return container;
    }
}
