/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.SsoContainer;
import org.ovirt.engine.sdk4.types.Method;
import org.ovirt.engine.sdk4.types.Sso;

public class SsoBuilder {
    private List<Method> methods;
    
    public SsoBuilder methods(List<Method> newMethods) {
        if (newMethods != null) {
            if (methods == null) {
                methods = new ArrayList<>(newMethods);
            }
            else {
                methods.addAll(newMethods);
            }
        }
        return this;
    }
    
    public SsoBuilder methods(Method... newMethods) {
        if (newMethods != null) {
            if (methods == null) {
                methods = new ArrayList<>(newMethods.length);
            }
            Collections.addAll(methods, newMethods);
        }
        return this;
    }
    
    public SsoBuilder methods(MethodBuilder... newMethods) {
        if (newMethods != null) {
            if (methods == null) {
                methods = new ArrayList<>(newMethods.length);
            }
            for (MethodBuilder builder : newMethods) {
                methods.add(builder.build());
            }
        }
        return this;
    }
    
    
    public Sso build() {
        SsoContainer container = new SsoContainer();
        container.methods(methods);
        return container;
    }
}
