/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HostStorageContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlLogicalUnitReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNfsVersionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVolumeGroupReader;
import org.ovirt.engine.sdk4.types.HostStorage;

public class XmlHostStorageReader {
    public static HostStorage readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        HostStorageContainer object = new HostStorageContainer();
        block58: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block58;
                }
                case "id": {
                    object.id(image);
                    continue block58;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block59: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block59;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block59;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block59;
                }
                case "driver_options": {
                    object.driverOptions(XmlPropertyReader.readMany(reader));
                    continue block59;
                }
                case "driver_sensitive_options": {
                    object.driverSensitiveOptions(XmlPropertyReader.readMany(reader));
                    continue block59;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block59;
                }
                case "logical_units": {
                    object.logicalUnits(XmlLogicalUnitReader.readMany(reader));
                    continue block59;
                }
                case "mount_options": {
                    object.mountOptions(reader.readString());
                    continue block59;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block59;
                }
                case "nfs_retrans": {
                    object.nfsRetrans(reader.readInteger());
                    continue block59;
                }
                case "nfs_timeo": {
                    object.nfsTimeo(reader.readInteger());
                    continue block59;
                }
                case "nfs_version": {
                    object.nfsVersion(XmlNfsVersionReader.readOne(reader));
                    continue block59;
                }
                case "override_luns": {
                    object.overrideLuns(reader.readBoolean());
                    continue block59;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block59;
                }
                case "path": {
                    object.path(reader.readString());
                    continue block59;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block59;
                }
                case "portal": {
                    object.portal(reader.readString());
                    continue block59;
                }
                case "target": {
                    object.target(reader.readString());
                    continue block59;
                }
                case "type": {
                    object.type(XmlStorageTypeReader.readOne(reader));
                    continue block59;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block59;
                }
                case "vfs_type": {
                    object.vfsType(reader.readString());
                    continue block59;
                }
                case "volume_group": {
                    object.volumeGroup(XmlVolumeGroupReader.readOne(reader));
                    continue block59;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block59;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHostStorageReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<HostStorage> iterateMany(final XmlReader reader) {
        return new Iterator<HostStorage>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public HostStorage next() {
                HostStorage next = XmlHostStorageReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<HostStorage> readMany(XmlReader reader) {
        ArrayList<HostStorage> list = new ArrayList<HostStorage>();
        Iterator<HostStorage> iterator = XmlHostStorageReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HostStorageContainer object, String[] link) {
    }
}

