/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.EventSubscriptionContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlNotifiableEventReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNotificationMethodReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.types.EventSubscription;

public class XmlEventSubscriptionReader {
    public static EventSubscription readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        EventSubscriptionContainer object = new EventSubscriptionContainer();
        block28: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block28;
                }
                case "id": {
                    object.id(image);
                    continue block28;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block29: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block29;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block29;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block29;
                }
                case "event": {
                    object.event(XmlNotifiableEventReader.readOne(reader));
                    continue block29;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block29;
                }
                case "notification_method": {
                    object.notificationMethod(XmlNotificationMethodReader.readOne(reader));
                    continue block29;
                }
                case "user": {
                    object.user(XmlUserReader.readOne(reader));
                    continue block29;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block29;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlEventSubscriptionReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<EventSubscription> iterateMany(final XmlReader reader) {
        return new Iterator<EventSubscription>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public EventSubscription next() {
                EventSubscription next = XmlEventSubscriptionReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<EventSubscription> readMany(XmlReader reader) {
        ArrayList<EventSubscription> list = new ArrayList<EventSubscription>();
        Iterator<EventSubscription> iterator = XmlEventSubscriptionReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(EventSubscriptionContainer object, String[] link) {
    }
}

