/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VirtualFunctionAllowedNetworkServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkWriter;
import org.ovirt.engine.sdk4.services.VirtualFunctionAllowedNetworkService;
import org.ovirt.engine.sdk4.services.VirtualFunctionAllowedNetworksService;
import org.ovirt.engine.sdk4.types.Network;

public class VirtualFunctionAllowedNetworksServiceImpl
extends ServiceImpl
implements VirtualFunctionAllowedNetworksService {
    public VirtualFunctionAllowedNetworksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VirtualFunctionAllowedNetworksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VirtualFunctionAllowedNetworksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VirtualFunctionAllowedNetworkService networkService(String id) {
        return new VirtualFunctionAllowedNetworkServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.networkService(path);
        }
        return this.networkService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VirtualFunctionAllowedNetworksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VirtualFunctionAllowedNetworksService.ListResponse {
        private List<Network> networks;

        private ListResponseImpl() {
        }

        public void networks(List<Network> networks) {
            this.networks = networks;
        }

        @Override
        public List<Network> networks() {
            return this.networks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VirtualFunctionAllowedNetworksService.ListRequest, VirtualFunctionAllowedNetworksService.ListResponse>
    implements VirtualFunctionAllowedNetworksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VirtualFunctionAllowedNetworksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VirtualFunctionAllowedNetworksServiceImpl.this.getConnection().getUrl() + VirtualFunctionAllowedNetworksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VirtualFunctionAllowedNetworksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.networks(XmlNetworkReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VirtualFunctionAllowedNetworksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VirtualFunctionAllowedNetworksService.AddResponse {
        private Network network;

        private AddResponseImpl() {
        }

        public void network(Network network) {
            this.network = network;
        }

        @Override
        public Network network() {
            return this.network;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VirtualFunctionAllowedNetworksService.AddRequest, VirtualFunctionAllowedNetworksService.AddResponse>
    implements VirtualFunctionAllowedNetworksService.AddRequest {
        private Network network;

        private AddRequestImpl() {
        }

        @Override
        public VirtualFunctionAllowedNetworksService.AddRequest network(Network network) {
            this.network = network;
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.AddRequest network(NetworkBuilder network) {
            this.network = network.build();
            return this;
        }

        @Override
        public VirtualFunctionAllowedNetworksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VirtualFunctionAllowedNetworksServiceImpl.this.getConnection().getUrl() + VirtualFunctionAllowedNetworksServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkWriter.writeOne(this.network, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VirtualFunctionAllowedNetworksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.network(XmlNetworkReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VirtualFunctionAllowedNetworksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

