/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.SnapshotBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SnapshotServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSnapshotWriter;
import org.ovirt.engine.sdk4.services.SnapshotService;
import org.ovirt.engine.sdk4.services.SnapshotsService;
import org.ovirt.engine.sdk4.types.Snapshot;

public class SnapshotsServiceImpl
extends ServiceImpl
implements SnapshotsService {
    public SnapshotsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SnapshotsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public SnapshotsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public SnapshotService snapshotService(String id) {
        return new SnapshotServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.snapshotService(path);
        }
        return this.snapshotService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "SnapshotsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements SnapshotsService.ListResponse {
        private List<Snapshot> snapshots;

        private ListResponseImpl() {
        }

        public void snapshots(List<Snapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Override
        public List<Snapshot> snapshots() {
            return this.snapshots;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<SnapshotsService.ListRequest, SnapshotsService.ListResponse>
    implements SnapshotsService.ListRequest {
        private Boolean allContent;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public SnapshotsService.ListRequest allContent(Boolean allContent) {
            this.allContent = allContent;
            return this;
        }

        @Override
        public SnapshotsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public SnapshotsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public SnapshotsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public SnapshotsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public SnapshotsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SnapshotsServiceImpl.this.getConnection().getUrl() + SnapshotsServiceImpl.this.getPath());
                if (this.allContent != null) {
                    uriBuilder.addParameter("all_content", XmlWriter.renderBoolean(this.allContent));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SnapshotsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.snapshots(XmlSnapshotReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SnapshotsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements SnapshotsService.AddResponse {
        private Snapshot snapshot;

        private AddResponseImpl() {
        }

        public void snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Snapshot snapshot() {
            return this.snapshot;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<SnapshotsService.AddRequest, SnapshotsService.AddResponse>
    implements SnapshotsService.AddRequest {
        private Snapshot snapshot;

        private AddRequestImpl() {
        }

        @Override
        public SnapshotsService.AddRequest snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Override
        public SnapshotsService.AddRequest snapshot(SnapshotBuilder snapshot) {
            this.snapshot = snapshot.build();
            return this;
        }

        @Override
        public SnapshotsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SnapshotsServiceImpl.this.getConnection().getUrl() + SnapshotsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlSnapshotWriter.writeOne(this.snapshot, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SnapshotsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.snapshot(XmlSnapshotReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SnapshotsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

