/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.SchedulingPolicyBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.SchedulingPolicyServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSchedulingPolicyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSchedulingPolicyWriter;
import org.ovirt.engine.sdk4.services.SchedulingPoliciesService;
import org.ovirt.engine.sdk4.services.SchedulingPolicyService;
import org.ovirt.engine.sdk4.types.SchedulingPolicy;

public class SchedulingPoliciesServiceImpl
extends ServiceImpl
implements SchedulingPoliciesService {
    public SchedulingPoliciesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SchedulingPoliciesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public SchedulingPoliciesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public SchedulingPolicyService policyService(String id) {
        return new SchedulingPolicyServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.policyService(path);
        }
        return this.policyService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "SchedulingPoliciesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements SchedulingPoliciesService.ListResponse {
        private List<SchedulingPolicy> policies;

        private ListResponseImpl() {
        }

        public void policies(List<SchedulingPolicy> policies) {
            this.policies = policies;
        }

        @Override
        public List<SchedulingPolicy> policies() {
            return this.policies;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<SchedulingPoliciesService.ListRequest, SchedulingPoliciesService.ListResponse>
    implements SchedulingPoliciesService.ListRequest {
        private Boolean filter;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public SchedulingPoliciesService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public SchedulingPoliciesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public SchedulingPoliciesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public SchedulingPoliciesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public SchedulingPoliciesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public SchedulingPoliciesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SchedulingPoliciesServiceImpl.this.getConnection().getUrl() + SchedulingPoliciesServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SchedulingPoliciesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.policies(XmlSchedulingPolicyReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SchedulingPoliciesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements SchedulingPoliciesService.AddResponse {
        private SchedulingPolicy policy;

        private AddResponseImpl() {
        }

        public void policy(SchedulingPolicy policy) {
            this.policy = policy;
        }

        @Override
        public SchedulingPolicy policy() {
            return this.policy;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<SchedulingPoliciesService.AddRequest, SchedulingPoliciesService.AddResponse>
    implements SchedulingPoliciesService.AddRequest {
        private SchedulingPolicy policy;

        private AddRequestImpl() {
        }

        @Override
        public SchedulingPoliciesService.AddRequest policy(SchedulingPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public SchedulingPoliciesService.AddRequest policy(SchedulingPolicyBuilder policy) {
            this.policy = policy.build();
            return this;
        }

        @Override
        public SchedulingPoliciesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SchedulingPoliciesServiceImpl.this.getConnection().getUrl() + SchedulingPoliciesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlSchedulingPolicyWriter.writeOne(this.policy, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SchedulingPoliciesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.policy(XmlSchedulingPolicyReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SchedulingPoliciesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

