/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.EventBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.EventServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlEventReader;
import org.ovirt.engine.sdk4.internal.xml.XmlEventWriter;
import org.ovirt.engine.sdk4.services.EventService;
import org.ovirt.engine.sdk4.services.EventsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Event;

public class EventsServiceImpl
extends ServiceImpl
implements EventsService {
    public EventsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public EventsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public EventsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public EventsService.UndeleteRequest undelete() {
        return new UndeleteRequestImpl();
    }

    @Override
    public EventService eventService(String id) {
        return new EventServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.eventService(path);
        }
        return this.eventService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "EventsService:" + this.getPath();
    }

    private class UndeleteResponseImpl
    implements EventsService.UndeleteResponse {
        private UndeleteResponseImpl() {
        }
    }

    private class UndeleteRequestImpl
    extends BaseRequest<EventsService.UndeleteRequest, EventsService.UndeleteResponse>
    implements EventsService.UndeleteRequest {
        private Boolean async;

        private UndeleteRequestImpl() {
        }

        @Override
        public EventsService.UndeleteRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public EventsService.UndeleteResponse send() {
            HttpPost request = new HttpPost(EventsServiceImpl.this.getConnection().getUrl() + EventsServiceImpl.this.getPath() + "/undelete");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = EventsServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = EventsServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new UndeleteResponseImpl();
        }
    }

    private class ListResponseImpl
    implements EventsService.ListResponse {
        private List<Event> events;

        private ListResponseImpl() {
        }

        public void events(List<Event> events) {
            this.events = events;
        }

        @Override
        public List<Event> events() {
            return this.events;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<EventsService.ListRequest, EventsService.ListResponse>
    implements EventsService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger from;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public EventsService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public EventsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public EventsService.ListRequest from(BigInteger from) {
            this.from = from;
            return this;
        }

        @Override
        public EventsService.ListRequest from(Integer from) {
            this.from = BigInteger.valueOf(from.intValue());
            return this;
        }

        @Override
        public EventsService.ListRequest from(Long from) {
            this.from = BigInteger.valueOf(from);
            return this;
        }

        @Override
        public EventsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public EventsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public EventsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public EventsService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public EventsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(EventsServiceImpl.this.getConnection().getUrl() + EventsServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.from != null) {
                    uriBuilder.addParameter("from", XmlWriter.renderInteger(this.from));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = EventsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.events(XmlEventReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            EventsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements EventsService.AddResponse {
        private Event event;

        private AddResponseImpl() {
        }

        public void event(Event event) {
            this.event = event;
        }

        @Override
        public Event event() {
            return this.event;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<EventsService.AddRequest, EventsService.AddResponse>
    implements EventsService.AddRequest {
        private Event event;

        private AddRequestImpl() {
        }

        @Override
        public EventsService.AddRequest event(Event event) {
            this.event = event;
            return this;
        }

        @Override
        public EventsService.AddRequest event(EventBuilder event) {
            this.event = event.build();
            return this;
        }

        @Override
        public EventsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(EventsServiceImpl.this.getConnection().getUrl() + EventsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlEventWriter.writeOne(this.event, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = EventsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.event(XmlEventReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            EventsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

