/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AttachedStorageDomainDisksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainDisksService;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class AttachedStorageDomainServiceImpl
extends ServiceImpl
implements AttachedStorageDomainService {
    public AttachedStorageDomainServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AttachedStorageDomainService.ActivateRequest activate() {
        return new ActivateRequestImpl();
    }

    @Override
    public AttachedStorageDomainService.DeactivateRequest deactivate() {
        return new DeactivateRequestImpl();
    }

    @Override
    public AttachedStorageDomainService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public AttachedStorageDomainService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public AttachedStorageDomainDisksService disksService() {
        return new AttachedStorageDomainDisksServiceImpl(this.getConnection(), this.getPath() + "/disks");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("disks")) {
            return this.disksService();
        }
        if (path.startsWith("disks/")) {
            return this.disksService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "AttachedStorageDomainService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements AttachedStorageDomainService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<AttachedStorageDomainService.RemoveRequest, AttachedStorageDomainService.RemoveResponse>
    implements AttachedStorageDomainService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public AttachedStorageDomainService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AttachedStorageDomainService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            AttachedStorageDomainServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements AttachedStorageDomainService.GetResponse {
        private StorageDomain storageDomain;

        private GetResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<AttachedStorageDomainService.GetRequest, AttachedStorageDomainService.GetResponse>
    implements AttachedStorageDomainService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public AttachedStorageDomainService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AttachedStorageDomainService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class DeactivateResponseImpl
    implements AttachedStorageDomainService.DeactivateResponse {
        private DeactivateResponseImpl() {
        }
    }

    private class DeactivateRequestImpl
    extends BaseRequest<AttachedStorageDomainService.DeactivateRequest, AttachedStorageDomainService.DeactivateResponse>
    implements AttachedStorageDomainService.DeactivateRequest {
        private Boolean async;
        private Boolean force;

        private DeactivateRequestImpl() {
        }

        @Override
        public AttachedStorageDomainService.DeactivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AttachedStorageDomainService.DeactivateRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public AttachedStorageDomainService.DeactivateResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainServiceImpl.this.getPath() + "/deactivate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.force(this.force);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new DeactivateResponseImpl();
        }
    }

    private class ActivateResponseImpl
    implements AttachedStorageDomainService.ActivateResponse {
        private ActivateResponseImpl() {
        }
    }

    private class ActivateRequestImpl
    extends BaseRequest<AttachedStorageDomainService.ActivateRequest, AttachedStorageDomainService.ActivateResponse>
    implements AttachedStorageDomainService.ActivateRequest {
        private Boolean async;

        private ActivateRequestImpl() {
        }

        @Override
        public AttachedStorageDomainService.ActivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AttachedStorageDomainService.ActivateResponse send() {
            HttpPost request = new HttpPost(AttachedStorageDomainServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainServiceImpl.this.getPath() + "/activate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = AttachedStorageDomainServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = AttachedStorageDomainServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ActivateResponseImpl();
        }
    }
}

