/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedDiskProfileServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileWriter;
import org.ovirt.engine.sdk4.services.AssignedDiskProfileService;
import org.ovirt.engine.sdk4.services.AssignedDiskProfilesService;
import org.ovirt.engine.sdk4.types.DiskProfile;

public class AssignedDiskProfilesServiceImpl
extends ServiceImpl
implements AssignedDiskProfilesService {
    public AssignedDiskProfilesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AssignedDiskProfilesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AssignedDiskProfilesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AssignedDiskProfileService profileService(String id) {
        return new AssignedDiskProfileServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.profileService(path);
        }
        return this.profileService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AssignedDiskProfilesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AssignedDiskProfilesService.ListResponse {
        private List<DiskProfile> profiles;

        private ListResponseImpl() {
        }

        public void profiles(List<DiskProfile> profiles) {
            this.profiles = profiles;
        }

        @Override
        public List<DiskProfile> profiles() {
            return this.profiles;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AssignedDiskProfilesService.ListRequest, AssignedDiskProfilesService.ListResponse>
    implements AssignedDiskProfilesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AssignedDiskProfilesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AssignedDiskProfilesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AssignedDiskProfilesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AssignedDiskProfilesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AssignedDiskProfilesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedDiskProfilesServiceImpl.this.getConnection().getUrl() + AssignedDiskProfilesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedDiskProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.profiles(XmlDiskProfileReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedDiskProfilesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AssignedDiskProfilesService.AddResponse {
        private DiskProfile profile;

        private AddResponseImpl() {
        }

        public void profile(DiskProfile profile) {
            this.profile = profile;
        }

        @Override
        public DiskProfile profile() {
            return this.profile;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AssignedDiskProfilesService.AddRequest, AssignedDiskProfilesService.AddResponse>
    implements AssignedDiskProfilesService.AddRequest {
        private DiskProfile profile;

        private AddRequestImpl() {
        }

        @Override
        public AssignedDiskProfilesService.AddRequest profile(DiskProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public AssignedDiskProfilesService.AddRequest profile(DiskProfileBuilder profile) {
            this.profile = profile.build();
            return this;
        }

        @Override
        public AssignedDiskProfilesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedDiskProfilesServiceImpl.this.getConnection().getUrl() + AssignedDiskProfilesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskProfileWriter.writeOne(this.profile, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedDiskProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.profile(XmlDiskProfileReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedDiskProfilesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

