/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AffinityLabelBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AffinityLabelHostsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AffinityLabelVmsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityLabelWriter;
import org.ovirt.engine.sdk4.services.AffinityLabelHostsService;
import org.ovirt.engine.sdk4.services.AffinityLabelService;
import org.ovirt.engine.sdk4.services.AffinityLabelVmsService;
import org.ovirt.engine.sdk4.types.AffinityLabel;

public class AffinityLabelServiceImpl
extends ServiceImpl
implements AffinityLabelService {
    public AffinityLabelServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AffinityLabelService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public AffinityLabelService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public AffinityLabelService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AffinityLabelHostsService hostsService() {
        return new AffinityLabelHostsServiceImpl(this.getConnection(), this.getPath() + "/hosts");
    }

    @Override
    public AffinityLabelVmsService vmsService() {
        return new AffinityLabelVmsServiceImpl(this.getConnection(), this.getPath() + "/vms");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("hosts")) {
            return this.hostsService();
        }
        if (path.startsWith("hosts/")) {
            return this.hostsService().service(path.substring(6));
        }
        if (path.equals("vms")) {
            return this.vmsService();
        }
        if (path.startsWith("vms/")) {
            return this.vmsService().service(path.substring(4));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "AffinityLabelService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements AffinityLabelService.UpdateResponse {
        private AffinityLabel label;

        private UpdateResponseImpl() {
        }

        public void label(AffinityLabel label) {
            this.label = label;
        }

        @Override
        public AffinityLabel label() {
            return this.label;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<AffinityLabelService.UpdateRequest, AffinityLabelService.UpdateResponse>
    implements AffinityLabelService.UpdateRequest {
        private AffinityLabel label;

        private UpdateRequestImpl() {
        }

        @Override
        public AffinityLabelService.UpdateRequest label(AffinityLabel label) {
            this.label = label;
            return this;
        }

        @Override
        public AffinityLabelService.UpdateRequest label(AffinityLabelBuilder label) {
            this.label = label.build();
            return this;
        }

        @Override
        public AffinityLabelService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityLabelServiceImpl.this.getConnection().getUrl() + AffinityLabelServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlAffinityLabelWriter.writeOne(this.label, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityLabelServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.label(XmlAffinityLabelReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityLabelServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements AffinityLabelService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<AffinityLabelService.RemoveRequest, AffinityLabelService.RemoveResponse>
    implements AffinityLabelService.RemoveRequest {
        private RemoveRequestImpl() {
        }

        @Override
        public AffinityLabelService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityLabelServiceImpl.this.getConnection().getUrl() + AffinityLabelServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityLabelServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            AffinityLabelServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements AffinityLabelService.GetResponse {
        private AffinityLabel label;

        private GetResponseImpl() {
        }

        public void label(AffinityLabel label) {
            this.label = label;
        }

        @Override
        public AffinityLabel label() {
            return this.label;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<AffinityLabelService.GetRequest, AffinityLabelService.GetResponse>
    implements AffinityLabelService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public AffinityLabelService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AffinityLabelService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityLabelServiceImpl.this.getConnection().getUrl() + AffinityLabelServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityLabelServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.label(XmlAffinityLabelReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityLabelServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

