/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.HostedEngineContainer;
import org.ovirt.engine.sdk4.types.HostedEngine;

public class HostedEngineBuilder {
    private Boolean active;
    private Boolean configured;
    private Boolean globalMaintenance;
    private Boolean localMaintenance;
    private BigInteger score;

    public HostedEngineBuilder active(boolean newActive) {
        this.active = newActive;
        return this;
    }

    public HostedEngineBuilder active(Boolean newActive) {
        this.active = newActive;
        return this;
    }

    public HostedEngineBuilder configured(boolean newConfigured) {
        this.configured = newConfigured;
        return this;
    }

    public HostedEngineBuilder configured(Boolean newConfigured) {
        this.configured = newConfigured;
        return this;
    }

    public HostedEngineBuilder globalMaintenance(boolean newGlobalMaintenance) {
        this.globalMaintenance = newGlobalMaintenance;
        return this;
    }

    public HostedEngineBuilder globalMaintenance(Boolean newGlobalMaintenance) {
        this.globalMaintenance = newGlobalMaintenance;
        return this;
    }

    public HostedEngineBuilder localMaintenance(boolean newLocalMaintenance) {
        this.localMaintenance = newLocalMaintenance;
        return this;
    }

    public HostedEngineBuilder localMaintenance(Boolean newLocalMaintenance) {
        this.localMaintenance = newLocalMaintenance;
        return this;
    }

    public HostedEngineBuilder score(int newScore) {
        this.score = BigInteger.valueOf(newScore);
        return this;
    }

    public HostedEngineBuilder score(Integer newScore) {
        this.score = newScore == null ? null : BigInteger.valueOf(newScore.longValue());
        return this;
    }

    public HostedEngineBuilder score(long newScore) {
        this.score = BigInteger.valueOf(newScore);
        return this;
    }

    public HostedEngineBuilder score(Long newScore) {
        this.score = newScore == null ? null : BigInteger.valueOf(newScore);
        return this;
    }

    public HostedEngineBuilder score(BigInteger newScore) {
        this.score = newScore;
        return this;
    }

    public HostedEngine build() {
        HostedEngineContainer container = new HostedEngineContainer();
        container.active(this.active);
        container.configured(this.configured);
        container.globalMaintenance(this.globalMaintenance);
        container.localMaintenance(this.localMaintenance);
        container.score(this.score);
        return container;
    }
}

