/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.util.List;

/**
 * Represents a MAC address pool.
 * 
 * Example of an XML representation of a MAC address pool:
 * 
 * [source,xml]
 * ----
 * <mac_pool href="/ovirt-engine/api/macpools/123" id="123">
 *   <name>Default</name>
 *   <description>Default MAC pool</description>
 *   <allow_duplicates>false</allow_duplicates>
 *   <default_pool>true</default_pool>
 *   <ranges>
 *     <range>
 *       <from>00:1A:4A:16:01:51</from>
 *       <to>00:1A:4A:16:01:E6</to>
 *     </range>
 *   </ranges>
 * </mac_pool>
 * ----
 */
public interface MacPool extends Identified {
    boolean allowDuplicates();
    
    boolean allowDuplicatesPresent();
    
    boolean defaultPool();
    
    boolean defaultPoolPresent();
    
    List<Range> ranges();
    
    boolean rangesPresent();
    
}
