/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VirtualNumaNodeBuilder;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;

public interface VmNumaNodesService extends Service {
    /**
     * Creates a new virtual NUMA node for the virtual machine.
     * 
     * An example of creating a NUMA node:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/c7ecd2dc/numanodes
     * Accept: application/xml
     * Content-type: application/xml
     * ----
     * The request body can contain the following:
     * [source,xml]
     * ----
     * <vm_numa_node>
     *   <cpu>
     *     <cores>
     *       <core>
     *         <index>0</index>
     *       </core>
     *     </cores>
     *   </cpu>
     *   <index>0</index>
     *   <memory>1024</memory>
     * </vm_numa_node>
     * ----
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest node(VirtualNumaNode node);
        AddRequest node(VirtualNumaNodeBuilder node);
    }
    
    /**
     * Creates a new virtual NUMA node for the virtual machine.
     * 
     * An example of creating a NUMA node:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/c7ecd2dc/numanodes
     * Accept: application/xml
     * Content-type: application/xml
     * ----
     * The request body can contain the following:
     * [source,xml]
     * ----
     * <vm_numa_node>
     *   <cpu>
     *     <cores>
     *       <core>
     *         <index>0</index>
     *       </core>
     *     </cores>
     *   </cpu>
     *   <index>0</index>
     *   <memory>1024</memory>
     * </vm_numa_node>
     * ----
     */
    public interface AddResponse extends Response {
        VirtualNumaNode node();
    }
    
    /**
     * Creates a new virtual NUMA node for the virtual machine.
     * 
     * An example of creating a NUMA node:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/c7ecd2dc/numanodes
     * Accept: application/xml
     * Content-type: application/xml
     * ----
     * The request body can contain the following:
     * [source,xml]
     * ----
     * <vm_numa_node>
     *   <cpu>
     *     <cores>
     *       <core>
     *         <index>0</index>
     *       </core>
     *     </cores>
     *   </cpu>
     *   <index>0</index>
     *   <memory>1024</memory>
     * </vm_numa_node>
     * ----
     */
    AddRequest add();
    
    /**
     * Lists virtual NUMA nodes of a virtual machine.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of nodes to return. If not specified all the nodes are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of nodes to return. If not specified all the nodes are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of nodes to return. If not specified all the nodes are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    /**
     * Lists virtual NUMA nodes of a virtual machine.
     */
    public interface ListResponse extends Response {
        List<VirtualNumaNode> nodes();
    }
    
    /**
     * Lists virtual NUMA nodes of a virtual machine.
     */
    ListRequest list();
    
    VmNumaNodeService nodeService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

