/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.HostDevice;

/**
 * A service to access host devices.
 */
public interface HostDevicesService extends Service {
    /**
     * List the devices of a host.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of devices to return. If not specified all the devices are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of devices to return. If not specified all the devices are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of devices to return. If not specified all the devices are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    /**
     * List the devices of a host.
     */
    public interface ListResponse extends Response {
        List<HostDevice> devices();
    }
    
    /**
     * List the devices of a host.
     */
    ListRequest list();
    
    /**
     * Reference to the service that can be used to access a specific host device.
     */
    HostDeviceService deviceService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

