/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.util.List;

/**
 * A vNIC profile is a collection of settings that can be applied to individual <<types/nics,NIC>>.
 */
public interface VnicProfile extends Identified {
    List<CustomProperty> customProperties();
    
    boolean customPropertiesPresent();
    
    boolean migratable();
    
    boolean migratablePresent();
    
    VnicPassThrough passThrough();
    
    boolean passThroughPresent();
    
    boolean portMirroring();
    
    boolean portMirroringPresent();
    
    Network network();
    
    boolean networkPresent();
    
    NetworkFilter networkFilter();
    
    boolean networkFilterPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    Qos qos();
    
    boolean qosPresent();
    
}
