/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.KatelloErratum;

/**
 * A service to manage a Katello erratum.
 */
public interface KatelloErratumService extends Service {
    /**
     * Retrieves a Katello erratum.
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/katelloerrata/123
     * ----
     * 
     * You will receive response in XML like this one:
     * 
     * [source,xml]
     * ----
     * <katello_erratum href="/ovirt-engine/api/katelloerrata/123" id="123">
     *   <name>RHBA-2013:XYZ</name>
     *   <description>The description of the erratum</description>
     *   <title>some bug fix update</title>
     *   <type>bugfix</type>
     *   <issued>2013-11-20T02:00:00.000+02:00</issued>
     *   <solution>Few guidelines regarding the solution</solution>
     *   <summary>Updated packages that fix one bug are now available for XYZ</summary>
     *   <packages>
     *     <package>
     *       <name>libipa_hbac-1.9.2-82.11.el6_4.i686</name>
     *     </package>
     *     ...
     *   </packages>
     * </katello_erratum>
     * ----
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Retrieves a Katello erratum.
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/katelloerrata/123
     * ----
     * 
     * You will receive response in XML like this one:
     * 
     * [source,xml]
     * ----
     * <katello_erratum href="/ovirt-engine/api/katelloerrata/123" id="123">
     *   <name>RHBA-2013:XYZ</name>
     *   <description>The description of the erratum</description>
     *   <title>some bug fix update</title>
     *   <type>bugfix</type>
     *   <issued>2013-11-20T02:00:00.000+02:00</issued>
     *   <solution>Few guidelines regarding the solution</solution>
     *   <summary>Updated packages that fix one bug are now available for XYZ</summary>
     *   <packages>
     *     <package>
     *       <name>libipa_hbac-1.9.2-82.11.el6_4.i686</name>
     *     </package>
     *     ...
     *   </packages>
     * </katello_erratum>
     * ----
     */
    public interface GetResponse extends Response {
        /**
         * Retrieves the representation of the Katello erratum.
         */
        KatelloErratum erratum();
    }
    
    /**
     * Retrieves a Katello erratum.
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/katelloerrata/123
     * ----
     * 
     * You will receive response in XML like this one:
     * 
     * [source,xml]
     * ----
     * <katello_erratum href="/ovirt-engine/api/katelloerrata/123" id="123">
     *   <name>RHBA-2013:XYZ</name>
     *   <description>The description of the erratum</description>
     *   <title>some bug fix update</title>
     *   <type>bugfix</type>
     *   <issued>2013-11-20T02:00:00.000+02:00</issued>
     *   <solution>Few guidelines regarding the solution</solution>
     *   <summary>Updated packages that fix one bug are now available for XYZ</summary>
     *   <packages>
     *     <package>
     *       <name>libipa_hbac-1.9.2-82.11.el6_4.i686</name>
     *     </package>
     *     ...
     *   </packages>
     * </katello_erratum>
     * ----
     */
    GetRequest get();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

