/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AffinityLabelBuilder;
import org.ovirt.engine.sdk4.types.AffinityLabel;

/**
 * Single affinity label details.
 */
public interface AffinityLabelService extends Service {
    /**
     * Retrieves details about a label.
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Retrieves details about a label.
     */
    public interface GetResponse extends Response {
        AffinityLabel label();
    }
    
    /**
     * Retrieves details about a label.
     */
    GetRequest get();
    
    /**
     * Removes a label from system and clears all assignments
     * of the removed label.
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
    }
    
    /**
     * Removes a label from system and clears all assignments
     * of the removed label.
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Removes a label from system and clears all assignments
     * of the removed label.
     */
    RemoveRequest remove();
    
    /**
     * Updates a label.
     * 
     * This call will update all metadata like name
     * or description.
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        UpdateRequest label(AffinityLabel label);
        UpdateRequest label(AffinityLabelBuilder label);
    }
    
    /**
     * Updates a label.
     * 
     * This call will update all metadata like name
     * or description.
     */
    public interface UpdateResponse extends Response {
        AffinityLabel label();
    }
    
    /**
     * Updates a label.
     * 
     * This call will update all metadata like name
     * or description.
     */
    UpdateRequest update();
    
    /**
     * List all Hosts with this label.
     */
    AffinityLabelHostsService hostsService();
    /**
     * List all VMs with this label.
     */
    AffinityLabelVmsService vmsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

