/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.Date;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.SnapshotStatus;
import org.ovirt.engine.sdk4.types.SnapshotType;
import org.ovirt.engine.sdk4.types.Vm;

public class SnapshotContainer extends VmContainer implements Snapshot {
    private Date date;
    private Boolean persistMemorystate;
    private SnapshotStatus snapshotStatus;
    private SnapshotType snapshotType;
    private Vm vm;
    
    public Date date() {
        if (date == null) {
            return null;
        }
        else {
            return new Date(date.getTime());
        }
    }
    
    public void date(Date newDate) {
        if (newDate == null) {
            date = null;
        }
        else {
            date = new Date(newDate.getTime());
        }
    }
    
    public boolean datePresent() {
        return date != null;
    }
    
    public boolean persistMemorystate() {
        return persistMemorystate;
    }
    
    public void persistMemorystate(boolean newPersistMemorystate) {
        persistMemorystate = Boolean.valueOf(newPersistMemorystate);
    }
    
    public void persistMemorystate(Boolean newPersistMemorystate) {
        persistMemorystate = newPersistMemorystate;
    }
    
    public boolean persistMemorystatePresent() {
        return persistMemorystate != null;
    }
    
    public SnapshotStatus snapshotStatus() {
        return snapshotStatus;
    }
    
    public void snapshotStatus(SnapshotStatus newSnapshotStatus) {
        snapshotStatus = newSnapshotStatus;
    }
    
    public boolean snapshotStatusPresent() {
        return snapshotStatus != null;
    }
    
    public SnapshotType snapshotType() {
        return snapshotType;
    }
    
    public void snapshotType(SnapshotType newSnapshotType) {
        snapshotType = newSnapshotType;
    }
    
    public boolean snapshotTypePresent() {
        return snapshotType != null;
    }
    
    public Vm vm() {
        return vm;
    }
    
    public void vm(Vm newVm) {
        vm = newVm;
    }
    
    public boolean vmPresent() {
        return vm != null;
    }
    
}
