/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.ExternalHostGroup;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public class ExternalHostGroupContainer extends IdentifiedContainer implements ExternalHostGroup {
    private String architectureName;
    private String domainName;
    private String operatingSystemName;
    private String subnetName;
    private ExternalHostProvider externalHostProvider;
    
    public String architectureName() {
        return architectureName;
    }
    
    public void architectureName(String newArchitectureName) {
        architectureName = newArchitectureName;
    }
    
    public boolean architectureNamePresent() {
        return architectureName != null;
    }
    
    public String domainName() {
        return domainName;
    }
    
    public void domainName(String newDomainName) {
        domainName = newDomainName;
    }
    
    public boolean domainNamePresent() {
        return domainName != null;
    }
    
    public String operatingSystemName() {
        return operatingSystemName;
    }
    
    public void operatingSystemName(String newOperatingSystemName) {
        operatingSystemName = newOperatingSystemName;
    }
    
    public boolean operatingSystemNamePresent() {
        return operatingSystemName != null;
    }
    
    public String subnetName() {
        return subnetName;
    }
    
    public void subnetName(String newSubnetName) {
        subnetName = newSubnetName;
    }
    
    public boolean subnetNamePresent() {
        return subnetName != null;
    }
    
    public ExternalHostProvider externalHostProvider() {
        return externalHostProvider;
    }
    
    public void externalHostProvider(ExternalHostProvider newExternalHostProvider) {
        externalHostProvider = newExternalHostProvider;
    }
    
    public boolean externalHostProviderPresent() {
        return externalHostProvider != null;
    }
    
}
